/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.beings.talkerBeings;

import silmar.Sound;
import silmar.entities.beings.player.Player;
import silmar.entities.beings.talkerBeings.TalkerBeing;
import silmar.entities.items.Item;
import silmar.entities.items.types.ItemType;
import silmar.entities.items.weapons.WeaponType;
import silmar.entities.talkers.ItemFixer;
import silmar.entities.talkers.ItemSellerUtil;
import silmar.entities.talkers.Service;
import silmar.entities.talkers.ServiceSeller;
import silmar.map.Map;
import silmar.map.effects.Teleport;
import silmar.map.effects.VisualEffect;
import silmar.util.Random;

public class TalkerBeings {

    public static class ItemIdentifier
    extends TalkerBeing {
        public int getAdjustedItemPrice(Item item, int normalPrice) {
            return normalPrice;
        }
    }

    public static class Repairer
    extends TalkerBeing
    implements ItemFixer {
        public int getAdjustedItemPrice(Item item, int normalPrice) {
            return normalPrice;
        }

        public boolean getCanFixItem(Item item) {
            return item.isIdentified();
        }
    }

    public static class Buyer
    extends TalkerBeing {
        public int getAdjustedItemOffering(Item item, int normalOffering) {
            return normalOffering;
        }

        public void onItemBought() {
        }

        public boolean getLeavesAfterPurchase() {
            return false;
        }
    }

    protected static abstract class ItemSeller
    extends TalkerBeing
    implements silmar.entities.talkers.ItemSeller {
        protected ItemSeller() {
        }

        public int getAdjustedItemPrice(Item item, int normalPrice) {
            return normalPrice;
        }
    }

    public static class MedicalRobot
    extends TalkerBeing {
        protected boolean alerting = this.shouldAlert();

        private boolean shouldAlert() {
            return Random.getInt(1, 10) <= 4;
        }

        public String getGreeting() {
            return !this.alerting ? "This robot drones, \"Please remain still, that I may alleviate your ailments.\"" : "This robot drones, \"You are not one of us...  Security alert!  Security alert!\"";
        }

        public void onGreetingHeardByPlayer(Player player) {
            if (!this.alerting) {
                player.onHealedByMedicalRobot();
            } else {
                this.getMap().onSoundIssued(Sound.alarm, this.getLocation());
            }
            this.alerting |= this.shouldAlert();
        }

        public Sound getMovementSound() {
            if (Random.getInt(1, 2) == 1) {
                return Sound.medicalRobot;
            }
            return super.getMovementSound();
        }
    }

    public static class TopsideStorekeeper
    extends ItemSeller {
        private static final ItemType[] itemTypesForSale = new ItemType[]{ItemType.ration, ItemType.torch, ItemType.arrow, ItemType.quarrel, ItemType.slingStone, WeaponType.dagger, WeaponType.club, WeaponType.mace, WeaponType.greatMace, WeaponType.staff, WeaponType.shortSword, WeaponType.longSword, WeaponType.twoHandedSword, WeaponType.sling, WeaponType.bow, WeaponType.crossbow, ItemType.leatherArmor, ItemType.chainMail, ItemType.plateMail, ItemType.smallShield, ItemType.largeShield, ItemType.greatShield};

        public Item[] getItemsForSale() {
            return ItemSellerUtil.doCreateItemsForSaleFromTypes(itemTypesForSale);
        }
    }

    public static class TopsidePriest
    extends TalkerBeing
    implements ServiceSeller {
        private static final Service[] servicesForSale = new Service[]{Service.curePoison, Service.cureDisease, Service.removeCursedItems, Service.healWounds, Service.healFully, Service.restoreLevels};

        public Service[] getServicesForSale() {
            return servicesForSale;
        }

        public int getServicePrice(Service service, Player forPlayer) {
            int price = 0;
            price = service.equals(Service.curePoison) ? service.getPrice() * forPlayer.getPoisonLevel() : (service.equals(Service.cureDisease) ? service.getPrice() * forPlayer.getNumDiseases() : (service.equals(Service.removeCursedItems) ? Math.max(service.getPrice() * forPlayer.getNumEquippedCursedItems(), forPlayer.getEquippedUnidentifiedCursedItemsTotalIdentificationValue() * 2) : (service.equals(Service.restoreLevels) ? service.getPrice() * forPlayer.getNumLevelsLost() : service.getPrice())));
            return price;
        }
    }

    public static class AlienBuyer
    extends Buyer {
        public int getAdjustedItemOffering(Item item, int normalOffering) {
            return normalOffering * 2;
        }

        public void onItemBought() {
            new Thread(this){
                private final /* synthetic */ AlienBuyer this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    Map map = this.this$0.getMap();
                    VisualEffect finalFrame = Teleport.doTeleport(this.this$0.getMap(), this.this$0.getLocation(), true, true);
                    map.doRemoveEntity(this.this$0);
                    map.doRemoveEntity(finalFrame);
                }
            }.start();
        }

        public boolean getLeavesAfterPurchase() {
            return true;
        }
    }

    public static class DemonicWizard
    extends Repairer {
        public int getAdjustedItemPrice(Item item, int normalPrice) {
            return normalPrice * 7 / 5;
        }

        public boolean getCanFixItem(Item item) {
            return super.getCanFixItem(item) && !item.isWeapon() && !item.getType().isArmor() && !item.getType().isShield() && item.getType().isMagical();
        }
    }

    public static class Nightdwarf
    extends Repairer {
        public int getAdjustedItemPrice(Item item, int normalPrice) {
            return normalPrice * 6 / 5;
        }

        public boolean getCanFixItem(Item item) {
            return super.getCanFixItem(item) && (item.isWeapon() || item.getType().isArmor() || item.getType().isShield()) && !item.getType().isTech();
        }
    }

    public static class TopsideBlacksmith
    extends Repairer {
        public int getAdjustedItemPrice(Item item, int normalPrice) {
            return normalPrice / 2;
        }

        public boolean getCanFixItem(Item item) {
            return super.getCanFixItem(item) && (item.isWeapon() || item.getType().isArmor() || item.getType().isShield()) && !item.getType().isMagical() && !item.getType().isTech();
        }
    }
}

