/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.beings.player;

import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import silmar.entities.beings.player.PlayerPower;
import silmar.util.ImageUtil;

public final class PlayerLevel
implements Serializable {
    private String name;
    private String imageName;
    private Dimension size;
    private PlayerPower[] powers;
    public static List levels = new ArrayList();
    public static HashMap levelsMap = new HashMap();
    public static PlayerLevel squire = new PlayerLevel("Squire", "acolyte");
    public static PlayerLevel fighter = new PlayerLevel("Fighter", "human");
    public static PlayerLevel monk = new PlayerLevel("Monk", "monk");
    public static PlayerLevel paladin = new PlayerLevel("Paladin", "paladin");
    public static PlayerLevel archer = new PlayerLevel("Archer", "archer");
    public static PlayerLevel superhero = new PlayerLevel("Superhero", "superhero");
    public static PlayerLevel neonKnight = new PlayerLevel("Neon Knight", "neonKnight");
    public static PlayerLevel barbarian = new PlayerLevel("Barbarian", "barbarian");
    public static PlayerLevel thief = new PlayerLevel("Thief", "thief");
    public static PlayerLevel ninja = new PlayerLevel("Ninja", "ninja");
    public static PlayerLevel werewolf = new PlayerLevel("Werewolf", "werewolf");
    public static PlayerLevel troll = new PlayerLevel("Troll", "troll");
    public static PlayerLevel pixie = new PlayerLevel("Pixie", "pixie");
    public static PlayerLevel giant = new PlayerLevel("Giant", "giant");
    public static PlayerLevel demon = new PlayerLevel("Demon", "demon");
    public static PlayerLevel minotaur = new PlayerLevel("Minotaur", "minotaur");
    public static PlayerLevel mutatedSpider = new PlayerLevel("Mutated Spider", "mutatedSpider");
    public static PlayerLevel kangadillo = new PlayerLevel("Kandadillo", "kangadillo");
    public static PlayerLevel subvampire = new PlayerLevel("Subvampire", "subvampire");
    public static PlayerLevel cyborg = new PlayerLevel("Cyborg", "cyborg");
    public static PlayerLevel cleric = new PlayerLevel("Cleric", "cleric");
    public static PlayerLevel druid = new PlayerLevel("Druid", "druid");
    public static PlayerLevel priest = new PlayerLevel("Priest", "priest");
    public static PlayerLevel deathCaster = new PlayerLevel("Death Caster", "deathCaster");
    public static PlayerLevel wizard = new PlayerLevel("Wizard", "wizard");
    public static PlayerLevel alchemist = new PlayerLevel("Alchemist", "alchemist");
    public static PlayerLevel sorcerer = new PlayerLevel("Sorcerer", "sorcerer");
    public static PlayerLevel battlemage = new PlayerLevel("Battlemage", "battlemage");
    public static PlayerLevel scientist = new PlayerLevel("Scientist", "scientist");

    public static PlayerLevel getLevel(String name) {
        return (PlayerLevel)levelsMap.get(name);
    }

    public PlayerLevel(String name, String imageName) {
        this.name = name;
        this.imageName = imageName;
        levels.add(this);
        levelsMap.put(name, this);
        this.doDetmSize();
    }

    public boolean equals(PlayerLevel level) {
        return level == this || level.name.equals(this.name);
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getName() {
        return this.name;
    }

    protected void doDetmSize() {
        this.size = ImageUtil.getSizeWithoutLoading("player/" + this.imageName);
    }

    public Dimension getSize() {
        return this.size;
    }

    public PlayerPower[] getPowers() {
        return this.powers;
    }

    static {
        PlayerLevel.squire.powers = new PlayerPower[0];
        PlayerLevel.fighter.powers = new PlayerPower[]{PlayerPower.combatProwess};
        PlayerLevel.monk.powers = new PlayerPower[]{PlayerPower.unarmedCombatProwess, PlayerPower.unarmoredDefensiveProwess};
        PlayerLevel.paladin.powers = new PlayerPower[]{PlayerPower.immunityToDisease, PlayerPower.layHands, PlayerPower.protectionAgainstEvil, PlayerPower.repelLivingDeadPaladin};
        PlayerLevel.archer.powers = new PlayerPower[]{PlayerPower.archerySkill};
        PlayerLevel.superhero.powers = new PlayerPower[]{PlayerPower.immunityToPoison, PlayerPower.fireEyeBeams, PlayerPower.employSuperVision};
        PlayerLevel.neonKnight.powers = new PlayerPower[]{PlayerPower.immunityToRadiation, PlayerPower.emitRadWave};
        PlayerLevel.barbarian.powers = new PlayerPower[]{PlayerPower.hunterSpeed, PlayerPower.fastRecuperation};
        PlayerLevel.thief.powers = new PlayerPower[]{PlayerPower.detectTraps, PlayerPower.disarmTraps};
        PlayerLevel.ninja.powers = new PlayerPower[]{PlayerPower.stealth};
        PlayerLevel.werewolf.powers = new PlayerPower[]{PlayerPower.nightVision, PlayerPower.claws, PlayerPower.invulnerabilityToLesserCreatures};
        PlayerLevel.troll.powers = new PlayerPower[]{PlayerPower.regeneration};
        PlayerLevel.pixie.powers = new PlayerPower[]{PlayerPower.teleportingTouch};
        PlayerLevel.giant.powers = new PlayerPower[]{PlayerPower.throwBoulder};
        PlayerLevel.demon.powers = new PlayerPower[]{PlayerPower.disintegratingTouch};
        PlayerLevel.minotaur.powers = new PlayerPower[]{PlayerPower.horns, PlayerPower.senseCreatures, PlayerPower.senseSecretDoors, PlayerPower.immunityToConfusion};
        PlayerLevel.mutatedSpider.powers = new PlayerPower[]{PlayerPower.spinWeb};
        PlayerLevel.kangadillo.powers = new PlayerPower[]{PlayerPower.leap, PlayerPower.toughExterior};
        PlayerLevel.subvampire.powers = new PlayerPower[]{PlayerPower.invulnerabilityToAverageCreatures, PlayerPower.immunityToParalyzation, PlayerPower.lifeDraining};
        PlayerLevel.cyborg.powers = new PlayerPower[]{PlayerPower.cyberneticAccuracy};
        PlayerLevel.cleric.powers = new PlayerPower[]{PlayerPower.healWounds, PlayerPower.curePoison, PlayerPower.repelLivingDeadCleric, PlayerPower.cureDisease};
        PlayerLevel.druid.powers = new PlayerPower[]{PlayerPower.emitLightning};
        PlayerLevel.priest.powers = new PlayerPower[]{PlayerPower.healFully, PlayerPower.revealTraps, PlayerPower.placeVengefulSymbol};
        PlayerLevel.deathCaster.powers = new PlayerPower[]{PlayerPower.conjureDeathFog};
        PlayerLevel.wizard.powers = new PlayerPower[]{PlayerPower.teleportSelf, PlayerPower.memorizeLocation, PlayerPower.hurlFireball, PlayerPower.findExit};
        PlayerLevel.alchemist.powers = new PlayerPower[]{PlayerPower.transmuteGoldToBars, PlayerPower.transmuteBarsToGold};
        PlayerLevel.sorcerer.powers = new PlayerPower[]{PlayerPower.findTreasure, PlayerPower.projectRetributiveShield};
        PlayerLevel.battlemage.powers = new PlayerPower[]{PlayerPower.freezeBeing, PlayerPower.quickenSelf};
        PlayerLevel.scientist.powers = new PlayerPower[]{PlayerPower.achieveBionicStrength, PlayerPower.summonMeteorShower};
    }
}

