/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.beings.player;

import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import silmar.Debug;
import silmar.Sound;
import silmar.client.gui.HandsItemsDialog;
import silmar.entities.LightSource;
import silmar.entities.MapEntity;
import silmar.entities.MapEntityUtil;
import silmar.entities.beings.Being;
import silmar.entities.beings.BeingUtil;
import silmar.entities.beings.Confusion;
import silmar.entities.beings.MovementType;
import silmar.entities.beings.attacks.AttackType;
import silmar.entities.beings.attacks.PenetrationType;
import silmar.entities.beings.attacks.RangedAttackUtil;
import silmar.entities.beings.monsters.Monster;
import silmar.entities.beings.monsters.MonsterAttack;
import silmar.entities.beings.monsters.Monsters;
import silmar.entities.beings.player.Disease;
import silmar.entities.beings.player.ExperienceNeededForLevels;
import silmar.entities.beings.player.Inventory;
import silmar.entities.beings.player.PlayerAttribute;
import silmar.entities.beings.player.PlayerClass;
import silmar.entities.beings.player.PlayerLevel;
import silmar.entities.beings.player.PlayerPower;
import silmar.entities.beings.player.PlayerUtil;
import silmar.entities.beings.player.events.InventoryEventType;
import silmar.entities.beings.player.events.InventoryEvents;
import silmar.entities.beings.player.events.PlayerEvent;
import silmar.entities.beings.player.events.PlayerEvents;
import silmar.entities.beings.talkerBeings.TalkerBeings;
import silmar.entities.damage.Damage;
import silmar.entities.damage.DamageForm;
import silmar.entities.items.EquipLocation;
import silmar.entities.items.Item;
import silmar.entities.items.ItemCondition;
import silmar.entities.items.ItemFactory;
import silmar.entities.items.ItemValueContext;
import silmar.entities.items.Items;
import silmar.entities.items.types.ItemType;
import silmar.entities.items.weapons.Weapon;
import silmar.entities.items.weapons.WeaponFactory;
import silmar.entities.items.weapons.WeaponType;
import silmar.entities.talkers.Service;
import silmar.entities.talkers.ServiceSeller;
import silmar.entities.talkers.Talker;
import silmar.entities.terrains.Terrain;
import silmar.entities.terrains.TerrainFactory;
import silmar.entities.terrains.TerrainType;
import silmar.entities.terrains.Terrains;
import silmar.entities.terrains.traps.Trap;
import silmar.entities.terrains.traps.TrapUtil;
import silmar.events.Event;
import silmar.events.Listener;
import silmar.events.Reporter;
import silmar.game.Game;
import silmar.map.Map;
import silmar.map.MapLevel;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.map.MapTileDistance;
import silmar.map.MapTileLocation;
import silmar.map.PathFinder;
import silmar.map.effects.Attack;
import silmar.map.effects.BoulderThrow;
import silmar.map.effects.DeathFog;
import silmar.map.effects.EyeBeams;
import silmar.map.effects.Fireball;
import silmar.map.effects.LightSourceVisualEffect;
import silmar.map.effects.LightningBolt;
import silmar.map.effects.LivingDeadRepel;
import silmar.map.effects.MeteorShower;
import silmar.map.effects.PowerDischarge;
import silmar.map.effects.RadWave;
import silmar.map.effects.Teleport;
import silmar.map.effects.VisualEffect;
import silmar.tiles.Tile;
import silmar.tiles.TileSize;
import silmar.tiles.TileSizeUtil;
import silmar.util.ArrayUtil;
import silmar.util.FloatPoint;
import silmar.util.ListUtil;
import silmar.util.PointUtil;
import silmar.util.Random;
import silmar.util.ThreadUtil;

public final class Player
extends Being
implements TileSize,
RangedAttackUtil.RangedAttacker,
LightSource {
    private final int castingLevelsPerClassLevel = 2;
    protected final Reporter reporter = new Reporter();
    private final List hitPointsByLevel = new ArrayList();
    private final MapPixelLocation pendingMoveDestination = new MapPixelLocation(-1, -1);
    private final Level level = new Level();
    private transient List levels = new ArrayList();
    private String[] levelNames;
    private static final Weapon hand = new Weapon();
    private final HandsConfig[] handsConfigs = new HandsConfig[4];
    private static final int numHandsConfigs = 4;
    private int handsConfigUsedIndex;
    private int previousHandsConfigUsedIndex = -1;
    private final Inventory inventory = new Inventory();
    private final EquippedItems equippedItems = new EquippedItems();
    private final List diseaseAfflictions = new ArrayList();
    private int numLevelsLost = 0;
    private int attacksMadeThisTurn;
    private int offhandAttacksMadeThisTurn;
    private boolean currentAttackOffhand;
    private int retributiveShieldTurnsLeft = 0;
    private int bionicStrengthTurnsLeft = 0;
    public static final int bionicStrengthModifier = 6;
    public static final int cyborgIntelligencePerBonus = 4;
    private int quickenSelfTurnsLeft = 0;
    private boolean damagedSinceLayHands;
    private String name;
    private int radiationExposures = 0;
    private int radiationDamage = 0;
    private final MemorizedLocations memorizedLocations = new MemorizedLocations();
    private final BaseAttributes baseAttributes = new BaseAttributes();
    private final Attributes attributes = new Attributes();
    private final MaxEncumbrance maxEncumbrance = new MaxEncumbrance();
    private final Encumbrance encumbrance = new Encumbrance();
    private final Experience experience = new Experience();
    private final MaxMagicPoints maxMagicPoints = new MaxMagicPoints();
    private final MagicPoints magicPoints = new MagicPoints();
    private final MaxClericalPoints maxClericalPoints = new MaxClericalPoints();
    private final ClericalPoints clericalPoints = new ClericalPoints();
    private final PoisonLevel poisonLevel = new PoisonLevel();
    private final Defenses defenses = new Defenses();
    private final Stealthy stealthy = new Stealthy();
    private final MoveTowardsGoalListener moveTowardsGoalListener = new MoveTowardsGoalListener();
    private final ActedThisTurn actedThisTurn = new ActedThisTurn();
    private static final String removeCursedItemMessage = "The equipped item is cursed and won't allow you to remove it!";
    private static final String notEnoughGoldMessage = "You don't have enough gold!<br><br>(Note that gold at your location also counts towards your total.)";
    private static final int startingLevel = 5;
    private static MapPixelDistance getCanEmployPowerNow_range;

    public Player() {
        for (int i = 0; i < this.handsConfigs.length; ++i) {
            this.handsConfigs[i] = new HandsConfig();
        }
        this.inventory.doAddListener(new InventoryListener());
        int numAttributes = PlayerAttribute.attributes.size();
        for (int i = 0; i < numAttributes; ++i) {
            this.baseAttributes.set(i, 10);
        }
        if (Debug.isOn()) {
            // empty if block
        }
        this.experience.set(ExperienceNeededForLevels.getExperienceNeededForLevel(6) - 100);
        this.levels.add(PlayerLevel.squire);
        this.setHitPoints(this.getMaxHitPoints());
        this.magicPoints.set(this.maxMagicPoints.get());
        this.clericalPoints.set(this.maxClericalPoints.get());
        this.doCreateInventoryItem(ItemType.torch);
        this.doCreateInventoryItem(ItemType.torch);
        this.doCreateInventoryItem(ItemType.torch);
        this.doCreateInventoryItem(ItemType.ration, 2);
        this.doCreateInventoryItem(ItemType.gold, 20);
        this.doCreateInventoryItem(WeaponType.dagger, 20);
        if (Debug.isOn()) {
            // empty if block
        }
        this.attributes.doUpdate();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.levelNames = new String[this.levels.size()];
        for (int i = 0; i < this.levelNames.length; ++i) {
            this.levelNames[i] = ((PlayerLevel)this.levels.get(i)).getName();
        }
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException {
        try {
            s.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.inventory.doAddListener(new InventoryListener());
        this.levels = new ArrayList();
        for (int i = 0; i < this.levelNames.length; ++i) {
            this.levels.add(PlayerLevel.getLevel(this.levelNames[i]));
        }
    }

    public int getMaxMovementPoints() {
        float points = 5.0f + (float)this.getMaxMovementPointsModifierForStrength() + (float)this.getMaxMovementPointsModifierForAgility();
        points = Math.max(points, 1.0f);
        float fractionNotEncumbered = 1.0f - (float)this.encumbrance.get() / (float)this.maxEncumbrance.get();
        points *= fractionNotEncumbered;
        if (this.getHasGainedLevel(PlayerLevel.barbarian)) {
            points = points * 3.0f / 2.0f;
        }
        if (this.quickenSelfTurnsLeft > 0) {
            points *= 2.0f;
        }
        if (this.equippedItems.getContains(ItemType.bootsOfQuickness)) {
            points = points * 3.0f / 2.0f;
        }
        if (this.equippedItems.getContains(ItemType.bootsOfLethargy)) {
            points /= 2.0f;
        }
        return Math.max(1, Math.round(points));
    }

    public int getMaxMovementPointsModifierForStrength() {
        return (this.getStrength() - 10) / 4;
    }

    public int getMaxMovementPointsModifierForAgility() {
        return (this.getAgility() - 10) / 4;
    }

    public void doTakeDamage(Damage damage) {
        if (this.isDead()) {
            return;
        }
        if (this.getHasGainedLevel(PlayerLevel.kangadillo) && damage.form.isLessenedByToughExterior()) {
            damage.amount = damage.amount / 2 + damage.amount % 2;
        }
        super.doTakeDamage(damage);
    }

    protected void onDamaged(Damage damage) {
        if (damage.amount > 2 && !damage.form.equals(DamageForm.exertion)) {
            this.damagedSinceLayHands = true;
        }
        this.pendingMoveDestination.x = -1;
        if (damage.foe != null && this.retributiveShieldTurnsLeft > 0 && this.isNextTo(damage.foe)) {
            damage.foe.onHitByRetributiveShield(damage.amount);
        }
        if (damage.form.getAffectsItems()) {
            int numItemsAffected = (int)Math.ceil((float)damage.amount / 5.0f);
            for (int i = 0; i < numItemsAffected; ++i) {
                Item item = this.getRandomItem();
                if (item == null) continue;
                item.onHolderDamaged(damage);
            }
        }
    }

    protected int getAttacksPerTurn(boolean offhand) {
        Weapon weapon;
        int attacks = 0;
        Weapon weapon2 = weapon = !offhand ? this.getWeapon() : this.getOffhandWeapon();
        if (weapon == null) {
            return 0;
        }
        boolean hand = weapon.isOfType(WeaponType.hand);
        if (offhand && hand && !this.getWeapon().isOfType(WeaponType.hand)) {
            return 0;
        }
        if (this.getHasGainedLevel(PlayerLevel.fighter) && !weapon.getWeaponType().isRanged()) {
            ++attacks;
        }
        if (this.getHasGainedLevel(PlayerLevel.monk) && hand) {
            ++attacks;
        }
        if (this.getHasGainedLevel(PlayerLevel.archer) && (weapon.getType().isDescendedFromType(WeaponType.bow) || weapon.getType().isDescendedFromType(WeaponType.crossbow))) {
            ++attacks;
        }
        attacks += weapon.getWeaponType().getNumAttacks();
        if (this.equippedItems.getContains(ItemType.helmOfCombatMastery) && !weapon.getWeaponType().isRanged()) {
            ++attacks;
        }
        if (this.quickenSelfTurnsLeft > 0) {
            attacks *= 2;
        }
        return attacks;
    }

    protected int getAccuracy(boolean offhand) {
        int accuracy = this.getAgility();
        Weapon weapon = !offhand ? this.getWeapon() : this.getOffhandWeapon();
        accuracy += weapon.getWeaponType().getToHitModifier();
        if (this.getHasGainedLevel(PlayerLevel.cyborg)) {
            accuracy += this.getIntelligence() / 4;
        }
        if (this.getHasGainedLevel(PlayerLevel.archer) && weapon.getType().isDescendedFromType(WeaponType.bow)) {
            accuracy += this.level.get() / 5;
        }
        return accuracy;
    }

    private void doInformTorchesOfEndOfTurn() {
        List items = this.inventory.getItems();
        int numItems = items.size();
        for (int i = 0; i < numItems; ++i) {
            Item item = (Item)items.get(i);
            if (!item.isOfType(ItemType.torch)) continue;
            ((Items.Torch)item).onEndOfTurn();
            if (item.getHolder() != null) continue;
            --numItems;
        }
    }

    private void doInformTerrainsOfPresence() {
        List terrains = this.map.getEntitiesInRectangle(this.location, this.getSize(), this.map.getTerrains(), null, null, null, null);
        int numTerrains = terrains.size();
        for (int i = 0; i < numTerrains; ++i) {
            Terrain terrain = (Terrain)terrains.get(i);
            terrain.onBeingHere(this);
        }
    }

    private void doCheckForBarbarianQuickHealing() {
        Game game = Game.getCurrentGame();
        if (this.getHasGainedLevel(PlayerLevel.barbarian) && game.getTurn() % 3 == 0 && this.isInjured()) {
            this.setHitPoints(this.getHitPoints() + 1);
        }
    }

    private void doCheckForTrollRegeneration() {
        if (this.getHasGainedLevel(PlayerLevel.troll) && this.isInjured()) {
            this.setHitPoints(this.getHitPoints() + 1);
        }
    }

    private void doCheckForDiseaseEffects() {
        int numDiseaseAfflictions = this.diseaseAfflictions.size();
        if (numDiseaseAfflictions > 0 && this.getHasGainedLevel(PlayerLevel.paladin)) {
            while (!this.diseaseAfflictions.isEmpty()) {
                this.onCureDiseaseReceived();
            }
            return;
        }
        Game game = Game.getCurrentGame();
        for (int i = 0; i < numDiseaseAfflictions; ++i) {
            DiseaseAffliction affliction = (DiseaseAffliction)this.diseaseAfflictions.get(i);
            Disease disease = affliction.disease;
            int interval = disease.getTurnInterval();
            if (Math.abs(affliction.turnAfflicted - game.getTurn()) % interval != interval - 1) continue;
            this.onMessage("DISEASE!");
            if (disease.equals(Disease.mutatedRat)) {
                PlayerAttribute attribute = PlayerAttribute.getRandomAttribute();
                if (Random.getInt(1, 100) <= 55) {
                    this.doDecrementBaseAttribute(attribute);
                    continue;
                }
                this.doIncrementBaseAttribute(attribute);
                continue;
            }
            this.doDecrementBaseAttribute(disease.getAttributeAffected());
        }
    }

    private void doCheckForNecklaceOfChokingEffects() {
        if (this.equippedItems.getContains(ItemType.necklaceOfChoking)) {
            this.onMessage("CHOKING!");
            this.doTakeDamage(new Damage(1, DamageForm.choking));
        }
    }

    private void doCheckForPoisonEffects() {
        Game game = Game.getCurrentGame();
        if (this.isPoisoned()) {
            if (this.getHasGainedLevel(PlayerLevel.superhero)) {
                while (this.isPoisoned()) {
                    this.onCurePoisonReceived();
                }
                return;
            }
            if (game.getTurn() % Math.max(1, 10 / this.poisonLevel.get()) == 0) {
                this.onMessage("POISON!");
                this.doTakeDamage(new Damage(1, DamageForm.poison));
            }
        }
    }

    private void doCheckForRationConsumption() {
        int eatingInterval = 200;
        Game game = Game.getCurrentGame();
        if (game.getTurn() % 200 == 0) {
            if (!this.doLoseRation(ItemLostReason.used)) {
                this.onMessage("STARVATION!");
                this.doTakeDamage(new Damage(this.getHitPoints() / 10, DamageForm.starvation));
            } else {
                this.onMessage("You consume a ration.");
            }
        }
    }

    private void doCheckForMagicPointRecharge() {
        if (this.getHasGainedLevel(PlayerLevel.wizard)) {
            int magicRechargeInterval = 5;
            Game game = Game.getCurrentGame();
            if (game.getTurn() % 5 == 0) {
                this.magicPoints.setOneMore();
            }
        }
    }

    private void doCheckForClericalPointRecharge() {
        if (this.getHasGainedLevel(PlayerLevel.cleric)) {
            int clericalRechargeInterval = 5;
            Game game = Game.getCurrentGame();
            if (game.getTurn() % 5 == 0) {
                this.clericalPoints.setOneMore();
            }
        }
    }

    private void doCheckForRetributiveShieldDrain() {
        if (this.retributiveShieldTurnsLeft > 0) {
            --this.retributiveShieldTurnsLeft;
        }
    }

    private void doCheckForBionicStrengthDrain() {
        if (this.bionicStrengthTurnsLeft > 0) {
            --this.bionicStrengthTurnsLeft;
            if (this.bionicStrengthTurnsLeft == 0) {
                this.attributes.doUpdate();
                this.onMessage("Your bionic strength has ended.");
            }
        }
    }

    private void doCheckForQuickenSelfDrain() {
        if (this.quickenSelfTurnsLeft > 0) {
            --this.quickenSelfTurnsLeft;
            if (this.quickenSelfTurnsLeft == 0) {
                this.reporter.doReport(new PlayerEvents.QuickenedChanged(this));
                this.onMessage("You are no longer quickened.");
                if (Random.getInt(1, 2) == 1) {
                    this.doDecrementBaseAttribute(PlayerAttribute.endurance);
                }
            }
        }
    }

    public void doAct() {
        this.actedThisTurn.set(false);
        this.currentAttackOffhand = false;
        this.attacksMadeThisTurn = 0;
        this.offhandAttacksMadeThisTurn = 0;
        this.setMovementPoints(this.getMaxMovementPoints());
        if (this.pendingMoveDestination.x >= 0 && !this.isParalyzed()) {
            this.doMove(this.pendingMoveDestination);
        } else {
            this.movementSoundCounter = 0;
        }
        this.doInformTerrainsOfPresence();
        this.doCheckForBarbarianQuickHealing();
        this.doCheckForTrollRegeneration();
        this.doCheckForDiseaseEffects();
        this.doCheckForNecklaceOfChokingEffects();
        this.doCheckForPoisonEffects();
        this.doCheckForRationConsumption();
        this.doCheckForMagicPointRecharge();
        this.doCheckForClericalPointRecharge();
        this.doCheckForRetributiveShieldDrain();
        this.doCheckForBionicStrengthDrain();
        this.doCheckForQuickenSelfDrain();
        boolean paralyzed = this.isParalyzed();
        if (!(this.actedThisTurn.get() || this.isDead() || paralyzed)) {
            this.reporter.doReport(new PlayerEvents.CanActAgain(this));
        } else if (!this.actedThisTurn.get() && paralyzed) {
            this.doEndTurn();
        }
    }

    public boolean getHasGainedLevel(PlayerLevel level) {
        int index = this.levels.indexOf(level);
        return index >= 0 && index <= this.level.get() - 5;
    }

    public Weapon getWeapon() {
        Item rightHandItem = this.equippedItems.get(EquipLocation.rightHand);
        if (rightHandItem != null && rightHandItem.isWeapon()) {
            return (Weapon)rightHandItem;
        }
        Item leftHandItem = this.equippedItems.get(EquipLocation.leftHand);
        if (leftHandItem != null && leftHandItem.isWeapon()) {
            return (Weapon)leftHandItem;
        }
        return hand;
    }

    public Weapon getOffhandWeapon() {
        Item rightHandItem;
        Item leftHandItem = this.equippedItems.get(EquipLocation.leftHand);
        if (leftHandItem == (rightHandItem = this.equippedItems.get(EquipLocation.rightHand)) && leftHandItem != null) {
            return null;
        }
        if (leftHandItem != null && leftHandItem.isWeapon() && rightHandItem != null && rightHandItem.isWeapon()) {
            return (Weapon)leftHandItem;
        }
        if (leftHandItem != null && leftHandItem.isWeapon() && rightHandItem == null || rightHandItem != null && rightHandItem.isWeapon() && leftHandItem == null || leftHandItem == null && rightHandItem == null) {
            return hand;
        }
        return null;
    }

    public int getRangedToHitModifier(Being target) {
        return this.getToHitModifier(this.currentAttackOffhand, target);
    }

    protected int getToHitModifier(boolean offhand, Being victim) {
        int modifier = 0;
        if (this.equippedItems.getContains(ItemType.blessedFigurine)) {
            ++modifier;
        }
        if (this.equippedItems.getContains(ItemType.cursedFigurine)) {
            --modifier;
        }
        Weapon offhandWeapon = this.getOffhandWeapon();
        Weapon weapon = !offhand ? this.getWeapon() : offhandWeapon;
        modifier += weapon.getWeaponType().getToHitModifier();
        if (weapon.isOfType(WeaponType.strengthBow)) {
            modifier += this.getStandardModifier(this.getStrength());
        }
        if (this.getHasGainedLevel(PlayerLevel.monk) && weapon.isOfType(WeaponType.hand)) {
            modifier += this.level.get() / 3;
        }
        if (this.getHasGainedLevel(PlayerLevel.archer) && weapon.getType().isDescendedFromType(WeaponType.bow)) {
            modifier += this.level.get() / 5;
        }
        if (this.getHasGainedLevel(PlayerLevel.cyborg) && weapon.getWeaponType().isRanged()) {
            modifier += this.getIntelligence() / 4;
        }
        if (this.getHasGainedLevel(PlayerLevel.paladin) && victim.isEvil()) {
            modifier += 2;
        }
        if (this.getAttacksPerTurn(true) > 0) {
            modifier += this.getToHitWithTwoWeaponsModifierForAgility(offhand);
        }
        modifier = !weapon.getWeaponType().isRanged() ? (modifier += this.getToHitModifierForStrength()) : (modifier += this.getRangedAttackToHitModifierForAgility());
        return modifier;
    }

    public int getRangedAttackToHitModifierForAgility() {
        return this.getStandardModifier(this.getAgility());
    }

    public int getToHitWithTwoWeaponsModifierForAgility(boolean offhand) {
        return -(Math.max(0, 23 - this.getAgility()) / 4) * (offhand ? 2 : 1);
    }

    private int getStandardModifier(int score) {
        return (score - 10) / 2;
    }

    protected int getDamageModifier(boolean offhand) {
        int modifier = 0;
        Weapon offhandWeapon = this.getOffhandWeapon();
        Weapon weapon = !offhand ? this.getWeapon() : offhandWeapon;
        modifier += weapon.getWeaponType().getDamageModifier();
        if (weapon.isOfType(WeaponType.strengthBow)) {
            modifier += this.getStrength() - 15;
        }
        if (this.getHasGainedLevel(PlayerLevel.monk) && weapon.isOfType(WeaponType.hand)) {
            modifier += this.level.get() / 3;
        }
        if (this.getHasGainedLevel(PlayerLevel.archer) && weapon.getType().isDescendedFromType(WeaponType.bow)) {
            modifier += this.level.get() / 5;
        }
        if (this.getHasGainedLevel(PlayerLevel.cyborg) && weapon.getWeaponType().isRanged()) {
            modifier += this.getIntelligence() / 4;
        }
        if (this.getHasGainedLevel(PlayerLevel.werewolf) && weapon.isOfType(WeaponType.hand)) {
            modifier += Random.getInt(0, 6);
        }
        if (!weapon.getWeaponType().isRanged()) {
            if (this.getHasGainedLevel(PlayerLevel.minotaur)) {
                modifier += Random.getInt(1, 4);
            }
            modifier += this.getDamageModifierForStrength();
        }
        return modifier;
    }

    public int getDefenseModifierForAgility() {
        return this.getStandardModifier(this.getAgility());
    }

    protected int getNumberToHitZeroDefense() {
        return 11 - this.level.get();
    }

    public int getAvoidance() {
        int avoidance = super.getAvoidance();
        List items = this.equippedItems.getCompressedList();
        int numItems = items.size();
        for (int j = 0; j < numItems; ++j) {
            Item item = (Item)items.get(j);
            avoidance -= item.getType().getAvoidanceModifier();
        }
        return avoidance -= this.getAvoidanceModifierForAgility();
    }

    public int getAvoidanceModifierForAgility() {
        return this.getStandardModifier(this.getAgility());
    }

    protected void onCureDiseaseReceived() {
        if (!this.diseaseAfflictions.isEmpty()) {
            this.map.onSoundIssued(Sound.cureDisease, this.location);
            LightSourceVisualEffect effect = new LightSourceVisualEffect(null, new MapPixelDistance(new MapTileDistance(4)));
            this.map.doAddEntity((MapEntity)effect, this.location);
            for (int i = 1; i <= 9; ++i) {
                int frame = i <= 5 ? i : 10 - i;
                effect.setImageName("cureDisease" + frame);
                ThreadUtil.doSleep(240L);
            }
            this.map.doRemoveEntity(effect);
            this.diseaseAfflictions.remove(this.diseaseAfflictions.size() - 1);
            if (this.diseaseAfflictions.isEmpty()) {
                this.reporter.doReport(new PlayerEvents.DiseasedChanged(this));
            }
        }
    }

    protected void onStruckByDisease(Disease disease) {
        if (this.getHasGainedLevel(PlayerLevel.paladin)) {
            return;
        }
        int numDiseaseAfflictions = this.diseaseAfflictions.size();
        for (int i = 0; i < numDiseaseAfflictions; ++i) {
            DiseaseAffliction affliction = (DiseaseAffliction)this.diseaseAfflictions.get(i);
            if (!affliction.disease.equals(disease)) continue;
            return;
        }
        DiseaseAffliction affliction = new DiseaseAffliction();
        affliction.disease = disease;
        affliction.turnAfflicted = Game.getCurrentGame().getTurn();
        this.diseaseAfflictions.add(affliction);
        if (this.diseaseAfflictions.size() == 1) {
            this.reporter.doReport(new PlayerEvents.DiseasedChanged(this));
        }
    }

    protected void onPoisoned(int degree) {
        if (this.getHasGainedLevel(PlayerLevel.superhero)) {
            return;
        }
        this.poisonLevel.set(this.poisonLevel.get() + degree);
    }

    protected void onCurePoisonReceived() {
        if (this.isPoisoned()) {
            this.map.onSoundIssued(Sound.curePoison, this.location);
            LightSourceVisualEffect effect = new LightSourceVisualEffect(null, new MapPixelDistance(new MapTileDistance(5)));
            this.map.doAddEntity((MapEntity)effect, this.location);
            for (int i = 1; i <= 5; ++i) {
                effect.setImageName("curePoison" + i);
                ThreadUtil.doSleep(200L);
            }
            this.map.doRemoveEntity(effect);
            this.poisonLevel.set(this.poisonLevel.get() - 1);
        }
    }

    public boolean isPoisoned() {
        return this.poisonLevel.get() > 0;
    }

    public void onRadiationExposure() {
        if (this.getHasGainedLevel(PlayerLevel.neonKnight)) {
            return;
        }
        if (this.equippedItems.getContains(ItemType.leadLinedCloak)) {
            return;
        }
        if (++this.radiationExposures >= 3) {
            this.radiationExposures = 0;
            ++this.radiationDamage;
            this.doUpdateMaxHitPoints();
            this.onMessage("RADIATION SICKNESS!");
        }
    }

    protected void onAttackHitVictim(Being victim, int damage, boolean offhand) {
        int roll;
        Weapon weapon = !offhand ? this.getWeapon() : this.getOffhandWeapon();
        weapon.onHitVictim(victim, this, damage);
        if (this.getHasGainedLevel(PlayerLevel.subvampire) && weapon.isOfType(WeaponType.hand) && (roll = Random.getInt(1, 20)) <= this.attributes.get(PlayerAttribute.agility)) {
            this.onHealed(damage / 2);
        }
        if (this.getHasGainedLevel(PlayerLevel.demon) && !victim.isDead() && weapon.isOfType(WeaponType.hand) && (roll = Random.getInt(1, 20)) <= this.attributes.get(PlayerAttribute.endurance)) {
            victim.onHitByDisintegration(this.level.get() - 4);
        }
        if (this.getHasGainedLevel(PlayerLevel.pixie) && !victim.isDead() && weapon.isOfType(WeaponType.hand)) {
            victim.onHitByPixieTouch(this.level.get());
        }
    }

    public boolean isBeingStealthy() {
        if (this.getHasGainedLevel(PlayerLevel.ninja)) {
            return this.stealthy.get();
        }
        return false;
    }

    public int getStealthAvoidancePenalty() {
        return (this.getAgility() + this.getIntelligence()) / 4;
    }

    public int getPowerRating() {
        return this.level.get();
    }

    public boolean getDisarmsTrap(Trap trap) {
        if (!this.getHasGainedLevel(PlayerLevel.thief)) {
            return false;
        }
        if (Random.getInt(1, 20) <= (this.getIntelligence() + this.getAgility()) / 2) {
            this.onMessage("You disarmed a trap!");
            return true;
        }
        return false;
    }

    protected boolean doDetectTraps() {
        if (!this.getHasGainedLevel(PlayerLevel.thief)) {
            return false;
        }
        List traps = this.map.getTrapsInRange(this.location, new MapPixelDistance(3 * TileSize.tileSize.width / 2), null);
        boolean trapsFound = false;
        int numTraps = traps.size();
        for (int i = 0; i < numTraps; ++i) {
            Trap trap = (Trap)traps.get(i);
            if (trap.isDetected() || Random.getInt(1, 20) > (this.getIntelligence() + this.getAgility()) / 4) continue;
            trap.onDetected();
            this.onMessage("You detect a trap!");
            trapsFound = true;
        }
        return trapsFound;
    }

    public void doRemoveItem(Item item) {
        boolean removed = this.inventory.doRemoveItem(item);
        if (!removed) {
            removed = this.doUnequipItem(item, false, false);
        }
        if (removed) {
            this.onItemLost(item, 0, item.isDestroyed() ? ItemLostReason.destroyed : ItemLostReason.used);
        }
    }

    protected boolean doLoseRation(ItemLostReason reason) {
        Item rations = this.inventory.getItemOfGroupableType(ItemType.ration);
        if (rations != null) {
            rations.doRemoveOne();
            this.onItemLost(rations, 1, reason);
            return true;
        }
        return false;
    }

    protected boolean doLoseGold(int quantity, ItemLostReason reason) {
        Item gold = this.inventory.getItemOfGroupableType(ItemType.gold);
        if (gold != null) {
            gold.doRemoveQuantity(quantity);
            this.onItemLost(gold, quantity, reason);
            return true;
        }
        return false;
    }

    protected void doDie(Damage damage) {
        Map map = this.getMap();
        map.onSoundIssued(Sound.playerDead, this.location);
        Item phylactery = this.inventory.getFirstItemOfType(ItemType.phylacteryOfResurrection);
        if (phylactery != null) {
            this.onMessage("phylactery of resurrection!");
            map.onSoundIssued(Sound.phylacteryOfResurrection, this.location);
            phylactery.doDestroy(false);
            this.onHealedFully();
            return;
        }
        super.doDie(damage);
        Terrain bones = TerrainFactory.doCreateTerrain(TerrainType.bones);
        map.doAddEntity((MapEntity)bones, this.location);
        this.reporter.doReport(new PlayerEvents.BecameBones(this, bones));
        this.reporter.doReport(new PlayerEvents.Dead(this));
        Game.getCurrentGame().onStopping();
    }

    protected void doGainExperienceLevel() {
        this.experience.set(ExperienceNeededForLevels.getExperienceNeededForLevel(this.level.get() + 1));
    }

    protected void doLoseExperienceLevel() {
        if (this.level.get() <= 1) {
            return;
        }
        if (this.equippedItems.getContains(ItemType.necklaceOfEssence)) {
            Item item = this.equippedItems.getItemOfType(ItemType.necklaceOfEssence);
            item.onWorked();
            return;
        }
        this.experience.set((ExperienceNeededForLevels.getExperienceNeededForLevel(this.level.get()) + ExperienceNeededForLevels.getExperienceNeededForLevel(this.level.get() - 1)) / 2);
        ++this.numLevelsLost;
    }

    protected void doIncrementBaseAttribute(PlayerAttribute attribute) {
        this.map.onSoundIssued(Sound.attributeGained, this.location);
        this.baseAttributes.set(attribute, this.baseAttributes.get(attribute) + 1);
        this.onMessage("You gain a point of " + attribute.getName() + "!");
    }

    protected void doDecrementBaseAttribute(PlayerAttribute attribute) {
        this.map.onSoundIssued(Sound.attributeLost, this.location);
        this.baseAttributes.set(attribute, this.baseAttributes.get(attribute) - 1);
        this.onMessage("You lose a point of " + attribute.getName() + "!");
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void onHitPointsChange() {
        this.reporter.doReport(new PlayerEvents.HitPointsChanged(this));
    }

    protected void onMaxHitPointsChange() {
        this.reporter.doReport(new PlayerEvents.MaxHitPointsChanged(this));
    }

    protected void doUpdateMaxHitPoints() {
        int max = ListUtil.getSumOfIntegerList(this.hitPointsByLevel, this.level.get());
        max -= this.radiationDamage;
        this.maxHitPoints.set(Math.max(1, max += this.level.get() * this.getHitPointsModifierForEndurance()));
    }

    public int getHitPointsModifierForEndurance() {
        return this.getStandardModifier(this.getEndurance());
    }

    public int getMaxEncumbranceModifierForStrength() {
        return (this.getStrength() - 10) * 10;
    }

    public int getMaxEncumbranceModifierForEndurance() {
        return (this.getEndurance() - 10) * 10;
    }

    private void doMemorizeLocation() {
        PowerDischarge.doDischarge(this);
        this.memorizedLocations.set(this.map.getLevel(), new MapPixelLocation(this.location));
    }

    public int getGold() {
        return this.getGold(false);
    }

    public int getGold(boolean countItemsUnderneath) {
        int gold;
        Item goldItem = this.inventory.getItemOfGroupableType(ItemType.gold);
        int n = gold = goldItem != null ? goldItem.getQuantity() : 0;
        if (countItemsUnderneath) {
            List items = this.map.getItemsInRange(this.location, TileSize.tileDistance, null);
            int numItems = items.size();
            for (int i = 0; i < numItems; ++i) {
                Item item = (Item)items.get(i);
                if (!item.isOfType(ItemType.gold)) continue;
                gold += item.getQuantity();
            }
        }
        return gold;
    }

    private void doAddGold(int amount) {
        Item gold = this.inventory.getItemOfGroupableType(ItemType.gold);
        if (gold == null) {
            gold = ItemFactory.doCreateItem(ItemType.gold);
            gold.setQuantity(0);
            this.inventory.doAddItem(gold);
        }
        gold.doAddQuantity(amount);
    }

    protected void doRemoveGold(int amount) {
        int remainder;
        int held;
        Item gold = this.inventory.getItemOfGroupableType(ItemType.gold);
        int n = held = gold != null ? gold.getQuantity() : 0;
        if (gold != null) {
            gold.doRemoveQuantity(Math.min(amount, held));
        }
        if ((remainder = amount - held) > 0) {
            List items = this.map.getItemsInRange(this.location, TileSize.tileDistance, null);
            int numItems = items.size();
            for (int i = 0; i < numItems; ++i) {
                Item item = (Item)items.get(i);
                if (!item.isOfType(ItemType.gold)) continue;
                int itemQuantity = item.getQuantity();
                int newRemainder = remainder - itemQuantity;
                item.doRemoveQuantity(Math.min(remainder, itemQuantity));
                remainder = newRemainder;
                if (remainder <= 0) break;
            }
        }
    }

    protected void onLevelsRestored() {
        for (int i = 0; i < this.numLevelsLost; ++i) {
            this.experience.set(ExperienceNeededForLevels.getExperienceNeededForLevel(this.level.get() + 1));
        }
        this.numLevelsLost = 0;
    }

    public void onMessage(String message) {
        this.onMessage(message, MessageType.normal);
    }

    public void onMessage(String message, MessageType type) {
        this.onMessage(message, type, 0);
    }

    public void onMessage(String message, MessageType type, int duration) {
        this.reporter.doReport(new PlayerEvents.MessageReceived(this, message, type, duration));
    }

    protected void onItemLost(Item item, ItemLostReason reason) {
        this.onItemLost(item, item.getQuantity(), reason);
    }

    protected void onItemLost(Item item, int quantity, ItemLostReason reason) {
        if (!item.getType().isGroupable() || item.getQuantity() <= 0) {
            item.setHolder(null);
        }
        for (int i = 0; i < this.handsConfigs.length; ++i) {
            HandsConfig config = this.handsConfigs[i];
            boolean removed = false;
            if (config.leftItem == item) {
                config.leftItem = null;
                removed = true;
            }
            if (config.rightItem == item) {
                config.rightItem = null;
                removed = true;
            }
            if (!removed) continue;
            this.reporter.doReport(new PlayerEvents.HandsConfigChanged(this));
        }
        if (reason == ItemLostReason.destroyed) {
            String message = !item.getType().isGroupable() ? "Your " + item.getName() + " is destroyed!" : "" + quantity + " of your " + item.getName() + " are destroyed!";
            this.getMap().onSoundIssued(Sound.itemDamaged, this.getLocation());
            this.getMap().onSoundIssued(Sound.itemLost, this.getLocation());
            this.onMessage(message);
        } else if (reason == ItemLostReason.stolen) {
            String message = !item.getType().isGroupable() ? "Your " + item.getName() + " is stolen!" : "" + quantity + " of your " + item.getType().getPluralName() + " " + (quantity > 1 ? "are" : "is") + " stolen!";
            this.getMap().onSoundIssued(Sound.itemLost, this.getLocation());
            this.onMessage(message);
        }
        this.encumbrance.doUpdate();
    }

    public void doEndTurn() {
        this.actedThisTurn.set(true);
    }

    private void doConjureDeathFog(MapPixelLocation location) {
        PowerDischarge.doDischarge(this);
        if (this.isConfused()) {
            location = Confusion.getModifiedLocation(this.map, location, this.getLocation());
        }
        DeathFog.doFog(this.map, location, this.getClericalCastingLevel());
    }

    protected void doSenseSecretDoors() {
        VisualEffect effect;
        PowerDischarge.doDischarge(this);
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        tiles.add(Tile.secretDoor);
        tiles.add(Tile.roomSecretDoor);
        List locations = this.map.getLocationsOfTilesInLOSAndRange(tiles, this.location, new MapTileDistance(10));
        ArrayList<MapPixelLocation> sensed = new ArrayList<MapPixelLocation>();
        int numLocations = locations.size();
        for (int i = 0; i < numLocations; ++i) {
            MapPixelLocation door = (MapPixelLocation)locations.get(i);
            int roll = Random.getInt(1, 20);
            MapTileDistance tileDistance = new MapTileDistance(MapPixelLocationUtil.getDistance(this.location, door));
            if (roll > this.getIntelligence() - tileDistance.distance / 3) continue;
            sensed.add(door);
        }
        ArrayList<VisualEffect> effects = new ArrayList<VisualEffect>();
        int numSensed = sensed.size();
        for (int i = 0; i < numSensed; ++i) {
            MapPixelLocation location = (MapPixelLocation)sensed.get(i);
            effect = new VisualEffect("mark");
            this.map.doAddEntity((MapEntity)effect, location);
            effects.add(effect);
            this.map.onSoundIssued(Sound.markLocation, location);
        }
        if (!sensed.isEmpty()) {
            ThreadUtil.doSleep(1000L);
        }
        int numEffects = effects.size();
        for (int i = 0; i < numEffects; ++i) {
            effect = (VisualEffect)effects.get(i);
            this.map.doRemoveEntity(effect);
        }
    }

    private boolean doLeap(MapPixelLocation location) {
        if (this.isConfused()) {
            location = Confusion.getModifiedLocation(this.map, location, this.getLocation());
        }
        FloatPoint direction = PointUtil.getUnitVector(this.location, location);
        MapPixelDistance distance = MapPixelLocationUtil.getDistance(this.location, location);
        boolean allowed = BeingUtil.doLeap(this, location, this.getStrength(), this.getAgility());
        if (allowed) {
            MapPixelLocation stopLocation = new MapPixelLocation(this.location);
            int inertiaMagnitude = distance.distance / 4;
            stopLocation.x = (int)((float)stopLocation.x + (float)inertiaMagnitude * direction.x);
            stopLocation.y = (int)((float)stopLocation.y + (float)inertiaMagnitude * direction.y);
            this.doMove(stopLocation);
        }
        return allowed;
    }

    private void doEmitLightning(MapPixelLocation location) {
        PowerDischarge.doDischarge(this);
        if (this.isConfused()) {
            location = Confusion.getModifiedLocation(this.map, location, this.getLocation());
        }
        LightningBolt.doBolt(this.map, this.getLocation(), location, this.getClericalCastingLevel(), false);
    }

    private void doPlaceVengefulSymbol(MapPixelLocation location) {
        PowerDischarge.doDischarge(this);
        Terrains.VengefulSymbol symbol = (Terrains.VengefulSymbol)TerrainFactory.doCreateTerrain(TerrainType.vengefulSymbol);
        symbol.setStrength(this.getClericalCastingLevel());
        if (this.isConfused()) {
            location = Confusion.getModifiedLocation(this.map, location, this.getLocation());
        }
        this.map.doAddEntity((MapEntity)symbol, location);
    }

    private void doHurlFireball(MapPixelLocation to) {
        PowerDischarge.doDischarge(this);
        MapPixelLocation from = this.getLocation();
        if (this.isConfused()) {
            to = Confusion.getModifiedLocation(this.map, to, from);
        }
        MapPixelDistance distance = MapPixelLocationUtil.getDistance(from, to);
        int roll = Random.getInt(1, 20);
        int missedBy = roll + distance.distance / 2 / TileSize.tileSize.width - (this.getAgility() + 5);
        if (missedBy > 0) {
            MapPixelDistance maxError = new MapPixelDistance(Math.min(distance.distance / 2, (int)Math.ceil((float)missedBy / 3.0f) * TileSize.tileSize.width));
            to = Fireball.getSkeweredTargetLocation(this.map, from, to, maxError);
        }
        Fireball.doFireball(this.map, from, to, this.getFireballStrength());
    }

    protected void doSpinWeb() {
        PowerDischarge.doDischarge(this);
        Terrains.Web web = (Terrains.Web)TerrainFactory.doCreateTerrain(TerrainType.web);
        web.setSpinner(this);
        this.map.doAddEntity((MapEntity)web, this.location);
        this.doTakeDamage(new Damage(1, DamageForm.exertion));
        this.doEndTurn();
    }

    public boolean getCanThrowBoulder() {
        MapPixelLocation from = this.getLocation();
        List terrains = this.map.getEntitiesInRectangle(from, this.getSize(), this.map.getTerrains(), null, null, null, null);
        int numTerrains = terrains.size();
        for (int i = 0; i < numTerrains; ++i) {
            Terrain terrain = (Terrain)terrains.get(i);
            if (!terrain.isOfType(TerrainType.boulder)) continue;
            int roll = Random.getInt(1, 20);
            if (roll > this.getStrength() - 5) {
                this.onMessage("You failed your strength check!");
                return false;
            }
            return true;
        }
        this.onMessage("There's no boulder here.");
        return false;
    }

    private void doThrowBoulder(MapPixelLocation to) {
        MapPixelLocation from = this.getLocation();
        if (this.isConfused()) {
            to = Confusion.getModifiedLocation(this.map, to, from);
        }
        List terrains = this.map.getEntitiesInRectangle(from, this.getSize(), this.map.getTerrains(), null, null, null, null);
        int numTerrains = terrains.size();
        for (int i = 0; i < numTerrains; ++i) {
            Terrain terrain = (Terrain)terrains.get(i);
            if (!terrain.isOfType(TerrainType.boulder)) continue;
            PowerDischarge.doDischarge(this);
            BoulderThrow.doThrow(this.map, terrain, from, to, this.getStrength(), this.getAgility());
            return;
        }
    }

    protected void doSenseCreatures() {
        this.map.onSoundIssued(Sound.senseCreatures, this.location);
        MapPixelDistance maxRange = new MapPixelDistance(10 * TileSize.tileSize.width);
        List inRange = this.map.getMonstersInRange(this.location, maxRange, null);
        PathFinder pathFinder = new PathFinder();
        MapTileDistance maxPathLength = new MapTileDistance(20);
        int numInRange = inRange.size();
        for (int i = 0; i < numInRange; ++i) {
            Monster monster = (Monster)inRange.get(i);
            if (pathFinder.getPassiblePath(this.map, this.location, monster.getLocation(), this, monster, maxPathLength, MovementType.flying, false, false) == null) continue;
            this.onMessage("You sense one or more creatures nearby");
            return;
        }
        this.onMessage("You sense no creatures nearby.");
    }

    protected void doEmploySuperVision() {
        PowerDischarge.doDischarge(this);
        this.doTakeDamage(new Damage(5, DamageForm.exertion));
        this.onSoundHeard(Sound.superVision, this.getLocation());
        this.reporter.doReport(new PlayerEvents.SuperVisionEmployed(this));
    }

    private void doFireEyeBeams(MapPixelLocation at) {
        PowerDischarge.doDischarge(this);
        MapPixelLocation from = this.getLocation();
        if (this.isConfused()) {
            at = Confusion.getModifiedLocation(this.map, at, from);
        }
        MapTileDistance tileDistance = new MapTileDistance(MapPixelLocationUtil.getDistance(from, at));
        int roll = Random.getInt(1, 20) + tileDistance.distance / 2;
        boolean willHit = roll <= this.getAgility();
        EyeBeams.doBeams(this.map, from, at, willHit);
        this.doTakeDamage(new Damage(2, DamageForm.exertion));
    }

    protected void doEmitRadWave() {
        if (this.getHitPoints() < this.getMaxHitPoints() / 2) {
            this.onMessage("You don't have enough of your hit points left to do this.", MessageType.important);
            return;
        }
        int roll = Random.getInt(1, 20);
        if (roll > this.getEndurance()) {
            this.onMessage("You failed your endurance check!");
            return;
        }
        PowerDischarge.doDischarge(this);
        this.doTakeDamage(new Damage(this.getHitPoints() - 1, DamageForm.exertion));
        RadWave.doWave(this.map, this.getLocation(), this.level.get());
    }

    protected void doRepelLivingDead() {
        PowerDischarge.doDischarge(this);
        boolean paladin = this.getHasGainedLevel(PlayerLevel.paladin);
        boolean cleric = this.getHasGainedLevel(PlayerLevel.cleric);
        int clericStrength = cleric ? this.getClericalCastingLevel() : 0;
        int paladinStrength = paladin ? this.level.get() / 2 : 0;
        int strength = Math.max(clericStrength, paladinStrength);
        LivingDeadRepel.doRepel(this, strength);
        if (paladin) {
            this.doTakeDamage(new Damage(2, DamageForm.exertion));
        }
    }

    protected void doLayHands() {
        if (!this.damagedSinceLayHands) {
            this.onMessage("No effect");
            return;
        }
        PowerDischarge.doDischarge(this);
        this.doTakeHealing(Random.getInt(1, this.level.get()));
        this.damagedSinceLayHands = false;
    }

    private void doFreezeBeing(MapPixelLocation at) {
        PowerDischarge.doDischarge(this);
        Being being = this.map.getFirstBeingAt(at);
        if (being == null) {
            return;
        }
        being.onFreezeAttack(this.getMagicUserCastingLevel());
    }

    protected void doFindExit() {
        PowerDischarge.doDischarge(this);
        Terrain exit = this.map.getTerrainOfType(TerrainType.downExit);
        if (exit != null) {
            this.onMessage("The exit is to the " + PointUtil.getDirectionString(this.location, exit.getLocation()) + ".");
        } else {
            this.onMessage("You don't sense an exit!");
        }
    }

    protected void doFindTreasure() {
        PowerDischarge.doDischarge(this);
        Item item = this.map.getNearestItem(this.location, 100);
        this.onMessage(item != null ? "The nearest treasure is to the " + PointUtil.getDirectionString(this.location, item.getLocation()) + "." : "You sense no valuable items around here!");
    }

    protected void doHealFully() {
        PowerDischarge.doDischarge(this);
        this.onHealedFully();
    }

    protected void doHealWounds() {
        PowerDischarge.doDischarge(this);
        this.onHealed(Random.getInt(2, 16));
    }

    protected void doCurePoison() {
        PowerDischarge.doDischarge(this);
        this.onCurePoisonReceived();
    }

    protected void doCureDisease() {
        PowerDischarge.doDischarge(this);
        this.onCureDiseaseReceived();
    }

    protected void doRevealTraps() {
        PowerDischarge.doDischarge(this);
        TrapUtil.doDetectTrapsInLOS(this.map, this.location);
    }

    protected void doSummonMeteorShower() {
        PowerDischarge.doDischarge(this);
        MeteorShower.doShower(this.map, this.getLocation(), true, this.getFireballStrength());
    }

    private int getFireballStrength() {
        return 3 + this.getMagicUserCastingLevel() - 2;
    }

    protected void doProjectRetributiveShield() {
        PowerDischarge.doDischarge(this);
        this.map.onSoundIssued(Sound.retributiveShieldProjection, this.location);
        LightSourceVisualEffect effect = new LightSourceVisualEffect(null, new MapPixelDistance(new MapTileDistance(4)));
        this.map.doAddEntity((MapEntity)effect, this.location);
        for (int i = 1; i <= 5; ++i) {
            effect.setImageName("retributiveShieldProjection" + i);
            ThreadUtil.doSleep(200L);
        }
        this.map.doRemoveEntity(effect);
        this.retributiveShieldTurnsLeft = this.getMagicUserCastingLevel() / 2 * 5;
    }

    protected void doAchieveBionicStrength() {
        PowerDischarge.doDischarge(this);
        this.getMap().onSoundIssued(Sound.bionicStrength, this.getLocation());
        this.bionicStrengthTurnsLeft = this.getMagicUserCastingLevel() / 2 * 5;
        this.attributes.doUpdate();
        this.onMessage("Strengthened!");
    }

    protected void doQuickenSelf() {
        for (int i = 0; i < 3; ++i) {
            PowerDischarge.doDischarge(this.map, this.location, 50);
        }
        this.quickenSelfTurnsLeft = this.getMagicUserCastingLevel() / 2 * 2;
        this.reporter.doReport(new PlayerEvents.QuickenedChanged(this));
    }

    public String getImageName() {
        PlayerLevel level = (PlayerLevel)this.levels.get(Math.max(this.level.get() - 5, 0));
        return "player/" + level.getImageName();
    }

    protected Item doCreateInventoryItem(ItemType type) {
        return this.doCreateInventoryItem(type, 1);
    }

    protected Item doCreateInventoryItem(ItemType type, int quantity) {
        Item item;
        Item item2 = item = type instanceof WeaponType ? WeaponFactory.doCreateWeapon((WeaponType)type) : ItemFactory.doCreateItem(type);
        if (type.isGroupable()) {
            item.setQuantity(quantity);
        }
        this.inventory.doAddItem(item);
        item.setIdentified(true);
        return item;
    }

    public int getToHitModifierForStrength() {
        return this.getStandardModifier(this.getStrength());
    }

    public int getDamageModifierForStrength() {
        return this.getStandardModifier(this.getStrength());
    }

    protected int getMagicUserCastingLevel() {
        int numLevels = this.levels.size();
        for (int i = this.level.get() - 5; i >= 0 && i < numLevels; --i) {
            PlayerLevel level = (PlayerLevel)this.levels.get(i);
            int index = ArrayUtil.getIndexOf(level, PlayerClass.magicUser.getLevels());
            if (index < 0) continue;
            return (index + 1) * 2;
        }
        return 0;
    }

    protected int getClericalCastingLevel() {
        int numLevels = this.levels.size();
        for (int i = this.level.get() - 5; i >= 0 && i < numLevels; --i) {
            PlayerLevel level = (PlayerLevel)this.levels.get(i);
            int index = ArrayUtil.getIndexOf(level, PlayerClass.cleric.getLevels());
            if (index < 0) continue;
            return (index + 1) * 2;
        }
        return 0;
    }

    public void doBecomeParalyzed(int duration) {
        if (this.getHasGainedLevel(PlayerLevel.subvampire)) {
            return;
        }
        super.doBecomeParalyzed(duration);
    }

    public void doBecomeConfused(int duration) {
        if (this.getHasGainedLevel(PlayerLevel.minotaur)) {
            return;
        }
        super.doBecomeConfused(duration);
    }

    protected boolean getBreaksOutOfWeb(int turnsStuck) {
        return turnsStuck + this.getStrength() > 20;
    }

    public MapPixelDistance getVacuumHoleSuckDistance() {
        return new MapPixelDistance(Math.min(4, this.getMaxMovementPoints() - 1) * TileSize.tileSize.width);
    }

    public void onGustOfWindTrap() {
        this.onMessage("A strong, wet gust of wind whips past you!");
        Items.Torch torch = null;
        while ((torch = this.inventory.getFirstLitTorch()) != null) {
            this.onMessage("Your torch is somehow spoiled!");
            torch.doSpoil();
        }
    }

    protected boolean onCurePoisonService(MapEntity seller) {
        if (!this.isPoisoned()) {
            this.onMessage("You aren't poisoned!", MessageType.error);
            return false;
        }
        while (this.isPoisoned()) {
            PowerDischarge.doDischarge(seller);
            this.onCurePoisonReceived();
        }
        return true;
    }

    protected boolean onCureDiseaseService(MapEntity seller) {
        if (!this.isDiseased()) {
            this.onMessage("You aren't diseased!", MessageType.error);
            return false;
        }
        while (this.isDiseased()) {
            PowerDischarge.doDischarge(seller);
            this.onCureDiseaseReceived();
        }
        return true;
    }

    protected boolean onHealWoundsService(MapEntity seller) {
        if (!this.isInjured()) {
            this.onMessage("You aren't hurt!", MessageType.error);
            return false;
        }
        PowerDischarge.doDischarge(seller);
        this.doTakeHealing(Random.getInt(1, 8));
        return true;
    }

    protected boolean onHealFullyService(MapEntity seller) {
        if (!this.isInjured()) {
            this.onMessage("You aren't hurt!", MessageType.error);
            return false;
        }
        PowerDischarge.doDischarge(seller);
        this.onHealedFully();
        return true;
    }

    protected boolean onRestoreLevelsService(MapEntity seller) {
        if (this.numLevelsLost == 0) {
            this.onMessage("You haven't lost any levels!", MessageType.error);
            return false;
        }
        PowerDischarge.doDischarge(seller);
        this.onLevelsRestored();
        return true;
    }

    protected boolean onRemoveCursedItemsService(MapEntity seller) {
        boolean hadCursedItem = false;
        int numEquipLocations = EquipLocation.locations.size();
        for (int j = 0; j < numEquipLocations; ++j) {
            Item item = this.equippedItems.get(j);
            if (item == null || !item.getType().isCursed()) continue;
            PowerDischarge.doDischarge(seller);
            PowerDischarge.doDischarge(this);
            this.doUnequipItem(item, false, true);
            hadCursedItem = true;
        }
        if (!hadCursedItem) {
            this.onMessage("You don't have any cursed items equipped!", MessageType.error);
            return false;
        }
        return true;
    }

    public void onHealedByMedicalRobot() {
        while (this.isPoisoned()) {
            this.onCurePoisonReceived();
        }
        while (this.isDiseased()) {
            this.onCureDiseaseReceived();
        }
        this.onHealedFully();
    }

    public void onMedusaDeath() {
        this.doBecomeNotParalyzed();
    }

    public void onMedusaGaze(int strength) {
        if (this.isParalyzed()) {
            return;
        }
        Being.AvoidResult result = this.doAvoid(strength / 2);
        if (!result.avoided) {
            this.doBecomeParalyzed(Random.getInt(1, strength));
        }
    }

    public void onHitByDragonBreath(DamageForm breathType, int strength, int damage) {
        Being.AvoidResult result = this.doAvoid(strength / 2);
        if (!result.avoided) {
            if (breathType.equals(DamageForm.acid)) {
                List items = this.equippedItems.getCompressedList();
                int numItems = items.size();
                for (int i = 0; i < numItems; ++i) {
                    Item item = (Item)items.get(i);
                    item.onHitByDragonBreath(breathType, strength);
                }
            }
        } else {
            damage /= 2;
        }
        this.doTakeDamage(new Damage(damage, breathType));
    }

    public void onHitByAssassinationBlow(int damage, DamageForm form) {
        this.onMessage("Assassination blow!!");
        this.doTakeDamage(new Damage(damage, form));
    }

    public void onPoisonGas(int strength) {
        Being.AvoidResult result = this.doAvoid(strength / 2);
        if (!result.avoided) {
            this.onPoisoned(1);
        }
    }

    public void onHitByMonster(Monster monster, MonsterAttack attack, int damage, int hitBy) {
        boolean subvampire = this.getHasGainedLevel(PlayerLevel.subvampire);
        if ((this.getHasGainedLevel(PlayerLevel.werewolf) || subvampire) && attack != null && monster.getPowerRating() <= (subvampire ? 6 : 3) && attack.getPenetrationType().equals(PenetrationType.normal)) {
            this.onAttackedAndMissed();
            return;
        }
        super.onHitByMonster(monster, attack, damage, hitBy);
        if (attack.equals(MonsterAttack.mummyArm)) {
            Being.AvoidResult result = this.doAvoid(damage);
            if (!result.avoided) {
                this.onStruckByDisease(Disease.mummy);
            }
        } else if (attack.equals(MonsterAttack.ghoulClaw)) {
            Being.AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided) {
                int maxDuration = 5;
                int duration = (int)Math.rint((double)(maxDuration * (20 - this.getEndurance())) / 20.0);
                this.doBecomeParalyzed(duration);
            }
        } else if (attack.equals(MonsterAttack.rogueDagger)) {
            Being.AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided) {
                this.onPoisoned(3);
            }
        } else if (attack.equals(MonsterAttack.cannibalBlowgunDart)) {
            Being.AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided) {
                this.onPoisoned(1);
            }
        } else if (attack.equals(MonsterAttack.giantWaspSting)) {
            Being.AvoidResult result = this.doAvoid(hitBy - 4);
            if (!result.avoided) {
                this.onPoisoned(1);
            }
        } else if (attack.equals(MonsterAttack.poisonousSnakeFangs)) {
            Being.AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided) {
                this.onPoisoned(1);
            }
        } else if (attack.equals(MonsterAttack.livingDeadPirateGrab)) {
            Being.AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided) {
                this.doLoseGold(Random.getInt(1, 20), ItemLostReason.stolen);
            }
        } else if (attack.equals(MonsterAttack.munchkinGrab)) {
            Being.AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided) {
                this.doLoseRation(ItemLostReason.stolen);
                if (this.inventory.getItemOfGroupableType(ItemType.ration) == null) {
                    ((Monsters.Munchkin)monster).onNoRationsLeft(this);
                }
            }
        } else if (attack.equals(MonsterAttack.rusterAntenna)) {
            this.onHitByRusterAntenna(hitBy);
        } else if (attack.equals(MonsterAttack.gremlinSwipe)) {
            Being.AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided) {
                this.doLoseRandomNonGroupableInventoryItem(ItemLostReason.stolen);
                ((Monsters.Gremlin)monster).onItemSwiped();
            }
        } else if (attack.equals(MonsterAttack.scumShambleArm)) {
            Being.AvoidResult result = this.doAvoid(damage - 4);
            if (!result.avoided) {
                this.onStruckByDisease(Disease.scumShamble);
            }
        } else if (attack.equals(MonsterAttack.ghastClaw)) {
            Being.AvoidResult result = this.doAvoid(hitBy - 6);
            if (!result.avoided) {
                this.doDecrementBaseAttribute(PlayerAttribute.strength);
            }
        } else if (attack.equals(MonsterAttack.negadeadClaw)) {
            Being.AvoidResult result = this.doAvoid(hitBy - 4);
            if (!result.avoided) {
                this.doLoseExperienceLevel();
            }
        } else if (attack.equals(MonsterAttack.killerCorpseTouch)) {
            Being.AvoidResult result = this.doAvoid(hitBy - 2);
            if (!result.avoided) {
                this.doLoseExperienceLevel();
            }
        } else if (attack.equals(MonsterAttack.typhoidZombieRend)) {
            Being.AvoidResult result = this.doAvoid(damage - 2);
            if (!result.avoided) {
                this.onStruckByDisease(Disease.typhoidZombie1);
                this.onStruckByDisease(Disease.typhoidZombie2);
                this.onStruckByDisease(Disease.typhoidZombie3);
            }
        } else if (attack.equals(MonsterAttack.slimeChuckerSlime)) {
            Item item;
            Being.AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided && (item = this.getRandomItem()) != null) {
                item.onHitBySlime(hitBy);
            }
        } else if (attack.equals(MonsterAttack.vampireDrainStrike)) {
            Being.AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided) {
                this.doLoseExperienceLevel();
                this.doLoseExperienceLevel();
                ((Monsters.Vampire)monster).onDrainStrikeWorked();
            }
        } else if (attack.equals(MonsterAttack.batBite)) {
            Items.Torch torch = this.inventory.getFirstLitTorch();
            if (torch != null) {
                Being.AvoidResult result = this.doAvoid(hitBy);
                if (!result.avoided) {
                    this.onMessage("Your torch is extinguished!");
                    torch.doExtinguish();
                }
            }
        } else if (attack.equals(MonsterAttack.minotaurFistHornCombo)) {
            if (hitBy >= 4) {
                this.doTakeDamage(new Damage(Random.getInt(1, 4), DamageForm.pierce));
            }
        } else if (attack.equals(MonsterAttack.mutatedRatBite)) {
            Being.AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided) {
                this.onStruckByDisease(Disease.mutatedRat);
            }
        } else if (attack.equals(MonsterAttack.giantRatBite)) {
            Being.AvoidResult result = this.doAvoid(hitBy - 4);
            if (!result.avoided) {
                this.onStruckByDisease(Disease.rat);
            }
        } else if (attack.equals(MonsterAttack.deathbotGrasp)) {
            Item item;
            Being.AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided && (item = this.getRandomEquippedItem()) != null) {
                item.onHitByDeathbotGrasp(hitBy);
            }
        } else if (attack.equals(MonsterAttack.poltergeistTouch)) {
            Being.AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided) {
                this.doLoseExperienceLevel();
            }
        } else if (attack.equals(MonsterAttack.livingDeadWizard2VortexBeam)) {
            Item item;
            Being.AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided && (item = this.getRandomEquippedItem()) != null) {
                item.onHitByVortexBeam(hitBy + 10);
            }
        } else if (attack.equals(MonsterAttack.mutividerRazorSwipe)) {
            if (this.doLoseRation(ItemLostReason.stolen)) {
                ((Monsters.Mutivider)monster).onRationTheftWorked();
            }
        } else if (attack.equals(MonsterAttack.medusaSnakes) || attack.equals(MonsterAttack.giantSpiderBite)) {
            Being.AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided) {
                this.onPoisoned(1);
            }
        }
    }

    public void onGameFinished() {
        this.onMessage(null, MessageType.gameFinished);
    }

    public void onExperienceGained(int amount) {
        this.experience.set(this.experience.get() + amount);
    }

    public String getName() {
        return this.name;
    }

    protected void onPotionOfAttributeUsed(Item potion) {
        PlayerAttribute attribute = PlayerAttribute.strength;
        if (potion.isOfType(ItemType.potionOfIntelligence)) {
            attribute = PlayerAttribute.intelligence;
        } else if (potion.isOfType(ItemType.potionOfJudgement)) {
            attribute = PlayerAttribute.judgement;
        } else if (potion.isOfType(ItemType.potionOfAgility)) {
            attribute = PlayerAttribute.agility;
        } else if (potion.isOfType(ItemType.potionOfEndurance)) {
            attribute = PlayerAttribute.endurance;
        }
        PowerDischarge.doDischarge(this);
        this.doIncrementBaseAttribute(attribute);
    }

    public void onUsedItem(Item item) {
        if (item.isOfType(ItemType.potionOfPoison)) {
            this.onPoisoned(5);
            this.onMessage("Aack!!");
        } else if (item.isOfType(ItemType.potionOfStrength) || item.isOfType(ItemType.potionOfIntelligence) || item.isOfType(ItemType.potionOfJudgement) || item.isOfType(ItemType.potionOfAgility) || item.isOfType(ItemType.potionOfEndurance)) {
            this.onPotionOfAttributeUsed(item);
        }
        super.onUsedItem(item);
    }

    public void onBeneficialDrinkFromFountain() {
        this.doIncrementBaseAttribute(PlayerAttribute.getRandomAttribute());
    }

    public void onDetrimentalDrinkFromFountain() {
        this.doDecrementBaseAttribute(PlayerAttribute.getRandomAttribute());
    }

    public void onReadFromLibrary() {
        this.onMessage("This library imparts the knowledge it contains directly into your mind!", MessageType.important);
        this.doIncrementBaseAttribute(PlayerAttribute.intelligence);
    }

    public boolean isWiseEnoughForSphinx() {
        return this.attributes.get(PlayerAttribute.judgement) >= 13;
    }

    public void onLookedIntoMirroredBall() {
        this.onMessage("This mirrored ball shows you some of your mistakes in the near future, providing you with the judgement to not make them in the first place!", MessageType.important);
        this.doIncrementBaseAttribute(PlayerAttribute.judgement);
    }

    public boolean getCanUseRobotCommandInterface() {
        return this.getIntelligence() >= 18;
    }

    public void onUsedHolographicTrainer() {
        this.onMessage("This holographic trainer teaches you the next evolution in your path!", MessageType.important);
        this.doGainExperienceLevel();
    }

    protected void onHitByRusterAntenna(int hitBy) {
        Item item = this.equippedItems.get(EquipLocation.body);
        if (item != null && item.onHitByRusterAntenna(hitBy)) {
            return;
        }
        item = this.getWeapon();
        if (item != null && item.onHitByRusterAntenna(hitBy)) {
            return;
        }
        item = this.getOffhandWeapon();
        if (item != null && item.onHitByRusterAntenna(hitBy)) {
            return;
        }
        item = this.getRandomItem();
        if (item != null && item.onHitByRusterAntenna(hitBy)) {
            return;
        }
    }

    protected Item getRandomItem() {
        Item item = null;
        item = Random.getInt(1, 3) > 1 ? this.getRandomEquippedItem() : this.inventory.getRandomItem();
        return item;
    }

    protected Item getRandomEquippedItem() {
        return (Item)ListUtil.getRandomElement(this.equippedItems.getCompressedList());
    }

    protected void doLoseRandomNonGroupableInventoryItem(ItemLostReason reason) {
        List items = this.inventory.getItems();
        int numItems = items.size();
        for (int i = 0; i < numItems; ++i) {
            Item item = (Item)items.get(i);
            if (item.getType().isGroupable()) continue;
            this.inventory.doRemoveItem(item);
            this.onItemLost(item, 1, reason);
            return;
        }
    }

    protected boolean doUseGoldUnderMe(int amount) {
        List items = this.map.getEntitiesInRectangle(this.location, this.getSize(), this.map.getItems(), null, null, null, null);
        int numItems = items.size();
        for (int i = 0; i < numItems; ++i) {
            Item item = (Item)items.get(i);
            if (item == null || !item.isOfType(ItemType.gold) || item.getQuantity() < amount) continue;
            item.doRemoveQuantity(amount);
            return true;
        }
        return false;
    }

    public boolean doInteractWithTerrain(Terrain terrain) {
        if (terrain.isOfType(TerrainType.downExit)) {
            if (this.map.getLevel().isHandsItemsLevel() && HandsItemsDialog.getHandsItems(this) == null) {
                return true;
            }
            this.reporter.doReport(new PlayerEvents.MapLoading(this));
            Game game = Game.getCurrentGame();
            game.onPlayerAtDownExit(this);
            this.doEndTurn();
            return true;
        }
        if (terrain.isOfType(TerrainType.upExit)) {
            this.reporter.doReport(new PlayerEvents.MapLoading(this));
            Game game = Game.getCurrentGame();
            game.onPlayerAtUpExit(this);
            this.doEndTurn();
            return true;
        }
        return terrain.onInteractionWithPlayer(this);
    }

    public void doDonateItem(Item item) {
        this.doDonateItem(item, item.getQuantity());
    }

    public void doDonateItem(Item item, int quantity) {
        if (this.equippedItems.isEquipped(item) && !this.doUnequipItem(item, false, false)) {
            return;
        }
        if (item.getQuantity() > quantity) {
            item.doRemoveQuantity(quantity);
            item = ItemFactory.doCreateItem(item.getType());
            item.setQuantity(quantity);
        } else {
            this.inventory.doRemoveItem(item);
        }
        this.onItemLost(item, ItemLostReason.donated);
        this.getMap().onSoundIssued(Sound.itemDonated, this.getLocation());
        int gained = item.getValue(ItemValueContext.experience);
        this.onMessage("You gained " + gained + " experience points for your donation!", MessageType.important);
        this.experience.set(this.experience.get() + gained);
    }

    public void doShutDoor(MapPixelLocation location) {
        if (!this.map.isRectanglePassible((MapPixelLocation)TileSizeUtil.getPixelLocation((MapTileLocation)TileSizeUtil.getTileLocation((MapPixelLocation)location)), (Dimension)TileSize.tileSize, (MovementType)MovementType.walking, (boolean)true, (MapEntity)this, null, (boolean)false).passible) {
            return;
        }
        this.map.doCloseDoor(location, true);
    }

    public void doSay(String whatToSay) {
        this.map.onSoundIssued(Sound.playerSaid, this.location);
        PlayerUtil.doSendMessageToPlayersInLOS(this.map, this.location, this.name + ": \"" + whatToSay + "\"");
    }

    public void doUsePower(PlayerPower power) {
        this.doUsePower(power, null);
    }

    public void doUsePower(PlayerPower power, MapPixelLocation on) {
        if (this.isParalyzed()) {
            return;
        }
        boolean turnUsed = true;
        if (power.equals(PlayerPower.healWounds)) {
            this.doHealWounds();
        } else if (power.equals(PlayerPower.curePoison)) {
            this.doCurePoison();
        } else if (power.equals(PlayerPower.cureDisease)) {
            this.doCureDisease();
        } else if (power.equals(PlayerPower.achieveBionicStrength)) {
            this.doAchieveBionicStrength();
        } else if (power.equals(PlayerPower.conjureDeathFog)) {
            this.doConjureDeathFog(on);
        } else if (power.equals(PlayerPower.emitLightning)) {
            this.doEmitLightning(on);
        } else if (power.equals(PlayerPower.emitRadWave)) {
            this.doEmitRadWave();
        } else if (power.equals(PlayerPower.employSuperVision)) {
            this.doEmploySuperVision();
        } else if (power.equals(PlayerPower.senseCreatures)) {
            this.doSenseCreatures();
        } else if (power.equals(PlayerPower.throwBoulder)) {
            this.doThrowBoulder(on);
        } else if (power.equals(PlayerPower.spinWeb)) {
            this.doSpinWeb();
            turnUsed = false;
        } else if (power.equals(PlayerPower.leap)) {
            turnUsed = this.doLeap(on);
        } else if (power.equals(PlayerPower.senseSecretDoors)) {
            this.doSenseSecretDoors();
        } else if (power.equals(PlayerPower.memorizeLocation)) {
            this.doMemorizeLocation();
        } else if (power.equals(PlayerPower.hurlFireball)) {
            this.doHurlFireball(on);
        } else if (power.equals(PlayerPower.healFully)) {
            this.doHealFully();
        } else if (power.equals(PlayerPower.revealTraps)) {
            this.doRevealTraps();
        } else if (power.equals(PlayerPower.placeVengefulSymbol)) {
            this.doPlaceVengefulSymbol(on);
            turnUsed = false;
        } else if (power.equals(PlayerPower.findTreasure)) {
            this.doFindTreasure();
        } else if (power.equals(PlayerPower.findExit)) {
            this.doFindExit();
        } else if (power.equals(PlayerPower.projectRetributiveShield)) {
            this.doProjectRetributiveShield();
        } else if (power.equals(PlayerPower.summonMeteorShower)) {
            this.doSummonMeteorShower();
        } else if (power.equals(PlayerPower.quickenSelf)) {
            this.doQuickenSelf();
        } else if (power.equals(PlayerPower.freezeBeing)) {
            this.doFreezeBeing(on);
        } else if (power.equals(PlayerPower.repelLivingDeadCleric)) {
            this.doRepelLivingDead();
        } else if (power.equals(PlayerPower.repelLivingDeadPaladin)) {
            this.doRepelLivingDead();
        } else if (power.equals(PlayerPower.fireEyeBeams)) {
            this.doFireEyeBeams(on);
        } else if (power.equals(PlayerPower.layHands)) {
            this.doLayHands();
        } else if (power.equals(PlayerPower.teleportSelf)) {
            this.doTeleportToLevel(on.x);
        } else if (power.equals(PlayerPower.transmuteGoldToBars)) {
            this.doTransmuteGoldToBars();
        } else if (power.equals(PlayerPower.transmuteBarsToGold)) {
            this.doTransmuteBarsToGold();
        }
        if (turnUsed) {
            this.doEndTurn();
        }
    }

    private boolean doIncurPowerCost(PlayerPower power) {
        boolean clerical = false;
        int cost = power.getMagicPointCost();
        if (cost == 0) {
            cost = power.getClericalPointCost();
            clerical = true;
        }
        if (cost > 0) {
            Item ring = this.equippedItems.getItemOfType(ItemType.ringOfPowerStorage);
            if (ring != null) {
                ((Items.RingOfPowerStorage)ring).onSuppliedMagicPoints(cost);
            } else {
                if (this.equippedItems.getContains(ItemType.robeOfMagicalEnergy)) {
                    cost = 2 * cost / 3;
                }
                if (clerical && this.clericalPoints.get() < cost || !clerical && this.magicPoints.get() < cost) {
                    this.onMessage("You do not have enough " + (clerical ? "clerical" : "magic") + " points!");
                    return false;
                }
                if (clerical) {
                    this.clericalPoints.set(this.clericalPoints.get() - cost);
                } else {
                    this.magicPoints.set(this.magicPoints.get() - cost);
                }
            }
        }
        return true;
    }

    private boolean doPowerUseSuccessCheck(PlayerPower power) {
        int modifier = 0;
        if (power.isMagicUserSpell()) {
            modifier += -power.getMagicPointCost();
            modifier += this.getCastingModifierForIntelligence();
        } else if (power.isClericalSpell()) {
            modifier += -power.getClericalPointCost();
            modifier += this.getCastingModifierForJudgement();
        } else {
            return true;
        }
        int roll = Random.getInt(1, 20);
        return roll <= 13 + modifier;
    }

    public void doTeleportToLevel(int levelIndex) {
        PowerDischarge.doDischarge(this);
        Map fromMap = this.getMap();
        Game game = Game.getCurrentGame();
        Map toMap = game.getMap(levelIndex);
        boolean mapChanging = toMap != fromMap;
        MapPixelLocation to = this.memorizedLocations.get(toMap.getLevel());
        if (to == null) {
            Terrain upExit = toMap.getTerrainOfType(TerrainType.upExit);
            if (upExit != null) {
                to = upExit.getLocation();
            } else {
                Terrain downExit = toMap.getTerrainOfType(TerrainType.downExit);
                to = downExit.getLocation();
            }
        }
        Teleport.doTeleport(fromMap, this.getLocation(), true, false);
        to = toMap.getNearbyPassibleRectangleLocation(to, this.getSize(), this.getMovementType());
        if (!mapChanging) {
            fromMap.doMoveEntity(this, to);
        } else {
            this.reporter.doReport(new PlayerEvents.MapLoading(this));
            fromMap.doRemoveEntity(this);
            toMap.doAddEntity((MapEntity)this, to);
        }
        Teleport.doTeleport(toMap, to, false, false);
    }

    public void doAttack(MapPixelLocation on) {
        boolean offhand;
        Weapon weapon;
        MapPixelLocation from = this.getLocation();
        Map map = this.getMap();
        if (map.getFirstBeingAt(on) == this) {
            this.doEndTurn();
            return;
        }
        if (this.isConfused()) {
            on = Confusion.getModifiedLocation(map, on, from);
        }
        Weapon weapon2 = weapon = !(offhand = this.currentAttackOffhand) ? this.getWeapon() : this.getOffhandWeapon();
        if (weapon.getRequiresAmmo()) {
            Item ammo = weapon.getAmmo(this.inventory);
            if (ammo == null) {
                this.onMessage("Out of ammunition!", MessageType.status);
                return;
            }
            ammo.doRemoveOne();
            this.onItemLost(ammo, 1, ItemLostReason.used);
        }
        if (this.getMovementPoints() > 0.0f) {
            this.setMovementPoints(0.0f);
        }
        Being being = null;
        boolean hit = false;
        AttackType attackType = AttackType.meleeAttack;
        if (!weapon.getWeaponType().isRanged()) {
            being = map.getFirstMonsterAt(on);
            if (being != null && this.isNextTo(being)) {
                int roll = Random.getInt(1, 20);
                hit = being.isAMeleeHit((int)(roll + this.getToHitModifier((boolean)offhand, (Being)being) - this.getNumberToHitZeroDefense()), (PenetrationType)weapon.getWeaponType().getPenetrationType(), (Being)this).hit;
            }
        } else {
            attackType = weapon.getWeaponType().getAttackType();
            MapTileDistance maxRange = weapon.getWeaponType().getMaxRange();
            on = RangedAttackUtil.doModifyTarget(from, on, maxRange, this.getAccuracy(offhand));
            RangedAttackUtil.DoMakeRangedAttackResult result = RangedAttackUtil.doMakeRangedAttack(this, map, from, on, maxRange, weapon.getWeaponType().getPenetrationType(), this.getNumberToHitZeroDefense());
            hit = result.hit;
            being = result.beingImpacted;
            on = result.impactLocation;
        }
        if (on != null) {
            Attack.doAttack(map, from, on, attackType);
        }
        if (being != null) {
            int damage = 0;
            if (hit) {
                damage = Random.getInt(weapon.getWeaponType().getMinDamage(), weapon.getWeaponType().getMaxDamage());
                damage += this.getDamageModifier(offhand);
                damage = Math.max(damage, 1);
                ((Being)being).onHitByWeapon(weapon, this, damage);
                this.onAttackHitVictim(being, damage, offhand);
            } else if (being != null) {
                being.onAttackedAndMissed();
            }
        }
        if (on != null) {
            map.onSoundIssued(attackType.alertSound, from);
        }
        int attacksPerTurn = this.getAttacksPerTurn(false);
        if (!offhand && ++this.attacksMadeThisTurn < attacksPerTurn) {
            this.currentAttackOffhand = false;
            this.reporter.doReport(new PlayerEvents.CanMakeAttack(this));
            return;
        }
        int offhandAttacksPerTurn = this.getAttacksPerTurn(true);
        if (offhand || this.attacksMadeThisTurn >= attacksPerTurn) {
            if (offhand) {
                ++this.offhandAttacksMadeThisTurn;
            }
            if (this.offhandAttacksMadeThisTurn < offhandAttacksPerTurn) {
                this.currentAttackOffhand = true;
                this.reporter.doReport(new PlayerEvents.CanMakeAttack(this));
                return;
            }
        }
        if (this.attacksMadeThisTurn >= attacksPerTurn && this.offhandAttacksMadeThisTurn >= offhandAttacksPerTurn) {
            this.doEndTurn();
        }
    }

    public void doMove(MapPixelLocation to) {
        float movementPoints;
        float oldMovementPoints = movementPoints = this.getMovementPoints();
        if (movementPoints <= 0.0f) {
            return;
        }
        if (this.isConfused()) {
            to = Confusion.getModifiedLocation(this.map, to, this.getLocation());
        }
        MapEntityUtil.MoveTowardsGoalResult result = MapEntityUtil.doMoveTowardsGoal(this, to, this.getMovementPoints(), this.moveTowardsGoalListener);
        if (result.notEnoughMovementPoints) {
            this.pendingMoveDestination.setLocation(to);
        } else {
            this.pendingMoveDestination.x = -1;
        }
        if (oldMovementPoints == this.getMovementPoints()) {
            this.setMovementPoints(result.movementPointsLeft);
            if (this.getMovementPoints() <= 0.0f) {
                this.doEndTurn();
            }
        }
    }

    public void doGetItem(Item item) {
        this.doGetItem(item, item.getQuantity());
    }

    public void doGetItem(Item item, int quantity) {
        int canCarry = (int)Math.floor((float)(this.maxEncumbrance.get() - this.encumbrance.get()) / item.getType().getEncumbrance());
        if (canCarry < 1) {
            this.onMessage("You cannot carry " + (quantity > 1 ? "any more of " : "") + "this item.");
            return;
        }
        int quantityToGet = quantity > canCarry ? canCarry : quantity;
        MapPixelLocation itemLocation = item.getLocation();
        if (quantityToGet == item.getQuantity()) {
            this.map.doRemoveEntity(item);
        } else {
            item.doRemoveQuantity(quantityToGet);
            item = ItemFactory.doCreateItem(item.getType());
            item.setQuantity(quantityToGet);
        }
        this.inventory.doAddItem(item);
        this.onMessage((quantityToGet > 1 ? "" + quantityToGet + " " : "") + item.getName(), new LocationalMessageType(itemLocation));
    }

    public void doEquipItem(Item item) {
        Item currentItem;
        if (item.getType().isArmor() && !this.getMap().getMonstersInLOS(this.getLocation(), null).isEmpty()) {
            this.onMessage("You cannot put on armor with monsters in sight.", MessageType.error);
            return;
        }
        EquipLocation equipLocation = item.getType().getEquipLocation();
        if (equipLocation.equals(EquipLocation.rightHand) && !item.getType().getTakesTwoHands() && this.equippedItems.get(EquipLocation.rightHand) != null && this.equippedItems.get(EquipLocation.leftHand) == null) {
            equipLocation = EquipLocation.leftHand;
        }
        if (equipLocation.equals(EquipLocation.rightRing) && this.equippedItems.get(EquipLocation.rightRing) != null && this.equippedItems.get(EquipLocation.leftRing) == null) {
            equipLocation = EquipLocation.leftRing;
        }
        Item leftItem = this.equippedItems.get(EquipLocation.leftHand);
        Item rightItem = this.equippedItems.get(EquipLocation.rightHand);
        if (item.getType().getTakesTwoHands() && (leftItem != null && this.equippedItems.get(EquipLocation.leftHand).getType().isCursed() || rightItem != null && this.equippedItems.get(EquipLocation.rightHand).getType().isCursed())) {
            this.onMessage(removeCursedItemMessage, MessageType.important);
            return;
        }
        Weapon leftWeapon = leftItem != null && leftItem.isWeapon() ? (Weapon)leftItem : null;
        Weapon rightWeapon = rightItem != null && rightItem.isWeapon() ? (Weapon)rightItem : null;
        float pistolSize = WeaponType.pistol.getEncumbrance();
        if (item.isWeapon() && !item.getType().getTakesTwoHands() && item.getType().getEncumbrance() > pistolSize) {
            boolean rightTwoHands;
            boolean leftPistolSize;
            boolean bl = leftWeapon != null ? leftWeapon.getType().getEncumbrance() <= pistolSize : (leftPistolSize = false);
            boolean rightPistolSize = rightWeapon != null ? rightWeapon.getType().getEncumbrance() <= pistolSize : false;
            boolean leftTwoHands = leftWeapon != null ? leftWeapon.getType().getTakesTwoHands() : false;
            boolean bl2 = rightTwoHands = rightWeapon != null ? rightWeapon.getType().getTakesTwoHands() : false;
            if (leftWeapon != null && !leftTwoHands && !leftPistolSize || rightWeapon != null && !rightTwoHands && !rightPistolSize) {
                if (rightWeapon != null && !rightTwoHands && !rightPistolSize) {
                    equipLocation = EquipLocation.rightHand;
                } else if (leftWeapon != null && !leftTwoHands && !leftPistolSize) {
                    equipLocation = EquipLocation.leftHand;
                } else {
                    this.onMessage("When equipping two weapons, one of them must be a dagger or other small weapon.", MessageType.important);
                    return;
                }
            }
        }
        if ((currentItem = this.equippedItems.get(equipLocation)) != null) {
            if (currentItem.getType().isCursed()) {
                this.onMessage(removeCursedItemMessage, MessageType.important);
                return;
            }
            if (currentItem.getType().getTakesTwoHands()) {
                this.equippedItems.set(null, EquipLocation.rightHand);
                this.equippedItems.set(null, EquipLocation.leftHand);
            }
            this.inventory.doAddItem(currentItem);
        }
        this.inventory.doRemoveItem(item);
        this.equippedItems.set(item, equipLocation);
        if (item.getType().getTakesTwoHands()) {
            Item offhandItem = this.equippedItems.get(EquipLocation.leftHand);
            if (offhandItem != null && offhandItem != currentItem) {
                this.inventory.doAddItem(offhandItem);
            }
            this.equippedItems.set(item, EquipLocation.leftHand);
        }
    }

    private boolean getHasAttributesToUseItem(Item item) {
        int numAttributes = PlayerAttribute.attributes.size();
        for (int i = 0; i < numAttributes; ++i) {
            PlayerAttribute attribute = PlayerAttribute.getAttribute(i);
            int requirement = item.getType().getAttributeRequirement(attribute);
            if (requirement <= this.attributes.get(i)) continue;
            this.onMessage("You need a " + requirement + " " + attribute.getName() + " to use this item.", MessageType.important);
            return false;
        }
        return true;
    }

    public void doUseItem(Item item) {
        if (this.isParalyzed()) {
            return;
        }
        if (!this.getHasAttributesToUseItem(item)) {
            return;
        }
        boolean inInventory = this.inventory.getContains(item);
        if (inInventory && item.getType().getEquipLocation() != null) {
            this.doEquipItem(item);
        } else {
            if (item.getType().equals(ItemType.torch) && !this.getMap().getMonstersInLOSAndRange(this.getLocation(), new MapPixelDistance(3 * TileSize.tileSize.width), null).isEmpty()) {
                this.onMessage("You cannot do that during close combat.", MessageType.error);
                return;
            }
            if (inInventory && item.getType().getEquipLocation() == null || !inInventory) {
                if (!(item instanceof Item.Usable)) {
                    this.onMessage("No effect!", MessageType.important);
                } else {
                    this.reporter.doReport(new PlayerEvents.UsedImmediateEffectItem(this));
                    ((Item.Usable)((Object)item)).onUsed(this);
                }
            }
        }
    }

    public void doDropItem(Item item, int quantity) {
        if (this.isParalyzed()) {
            return;
        }
        if (item.getQuantity() > quantity) {
            item.doRemoveQuantity(quantity);
            item = ItemFactory.doCreateItem(item.getType());
            item.setQuantity(quantity);
        } else {
            this.inventory.doRemoveItem(item);
        }
        this.map.doAddEntity((MapEntity)item, this.location);
        this.onItemLost(item, ItemLostReason.dropped);
    }

    public void doUseHandsConfig(int index) {
        HandsConfig config = this.handsConfigs[index];
        Item leftItem = config.leftItem;
        Item rightItem = config.rightItem;
        Item currentLeftItem = this.equippedItems.get(EquipLocation.leftHand);
        Item currentRightItem = this.equippedItems.get(EquipLocation.rightHand);
        if (currentLeftItem != null && currentLeftItem.getType().isCursed() || currentRightItem != null && currentRightItem.getType().isCursed()) {
            this.onMessage("You have a cursed item equipped that you cannot unequip!", MessageType.error);
            return;
        }
        if (leftItem != null && !this.getHasAttributesToUseItem(leftItem) || rightItem != null && !this.getHasAttributesToUseItem(rightItem)) {
            return;
        }
        this.previousHandsConfigUsedIndex = this.handsConfigUsedIndex;
        this.handsConfigUsedIndex = index;
        if (currentLeftItem != null) {
            this.inventory.doAddItem(currentLeftItem);
        }
        if (currentRightItem != null && currentRightItem != currentLeftItem) {
            this.inventory.doAddItem(currentRightItem);
        }
        if (leftItem != null) {
            this.inventory.doRemoveItem(leftItem);
        }
        if (rightItem != null) {
            this.inventory.doRemoveItem(rightItem);
        }
        this.equippedItems.set(leftItem, EquipLocation.leftHand);
        this.equippedItems.set(rightItem, EquipLocation.rightHand);
    }

    public void setHandsConfig(int index) {
        HandsConfig config = this.handsConfigs[index];
        config.leftItem = this.equippedItems.get(EquipLocation.leftHand);
        config.rightItem = this.equippedItems.get(EquipLocation.rightHand);
        this.previousHandsConfigUsedIndex = this.handsConfigUsedIndex;
        this.handsConfigUsedIndex = index;
        this.reporter.doReport(new PlayerEvents.HandsConfigSet(this, index, config));
    }

    public void doIdentifyItem(Item item, int price) {
        if (this.getGold(true) < price) {
            this.onMessage(notEnoughGoldMessage, MessageType.error);
            return;
        }
        this.getMap().onSoundIssued(Sound.itemIdentified, this.getLocation(), true);
        item.setIdentified(true);
        this.doRemoveGold(price);
    }

    public void doRepairItem(Item item, int price) {
        if (this.getGold(true) < price) {
            this.onMessage(notEnoughGoldMessage, MessageType.error);
            return;
        }
        item.onRepaired();
        this.doRemoveGold(price);
    }

    public void doSellItem(Item item, TalkerBeings.Buyer buyer) {
        this.doSellItem(item, buyer, item.getQuantity());
    }

    public void doSellItem(Item item, TalkerBeings.Buyer buyer, int quantity) {
        if (this.equippedItems.isEquipped(item) && !this.doUnequipItem(item, false, false)) {
            return;
        }
        if (item.getQuantity() > quantity) {
            item.doRemoveQuantity(quantity);
            item = ItemFactory.doCreateItem(item.getType());
            item.setQuantity(quantity);
        } else {
            this.inventory.doRemoveItem(item);
        }
        int price = buyer.getAdjustedItemOffering(item, item.getValue(ItemValueContext.sell));
        this.doAddGold(price);
        this.onItemLost(item, ItemLostReason.sold);
        this.getMap().onSoundIssued(Sound.itemSold, this.getLocation());
        if (buyer.getLeavesAfterPurchase()) {
            this.reporter.doReport(new PlayerEvents.BuyerLeft(this));
        }
        buyer.onItemBought();
    }

    public void doBuyItem(Item item, int price) {
        if (this.getGold(true) < price) {
            this.onMessage(notEnoughGoldMessage, MessageType.error);
            return;
        }
        if (item.getEncumbrance() > (float)(this.maxEncumbrance.get() - this.encumbrance.get())) {
            this.onMessage("You can't carry that!", MessageType.error);
            return;
        }
        if (price > 0) {
            this.doRemoveGold(price);
        }
        Item clone = ItemFactory.doCreateItem(item.getType());
        clone.setQuantity(item.getQuantity());
        clone.setCondition(item.getCondition());
        this.inventory.doAddItem(clone);
        this.getMap().onSoundIssued(Sound.itemBought, this.getLocation());
    }

    public void doEnterMine(Terrains.Mine mine) {
        mine.onPlayerEnters(this);
    }

    public void doWasteMagicPoints(int amount) {
        this.magicPoints.set(this.magicPoints.get() - amount);
    }

    public void doWasteClericalPoints(int amount) {
        this.clericalPoints.set(this.clericalPoints.get() - amount);
    }

    public void doDrinkFromFountain(Terrains.Fountain fountain) {
        fountain.onPlayerDrinks(this);
    }

    public void doProceedWithTalkerBeyondGreeting(Talker talker) {
        talker.onGreetingHeardByPlayer(this);
    }

    public void doInsertGoldIntoStatue(int gold, Terrains.Statue statue) {
        this.doRemoveGold(gold);
        statue.onGoldInserted(gold);
    }

    public boolean doBuyService(Service service, ServiceSeller seller) {
        int price = seller.getServicePrice(service, this);
        if (this.getGold(true) < price) {
            this.onMessage(notEnoughGoldMessage, MessageType.error);
            return false;
        }
        boolean performed = false;
        MapEntity sellerEntity = (MapEntity)((Object)seller);
        if (service.equals(Service.healWounds)) {
            performed = this.onHealWoundsService(sellerEntity);
        } else if (service.equals(Service.healFully)) {
            performed = this.onHealFullyService(sellerEntity);
        } else if (service.equals(Service.curePoison)) {
            performed = this.onCurePoisonService(sellerEntity);
        } else if (service.equals(Service.cureDisease)) {
            performed = this.onCureDiseaseService(sellerEntity);
        } else if (service.equals(Service.removeCursedItems)) {
            performed = this.onRemoveCursedItemsService(sellerEntity);
        } else if (service.equals(Service.restoreLevels)) {
            performed = this.onRestoreLevelsService(sellerEntity);
        }
        if (performed) {
            this.doRemoveGold(price);
        }
        return performed;
    }

    public boolean doUnequipItem(Item item, boolean checkForMonstersInLOS, boolean ignoreCurse) {
        if (this.isParalyzed()) {
            return false;
        }
        if (checkForMonstersInLOS && item.getType().isArmor() && !this.getMap().getMonstersInLOS(this.getLocation(), null).isEmpty()) {
            this.onMessage("You cannot remove armor right now.", MessageType.error);
            return false;
        }
        if (!ignoreCurse && item.getType().isCursed()) {
            this.onMessage(removeCursedItemMessage, MessageType.error);
            return false;
        }
        EquipLocation equipLocation = this.equippedItems.getItemEquipLocation(item);
        this.equippedItems.set(null, equipLocation);
        if (item.getType().getTakesTwoHands()) {
            this.equippedItems.set(null, EquipLocation.rightHand);
            this.equippedItems.set(null, EquipLocation.leftHand);
        }
        this.inventory.doAddItem(item);
        return true;
    }

    public void onItemRemoved(Item item) {
        if (this.equippedItems.isEquipped(item)) {
            this.doUnequipItem(item, false, true);
        }
        this.inventory.doRemoveItem(item);
        this.onItemLost(item, null);
    }

    public int getDefense(PenetrationType penetration, Being attacker) {
        int defense = this.defenses.get(penetration);
        if (this.getHasGainedLevel(PlayerLevel.paladin) && attacker != null && attacker.isEvil()) {
            defense += 2;
        }
        return defense;
    }

    public static int getStartingLevel() {
        return 5;
    }

    public int getStrength() {
        return this.attributes.get(PlayerAttribute.strength);
    }

    public int getIntelligence() {
        return this.attributes.get(PlayerAttribute.intelligence);
    }

    public int getJudgement() {
        return this.attributes.get(PlayerAttribute.judgement);
    }

    public int getAgility() {
        return this.attributes.get(PlayerAttribute.agility);
    }

    public int getEndurance() {
        return this.attributes.get(PlayerAttribute.endurance);
    }

    public boolean isDiseased() {
        return !this.diseaseAfflictions.isEmpty();
    }

    public Dimension getSize() {
        PlayerLevel currentLevel = (PlayerLevel)this.levels.get(Math.max(this.level.get() - 5, 0));
        return currentLevel.getSize();
    }

    public boolean isCurrentAttackOffhand() {
        return this.currentAttackOffhand;
    }

    public static int getNumHandsConfigs() {
        return 4;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public BaseAttributes getBaseAttributes() {
        return this.baseAttributes;
    }

    public int getCastingModifierForIntelligence() {
        return this.getIntelligence() - 10;
    }

    public int getCastingModifierForJudgement() {
        return this.getJudgement() - 10;
    }

    public EquippedItems getEquippedItems() {
        return this.equippedItems;
    }

    public HandsConfig[] getHandsConfigs() {
        return this.handsConfigs;
    }

    public Level getLevel() {
        return this.level;
    }

    public MagicPoints getMagicPoints() {
        return this.magicPoints;
    }

    public ClericalPoints getClericalPoints() {
        return this.clericalPoints;
    }

    public MaxClericalPoints getMaxClericalPoints() {
        return this.maxClericalPoints;
    }

    public MaxMagicPoints getMaxMagicPoints() {
        return this.maxMagicPoints;
    }

    public List getPowers() {
        ArrayList<PlayerPower> powers = new ArrayList<PlayerPower>();
        for (int i = 0; i < this.level.get() - 5 + 1; ++i) {
            PlayerLevel level = (PlayerLevel)this.levels.get(i);
            PlayerPower[] levelPowers = level.getPowers();
            for (int j = 0; j < levelPowers.length; ++j) {
                PlayerPower power = levelPowers[j];
                powers.add(power);
            }
        }
        return powers;
    }

    public Encumbrance getEncumbrance() {
        return this.encumbrance;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setMap(Map map) {
        super.setMap(map);
        if (map != null) {
            this.reporter.doReport(new PlayerEvents.AtMap(this));
        }
    }

    public void onSoundHeard(Sound sound, MapPixelLocation location, MapPixelDistance distance) {
        this.reporter.doReport(new PlayerEvents.SoundHeard(this, sound, location, distance));
    }

    public void doEmitEvent(PlayerEvent event) {
        this.reporter.doReport(event);
    }

    public MovementType getMovementType() {
        return MovementType.walking;
    }

    public MaxEncumbrance getMaxEncumbrance() {
        return this.maxEncumbrance;
    }

    public void onPlayerLevelChosen(PlayerLevel level) {
        this.levels.add(level);
    }

    public PlayerLevel getNextEarnableLevel(PlayerClass playerClass) {
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            Object[] levels;
            PlayerLevel level = (PlayerLevel)this.levels.get(i);
            int index = ArrayUtil.getIndexOf(level, levels = playerClass.getLevels());
            if (index < 0) continue;
            if (index == levels.length - 1) {
                return null;
            }
            return levels[index + 1];
        }
        return playerClass.getLevels()[0];
    }

    public Sound getMovementSound() {
        if (this.isBeingStealthy()) {
            return null;
        }
        return super.getMovementSound();
    }

    public int getPoisonLevel() {
        return this.poisonLevel.get();
    }

    public int getNumDiseases() {
        return this.diseaseAfflictions.size();
    }

    public int getNumEquippedCursedItems() {
        List items = this.equippedItems.getCompressedList();
        int numCursed = 0;
        int numItems = items.size();
        for (int j = 0; j < numItems; ++j) {
            Item item = (Item)items.get(j);
            if (!item.getType().isCursed()) continue;
            ++numCursed;
        }
        return numCursed;
    }

    public int getEquippedUnidentifiedCursedItemsTotalIdentificationValue() {
        List items = this.equippedItems.getCompressedList();
        int totalCost = 0;
        int numItems = items.size();
        for (int j = 0; j < numItems; ++j) {
            Item item = (Item)items.get(j);
            if (item.isIdentified() || !item.getType().isCursed()) continue;
            totalCost += item.getValue(ItemValueContext.identify);
        }
        return totalCost;
    }

    public int getNumLevelsLost() {
        return this.numLevelsLost;
    }

    private int getDampenedStandardModifier(int score) {
        return this.getStandardModifier(score) * 3 / 5;
    }

    public int getMagicPointsModifierForIntelligence() {
        return this.getDampenedStandardModifier(this.getIntelligence());
    }

    public int getClericalPointsModifierForJudgement() {
        return this.getDampenedStandardModifier(this.getJudgement());
    }

    public int getMagicPointsModifierForEndurance() {
        return this.getDampenedStandardModifier(this.getEndurance());
    }

    public int getClericalPointsModifierForEndurance() {
        return this.getDampenedStandardModifier(this.getEndurance());
    }

    public void doAddListener(Listener listener) {
        this.reporter.doAddListener(listener);
    }

    protected void onParalyzedStatusChange(boolean nowParalyzed) {
        this.reporter.doReport(nowParalyzed ? new PlayerEvents.Paralyzed(this) : new PlayerEvents.NotParalyzed(this));
    }

    protected void onConfusedStatusChange(boolean nowConfused) {
        this.reporter.doReport(nowConfused ? new PlayerEvents.Confused(this) : new PlayerEvents.NotConfused(this));
    }

    public boolean getCanEmployPowerNow(PlayerPower power) {
        boolean canEmploy = true;
        if (canEmploy && power.equals(PlayerPower.throwBoulder) && !this.getCanThrowBoulder()) {
            canEmploy = false;
        }
        if (canEmploy && !this.doIncurPowerCost(power)) {
            canEmploy = false;
        }
        if (!(!canEmploy || this.map.getMonstersInLOS(this.location, null).isEmpty() && this.map.getMonstersInPassibleRange(this.location, getCanEmployPowerNow_range, null).isEmpty() || this.doPowerUseSuccessCheck(power))) {
            this.onMessage("Power use failed!");
            canEmploy = false;
        }
        if (!canEmploy) {
            this.doEndTurn();
        }
        return canEmploy;
    }

    private void doTransmuteGoldToBars() {
        PowerDischarge.doDischarge(this);
        int gold = 0;
        Item held = this.inventory.getItemOfGroupableType(ItemType.gold);
        if (held != null) {
            gold += held.getQuantity();
            this.doRemoveItem(held);
        }
        List items = this.map.getItemsInRange(this.location, new MapPixelDistance(2 * TileSize.tileSize.width), null);
        int numItems = items.size();
        for (int i = 0; i < numItems; ++i) {
            Item item = (Item)items.get(i);
            if (!item.isOfType(ItemType.gold)) continue;
            gold += item.getQuantity();
            this.map.doRemoveEntity(item);
        }
        int barValue = ItemType.goldBar.getPlacementValue();
        List conditions = ItemCondition.conditions;
        boolean barMade = false;
        for (int i = conditions.size() - 1; i > 0; --i) {
            ItemCondition condition = (ItemCondition)conditions.get(i);
            int conditionBarValue = (int)((float)barValue * condition.getValueFraction());
            while (gold >= conditionBarValue) {
                gold -= conditionBarValue;
                Item bar = ItemFactory.doCreateItem(ItemType.goldBar);
                bar.setCondition(condition);
                this.inventory.doAddItem(bar);
                barMade = true;
            }
        }
        if (!barMade) {
            this.onMessage("There's not enough gold in or around your location for you to productively use this power.", MessageType.error);
        }
        if (gold > 0) {
            Item goldItem = ItemFactory.doCreateItem(ItemType.gold);
            goldItem.setQuantity(gold);
            this.map.doAddEntity((MapEntity)goldItem, this.location);
        }
    }

    private void doTransmuteBarsToGold() {
        Item bar;
        PowerDischarge.doDischarge(this);
        if (this.inventory.getFirstItemOfType(ItemType.goldBar) == null) {
            this.onMessage("You don't have any gold bars!", MessageType.important);
            return;
        }
        Item gold = null;
        while ((bar = this.inventory.getFirstItemOfType(ItemType.goldBar)) != null) {
            if (gold == null) {
                gold = ItemFactory.doCreateItem(ItemType.gold);
                gold.setQuantity(0);
            }
            this.inventory.doRemoveItem(bar);
            gold.doAddQuantity(bar.getValue(ItemValueContext.placement));
        }
        this.map.doAddEntity((MapEntity)gold, this.location);
    }

    public boolean isQuickened() {
        return this.quickenSelfTurnsLeft > 0;
    }

    public void onHeldItemChanged() {
        this.encumbrance.doUpdate();
        this.doEmitEvent(new PlayerEvents.HeldItemChanged(this));
    }

    public void doUsePreviousHandsConfig() {
        if (this.previousHandsConfigUsedIndex >= 0) {
            this.doUseHandsConfig(this.previousHandsConfigUsedIndex);
        }
    }

    public MapPixelDistance getLightRadius() {
        return Items.Torch.torchLightRadius;
    }

    public boolean isEmittingLight() {
        return this.inventory.getFirstLitTorch() != null;
    }

    public boolean isUsingNightVision() {
        return !this.isEmittingLight() && this.getHasGainedLevel(PlayerLevel.werewolf);
    }

    public boolean isLightSource() {
        return true;
    }

    public void onTurnOver() {
        super.onTurnOver();
        this.doInformTorchesOfEndOfTurn();
        if (this.isConfused() && this.getHasGainedLevel(PlayerLevel.minotaur)) {
            this.confusedTurnsLeft.set(0);
        }
    }

    protected void doTakeHealingHook1(int healAmount, int pausePerHitPoint) {
        this.onMessage("" + healAmount, MessageType.normal, healAmount * pausePerHitPoint);
    }

    public boolean isPlayer() {
        return true;
    }

    public void onTeleported() {
        this.pendingMoveDestination.x = -1;
    }

    static {
        hand.onCreated(WeaponType.hand);
        getCanEmployPowerNow_range = new MapPixelDistance(17 * TileSize.tileSize.width);
    }

    private class Defenses
    implements Serializable {
        private int[] defenses = new int[PenetrationType.types.size()];

        private Defenses() {
        }

        public int get(PenetrationType penetration) {
            int defense = this.defenses[penetration.getRank()];
            if (Player.this.isParalyzed()) {
                defense -= 10;
            }
            return defense;
        }

        public void set(int index, int value) {
            this.set(PenetrationType.getType(index), value);
        }

        public void set(PenetrationType penetration, int value) {
            this.defenses[penetration.getRank()] = value;
            Player.this.reporter.doReport(new PlayerEvents.DefenseChanged(Player.this));
        }

        public void doUpdate() {
            int numTypes = PenetrationType.types.size();
            for (int i = 0; i < numTypes; i = (int)((byte)(i + 1))) {
                Item item;
                int defense = 0;
                if (Player.this.getHasGainedLevel(PlayerLevel.monk) && ((item = Player.this.equippedItems.get(EquipLocation.body)) == null || item.getType().getDefenseModifiers()[i] == 0)) {
                    defense += Player.this.level.get() / 2;
                }
                List items = Player.this.equippedItems.getCompressedList();
                int numItems = items.size();
                for (int j = 0; j < numItems; ++j) {
                    Item item2 = (Item)items.get(j);
                    defense += item2.getType().getDefenseModifiers()[i];
                }
                this.set(i, defense += Player.this.getDefenseModifierForAgility());
            }
        }
    }

    public class BaseAttributes
    implements Serializable {
        private int[] attributes = new int[PlayerAttribute.attributes.size()];

        public int get(int index) {
            return this.attributes[index];
        }

        public int get(PlayerAttribute attribute) {
            return this.attributes[attribute.getIndex()];
        }

        public void set(int index, int value) {
            this.set(PlayerAttribute.getAttribute(index), value);
        }

        public void set(PlayerAttribute attribute, int value) {
            this.attributes[attribute.getIndex()] = value;
            Player.this.attributes.doUpdate();
        }

        public void doAdd(int index, int amount) {
            this.set(index, this.get(index) + amount);
        }
    }

    public class Attributes
    implements Serializable {
        private int[] attributes = new int[PlayerAttribute.attributes.size()];

        public int get(int index) {
            return this.attributes[index];
        }

        public int get(PlayerAttribute attribute) {
            return this.attributes[attribute.getIndex()];
        }

        private void set(int index, int value) {
            this.set(PlayerAttribute.getAttribute(index), value);
        }

        private void set(PlayerAttribute attribute, int value) {
            this.attributes[attribute.getIndex()] = value;
            Player.this.reporter.doReport(new PlayerEvents.AttributeChanged(Player.this, attribute));
            if (attribute.equals(PlayerAttribute.strength)) {
                Player.this.maxEncumbrance.doUpdate();
            } else if (attribute.equals(PlayerAttribute.intelligence)) {
                Player.this.maxMagicPoints.doUpdate();
            } else if (attribute.equals(PlayerAttribute.judgement)) {
                Player.this.maxClericalPoints.doUpdate();
            } else if (attribute.equals(PlayerAttribute.endurance)) {
                Player.this.doUpdateMaxHitPoints();
                Player.this.maxEncumbrance.doUpdate();
                Player.this.maxMagicPoints.doUpdate();
                Player.this.maxClericalPoints.doUpdate();
            } else if (attribute.equals(PlayerAttribute.agility)) {
                Player.this.defenses.doUpdate();
            }
        }

        public void doUpdate() {
            List items = Player.this.equippedItems.getCompressedList();
            int numAttributes = PlayerAttribute.attributes.size();
            for (int i = 0; i < numAttributes; ++i) {
                int newValue = Player.this.baseAttributes.get(i);
                int numItems = items.size();
                for (int j = 0; j < numItems; ++j) {
                    Item item = (Item)items.get(j);
                    newValue += item.getType().getAttributeModifiers()[i];
                }
                if (i == PlayerAttribute.strength.getIndex()) {
                    if (Player.this.bionicStrengthTurnsLeft > 0) {
                        newValue += 6;
                    } else if (newValue < 19 && Player.this.equippedItems.getContains(ItemType.necklaceOfOgreStrength)) {
                        newValue = 19;
                    }
                }
                if (this.get(i) == newValue) continue;
                this.set(i, newValue);
                if (newValue > 0) continue;
                Player.this.doTakeDamage(new Damage(Player.this.getHitPoints(), DamageForm.attributeAtZero));
            }
        }
    }

    private class Experience
    implements Serializable {
        private int experience;

        private Experience() {
        }

        public int get() {
            return this.experience;
        }

        public void set(int amount) {
            this.experience = amount;
            Player.this.level.doUpdate();
        }
    }

    private class ActedThisTurn
    implements Serializable {
        private boolean actedThisTurn;

        private ActedThisTurn() {
        }

        public boolean get() {
            return this.actedThisTurn;
        }

        public void set(boolean acted) {
            boolean changedToTrue = acted && !this.actedThisTurn;
            this.actedThisTurn = acted;
            if (changedToTrue) {
                Game game = Game.getCurrentGame();
                game.onPlayerHasFinishedTurn();
                Player.this.reporter.doReport(new PlayerEvents.MustWaitToAct(Player.this));
            }
        }
    }

    public class Level
    implements Serializable {
        private int level;

        public int get() {
            return this.level;
        }

        public void set(int level) {
            boolean forInit;
            if (level == this.level || level < 1) {
                return;
            }
            boolean bl = forInit = this.level == 0;
            if (level < this.level) {
                Player.this.getMap().onSoundIssued(Sound.levelLost, Player.this.getLocation());
                Player.this.onMessage("You lose a level!");
            } else if (level > this.level && !forInit) {
                while (Player.this.levels.size() < level - 5 + 1) {
                    if (level - 5 == 1) {
                        Player.this.onPlayerLevelChosen(PlayerLevel.wizard);
                        continue;
                    }
                    Player.this.reporter.doReport(new PlayerEvents.MustChooseLevelGained(Player.this));
                }
                Player.this.onMessage("You gain a level!");
                PowerDischarge.doDischarge(Player.this);
            }
            this.level = level;
            if (!forInit) {
                Player.this.onImageToChange();
                Player.this.getMap().onEntityChangedAppearance(Player.this);
                Player.this.reporter.doReport(new PlayerEvents.LevelChanged(Player.this));
            }
            while (level >= Player.this.hitPointsByLevel.size()) {
                int maxHitPointsPerLevel = 10;
                int averageHitPointsPerLevel = 6;
                int amount = Player.this.hitPointsByLevel.size() >= 5 ? Random.getInt(1, 10) : 6;
                Player.this.hitPointsByLevel.add(new Integer(amount));
            }
            Player.this.doUpdateMaxHitPoints();
            Player.this.maxMagicPoints.doUpdate();
            Player.this.maxClericalPoints.doUpdate();
            Player.this.defenses.doUpdate();
            Player.this.stealthy.doUpdate();
        }

        public void doUpdate() {
            this.set(ExperienceNeededForLevels.getLevelForExperience(Player.this.experience.get()));
        }
    }

    public class Encumbrance
    implements Serializable {
        private int encumbrance;

        public int get() {
            return this.encumbrance;
        }

        public void set(int amount) {
            this.encumbrance = amount;
            Player.this.reporter.doReport(new PlayerEvents.EncumbranceChanged(Player.this));
        }

        public void doUpdate() {
            Item item;
            int i;
            int newValue = 0;
            List items = Player.this.equippedItems.getCompressedList();
            int numItems = items.size();
            for (i = 0; i < numItems; ++i) {
                item = (Item)items.get(i);
                newValue = (int)((float)newValue + item.getEncumbrance());
            }
            items = Player.this.inventory.getItems();
            numItems = items.size();
            for (i = 0; i < numItems; ++i) {
                item = (Item)items.get(i);
                newValue = (int)((float)newValue + item.getEncumbrance());
            }
            this.set(newValue);
        }
    }

    public class MaxEncumbrance
    implements Serializable {
        private int maxEncumbrance = 100;

        public int get() {
            return this.maxEncumbrance;
        }

        public void set(int amount) {
            this.maxEncumbrance = amount;
            Player.this.reporter.doReport(new PlayerEvents.MaxEncumbranceChanged(Player.this));
        }

        public void doUpdate() {
            this.set(Math.max(0, 200 + Player.this.getMaxEncumbranceModifierForStrength() + Player.this.getMaxEncumbranceModifierForEndurance()));
        }
    }

    public static class HandsConfig
    implements Serializable {
        public Item leftItem;
        public Item rightItem;
    }

    private class MoveTowardsGoalListener
    implements MapEntityUtil.MoveTowardsGoalListener,
    Serializable {
        private MoveTowardsGoalListener() {
        }

        public boolean onAtTerrain(Terrain terrain) {
            return !terrain.isTrap() || ((Trap)terrain).getChest() != null;
        }

        public boolean onMovedOntoNewTile(Tile tile) {
            return !Player.this.doDetectTraps();
        }

        public boolean getShouldContinue(MapPixelLocation oldLocation) {
            return !Player.this.isDead();
        }
    }

    protected static class ItemLostReason {
        public static ItemLostReason dropped = new ItemLostReason();
        public static ItemLostReason used = new ItemLostReason();
        public static ItemLostReason destroyed = new ItemLostReason();
        public static ItemLostReason sold = new ItemLostReason();
        public static ItemLostReason donated = new ItemLostReason();
        public static ItemLostReason stolen = new ItemLostReason();

        protected ItemLostReason() {
        }
    }

    public static class LocationalMessageType
    extends MessageType {
        public MapPixelLocation location;

        public LocationalMessageType(MapPixelLocation location) {
            this.location = location;
        }
    }

    public static class MessageType {
        public static MessageType normal = new MessageType();
        public static MessageType error = new MessageType();
        public static MessageType status = new MessageType();
        public static MessageType important = new MessageType();
        public static MessageType gameFinished = new MessageType();
    }

    private class MemorizedLocations
    implements Serializable {
        private List memorizedLocations = new ArrayList();

        private MemorizedLocations() {
        }

        public MapPixelLocation get(MapLevel level) {
            if (level.getIndex() >= this.memorizedLocations.size()) {
                return null;
            }
            return (MapPixelLocation)this.memorizedLocations.get(level.getIndex());
        }

        public void set(MapLevel level, Point location) {
            while (this.memorizedLocations.size() <= level.getIndex()) {
                this.memorizedLocations.add(null);
            }
            this.memorizedLocations.set(level.getIndex(), location);
        }
    }

    protected class InventoryListener
    implements Listener,
    Serializable {
        protected InventoryListener() {
        }

        public void onEvent(Event event) {
            if (event.isOfType(InventoryEventType.itemAdded)) {
                InventoryEvents.ItemAdded added = (InventoryEvents.ItemAdded)event;
                this.onItemAdded(added.item);
            } else if (event.isOfType(InventoryEventType.itemRemoved)) {
                InventoryEvents.ItemRemoved removed = (InventoryEvents.ItemRemoved)event;
                this.onItemRemoved(removed.item);
            }
        }

        private void onItemAdded(Item item) {
            item.setHolder(Player.this);
            Player.this.reporter.doReport(new PlayerEvents.ItemAddedToInventory(Player.this, item));
            Player.this.encumbrance.doUpdate();
        }

        public void onItemRemoved(Item item) {
            Player.this.reporter.doReport(new PlayerEvents.ItemRemovedFromInventory(Player.this, item));
            Player.this.encumbrance.doUpdate();
        }
    }

    private class PoisonLevel
    implements Serializable {
        private int poisonLevel;

        private PoisonLevel() {
        }

        public int get() {
            return this.poisonLevel;
        }

        protected void set(int value) {
            this.poisonLevel = value;
            if (value == 0 || value == 1) {
                Player.this.reporter.doReport(new PlayerEvents.PoisonedChanged(Player.this));
            }
        }
    }

    public class ClericalPoints
    implements Serializable {
        private int clericalPoints;

        public int get() {
            return this.clericalPoints;
        }

        protected void set(int value) {
            this.clericalPoints = value = Math.min(value, Player.this.maxClericalPoints.get());
            Player.this.reporter.doReport(new PlayerEvents.ClericalPointsChanged(Player.this));
        }

        public void setOneMore() {
            this.set(this.get() + 1);
        }
    }

    public class MaxClericalPoints
    implements Serializable {
        private int maxClericalPoints;

        public int get() {
            return this.maxClericalPoints;
        }

        protected void set(int value) {
            this.maxClericalPoints = value;
            Player.this.reporter.doReport(new PlayerEvents.MaxClericalPointsChanged(Player.this));
            Player.this.clericalPoints.set(Math.min(Player.this.clericalPoints.get(), value));
        }

        public void doUpdate() {
            this.set(Math.max(0, Player.this.getClericalCastingLevel() * (3 + Player.this.getClericalPointsModifierForJudgement() + Player.this.getClericalPointsModifierForEndurance())));
        }
    }

    public class MagicPoints
    implements Serializable {
        private int magicPoints;

        public int get() {
            return this.magicPoints;
        }

        protected void set(int value) {
            this.magicPoints = value = Math.min(value, Player.this.maxMagicPoints.get());
            Player.this.reporter.doReport(new PlayerEvents.MagicPointsChanged(Player.this));
        }

        public void setOneMore() {
            this.set(this.get() + 1);
        }
    }

    public class MaxMagicPoints
    implements Serializable {
        private int maxMagicPoints;

        public int get() {
            return this.maxMagicPoints;
        }

        protected void set(int value) {
            this.maxMagicPoints = value;
            Player.this.reporter.doReport(new PlayerEvents.MaxMagicPointsChanged(Player.this));
            Player.this.magicPoints.set(Math.min(Player.this.magicPoints.get(), value));
        }

        public void doUpdate() {
            this.set(Math.max(0, Player.this.getMagicUserCastingLevel() * (3 + Player.this.getMagicPointsModifierForIntelligence() + Player.this.getMagicPointsModifierForEndurance())));
        }
    }

    private class Stealthy
    implements Serializable {
        private boolean stealthy = false;

        private Stealthy() {
        }

        public boolean get() {
            return this.stealthy;
        }

        public void doUpdate() {
            int numEquipLocations = EquipLocation.locations.size();
            for (int i = 0; i < numEquipLocations; i = (int)((byte)(i + 1))) {
                Item item = Player.this.equippedItems.get(i);
                if (item == null || !item.getType().isNoisy()) continue;
                this.stealthy = false;
                return;
            }
            this.stealthy = true;
        }
    }

    public class EquippedItems
    implements Serializable {
        private Item[] equippedItems = new Item[EquipLocation.locations.size()];

        public Item get(EquipLocation equipLocation) {
            return this.equippedItems[equipLocation.getIndex()];
        }

        public Item get(int index) {
            return this.equippedItems[index];
        }

        protected List getCompressedList() {
            ArrayList<Item> items = new ArrayList<Item>();
            for (int i = 0; i < this.equippedItems.length; ++i) {
                Item item = this.equippedItems[i];
                if (item == null || item.getType().getTakesTwoHands() && i == EquipLocation.leftHand.getIndex()) continue;
                items.add(item);
            }
            return items;
        }

        public EquipLocation getItemEquipLocation(Item item) {
            for (int i = 0; i < this.equippedItems.length; ++i) {
                if (item != this.equippedItems[i]) continue;
                return EquipLocation.getLocation(i);
            }
            return null;
        }

        public boolean isEquipped(Item item) {
            return this.getItemEquipLocation(item) != null;
        }

        public void set(Item item, EquipLocation equipLocation) {
            this.equippedItems[equipLocation.getIndex()] = item;
            Player.this.reporter.doReport(new PlayerEvents.ItemEquipped(Player.this, item, equipLocation));
            Player.this.attributes.doUpdate();
            Player.this.defenses.doUpdate();
            Player.this.encumbrance.doUpdate();
            Player.this.stealthy.doUpdate();
        }

        protected boolean getContains(ItemType type) {
            return this.getItemOfType(type) != null;
        }

        protected Item getItemOfType(ItemType type) {
            int numEquipLocations = EquipLocation.locations.size();
            for (int i = 0; i < numEquipLocations; ++i) {
                Item item = this.get(i);
                if (item == null || !item.isOfType(type)) continue;
                return item;
            }
            return null;
        }
    }

    private class DiseaseAffliction
    implements Serializable {
        public Disease disease;
        public int turnAfflicted;

        private DiseaseAffliction() {
        }
    }
}

