/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.beings.player;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import silmar.entities.beings.player.events.InventoryEvents;
import silmar.entities.items.Item;
import silmar.entities.items.Items;
import silmar.entities.items.types.ItemType;
import silmar.events.Listener;
import silmar.events.Reporter;
import silmar.util.Random;

public final class Inventory
implements Serializable {
    private List items = new ArrayList();
    private Reporter reporter = new Reporter();

    public void doAddItem(Item item) {
        Item sameType;
        if (item.getType().isGroupable() && (sameType = this.getFirstItemOfType(item.getType())) != null) {
            sameType.doAddQuantity(item.getQuantity());
            return;
        }
        this.items.add(item);
        this.reporter.doReport(new InventoryEvents.ItemAdded(this, item));
    }

    public boolean doRemoveItem(Item item) {
        if (!this.items.remove(item)) {
            return false;
        }
        this.reporter.doReport(new InventoryEvents.ItemRemoved(this, item));
        return true;
    }

    public Item getItemOfGroupableType(ItemType type) {
        return this.getFirstItemOfType(type);
    }

    public Item getFirstItemOfType(ItemType type) {
        int numItems = this.items.size();
        for (int i = 0; i < numItems; ++i) {
            Item item = (Item)this.items.get(i);
            if (!item.isOfType(type)) continue;
            return item;
        }
        return null;
    }

    public void doAddListener(Listener listener) {
        this.reporter.doAddListener(listener);
    }

    public List getItems() {
        return this.items;
    }

    public Item getRandomItem() {
        if (this.items.isEmpty()) {
            return null;
        }
        return (Item)this.items.get(Random.getInt(0, this.items.size() - 1));
    }

    public boolean getContains(Item item) {
        return this.items.contains(item);
    }

    public Items.Torch getFirstLitTorch() {
        int numItems = this.items.size();
        for (int i = 0; i < numItems; ++i) {
            Items.Torch torch;
            Item item = (Item)this.items.get(i);
            if (!item.isOfType(ItemType.torch) || !(torch = (Items.Torch)item).isEmittingLight()) continue;
            return torch;
        }
        return null;
    }
}

