/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.beings.movement;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.List;
import silmar.entities.MapEntity;
import silmar.entities.beings.movement.MovementAlgorithm;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapTileDistance;
import silmar.map.PathFinder;
import silmar.tiles.TileSize;
import silmar.util.PointUtil;
import silmar.util.Random;

public class MovementAlgorithms {

    public static class RandomPath
    extends MovementAlgorithm {
        private List path;
        private transient PathFinder pathFinder;

        public RandomPath(MapEntity movingEntity) {
            super(movingEntity);
        }

        public MapPixelLocation getNextImmediateGoal(MapEntity movingEntity, MapPixelLocation finalGoal, MapEntity goalEntity) {
            MapPixelLocation current = movingEntity.getLocation();
            if (this.path == null || this.path.isEmpty()) {
                this.doDetmPath(movingEntity);
                return current;
            }
            return (MapPixelLocation)this.path.remove(0);
        }

        protected void doDetmPath(MapEntity movingEntity) {
            MapPixelLocation current;
            MapPixelLocation goal;
            Map map = movingEntity.getMap();
            if (this.pathFinder == null) {
                this.pathFinder = new PathFinder();
            }
            if ((goal = map.getRandomPassibleRectangleLocationInRange(current = movingEntity.getLocation(), movingEntity.getSize(), new MapPixelDistance(12 * TileSize.tileSize.width))) == null) {
                return;
            }
            this.path = this.pathFinder.getPassiblePath(map, current, goal, movingEntity, null, new MapTileDistance(15));
        }
    }

    public static class Flee
    extends MovementAlgorithm {
        private MapPixelLocation fleeFrom;
        private MapPixelLocation goal;
        private MovementAlgorithm helper;

        public Flee(MapEntity movingEntity) {
            super(movingEntity);
            this.helper = new GoDirectOrFindPath(this, movingEntity){
                private final /* synthetic */ Flee this$0;
                {
                    this.this$0 = this$0;
                }

                protected MapPixelLocation getGoalWhenNoPathFound(MapPixelLocation finalGoal) {
                    return null;
                }
            };
        }

        public MapPixelLocation getNextImmediateGoal(MapEntity movingEntity, MapPixelLocation fleeFrom, MapEntity goalEntity) {
            MapPixelLocation current = movingEntity.getLocation();
            if (fleeFrom == null) {
                return current;
            }
            if (!fleeFrom.equals(this.fleeFrom)) {
                this.fleeFrom = fleeFrom;
                this.goal = null;
            }
            MapPixelDistance maxDistance = new MapPixelDistance(10 * TileSize.tileSize.width);
            int i = 0;
            while (i < 10) {
                Map map = movingEntity.getMap();
                int tries = 0;
                while (this.goal == null && ++tries < 10) {
                    MapPixelLocation test = map.getRandomPassibleRectangleLocationInRange(current, movingEntity.getSize(), maxDistance);
                    if (test == null) {
                        return current;
                    }
                    if (PointUtil.getAngleBetween((Point2D.Double)PointUtil.getUnitVector((Point)current, (Point)test), (Point2D.Double)PointUtil.getUnitVector((Point)current, (Point)fleeFrom)) < 1.5707963267948966) continue;
                    this.goal = test;
                }
                if (this.goal == null) {
                    return current;
                }
                MapPixelLocation next = this.helper.getNextImmediateGoal(movingEntity, this.goal, null);
                if (next != null && !next.equals(current)) {
                    return next;
                }
                this.goal = null;
                ++i;
            }
            return current;
        }
    }

    public static class RandomOnSameTile
    extends MovementAlgorithm {
        public RandomOnSameTile(MapEntity movingEntity) {
            super(movingEntity);
        }

        public MapPixelLocation getNextImmediateGoal(MapEntity movingEntity, MapPixelLocation finalGoal, MapEntity goalEntity) {
            int maxTries = 5;
            Map map = movingEntity.getMap();
            MapPixelLocation current = movingEntity.getLocation();
            MapPixelLocation next = new MapPixelLocation();
            int maxTileDistance = 4;
            int widthRange = 4 * TileSize.tileSize.width;
            int heightRange = 4 * TileSize.tileSize.height;
            int i = 0;
            while (i < 5) {
                next.setLocation(current.x + Random.getInt(-widthRange, widthRange), current.y + Random.getInt(-heightRange, heightRange));
                if (map.getTile(next).equals(map.getTile(current))) {
                    return next;
                }
                ++i;
            }
            return current;
        }
    }

    public static class Stationary
    extends MovementAlgorithm {
        public Stationary(MapEntity movingEntity) {
            super(movingEntity);
        }

        public MapPixelLocation getNextImmediateGoal(MapEntity movingEntity, MapPixelLocation finalGoal, MapEntity goalEntity) {
            return movingEntity.getLocation();
        }
    }

    public static class GoDirectOrFindPath
    extends MovementAlgorithm {
        private transient PathFinder pathFinder;
        private List path;
        private MapPixelLocation lastImmediateGoal = new MapPixelLocation();

        public GoDirectOrFindPath(MapEntity movingEntity) {
            super(movingEntity);
        }

        public MapPixelLocation getNextImmediateGoal(MapEntity movingEntity, MapPixelLocation finalGoal, MapEntity goalEntity) {
            MapPixelLocation current;
            Map map = movingEntity.getMap();
            if (map.isLinePassible(current = movingEntity.getLocation(), finalGoal, movingEntity.getMovementType(), movingEntity.getSize(), movingEntity, goalEntity)) {
                return finalGoal;
            }
            if (this.path != null && !current.equals(this.lastImmediateGoal)) {
                this.path = null;
            }
            if (this.path == null || this.path.isEmpty()) {
                if (this.pathFinder == null) {
                    this.pathFinder = new PathFinder();
                }
                this.path = this.pathFinder.getPassiblePath(map, current, finalGoal, movingEntity, goalEntity, new MapTileDistance(15));
                if (this.path == null) {
                    return this.getGoalWhenNoPathFound(finalGoal);
                }
                MapPixelLocation first = (MapPixelLocation)this.path.get(0);
                if (first.equals(current)) {
                    this.path.remove(0);
                }
            }
            MapPixelLocation next = (MapPixelLocation)this.path.remove(0);
            this.lastImmediateGoal.setLocation(next);
            return next;
        }

        public void onCouldNotReachImmediateGoal() {
            this.path = null;
        }

        protected MapPixelLocation getGoalWhenNoPathFound(MapPixelLocation finalGoal) {
            return finalGoal;
        }
    }
}

