/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.beings.monsters;

import java.util.List;
import silmar.entities.MapEntity;
import silmar.entities.beings.monsters.Monster;
import silmar.entities.beings.monsters.MonsterFactory;
import silmar.entities.beings.monsters.MonsterType;
import silmar.entities.beings.player.PlayerUtil;
import silmar.game.Game;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapTileDistance;
import silmar.map.effects.PowerDischarge;
import silmar.tiles.TileSize;

public class MonsterUtil
implements TileSize {
    private static MapPixelDistance createMonsterPlacementDistance = new MapPixelDistance(3 * TileSize.tileSize.width);

    public static void doActivateMonstersInRange(Map map, MapPixelLocation location, MapTileDistance range) {
        MonsterUtil.doActivateMonsters(map.getMonstersInRange(location, new MapPixelDistance(range.distance * TileSize.tileSize.width), null));
    }

    public static void doActivateMonsters(List monsters) {
        int numMonsters = monsters.size();
        for (int i = 0; i < numMonsters; ++i) {
            Monster monster = (Monster)monsters.get(i);
            monster.doActivate();
        }
    }

    public static void doActivateMonstersInLOS(Map map, MapPixelLocation location) {
        MonsterUtil.doActivateMonsters(map.getMonstersInLOS(location, null));
    }

    public static boolean doGenerateMonster(Map map, MapPixelLocation location, MonsterType generateType, int interval) {
        Game game = Game.getCurrentGame();
        if (game.getTurn() % interval == 0) {
            MonsterUtil.doCreateMonster(map, location, generateType, CreateMonsterReason.generation);
            return true;
        }
        return false;
    }

    public static Monster doCreateMonster(Map map, MapPixelLocation location, MonsterType type, CreateMonsterReason reason) {
        Monster monster = MonsterFactory.doCreateMonster(type);
        MapPixelLocation where = map.getNearbyPassibleRectangleLocation(location, monster.getSize(), type.getMovementType(), createMonsterPlacementDistance);
        if (where == null) {
            return null;
        }
        PowerDischarge.doDischarge(map, location);
        map.doAddEntity((MapEntity)monster, where);
        PlayerUtil.doSendMessageToPlayersInLOS(map, location, reason.message);
        return monster;
    }

    public static class CreateMonsterReason {
        private String message;
        public static CreateMonsterReason generation = new CreateMonsterReason("generates!");
        public static CreateMonsterReason summoning = new CreateMonsterReason("summons!");
        public static CreateMonsterReason split = new CreateMonsterReason("splits!");

        public CreateMonsterReason(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

