/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.beings.monsters;

import silmar.entities.beings.attacks.AttackType;
import silmar.entities.beings.attacks.PenetrationType;
import silmar.entities.damage.DamageForm;
import silmar.map.MapTileDistance;
import silmar.tiles.TileSize;

public final class MonsterAttack
implements TileSize {
    private String description;
    private int minDamage;
    private int maxDamage;
    private MapTileDistance maxRange;
    private int accuracy;
    private DamageForm damageForm;
    public static MonsterAttack giantRatBite = new MonsterAttack("bite", 1, 3, 0, 0, DamageForm.pierce);
    public static MonsterAttack batBite = new MonsterAttack("bite", 1, 1, 0, 0, DamageForm.pierce);
    public static MonsterAttack orcSword = new MonsterAttack("long sword", 1, 8, 0, 0, DamageForm.slash);
    public static MonsterAttack orcCrossbow = new MonsterAttack("crossbow", 1, 4, 20, 6, DamageForm.pierce);
    public static MonsterAttack goblinSword = new MonsterAttack("short sword", 1, 6, 0, 0, DamageForm.slash);
    public static MonsterAttack skeletonSword = new MonsterAttack("short sword", 1, 6, 0, 0, DamageForm.slash);
    public static MonsterAttack reptileManClaw = new MonsterAttack("claw", 1, 2, 0, 0, DamageForm.slash);
    public static MonsterAttack reptileManBite = new MonsterAttack("bite", 1, 8, 0, 0, DamageForm.pierce);
    public static MonsterAttack floatingSpheroidBite = new MonsterAttack("bite", 1, 6, 0, 0, DamageForm.pierce);
    public static MonsterAttack zombieRend = new MonsterAttack("rend", 1, 8, 0, 0, DamageForm.slash);
    public static MonsterAttack slimeOoze = new MonsterAttack("ooze", 1, 8, 0, 0, DamageForm.acid);
    public static MonsterAttack warlockDagger = new MonsterAttack("dagger", 1, 4, 0, 0, DamageForm.pierce);
    public static MonsterAttack warlockDarts = new MonsterAttack("dart", 1, 2, 8, 7, DamageForm.pierce);
    public static MonsterAttack transparentGelatinoidAcid = new MonsterAttack("acid", 2, 8, 0, 0, DamageForm.acid);
    public static MonsterAttack ogreFist = new MonsterAttack("fist", 1, 10, 0, 0, DamageForm.bluntImpact);
    public static MonsterAttack munchkinGrab = new MonsterAttack("grab", 0, 0, 0, 0, DamageForm.pierce);
    public static MonsterAttack berzerkerSword = new MonsterAttack("long sword", 1, 8, 0, 0, DamageForm.slash);
    public static MonsterAttack berzerkerDagger = new MonsterAttack("dagger", 1, 4, 0, 0, DamageForm.pierce);
    public static MonsterAttack poisonousSnakeFangs = new MonsterAttack("fangs", 1, 3, 0, 0, DamageForm.pierce);
    public static MonsterAttack atomanFist = new MonsterAttack("fist", 1, 6, 0, 0, DamageForm.bluntImpact);
    public static MonsterAttack atomanBite = new MonsterAttack("bite", 2, 12, 0, 0, DamageForm.pierce);
    public static MonsterAttack gargoyleClaw = new MonsterAttack("claw", 1, 3, 0, 0, DamageForm.slash);
    public static MonsterAttack gargoyleBite = new MonsterAttack("bite", 1, 6, 0, 0, DamageForm.pierce);
    public static MonsterAttack gargoyleTail = new MonsterAttack("tail", 1, 4, 0, 0, DamageForm.pierce);
    public static MonsterAttack rusterAntenna = new MonsterAttack("antenna", 0, 0, 0, 0, DamageForm.pierce);
    public static MonsterAttack blobAcid = new MonsterAttack("acid", 1, 10, 0, 0, DamageForm.acid);
    public static MonsterAttack pretegClaw = new MonsterAttack("claw", 1, 8, 0, 0, DamageForm.slash);
    public static MonsterAttack minotaurFistHornCombo = new MonsterAttack("fist/horn combo", 3, 5, 0, 0, DamageForm.bluntImpact);
    public static MonsterAttack dopplegangerFist = new MonsterAttack("fist", 1, 12, 0, 0, DamageForm.bluntImpact);
    public static MonsterAttack gremlinSwipe = new MonsterAttack("swipe", 1, 1, 0, 0, DamageForm.slash);
    public static MonsterAttack ghoulClaw = new MonsterAttack("claw", 1, 3, 0, 0, DamageForm.slash);
    public static MonsterAttack ghoulBite = new MonsterAttack("bite", 1, 6, 0, 0, DamageForm.pierce);
    public static MonsterAttack redDragonClaw = new MonsterAttack("claw", 1, 8, 0, 0, DamageForm.slash);
    public static MonsterAttack redDragonBite = new MonsterAttack("bite", 3, 30, 0, 0, DamageForm.pierce);
    public static MonsterAttack medusaSnakes = new MonsterAttack("snakes", 1, 4, 0, 0, DamageForm.pierce);
    public static MonsterAttack trollRake = new MonsterAttack("rake", 5, 8, 0, 0, DamageForm.slash);
    public static MonsterAttack trollBite = new MonsterAttack("bite", 2, 12, 0, 0, DamageForm.pierce);
    public static MonsterAttack negadeadClaw = new MonsterAttack("claw", 1, 4, 0, 0, DamageForm.slash);
    public static MonsterAttack assassinSword = new MonsterAttack("long sword", 1, 8, 0, 0, DamageForm.slash);
    public static MonsterAttack killerTreeLimb = new MonsterAttack("limb", 2, 16, 0, 0, DamageForm.bluntImpact);
    public static MonsterAttack mummyArm = new MonsterAttack("arm", 1, 12, 0, 0, DamageForm.bluntImpact);
    public static MonsterAttack hulksterClaw = new MonsterAttack("claw", 3, 12, 0, 0, DamageForm.slash);
    public static MonsterAttack hulksterMandibles = new MonsterAttack("mandibles", 2, 10, 0, 0, DamageForm.pierce);
    public static MonsterAttack earthElementalFist = new MonsterAttack("fist", 4, 32, 0, 0, DamageForm.bluntImpact);
    public static MonsterAttack ferrousGolemSword = new MonsterAttack("huge sword", 4, 40, 0, 0, DamageForm.slash);
    public static MonsterAttack darkKnightSword = new MonsterAttack("two-handed sword", 7, 20, 0, 0, DamageForm.slash);
    public static MonsterAttack stalkinFist = new MonsterAttack("fist", 4, 16, 0, 0, DamageForm.bluntImpact);
    public static MonsterAttack warpDemonArm = new MonsterAttack("arm", 2, 8, 0, 0, DamageForm.bluntImpact);
    public static MonsterAttack vampireDrainStrike = new MonsterAttack("drain strike", 5, 10, 0, 0, DamageForm.pierce);
    public static MonsterAttack livingDeadWizardTouch = new MonsterAttack("touch", 1, 10, 0, 0, DamageForm.pierce);
    public static MonsterAttack livingDeadPirateGrab = new MonsterAttack("grab", 1, 4, 0, 0, DamageForm.pierce);
    public static MonsterAttack livingDeadPirateRake = new MonsterAttack("rake", 1, 8, 0, 0, DamageForm.slash);
    public static MonsterAttack painkillerInjection = new MonsterAttack("injection", 1, 4, 0, 0, DamageForm.pierce);
    public static MonsterAttack giantAntBite = new MonsterAttack("bite", 1, 6, 0, 0, DamageForm.pierce);
    public static MonsterAttack dreadedPansyNeedle = new MonsterAttack("needle", 1, 4, 10, 5, DamageForm.pierce);
    public static MonsterAttack scumShambleArm = new MonsterAttack("arm", 1, 8, 0, 0, DamageForm.bluntImpact);
    public static MonsterAttack giantWaspBite = new MonsterAttack("bite", 2, 8, 0, 0, DamageForm.pierce);
    public static MonsterAttack giantWaspSting = new MonsterAttack("sting", 1, 4, 0, 0, DamageForm.pierce);
    public static MonsterAttack weirdThingZap = new MonsterAttack("zap", 1, 12, 7, 7, DamageForm.electricity);
    public static MonsterAttack hydraBite = new MonsterAttack("bite", 1, 10, 0, 0, DamageForm.pierce);
    public static MonsterAttack giantZombieBlow = new MonsterAttack("crushing blow", 2, 24, 0, 0, DamageForm.bluntImpact);
    public static MonsterAttack moldySkeletonRapier = new MonsterAttack("rapier", 1, 8, 0, 0, DamageForm.slash);
    public static MonsterAttack ghostTouch = new MonsterAttack("touch", 4, 12, 0, 0, DamageForm.pierce);
    public static MonsterAttack killerCorpseTouch = new MonsterAttack("touch", 1, 3, 0, 0, DamageForm.pierce);
    public static MonsterAttack giantSpiderBite = new MonsterAttack("bite", 2, 8, 0, 0, DamageForm.pierce);
    public static MonsterAttack ghastClaw = new MonsterAttack("claw", 1, 4, 0, 0, DamageForm.slash);
    public static MonsterAttack ghastBite = new MonsterAttack("bite", 1, 8, 0, 0, DamageForm.pierce);
    public static MonsterAttack giantWormBite = new MonsterAttack("bite", 2, 20, 0, 0, DamageForm.swallow);
    public static MonsterAttack acidDragonClaw = new MonsterAttack("claw", 1, 5, 0, 0, DamageForm.slash);
    public static MonsterAttack acidDragonBite = new MonsterAttack("bite", 3, 16, 0, 0, DamageForm.pierce);
    public static MonsterAttack visculoidTouch = new MonsterAttack("corrosive touch", 3, 21, 0, 0, DamageForm.acid);
    public static MonsterAttack mirroredArmorRam = new MonsterAttack("ramming attempt", 5, 10, 0, 0, DamageForm.bluntImpact);
    public static MonsterAttack guardianSwordSlash = new MonsterAttack("vorpal slash", 3, 30, 0, 0, DamageForm.slash);
    public static MonsterAttack landSharkBite = new MonsterAttack("bite", 2, 16, 0, 0, DamageForm.pierce);
    public static MonsterAttack cyclopsClub = new MonsterAttack("club", 3, 8, 0, 0, DamageForm.bluntImpact);
    public static MonsterAttack typhoidZombieRend = new MonsterAttack("rend", 1, 10, 0, 0, DamageForm.slash);
    public static MonsterAttack slimeChuckerSlime = new MonsterAttack("slime", 1, 4, 5, 8, DamageForm.acid);
    public static MonsterAttack cannibalSpear = new MonsterAttack("spear", 3, 7, 0, 0, DamageForm.pierce);
    public static MonsterAttack cannibalBlowgunDart = new MonsterAttack("blowgun dart", 1, 2, 5, 5, DamageForm.pierce);
    public static MonsterAttack giantCentipedeBite = new MonsterAttack("bite", 1, 6, 0, 0, DamageForm.pierce);
    public static MonsterAttack rogueDagger = new MonsterAttack("dagger", 1, 4, 0, 0, DamageForm.pierce);
    public static MonsterAttack grenadierPistol = new MonsterAttack("pistol", 1, 5, 20, 8, DamageForm.pierce);
    public static MonsterAttack maniacKnife = new MonsterAttack("knife", 1, 4, 0, 0, DamageForm.slash);
    public static MonsterAttack mercenaryAssaultRifle = new MonsterAttack("assault rifle", 1, 7, 30, 7, DamageForm.pierce);
    public static MonsterAttack sentryborgPincer = new MonsterAttack("pincer", 5, 20, 0, 0, DamageForm.pierce);
    public static MonsterAttack sentryborgStunRay = new MonsterAttack("stun ray", 1, 1, 10, 8, DamageForm.electricity);
    public static MonsterAttack mutividerRazorSwipe = new MonsterAttack("razor swipe", 1, 8, 0, 0, DamageForm.slash);
    public static MonsterAttack mutatedRatBite = new MonsterAttack("bite", 4, 12, 0, 0, DamageForm.pierce);
    public static MonsterAttack dragonmanBite = new MonsterAttack("bite", 1, 12, 0, 0, DamageForm.pierce);
    public static MonsterAttack cethargFist = new MonsterAttack("fist", 3, 14, 0, 0, DamageForm.bluntImpact);
    public static MonsterAttack mutatedWarriorSabre = new MonsterAttack("sabre", 4, 11, 0, 0, DamageForm.slash);
    public static MonsterAttack mutatedWarriorDagger = new MonsterAttack("dagger", 4, 7, 0, 0, DamageForm.pierce);
    public static MonsterAttack mutatedWarriorPistol = new MonsterAttack("pistol", 1, 5, 20, 8, DamageForm.pierce);
    public static MonsterAttack deathbotGrasp = new MonsterAttack("crushing grasp", 10, 30, 0, 0, DamageForm.pierce);
    public static MonsterAttack deathbotRay = new MonsterAttack("death ray", 10, 30, 50, 9, DamageForm.laser);
    public static MonsterAttack poltergeistTouch = new MonsterAttack("touch", 1, 8, 0, 0, DamageForm.pierce);
    public static MonsterAttack livingDeadWizard2VortexBeam = new MonsterAttack("vortex beam", 10, 40, 40, 9, DamageForm.laser);

    public MonsterAttack(String description, int minDamage, int maxDamage, int maxTileRange, int halfAccuracy, DamageForm damageForm) {
        this.description = description;
        this.minDamage = minDamage;
        this.maxDamage = maxDamage;
        this.maxRange = new MapTileDistance(maxTileRange);
        this.accuracy = halfAccuracy * 2;
        this.damageForm = damageForm;
    }

    public AttackType getAttackType() {
        if (this.equals(weirdThingZap) || this.equals(sentryborgStunRay)) {
            return AttackType.electricity;
        }
        if (this.equals(deathbotRay)) {
            return AttackType.deathRay;
        }
        if (this.equals(orcCrossbow)) {
            return AttackType.oldProjectile;
        }
        if (this.equals(livingDeadWizard2VortexBeam)) {
            return AttackType.vortexBeam;
        }
        if (this.maxRange.distance > 1) {
            PenetrationType type = this.getPenetrationType();
            if (type.equals(PenetrationType.laser)) {
                return AttackType.laserCell;
            }
            if (type.equals(PenetrationType.firearm)) {
                return AttackType.bullet;
            }
            return AttackType.oldProjectile;
        }
        return AttackType.meleeAttack;
    }

    public int getMinDamage() {
        return this.minDamage;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    public MapTileDistance getMaxRange() {
        return this.maxRange;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public PenetrationType getPenetrationType() {
        if (this.equals(orcCrossbow) || this.equals(grenadierPistol) || this.equals(mercenaryAssaultRifle) || this.equals(sentryborgPincer) || this.equals(mutatedWarriorPistol)) {
            return PenetrationType.firearm;
        }
        if (this.equals(sentryborgStunRay) || this.equals(deathbotGrasp) || this.equals(deathbotRay) || this.equals(livingDeadWizard2VortexBeam)) {
            return PenetrationType.laser;
        }
        return PenetrationType.normal;
    }

    public DamageForm getDamageForm() {
        return this.damageForm;
    }
}

