/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.beings.monsters;

import java.awt.Dimension;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import silmar.Sound;
import silmar.entities.LightSource;
import silmar.entities.MapEntity;
import silmar.entities.MapEntityUtil;
import silmar.entities.beings.Alignment;
import silmar.entities.beings.Being;
import silmar.entities.beings.MovementType;
import silmar.entities.beings.attacks.PenetrationType;
import silmar.entities.beings.attacks.RangedAttackUtil;
import silmar.entities.beings.monsters.MonsterAttack;
import silmar.entities.beings.monsters.MonsterType;
import silmar.entities.beings.monsters.MonsterUtil;
import silmar.entities.beings.player.Player;
import silmar.entities.beings.player.PlayerUtil;
import silmar.entities.damage.Damage;
import silmar.entities.damage.DamageForm;
import silmar.entities.damage.DamageUtil;
import silmar.entities.items.weapons.Weapon;
import silmar.entities.terrains.Terrain;
import silmar.game.Game;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.map.MapTileDistance;
import silmar.map.PathFinder;
import silmar.map.adjacency.AdjacencyMap;
import silmar.map.effects.Attack;
import silmar.map.effects.LightSourceVisualEffect;
import silmar.map.effects.Poof;
import silmar.tiles.Tile;
import silmar.tiles.TileSize;
import silmar.util.FloatPoint;
import silmar.util.PointUtil;
import silmar.util.Random;
import silmar.util.ThreadUtil;

public class Monster
extends Being
implements RangedAttackUtil.RangedAttacker {
    private boolean checkedRangedAttackFrequencyThisTurn;
    private Player focusPlayer;
    private boolean seekingOtherGoal = false;
    private MapPixelLocation otherGoal = new MapPixelLocation();
    private FloatPoint lastDirectionMoved;
    private final MoveTowardsGoalListener moveTowardsGoalListener = new MoveTowardsGoalListener();
    private boolean stationary = false;
    protected final Fleeing fleeing = new Fleeing();
    protected Player fleeFromPlayer;
    private int fleeStartTurn;
    private transient PathFinder pathFinder;
    private boolean turnOver;
    protected transient MonsterType type;
    private String typeName;
    protected final Activated activated = new Activated();
    private Map.IsLitResult onSoundHeard_isLitResult = new Map.IsLitResult();
    private final MapPixelDistance doAct_maxAdjacencyPathDistance;
    private MapPixelDistance doAct_range;
    private MapPixelLocation doAct_spot;
    private static final MapTileDistance doAct_maxPathDistance = new MapTileDistance(13);
    private Map.IsLitResult doCheckForRangedAttacks_isLitResult;
    private List getShouldActivate_players;
    private Map.IsLitResult getShouldActivate_isLitResult;
    private final MapPixelDistance doDie_ExperienceDistance;
    private List doInformTerrainsOfPresence_terrainsAt;

    public Monster() {
        this.doAct_maxAdjacencyPathDistance = new MapPixelDistance(20 * TileSize.tileSize.width);
        this.doAct_range = new MapPixelDistance();
        this.doAct_spot = new MapPixelLocation();
        this.doCheckForRangedAttacks_isLitResult = new Map.IsLitResult();
        this.getShouldActivate_players = new ArrayList();
        this.getShouldActivate_isLitResult = new Map.IsLitResult();
        this.doDie_ExperienceDistance = new MapPixelDistance(20 * TileSize.tileSize.width);
        this.doInformTerrainsOfPresence_terrainsAt = new ArrayList();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.typeName = this.type.getName();
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException {
        try {
            s.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.type = (MonsterType)MonsterType.typesMap.get(this.typeName);
    }

    public void onCreated(MonsterType type) {
        this.type = type;
        if (type.equals(MonsterType.robotGenerator)) {
            this.maxHitPoints.set(200);
        } else if (type.equals(MonsterType.floatingSpheroid)) {
            this.maxHitPoints.set(1);
        } else {
            this.maxHitPoints.set(Random.getBellCurveInt(1, 8, type.getPowerRating()));
        }
        this.setHitPoints(this.getMaxHitPoints());
    }

    public void onSoundHeard(Sound sound, MapPixelLocation soundLocation, MapPixelDistance distance) {
        if (soundLocation.equals(this.location)) {
            return;
        }
        if (!sound.getActivatesMonsters()) {
            return;
        }
        if ((sound == Sound.movement || sound == Sound.doorOpens || sound == Sound.doorCloses) && (this.map.getFirstPlayerAt(soundLocation) == null || !this.map.getCanSee(this.location, soundLocation, TileSize.tileSize.width, false, false, null, null)) || this.isLightSource() && !this.map.isLit((MapPixelLocation)soundLocation, (MapPixelLocation)this.location, (LightSource)((LightSource)((Object)this)), (MapEntity)this, (Map.IsLitResult)this.onSoundHeard_isLitResult).halfLit) {
            return;
        }
        if (!this.activated.get()) {
            this.activated.set(true);
        }
        if (this.focusPlayer == null) {
            this.otherGoal.setLocation(soundLocation);
            this.seekingOtherGoal = true;
        }
    }

    public void doEndTurn() {
        this.turnOver = true;
    }

    protected void doAffectDamage(Damage damage) {
    }

    public void doTakeDamage(Damage damage) {
        if (this.isDead()) {
            return;
        }
        this.doAffectDamage(damage);
        if (!this.activated.get()) {
            damage.amount *= 2;
            this.activated.set(true);
        }
        super.doTakeDamage(damage);
    }

    public final int getAvoidance() {
        return super.getAvoidance() - this.getType().getAvoidanceModifier();
    }

    public void doAct() {
        boolean canSeePlayer;
        super.doAct();
        this.turnOver = false;
        this.doInformTerrainsOfPresence();
        if (this.turnOver || this.isDead()) {
            return;
        }
        if (this.isParalyzed()) {
            return;
        }
        if (this.fleeing.get()) {
            this.doCheckForFleeingEnd();
        }
        this.movementSoundCounter = 0;
        if (!this.activated.get() && !this.fleeing.get() && this.getShouldActivate()) {
            this.activated.set(true);
        }
        if (this.activated.get() && this.focusPlayer == null) {
            this.focusPlayer = this.map.getNearestPlayerInLOS(this.location);
        }
        boolean bl = canSeePlayer = this.focusPlayer != null && this.map.getCanSee(this.location, this.focusPlayer.getLocation(), RangedAttackUtil.pixelsPerShotMove, false, true, this, this.focusPlayer);
        if (this.activated.get() && (canSeePlayer || !this.type.getMustSeePlayerToUsePower()) && this.doUsePreMovementPower(this.focusPlayer)) {
            return;
        }
        this.setMovementPoints(this.getMaxMovementPoints());
        MapPixelLocation goal = null;
        if (this.stationary || this.type.isStationary()) {
            goal = this.location;
        } else if (this.fleeing.get()) {
            goal = this.getFleeingGoal();
        } else if (this.focusPlayer != null) {
            goal = this.focusPlayer.getLocation();
        } else if (this.seekingOtherGoal) {
            goal = this.otherGoal;
        } else if (this.activated.get() && this.map.getAdjacencyMap() != null) {
            goal = this.getGoalFromAdjacencyMap();
            if (goal == null) {
                this.activated.set(false);
            }
        } else {
            goal = this.getUnactivatedGoal();
        }
        if (goal == null) {
            return;
        }
        this.checkedRangedAttackFrequencyThisTurn = false;
        if (canSeePlayer && this.doCheckForRangedAttacks()) {
            return;
        }
        if (!this.fleeing.get() && this.focusPlayer != null && this.isNextTo(this.focusPlayer)) {
            this.doCheckForMeleeAttacks();
            this.turnOver = true;
            return;
        }
        List path = null;
        boolean pathTried = false;
        boolean harmfulPathTried = false;
        while (!this.turnOver && !this.isDead()) {
            PathFinder.GetPassiblePathResult pathResult;
            Player goalEntity;
            MapPixelLocation pathLocation = null;
            MapPixelLocation immediateGoal = null;
            Map.IsLinePassibleResult lineResult = null;
            if (path == null) {
                lineResult = this.map.isLinePassible(this.location, goal, this.getMovementType(), this.getSize(), this, this.focusPlayer, true);
                if (lineResult.passible && !lineResult.harmful) {
                    immediateGoal = goal;
                    path = null;
                }
            }
            boolean pathSearchFoundHarm = false;
            if (immediateGoal == null) {
                if (this.activated.get() && path == null && !pathTried) {
                    if (this.pathFinder == null) {
                        this.pathFinder = new PathFinder();
                    }
                    goalEntity = this.focusPlayer != null ? this.focusPlayer : this.map.getNearestPlayer(this.location);
                    pathResult = this.pathFinder.getPassiblePath(this.map, this.location, goal, this, goalEntity, doAct_maxPathDistance, this.getMovementType(), true, true);
                    pathSearchFoundHarm = pathResult.foundHarm;
                    if (!pathSearchFoundHarm || !pathResult.bestPathReturned) {
                        path = pathResult.path;
                    }
                    pathTried = true;
                }
                if (path != null) {
                    immediateGoal = pathLocation = (MapPixelLocation)path.remove(0);
                    if (path.isEmpty()) {
                        path = null;
                    }
                }
            }
            if (immediateGoal == null && path == null && (lineResult == null || lineResult.harmful) && this.map.isLinePassible((MapPixelLocation)this.location, (MapPixelLocation)goal, (MovementType)this.getMovementType(), (Dimension)this.getSize(), (MapEntity)this, (MapEntity)this.focusPlayer, (boolean)false).passible) {
                immediateGoal = goal;
                path = null;
            }
            if (immediateGoal == null) {
                if (this.activated.get() && path == null && pathSearchFoundHarm && !harmfulPathTried) {
                    if (this.pathFinder == null) {
                        this.pathFinder = new PathFinder();
                    }
                    goalEntity = this.focusPlayer != null ? this.focusPlayer : this.map.getNearestPlayer(this.location);
                    pathResult = this.pathFinder.getPassiblePath(this.map, this.location, goal, this, goalEntity, doAct_maxPathDistance, this.getMovementType(), true, false);
                    path = pathResult.path;
                    harmfulPathTried = true;
                }
                if (path != null) {
                    immediateGoal = pathLocation = (MapPixelLocation)path.remove(0);
                    if (path.isEmpty()) {
                        path = null;
                    }
                }
            }
            if (immediateGoal == null) {
                immediateGoal = goal;
                this.seekingOtherGoal = false;
            }
            this.lastDirectionMoved = PointUtil.getUnitVector(this.location, immediateGoal);
            MapEntityUtil.MoveTowardsGoalResult result = MapEntityUtil.doMoveTowardsGoal(this, immediateGoal, this.getMovementPoints(), this.moveTowardsGoalListener);
            this.setMovementPoints(result.movementPointsLeft);
            if (this.isDead()) {
                return;
            }
            if (result.impass) {
                path = null;
                this.turnOver = true;
            } else if (result.notEnoughMovementPoints || this.getMovementPoints() <= 0.0f) {
                if (pathLocation != null && path != null) {
                    path.add(0, pathLocation);
                }
                this.turnOver = true;
            } else if (immediateGoal.equals(goal)) {
                this.turnOver = true;
            } else {
                immediateGoal = null;
            }
            if (this.seekingOtherGoal && MapPixelLocationUtil.isDistanceAtMost(this.location, this.otherGoal, TileSize.tileDistance)) {
                this.seekingOtherGoal = false;
            }
            if (this.activated.get() && this.focusPlayer == null) {
                this.focusPlayer = this.map.getNearestPlayerInLOS(this.location);
                if (this.focusPlayer != null) {
                    goal = this.focusPlayer.getLocation();
                    canSeePlayer = this.map.getCanSee(this.location, this.focusPlayer.getLocation(), TileSize.tileSize.width / 4, false, true, this, this.focusPlayer);
                }
            }
            if (!this.checkedRangedAttackFrequencyThisTurn && canSeePlayer && this.doCheckForRangedAttacks()) {
                return;
            }
            this.doCheckForMeleeAttacks();
        }
        if (this.focusPlayer != null && path == null && !this.map.getCanSee(this.location, this.focusPlayer.getLocation(), TileSize.tileSize.width, false, false, null, null)) {
            this.otherGoal.setLocation(this.focusPlayer.getLocation());
            this.focusPlayer = null;
        }
        if (!this.activated.get() && !this.fleeing.get() && this.getShouldActivate()) {
            this.activated.set(true);
        }
    }

    private boolean doCheckForRangedAttacks() {
        if (this.focusPlayer != null) {
            MapPixelLocation playerLocation = this.focusPlayer.getLocation();
            if (!this.fleeing.get() && this.activated.get() && this.type.getRangedAttacks() != null && this.isInRange(playerLocation) && (!this.isNextTo(this.focusPlayer) || this.type.getMeleeAttacks() == null)) {
                if ((this.isLightSource() || this.getMap().isLit((MapPixelLocation)this.getLocation(), null, null, (MapEntity)this, (Map.IsLitResult)this.doCheckForRangedAttacks_isLitResult).halfLit) && !this.getMap().isLit((MapPixelLocation)playerLocation, (MapPixelLocation)this.getLocation(), null, (MapEntity)this, (Map.IsLitResult)this.doCheckForRangedAttacks_isLitResult).halfLit) {
                    return false;
                }
                this.checkedRangedAttackFrequencyThisTurn = true;
                if (Random.getInt(1, 10) <= this.type.getRangedAttackFrequency()) {
                    this.doMakeRangedAttacks(this.focusPlayer);
                    this.turnOver = true;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean doCheckForMeleeAttacks() {
        if (this.focusPlayer == null) {
            return false;
        }
        if (!this.fleeing.get() && this.activated.get() && this.type.getMeleeAttacks() != null && this.isNextTo(this.focusPlayer)) {
            this.doMakeMeleeAttacks(this.focusPlayer);
            this.turnOver = true;
            return true;
        }
        return false;
    }

    private boolean getShouldActivate() {
        List players = this.getShouldActivate_players;
        this.map.getPlayersInLOS(this.location, players);
        int numPlayers = players.size();
        for (int i = 0; i < numPlayers; ++i) {
            Player player = (Player)players.get(i);
            if (!(!player.isEmittingLight() || this.isLightSource() && ((LightSource)((Object)this)).isEmittingLight())) {
                return true;
            }
            if (this.lastDirectionMoved != null && !PointUtil.isLocationInDirection(this.location, player.getLocation(), this.lastDirectionMoved) || this.isLightSource() && !this.map.isLit((MapPixelLocation)player.getLocation(), (MapPixelLocation)this.location, (LightSource)((LightSource)((Object)this)), (MapEntity)this, (Map.IsLitResult)this.getShouldActivate_isLitResult).halfLit) continue;
            if (player.isBeingStealthy()) {
                Being.AvoidResult result = this.doAvoid(player.getStealthAvoidancePenalty());
                if (!result.avoided) continue;
            }
            return true;
        }
        return false;
    }

    public void doBecomeParalyzed(int duration) {
        if (this.type.isLivingDead() || this.type.equals(MonsterType.grave) || this.type.equals(MonsterType.bones) || this.type.equals(MonsterType.vortex) || this.type.equals(MonsterType.casket) || this.type.equals(MonsterType.robotGenerator)) {
            PlayerUtil.doSendMessageToPlayersInLOS(this.getMap(), this.getLocation(), "No effect");
            return;
        }
        super.doBecomeParalyzed(duration);
    }

    protected void onAttackHitPlayer(Player player, MonsterAttack attack, int hitBy) {
    }

    protected void onAttackHitBeing(Being being, MonsterAttack attack, int hitBy) {
        if (being.isPlayer()) {
            this.onAttackHitPlayer((Player)being, attack, hitBy);
        }
    }

    protected void doMakeMeleeAttacks(Player player) {
        MonsterAttack[] attacks = this.type.getMeleeAttacks();
        if (attacks == null) {
            return;
        }
        MapPixelLocation playerLocation = player.getLocation();
        for (int i = 0; i < attacks.length; ++i) {
            MonsterAttack attack = attacks[i];
            PlayerUtil.doSendMessageToPlayersInLOS(this.map, this.location, this.type.getName() + ": " + attack.getDescription());
            int roll = Random.getInt(1, 20);
            int total = roll + this.getToHitModifier(player, attack) - this.getNumberToHitDefense0();
            Being.IsAHitResult result = player.isAMeleeHit(total, attack.getPenetrationType(), this);
            int damage = 0;
            if (result.hit) {
                damage = Random.getInt(attack.getMinDamage(), attack.getMaxDamage());
            }
            Attack.doAttack(this.map, this.location, playerLocation, attack.getAttackType());
            if (result.hit) {
                player.onHitByMonster(this, attack, damage, result.hitBy);
                this.onAttackHitBeing(player, attack, result.hitBy);
            } else {
                player.onAttackedAndMissed();
            }
            this.onMadeAttack(attack);
        }
    }

    protected void doMakeRangedAttacks(Player player) {
        MonsterAttack[] attacks = this.type.getRangedAttacks();
        if (attacks == null) {
            return;
        }
        MapPixelLocation playerLocation = player.getLocation();
        for (int i = 0; i < attacks.length; ++i) {
            MonsterAttack attack = attacks[i];
            PlayerUtil.doSendMessageToPlayersInLOS(this.map, this.location, this.type.getName() + ": " + attack.getDescription());
            MapPixelLocation target = RangedAttackUtil.doModifyTarget(this.location, playerLocation, attack.getMaxRange(), attack.getAccuracy());
            RangedAttackUtil.DoMakeRangedAttackResult result = RangedAttackUtil.doMakeRangedAttack(this, this.map, this.location, target, attack.getMaxRange(), attack.getPenetrationType(), this.getNumberToHitDefense0());
            int damage = 0;
            if (result.hit) {
                damage = Random.getInt(attack.getMinDamage(), attack.getMaxDamage());
            }
            MapPixelLocation impact = result.beingImpacted != null ? result.beingImpacted.getLocation() : result.impactLocation;
            Attack.doAttack(this.map, this.location, impact, attack.getAttackType());
            if (result.hit) {
                result.beingImpacted.onHitByMonster(this, attack, damage, result.hitBy);
                this.onAttackHitBeing(result.beingImpacted, attack, result.hitBy);
            } else if (result.beingImpacted != null) {
                result.beingImpacted.onAttackedAndMissed();
            }
            this.onMadeAttack(attack);
        }
    }

    protected final int getNumberToHitDefense0() {
        int number = 9 - this.type.getPowerRating();
        if (this.type.equals(MonsterType.darkKnight)) {
            number -= 3;
        }
        return number;
    }

    protected boolean doUsePreMovementPower(Player player) {
        return false;
    }

    protected void doSplit() {
        Monster monster = MonsterUtil.doCreateMonster(this.getMap(), this.getLocation(), this.type, MonsterUtil.CreateMonsterReason.split);
        int halfHitPoints = this.getHitPoints() / 2;
        this.setHitPoints(halfHitPoints);
        monster.setHitPoints(halfHitPoints);
    }

    protected void doDie(Damage damage) {
        Map map = this.getMap();
        MapPixelLocation location = this.getLocation();
        super.doDie(damage);
        Poof.doPoof(map, location, this.getSize());
        List players = map.getPlayersInRange(location, this.doDie_ExperienceDistance, null);
        if (players != null && !players.isEmpty()) {
            int share = Math.max(1, this.type.getExperienceValue() / players.size());
            int numPlayers = players.size();
            for (int i = 0; i < numPlayers; ++i) {
                Player player = (Player)players.get(i);
                player.onExperienceGained(share);
            }
        }
    }

    protected void onMadeAttack(MonsterAttack attack) {
    }

    public String getImageName() {
        String imageName = this.type.getImageName();
        return imageName != null ? "monsters/" + imageName : null;
    }

    protected boolean isInRange(MapPixelLocation target) {
        MapPixelDistance range = MapPixelLocationUtil.getDistance(this.location, target);
        MonsterAttack[] attacks = this.type.getRangedAttacks();
        for (int i = 0; i < attacks.length; ++i) {
            MonsterAttack attack = attacks[i];
            if (attack.getMaxRange().distance * TileSize.tileSize.width < range.distance) continue;
            return true;
        }
        return false;
    }

    public void onAffectedByRobotCommandInterface() {
        if (this.type.equals(MonsterType.cetharg) || this.type.equals(MonsterType.deathbot) || this.type.equals(MonsterType.sentryborg)) {
            this.doBecomeParalyzed(1);
        }
    }

    public void onHitByMaceOfPurity() {
        if (this.type.isLivingDead()) {
            this.doTakeDamage(new Damage(Random.getInt(3, 20), DamageForm.holyPower));
        }
    }

    public final boolean isMorePowerfulThan(Monster monster) {
        return this.type.getPowerRating() > monster.type.getPowerRating();
    }

    public void onHitByWeapon(Weapon weapon, Being wielder, int damageAmount) {
        Damage damage = new Damage(damageAmount, weapon.getWeaponType().getDamageForm(), wielder, weapon);
        DamageUtil.doAffectByWeaponPlusNeededToHit(damage, this.type.getWeaponPlusNeededToHit());
        if (damageAmount != 0 && damage.amount == 0 && wielder.isPlayer()) {
            ((Player)wielder).onMessage("Your weapon may not be able to damage this monster.", Player.MessageType.status);
        }
        if (this.type.isLessVulnerableToEdgedWeapons()) {
            DamageUtil.doAffectEdgedWeapons(damage, 0.5f);
        }
        this.doTakeDamage(damage);
    }

    protected int getModifierOnMeleeAttackAgainstThisBeing() {
        return this.activated.get() ? 0 : 4;
    }

    protected int getModifierOnRangedAttackAgainstThisBeing() {
        return this.activated.get() ? 0 : 4;
    }

    protected final int getDefense(PenetrationType penetration, Being attacker) {
        int defense = this.type.getDefenses()[penetration.getRank()];
        if (this.isParalyzed()) {
            defense -= 10;
        }
        return defense;
    }

    public int getRangedToHitModifier(Being target) {
        return 0;
    }

    public final boolean isOfType(MonsterType type) {
        return type.equals(this.type);
    }

    public void onLivingDeadRepel(Player repeller, int strength) {
        if (this.type.isLivingDead()) {
            Being.AvoidResult result = this.doAvoid(strength / 2);
            if (!result.avoided) {
                this.fleeing.set(true);
                this.fleeFromPlayer = repeller;
                LightSourceVisualEffect effect = new LightSourceVisualEffect("repelled", new MapPixelDistance(new MapTileDistance(4)));
                this.map.doAddEntity((MapEntity)effect, this.location);
                this.map.onSoundIssued(Sound.livingDeadRepel, this.location);
                ThreadUtil.doSleep(700L);
                this.map.doRemoveEntity(effect);
                if (result.missedBy >= 8) {
                    this.doTakeDamage(new Damage(this.getHitPoints(), DamageForm.holyPower));
                }
                this.focusPlayer = repeller;
            }
        }
    }

    public void setStationary(boolean stationary) {
        this.stationary = stationary;
    }

    public Dimension getSize() {
        return this.type.getSize();
    }

    public final MonsterType getType() {
        return this.type;
    }

    public final int getPowerRating() {
        return this.type.getPowerRating();
    }

    public int getMaxMovementPoints() {
        return this.type.getMovementPoints();
    }

    protected final boolean isActivated() {
        return this.activated.get();
    }

    protected void setType(MonsterType type) {
        this.type = type;
    }

    public void doActivate() {
        this.activated.set(true);
    }

    public MovementType getMovementType() {
        return this.type.getMovementType();
    }

    public final Sound getMovementSound() {
        Sound sound = this.type.getSound();
        if (sound != null && Random.getFloat() <= this.type.getSoundFrequency()) {
            return sound;
        }
        return super.getMovementSound();
    }

    public final boolean isEvil() {
        return this.type.getAlignment().equals(Alignment.evil);
    }

    public boolean onTouchedVengefulSymbol(int strength) {
        if (this.isEvil()) {
            int damage = Random.getInt(strength, strength * 2);
            this.doTakeDamage(new Damage(damage, DamageForm.holyPower));
            return true;
        }
        return false;
    }

    protected int getToHitModifier(Player player, MonsterAttack attack) {
        return 0;
    }

    public boolean isMonster() {
        return true;
    }

    private void doInformTerrainsOfPresence() {
        List terrains = this.doInformTerrainsOfPresence_terrainsAt;
        this.map.getEntitiesInRectangle(this.location, this.getSize(), this.map.getTerrains(), null, null, null, terrains);
        int numTerrains = terrains.size();
        for (int i = 0; i < numTerrains; ++i) {
            Terrain terrain = (Terrain)terrains.get(i);
            terrain.onBeingHere(this);
        }
    }

    private void doCheckForFleeingEnd() {
        int roll;
        int minFleeDuration = 6;
        Game game = Game.getCurrentGame();
        if (game.getTurn() - this.fleeStartTurn >= 6 && (roll = Random.getInt(1, 20)) >= 20 - this.type.getPowerRating() / 2) {
            this.fleeing.set(false);
        }
    }

    private MapPixelLocation getFleeingGoal() {
        MapPixelLocation goal;
        MapPixelDistance maxDistance = new MapPixelDistance(this.getMaxMovementPoints() * TileSize.tileSize.width);
        MapPixelDistance maxPathDistance = new MapPixelDistance(maxDistance.distance * 2);
        MapPixelLocation furthestGoal = null;
        MapPixelDistance furthestDistance = null;
        for (int i = 0; i < 10 && (goal = this.map.getRandomPassibleRectangleLocationInRange(this.location, this.getSize(), maxDistance, 50, this.type.getMovementType(), false)) != null; ++i) {
            if ((double)PointUtil.getAngleBetween(PointUtil.getUnitVector(this.location, goal), PointUtil.getUnitVector(this.location, this.fleeFromPlayer.getLocation())) < 1.5707963267948966) {
                goal = null;
                continue;
            }
            AdjacencyMap adjacencyMap = this.map.getAdjacencyMap();
            if (adjacencyMap != null && !adjacencyMap.getPathExists((MapPixelLocation)this.location, (MapPixelLocation)goal, (MapPixelDistance)maxPathDistance, (boolean)this.getMovementType().getAllowsWorkingDoors()).pathExists) {
                goal = null;
                continue;
            }
            MapPixelDistance distance = MapPixelLocationUtil.getDistance(this.location, goal);
            if (furthestGoal != null && distance.distance <= furthestDistance.distance) break;
            furthestGoal = goal;
            furthestDistance = distance;
            break;
        }
        goal = furthestGoal;
        return goal;
    }

    private MapPixelLocation getGoalFromAdjacencyMap() {
        MapPixelLocation goal = null;
        Player nearestPlayer = this.map.getNearestPlayer(this.location);
        if (nearestPlayer == null) {
            return goal;
        }
        MapPixelLocation playerLocation = nearestPlayer.getLocation();
        AdjacencyMap.GetPathExistsResult result = this.map.getAdjacencyMap().getPathExists(this.location, playerLocation, this.doAct_maxAdjacencyPathDistance, true);
        if (result.pathExists && Random.getFloat() < 1.0f - (float)(result.pathLength.distance / TileSize.tileSize.width) * 0.015f) {
            goal = playerLocation;
        }
        return goal;
    }

    private MapPixelLocation getUnactivatedGoal() {
        MapPixelLocation goal = null;
        MapPixelLocation spot = this.doAct_spot;
        spot.setLocation(this.location);
        MapPixelDistance range = this.doAct_range;
        range.distance = this.getMaxMovementPoints() * TileSize.tileSize.width / 2;
        if (this.lastDirectionMoved != null) {
            spot.setLocation((int)((float)spot.x + this.lastDirectionMoved.x * (float)range.distance), (int)((float)spot.y + this.lastDirectionMoved.y * (float)range.distance));
        }
        for (int i = 0; i < 3 && (goal = this.map.getRandomPassibleRectangleLocationInRange(spot, this.getSize(), range, 10, this.type.getMovementType(), false)) != null && !this.map.isLinePassible((MapPixelLocation)this.location, (MapPixelLocation)goal, (MovementType)this.getMovementType(), (Dimension)this.getSize(), (MapEntity)this, null, (boolean)true).passible; ++i) {
            goal = null;
        }
        if (goal == null) {
            this.lastDirectionMoved = null;
        }
        return goal;
    }

    public boolean isAffectedByDeathFog() {
        return true;
    }

    public boolean isAffectedByFire() {
        return true;
    }

    private class MoveTowardsGoalListener
    implements MapEntityUtil.MoveTowardsGoalListener,
    Serializable {
        private MoveTowardsGoalListener() {
        }

        public boolean onMovedOntoNewTile(Tile tile) {
            if (!Monster.this.activated.get() && Monster.this.type.getMovementType().getAllowsWorkingDoors()) {
                Monster.this.map.doCloseDoor(Monster.this.location, false);
            }
            return true;
        }

        public boolean getShouldContinue(MapPixelLocation oldLocation) {
            return !Monster.this.isDead();
        }

        public boolean onAtTerrain(Terrain terrain) {
            return true;
        }
    }

    protected class Fleeing
    implements Serializable {
        private boolean fleeing = false;

        protected Fleeing() {
        }

        public boolean get() {
            return this.fleeing;
        }

        protected void set(boolean fleeing) {
            if (fleeing == this.fleeing) {
                return;
            }
            this.fleeing = fleeing;
            if (fleeing) {
                Game game = Game.getCurrentGame();
                Monster.this.fleeStartTurn = game.getTurn();
            }
        }
    }

    protected class Activated
    implements Serializable {
        private boolean activated = false;

        protected Activated() {
        }

        public boolean get() {
            return this.activated;
        }

        public void set(boolean activated) {
            if (this.activated == activated) {
                return;
            }
            if (Monster.this.fleeing.get() && activated) {
                return;
            }
            this.activated = activated;
            if (activated && Monster.this.isVisible()) {
                Monster.this.getMap().onSoundIssued(Sound.monsterActivation, Monster.this.getLocation(), false);
            }
        }
    }
}

