/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.beings.attacks;

import java.awt.geom.Point2D;
import silmar.entities.beings.Being;
import silmar.entities.beings.attacks.PenetrationType;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.map.MapTileDistance;
import silmar.tiles.TileSize;
import silmar.util.FloatPoint;
import silmar.util.PointUtil;
import silmar.util.Random;

public class RangedAttackUtil
implements TileSize {
    public static int pixelsPerShotMove = 4;

    public static MapPixelLocation doModifyTarget(MapPixelLocation attackerLocation, MapPixelLocation target, MapTileDistance maxRange, int accuracy) {
        MapPixelDistance range = MapPixelLocationUtil.getDistance(attackerLocation, target);
        int penalty = RangedAttackUtil.getPenaltyForRange(range, new MapPixelDistance(maxRange.distance * TileSize.tileSize.width));
        int missedBy = Random.getInt(1, 20) - accuracy + penalty;
        if (missedBy > 0) {
            int magnitude = Math.min(range.distance - TileSize.tileSize.width, (int)((float)missedBy / 8.0f * ((float)range.distance / 8.0f)));
            float angle = (float)((double)(Random.getFloat() * 2.0f) * Math.PI);
            target = new MapPixelLocation(target);
            target.x = (int)((double)target.x + (double)magnitude * Math.cos(angle));
            target.y = (int)((double)target.y + (double)magnitude * Math.sin(angle));
        }
        return target;
    }

    public static int getPenaltyForRange(MapPixelDistance range, MapPixelDistance maxRange) {
        return (int)Math.rint(7.0f * ((float)range.distance / (float)maxRange.distance));
    }

    public static DoMakeRangedAttackResult doMakeRangedAttack(RangedAttacker attacker, Map map, MapPixelLocation attackerLocation, MapPixelLocation target, MapTileDistance maxRange, PenetrationType penetrationType, int attackerNumberToHitDefense0) {
        FloatPoint direction = PointUtil.getUnitVector(attackerLocation, target);
        direction.x *= (float)pixelsPerShotMove;
        direction.y *= (float)pixelsPerShotMove;
        float numMoves = maxRange.distance * TileSize.tileSize.width / pixelsPerShotMove;
        DoMakeRangedAttackResult result = new DoMakeRangedAttackResult();
        Point2D.Float current = new Point2D.Float(attackerLocation.x, attackerLocation.y);
        MapPixelLocation rounded = new MapPixelLocation(attackerLocation);
        int i = 0;
        while ((float)i < numMoves) {
            current.x += direction.x;
            current.y += direction.y;
            rounded.move((int)current.x, (int)current.y);
            Being being = map.getFirstBeingAt(rounded);
            if (being != null && being != attacker) {
                MapPixelDistance range = MapPixelLocationUtil.getDistance(attackerLocation, rounded);
                int rangePenalty = RangedAttackUtil.getPenaltyForRange(range, new MapPixelDistance(maxRange.distance * TileSize.tileSize.width));
                int roll = Random.getInt(1, 20);
                int total = roll + attacker.getRangedToHitModifier(being) - attackerNumberToHitDefense0 - rangePenalty;
                Being.IsAHitResult isAHitResult = being.isARangedHit(total, penetrationType, attacker instanceof Being ? (Being)((Object)attacker) : null);
                result.hit = isAHitResult.hit;
                result.hitBy = isAHitResult.hitBy;
                if (isAHitResult.missedBy < 6) {
                    result.beingImpacted = being;
                    result.impactLocation = rounded;
                    return result;
                }
            }
            if (map.getTile(rounded).getBlocksLOS() || (float)i == numMoves - 1.0f) {
                result.impactLocation = rounded;
                result.hit = false;
                return result;
            }
            ++i;
        }
        return null;
    }

    public static interface RangedAttacker {
        public int getRangedToHitModifier(Being var1);
    }

    public static class DoMakeRangedAttackResult {
        public boolean hit;
        public Being beingImpacted;
        public MapPixelLocation impactLocation;
        public int hitBy = 0;
    }
}

