/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.beings;

import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import silmar.Sound;
import silmar.entities.MapEntity;
import silmar.entities.beings.BeingUtil;
import silmar.entities.beings.MovementType;
import silmar.entities.beings.attacks.PenetrationType;
import silmar.entities.beings.monsters.Monster;
import silmar.entities.beings.monsters.MonsterAttack;
import silmar.entities.beings.player.PlayerUtil;
import silmar.entities.damage.Damage;
import silmar.entities.damage.DamageForm;
import silmar.entities.damage.DamageStatus;
import silmar.entities.items.Item;
import silmar.entities.items.types.ItemType;
import silmar.entities.items.weapons.Weapon;
import silmar.entities.terrains.Terrain;
import silmar.entities.terrains.TerrainType;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapTileDistance;
import silmar.map.effects.Disintegration;
import silmar.map.effects.LightSourceVisualEffect;
import silmar.map.effects.PowerDischarge;
import silmar.map.effects.VisualEffect;
import silmar.tiles.TileSize;
import silmar.util.Random;
import silmar.util.ThreadUtil;

public abstract class Being
extends MapEntity
implements TileSize {
    protected final HitPoints hitPoints = new HitPoints();
    protected final MaxHitPoints maxHitPoints = new MaxHitPoints();
    protected final ParalyzedTurnsLeft paralyzedTurnsLeft = new ParalyzedTurnsLeft();
    protected final ConfusedTurnsLeft confusedTurnsLeft = new ConfusedTurnsLeft();
    protected float movementPoints;
    protected static final int paralysisDefenseModifier = -10;

    public void doTakeDamage(Damage damage) {
        if (this.isDead()) {
            return;
        }
        if (this.isParalyzed()) {
            damage.amount *= 2;
        }
        this.hitPoints.doRemove(damage.amount);
        VisualEffect effect = new VisualEffect(this.getDamageStatus().getHitImageName());
        this.map.doAddEntity((MapEntity)effect, this.location);
        int effectDuration = 300;
        if (damage.amount > 0) {
            PlayerUtil.doSendMessageToPlayersInLOS(this.map, this.location, Integer.toString(damage.amount), 300);
        }
        this.map.onSoundIssued(Sound.damage, this.location);
        if (!this.map.getPlayersInLOS(this.location, null).isEmpty()) {
            ThreadUtil.doSleep(300L);
        }
        this.map.doRemoveEntity(effect);
        this.onDamaged(damage);
        if (this.isDead()) {
            this.doDie(damage);
        }
    }

    protected void doDie(Damage damage) {
        this.doBecomeNotParalyzed();
        this.getMap().doRemoveEntity(this);
    }

    protected void onDamaged(Damage damage) {
    }

    public void doTakeHealing(int amount) {
        int actual = Math.min(amount, this.maxHitPoints.get() - this.hitPoints.get());
        if (actual <= 0) {
            return;
        }
        LightSourceVisualEffect effect = new LightSourceVisualEffect("healing", new MapPixelDistance(new MapTileDistance(4)));
        this.map.doAddEntity((MapEntity)effect, this.location);
        int pausePerHitPoint = 60;
        this.doTakeHealingHook1(actual, 60);
        this.map.onSoundIssued(Sound.heal, this.location);
        ThreadUtil.doSleep(actual * 60);
        this.hitPoints.doAdd(actual);
        this.map.doRemoveEntity(effect);
    }

    protected void doTakeHealingHook1(int healAmount, int pausePerHitPoint) {
    }

    public abstract int getPowerRating();

    public int getAvoidance() {
        return 18 - this.getPowerRating() * 2 / 3;
    }

    protected void doEndTurn() {
    }

    public void doBecomeConfused(int duration) {
        if (this.isConfused()) {
            return;
        }
        PowerDischarge.doDischarge(this);
        this.onSoundHeard(Sound.confused, this.getLocation());
        this.confusedTurnsLeft.set(duration);
    }

    public final boolean isConfused() {
        return this.confusedTurnsLeft.get() > 0;
    }

    public final boolean isParalyzed() {
        return this.paralyzedTurnsLeft.get() > 0;
    }

    public void doBecomeParalyzed(int duration) {
        if (this.isParalyzed()) {
            return;
        }
        PlayerUtil.doSendMessageToPlayersInLOS(this.map, this.location, "Paralyzed!");
        this.paralyzedTurnsLeft.set(duration);
    }

    public void doBecomeNotParalyzed() {
        this.paralyzedTurnsLeft.set(0);
    }

    public void onStuckInWeb(Terrain web, int turnsStuck) {
        if (!this.getBreaksOutOfWeb(turnsStuck)) {
            this.doEndTurn();
            this.getMap().onSoundIssued(Sound.inWeb, this.getLocation());
            PlayerUtil.doSendMessageToPlayersInLOS(this.getMap(), this.getLocation(), "stuck in web");
        } else {
            this.getMap().doRemoveEntity(web);
        }
    }

    protected boolean getBreaksOutOfWeb(int turnsStuck) {
        return turnsStuck + this.getPowerRating() >= 12;
    }

    public MapPixelDistance getVacuumHoleSuckDistance() {
        return new MapPixelDistance(Math.min(5 - this.getPowerRating() / 3, this.getMaxMovementPoints() - 1) * TileSize.tileSize.width);
    }

    public abstract int getMaxMovementPoints();

    public final boolean isDead() {
        return this.hitPoints.get() <= 0;
    }

    public MapTileDistance getBaseKnockbackDistance() {
        return new MapTileDistance((15 - this.getPowerRating()) / 2);
    }

    public void onHitByStunWhip() {
        this.doBecomeParalyzed(Math.max(1, 6 - this.getPowerRating() / 2));
    }

    public void onInKnockBackCollision(int damage) {
        this.doTakeDamage(new Damage(damage, DamageForm.bluntImpact));
    }

    public boolean onBroughtBackToLife(Map map, MapPixelLocation location) {
        if ((location = map.getNearbyPassibleRectangleLocation(location, this.getSize(), this.getMovementType(), new MapPixelDistance(2 * TileSize.tileSize.width))) == null) {
            return false;
        }
        map.doAddEntity((MapEntity)this, location);
        this.doTakeHealing(1 - this.hitPoints.get());
        return true;
    }

    public void onInFire() {
        this.doTakeDamage(new Damage(Random.getInt(1, 6), DamageForm.fire));
    }

    public void onInDeathFog(int strength) {
        int damage = Random.getInt(strength, strength * 2);
        AvoidResult result = this.doAvoid(strength / 2);
        if (result.avoided) {
            damage /= 2;
        }
        if (!result.superAvoided) {
            this.doTakeDamage(new Damage(damage, DamageForm.deathFog));
        }
    }

    public AvoidResult doAvoid(int penalty) {
        int roll = Random.getInt(1, 20);
        AvoidResult result = new AvoidResult();
        int avoidance = this.getAvoidance();
        result.avoided = roll - penalty >= avoidance;
        result.superAvoided = roll - penalty - 8 >= avoidance;
        result.missedBy = avoidance - (roll - penalty);
        if (result.avoided) {
            PlayerUtil.doSendMessageToPlayersInLOS(this.getMap(), this.getLocation(), result.superAvoided ? "super-avoids" : "avoids");
        }
        return result;
    }

    public void onHitByStaffOfHarming() {
        this.doTakeDamage(new Damage(Random.getInt(2, 27), DamageForm.holyPower));
    }

    public void onHitByLightningBolt(int strength) {
        int damage = Random.getBellCurveInt(1, 6, strength);
        AvoidResult result = this.doAvoid(strength / 2);
        if (result.avoided) {
            damage /= 2;
        }
        if (!result.superAvoided) {
            this.doTakeDamage(new Damage(damage, DamageForm.electricity));
        }
    }

    public void onNonEmemyDied() {
    }

    public void onStruckBlobWithWeapon(Weapon weapon, int blobGrabStrength) {
        AvoidResult result = this.doAvoid(blobGrabStrength);
        if (!result.avoided) {
            weapon.onGrabbedByBlob();
        }
    }

    protected void doHealFromForm(DamageForm formWhichHeals, Damage damage, float factor) {
        if (damage.form.equals(formWhichHeals)) {
            this.doTakeHealing((int)((float)damage.amount * factor));
            damage.amount = 0;
        }
    }

    public void onHitByWeapon(Weapon weapon, Being wielder, int damage) {
        this.doTakeDamage(new Damage(damage, weapon.getWeaponType().getDamageForm(), wielder, weapon));
    }

    public void onHitByMonster(Monster monster, MonsterAttack attack, int damageAmount, int hitBy) {
        if (attack.equals(MonsterAttack.guardianSwordSlash)) {
            if (hitBy >= 8) {
                this.doSufferDecapitation();
                return;
            }
        } else if (attack.equals(MonsterAttack.giantWormBite) && hitBy >= 8) {
            this.doSufferBeingSwallowedWhole(monster);
            return;
        }
        Damage damage = new Damage(damageAmount, attack.getDamageForm(), monster, null, attack);
        this.doTakeDamage(damage);
        if (attack.equals(MonsterAttack.transparentGelatinoidAcid) || attack.equals(MonsterAttack.giantCentipedeBite)) {
            AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided) {
                this.doBecomeParalyzed(1);
            }
        } else if (attack.equals(MonsterAttack.ghoulClaw)) {
            AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided) {
                this.doBecomeParalyzed(Random.getInt(1, 5));
            }
        } else if (attack.equals(MonsterAttack.sentryborgStunRay)) {
            AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided) {
                this.doBecomeParalyzed(2);
            }
        } else if (attack.equals(MonsterAttack.pretegClaw)) {
            AvoidResult result = this.doAvoid(hitBy);
            if (!result.avoided) {
                BeingUtil.doTeleportRandomlyWithinMap(this, this.getMap());
            }
        } else if (attack.equals(MonsterAttack.painkillerInjection)) {
            if (Random.getBoolean()) {
                this.doTakeHealing(Random.getInt(1, 12));
            }
        } else if (attack.equals(MonsterAttack.livingDeadWizardTouch)) {
            AvoidResult result = this.doAvoid(hitBy + 8);
            if (!result.avoided) {
                this.doBecomeParalyzed(2);
            }
        }
    }

    protected int getModifierOnMeleeAttackAgainstThisBeing() {
        return 0;
    }

    protected int getModifierOnRangedAttackAgainstThisBeing() {
        return 0;
    }

    protected abstract int getDefense(PenetrationType var1, Being var2);

    public IsAHitResult isAMeleeHit(int number, PenetrationType penetration, Being attacker) {
        return this.isAHit(number + this.getModifierOnMeleeAttackAgainstThisBeing(), penetration, attacker);
    }

    public IsAHitResult isARangedHit(int number, PenetrationType penetration, Being attacker) {
        return this.isAHit(number + this.getModifierOnRangedAttackAgainstThisBeing(), penetration, attacker);
    }

    protected IsAHitResult isAHit(int number, PenetrationType penetration, Being attacker) {
        IsAHitResult result = new IsAHitResult();
        result.missedBy = this.getDefense(penetration, attacker) - number;
        result.hit = result.missedBy <= 0;
        result.hitBy = -result.missedBy;
        return result;
    }

    public void onHeardSound(Point location) {
    }

    public void onHitByDragonBreath(DamageForm breathType, int strength, int damage) {
        AvoidResult result = this.doAvoid(strength / 2);
        if (result.avoided) {
            damage /= 2;
        }
        this.doTakeDamage(new Damage(damage, breathType));
    }

    public void onHitByStunFlash(int strength) {
        AvoidResult result = this.doAvoid(strength / 2);
        if (!result.avoided) {
            this.doBecomeParalyzed(3);
        }
    }

    public void onHitByElectricityDischarge(int strength, int damage) {
        AvoidResult result = this.doAvoid(strength / 2);
        if (result.superAvoided) {
            return;
        }
        if (result.avoided) {
            damage /= 2;
        }
        this.doTakeDamage(new Damage(damage, DamageForm.electricity));
    }

    public int getDamageModifierForStrength() {
        return 0;
    }

    public void onHitByRetributiveShield(int damage) {
        this.doTakeDamage(new Damage(damage, DamageForm.bluntImpact));
    }

    public boolean isEvil() {
        return false;
    }

    public void onHitByPixieTouch(int strength) {
        AvoidResult result = this.doAvoid(strength / 2);
        if (!result.avoided) {
            BeingUtil.doTeleportRandomlyWithinMap(this, this.getMap());
        }
    }

    public void onHitByDisintegration(int strength) {
        AvoidResult result = this.doAvoid(strength / 2);
        if (!result.avoided) {
            Disintegration.doDisintegration(this.map, this.location);
            this.doTakeDamage(new Damage(this.hitPoints.get(), DamageForm.disintegration));
        }
    }

    public void onUsedItem(Item item) {
        if (item.isOfType(ItemType.potionOfHealing)) {
            this.doTakeHealing(Random.getBellCurveInt(1, 8, 4));
        }
    }

    public void onHitByMaceOfPurity() {
    }

    public void onHitByEyeBeams(int damage) {
        this.doTakeDamage(new Damage(damage, DamageForm.laser));
    }

    public void onHitByFireball(int strength) {
        int damage = Random.getBellCurveInt(1, 6, strength);
        AvoidResult result = this.doAvoid(strength / 2);
        if (result.avoided) {
            damage /= 2;
        }
        if (!result.superAvoided) {
            this.doTakeDamage(new Damage(damage / 2, DamageForm.explosion));
            this.doTakeDamage(new Damage(damage / 2, DamageForm.fire));
        }
    }

    public void onHulksterGaze(int strength) {
        if (this.isConfused()) {
            return;
        }
        AvoidResult result = this.doAvoid(strength / 2);
        if (!result.avoided) {
            this.doBecomeConfused(1 + result.missedBy);
        }
    }

    public void onMassConfusion(int strength) {
        this.onHulksterGaze(strength);
    }

    public void onHitByRadWave(int strength) {
        AvoidResult result = this.doAvoid(8 + strength / 2);
        if (!result.avoided) {
            this.doTakeDamage(new Damage(this.hitPoints.get(), DamageForm.radiation));
        } else if (!result.superAvoided) {
            this.doTakeDamage(new Damage(this.hitPoints.get() / 2, DamageForm.radiation));
        }
    }

    public void onHitByBoulder(int strength, int damage) {
        AvoidResult result = this.doAvoid(strength / 2);
        if (result.avoided) {
            damage /= 2;
        }
        this.doTakeDamage(new Damage(damage, DamageForm.bluntImpact));
    }

    public void onFreezeAttack(int strength) {
        if (this.isParalyzed()) {
            return;
        }
        AvoidResult result = this.doAvoid(strength / 2);
        if (!result.avoided) {
            this.doBecomeParalyzed(Math.max(strength / 2, 1));
        }
    }

    public void onHealedFully() {
        this.doTakeHealing(this.maxHitPoints.get() - this.hitPoints.get());
    }

    public void onHealed(int amount) {
        this.doTakeHealing(amount);
    }

    public void onHitByCrusher() {
        this.doTakeDamage(new Damage(this.hitPoints.get(), DamageForm.crushing));
    }

    public final int getMaxHitPoints() {
        return this.maxHitPoints.get();
    }

    public final float getMovementPoints() {
        return this.movementPoints;
    }

    protected void setMovementPoints(float movementPoints) {
        this.movementPoints = movementPoints;
    }

    public final int getHitPoints() {
        return this.hitPoints.get();
    }

    protected void setHitPoints(int amount) {
        this.hitPoints.set(amount);
    }

    public DamageStatus getDamageStatus() {
        int maxHitPoints;
        DamageStatus status = DamageStatus.critical;
        int hitPoints = this.getHitPoints();
        if (hitPoints >= (maxHitPoints = this.getMaxHitPoints())) {
            status = DamageStatus.undamaged;
        } else if (hitPoints > 2 * maxHitPoints / 3) {
            status = DamageStatus.ok;
        } else if (hitPoints > 1 * maxHitPoints / 3) {
            status = DamageStatus.serious;
        }
        return status;
    }

    public boolean isInjured() {
        return this.getHitPoints() < this.getMaxHitPoints();
    }

    public void onSoundHeard(Sound sound, MapPixelLocation location) {
        this.onSoundHeard(sound, location, new MapPixelDistance(0));
    }

    public void onSoundHeard(Sound sound, MapPixelLocation location, MapPixelDistance distance) {
    }

    protected void onHitPointsChange() {
    }

    protected void onMaxHitPointsChange() {
    }

    protected void onParalyzedStatusChange(boolean nowParalyzed) {
    }

    protected void onConfusedStatusChange(boolean nowConfused) {
    }

    public void onAttackedAndMissed() {
        VisualEffect effect = new VisualEffect("noDamage");
        this.map.doAddEntity((MapEntity)effect, this.location);
        this.map.onSoundIssued(Sound.miss, this.location);
        if (!this.map.getPlayersInLOS(this.location, null).isEmpty()) {
            ThreadUtil.doSleep(300L);
        }
        this.map.doRemoveEntity(effect);
    }

    public void onTurnOver() {
        super.onTurnOver();
        if (this.paralyzedTurnsLeft.get() > 0) {
            this.paralyzedTurnsLeft.doRemoveOne();
        }
        if (this.confusedTurnsLeft.get() > 0) {
            this.confusedTurnsLeft.doRemoveOne();
        }
    }

    public void onImageToChange() {
        super.onImageToChange();
        Dimension size = this.getSize();
        if (!this.map.isRectanglePassible((MapPixelLocation)this.location, (Dimension)size, (MovementType)this.getMovementType(), (boolean)true, (MapEntity)this, null, (boolean)false).passible) {
            this.map.doMoveEntity(this, this.map.getNearbyPassibleRectangleLocation(this.location, size, this.getMovementType()));
        }
    }

    public boolean isStuckInWebs() {
        return this.map.isTerrainOfTypeInRectangle(TerrainType.web, this.location, this.getSize());
    }

    protected void doSufferDecapitation() {
        PlayerUtil.doSendMessageToPlayersInLOS(this.map, this.location, "decapitated!");
        this.doTakeDamage(new Damage(this.hitPoints.get(), DamageForm.decapitation));
    }

    protected void doSufferBeingSwallowedWhole(Being swallower) {
        this.map.onSoundIssued(Sound.gulp, this.location);
        ThreadUtil.doSleep(200L);
        this.map.doMoveEntity(this, swallower.getLocation());
        ThreadUtil.doSleep(50L);
        PlayerUtil.doSendMessageToPlayersInLOS(this.map, this.location, "swallowed whole!");
        this.doTakeDamage(new Damage(this.getHitPoints(), DamageForm.swallow));
    }

    public boolean isBeing() {
        return true;
    }

    protected class MaxHitPoints
    implements Serializable {
        private int maxHitPoints;

        protected MaxHitPoints() {
        }

        public int get() {
            return this.maxHitPoints;
        }

        public void set(int amount) {
            if (amount == this.maxHitPoints) {
                return;
            }
            this.maxHitPoints = amount;
            Being.this.hitPoints.set(Math.min(Being.this.hitPoints.get(), this.maxHitPoints));
            Being.this.onMaxHitPointsChange();
        }

        public void doRemove(int amount) {
            this.set(this.get() - amount);
        }

        public void doAdd(int amount) {
            this.set(this.get() + amount);
        }
    }

    protected class HitPoints
    implements Serializable {
        private int hitPoints;

        protected HitPoints() {
        }

        public int get() {
            return this.hitPoints;
        }

        public void set(int amount) {
            if (amount == this.hitPoints) {
                return;
            }
            this.hitPoints = amount;
            Being.this.onHitPointsChange();
        }

        public void doRemove(int amount) {
            this.set(this.get() - amount);
        }

        public void doAdd(int amount) {
            this.set(this.get() + amount);
        }
    }

    protected class ConfusedTurnsLeft
    implements Serializable {
        private int confusedTurnsLeft;

        protected ConfusedTurnsLeft() {
        }

        public int get() {
            return this.confusedTurnsLeft;
        }

        public void set(int turnsLeft) {
            if (turnsLeft == this.confusedTurnsLeft) {
                return;
            }
            boolean becameConfused = turnsLeft > 0 && this.confusedTurnsLeft == 0;
            boolean noLongerConfused = turnsLeft == 0 && this.confusedTurnsLeft > 0;
            this.confusedTurnsLeft = turnsLeft;
            if (becameConfused || noLongerConfused) {
                Being.this.onConfusedStatusChange(becameConfused);
            }
        }

        public void doRemoveOne() {
            this.set(this.get() - 1);
        }
    }

    protected class ParalyzedTurnsLeft
    implements Serializable {
        private int paralyzedTurnsLeft;

        protected ParalyzedTurnsLeft() {
        }

        public int get() {
            return this.paralyzedTurnsLeft;
        }

        public void set(int turnsLeft) {
            if (turnsLeft == this.paralyzedTurnsLeft) {
                return;
            }
            boolean becameParalyzed = turnsLeft > 0 && this.paralyzedTurnsLeft == 0;
            boolean noLongerParalyzed = turnsLeft == 0 && this.paralyzedTurnsLeft > 0;
            this.paralyzedTurnsLeft = turnsLeft;
            if (becameParalyzed || noLongerParalyzed) {
                Being.this.onParalyzedStatusChange(becameParalyzed);
            }
        }

        public void doRemoveOne() {
            this.set(this.get() - 1);
        }
    }

    public static class IsAHitResult {
        public boolean hit;
        public int hitBy;
        public int missedBy;
    }

    protected class AvoidResult {
        public boolean avoided;
        public boolean superAvoided;
        public int missedBy;

        protected AvoidResult() {
        }
    }
}

