/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import java.awt.Frame;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JPanel;
import silmar.client.CommandsThread;
import silmar.client.gui.EquippedItemsAndInventoryDialog;
import silmar.client.gui.ItemDisplay;
import silmar.client.gui.WindowArrangement;
import silmar.entities.beings.player.Player;
import silmar.events.Event;
import silmar.events.Listener;
import silmar.gui.Fonts;
import silmar.gui.dialogs.InputIntDialog;
import silmar.gui.widgets.Label;

public class UseOrDropItemsDialog
extends EquippedItemsAndInventoryDialog {
    public UseOrDropItemsDialog(Frame parent, Player player) {
        super(parent, "Items", player, null);
        this.getEquippedItemsDisplay().doAddListener(new EquippedItemsDisplayListener());
        this.getInventoryDisplay().doAddListener(new InventoryDisplayListener());
        Point location = WindowArrangement.getInstance().useOrDropItemsDialogLocation;
        if (location != null) {
            this.setLocation(location);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                WindowArrangement arrangement = WindowArrangement.getInstance();
                arrangement.useOrDropItemsDialogLocation = UseOrDropItemsDialog.this.getLocation();
            }
        });
    }

    protected void doAddEquippedItemsHelpText(JPanel panel) {
        Label label = new Label("left-click: use   right-click: remove", Fonts.small);
        panel.add(label);
    }

    protected void doAddInventoryHelpText(JPanel panel) {
        Label label = new Label("left-click: use   right-click: drop", Fonts.small);
        panel.add(label);
        label = new Label("mouseover for info", Fonts.small);
        panel.add(label);
    }

    private class InventoryDisplayListener
    implements Listener {
        private InventoryDisplayListener() {
        }

        public void onEvent(Event event) {
            if (event.isOfType(ItemDisplay.ItemClicked.itemClicked)) {
                this.onItemClicked((ItemDisplay.ItemClicked)event);
            }
        }

        protected void onItemClicked(ItemDisplay.ItemClicked event) {
            if (event.rightClick) {
                int quantity = event.item.getQuantity();
                if (quantity > 1) {
                    InputIntDialog.Result result = InputIntDialog.doShow(UseOrDropItemsDialog.this, "Drop how many of this item?", 1, quantity, quantity);
                    if (result.cancelled) {
                        return;
                    }
                    quantity = result.valueEntered;
                }
                int finalQuantity = quantity;
                CommandsThread.getInstance().doAddCommand(new CommandsThread.Command(this, event, finalQuantity){
                    private final /* synthetic */ ItemDisplay.ItemClicked val$event;
                    private final /* synthetic */ int val$finalQuantity;
                    private final /* synthetic */ InventoryDisplayListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$event = val$event;
                        this.val$finalQuantity = val$finalQuantity;
                    }

                    public void doExecute() {
                        InventoryDisplayListener.access$200((InventoryDisplayListener)this.this$1).player.doDropItem(this.val$event.item, this.val$finalQuantity);
                    }
                });
            } else {
                CommandsThread.getInstance().doAddCommand(new CommandsThread.Command(this, event){
                    private final /* synthetic */ ItemDisplay.ItemClicked val$event;
                    private final /* synthetic */ InventoryDisplayListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$event = val$event;
                    }

                    public void doExecute() {
                        InventoryDisplayListener.access$200((InventoryDisplayListener)this.this$1).player.doUseItem(this.val$event.item);
                    }
                });
            }
        }

        static /* synthetic */ UseOrDropItemsDialog access$200(InventoryDisplayListener x0) {
            return x0.UseOrDropItemsDialog.this;
        }
    }

    private class EquippedItemsDisplayListener
    implements Listener {
        private EquippedItemsDisplayListener() {
        }

        public void onEvent(Event event) {
            if (event.isOfType(ItemDisplay.ItemClicked.itemClicked)) {
                this.onItemClicked((ItemDisplay.ItemClicked)event);
            }
        }

        protected void onItemClicked(ItemDisplay.ItemClicked event) {
            if (event.rightClick) {
                UseOrDropItemsDialog.this.player.doUnequipItem(event.item, true, false);
            } else {
                UseOrDropItemsDialog.this.player.doUseItem(event.item);
            }
        }
    }
}

