/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import java.awt.Frame;
import javax.swing.JFrame;
import silmar.client.gui.EquippedItemsAndInventoryDialog;
import silmar.client.gui.ItemDisplay;
import silmar.client.gui.ItemDisplayListener;
import silmar.entities.beings.player.Player;
import silmar.entities.beings.talkerBeings.TalkerBeings;
import silmar.entities.items.ItemValueContext;
import silmar.gui.dialogs.InputIntDialog;

public final class SellDialog
extends EquippedItemsAndInventoryDialog {
    public SellDialog(JFrame owner, final Player player, final TalkerBeings.Buyer buyer, String greeting) {
        super((Frame)owner, "Sell items", player, greeting);
        this.setModal(true);
        ItemDisplayListener listener = new ItemDisplayListener(ItemValueContext.sell){

            protected void onItemClickedAndValidated(ItemDisplay.ItemClicked event) {
                int quantity = event.item.getQuantity();
                if (quantity > 1) {
                    InputIntDialog.Result result = InputIntDialog.doShow(SellDialog.this, "Sell how many of this item?", 1, quantity, quantity);
                    if (result.cancelled) {
                        return;
                    }
                    quantity = result.valueEntered;
                }
                player.doSellItem(event.item, buyer, quantity);
            }
        };
        listener.setBuyer(buyer);
        this.getEquippedItemsDisplay().doAddListener(listener);
        this.getInventoryDisplay().doAddListener(listener);
    }
}

