/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import silmar.client.gui.WindowArrangement;
import silmar.entities.beings.player.Player;
import silmar.entities.beings.player.PlayerLevel;
import silmar.entities.beings.player.PlayerPower;
import silmar.events.Event;
import silmar.events.EventType;
import silmar.events.Listener;
import silmar.events.Reporter;
import silmar.gui.Fonts;
import silmar.gui.widgets.Button;
import silmar.gui.widgets.Label;
import silmar.util.WindowUtil;

public final class PowersDialog
extends JDialog {
    private Player player;
    private Reporter reporter = new Reporter();
    private JPanel powersPanel;

    public PowersDialog(Frame parent, Player player) {
        super(parent, "Powers");
        this.player = player;
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.setBackground(Color.black);
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.setLayout(new BoxLayout(panel, 1));
        pane.add((Component)panel, "Center");
        JPanel panel2 = this.powersPanel = new JPanel();
        panel2.setBackground(Color.black);
        panel2.setLayout(new BoxLayout(panel2, 1));
        this.powersPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JScrollPane scrollPane = new JScrollPane(this.powersPanel);
        scrollPane.setBorder(new LineBorder(Color.lightGray, 1));
        scrollPane.setOpaque(false);
        scrollPane.setHorizontalScrollBarPolicy(31);
        panel.add((Component)scrollPane, "Center");
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        panel.add(new Label("mouseover for info", Fonts.small));
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.doCreatePowersWidgets();
        WindowUtil.doCenterWindow(this);
        Point location = WindowArrangement.getInstance().powersDialogLocation;
        if (location != null) {
            this.setLocation(location);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                WindowArrangement arrangement = WindowArrangement.getInstance();
                arrangement.powersDialogLocation = PowersDialog.this.getLocation();
            }

            public void windowDeactivated(WindowEvent e) {
                this.windowClosing(e);
            }
        });
    }

    private void doCreatePowersWidgets() {
        this.powersPanel.removeAll();
        List powers = this.player.getPowers();
        int spacing = 5;
        PlayerLevel level = null;
        int numPowers = powers.size();
        for (int i = 0; i < numPowers; ++i) {
            PlayerPower power = (PlayerPower)powers.get(i);
            if (power.getLevel() != level) {
                level = power.getLevel();
                if (i != 0) {
                    this.powersPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                }
                Label label = new Label(level.getName(), Fonts.mediumBold);
                label.setHorizontalAlignment(2);
                this.powersPanel.add(label);
            }
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            panel.setLayout(new BoxLayout(panel, 0));
            this.powersPanel.add(panel);
            Label label = new Label(power.getName(), Fonts.medium);
            panel.add(label);
            label.getHasTooltipImpl().setTooltipText(power.getTooltipText(), 0);
            panel.add(Box.createRigidArea(new Dimension(5, 0)));
            if (power.isActiveUse()) {
                Button button = new Button(" Use ");
                panel.add(button);
                final PlayerPower finalPower = power;
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PowersDialog.this.setVisible(false);
                        PowersDialog.this.reporter.doReport(new PowerSelected(finalPower));
                    }
                });
            } else {
                label = new Label("PASSIVE", Fonts.medium);
                label.setForeground(Color.gray);
                panel.add(label);
                label.getHasTooltipImpl().setTooltipText("This power is always in effect.", 0);
            }
            panel.add(Box.createRigidArea(new Dimension(5, 0)));
            int cost = power.getMagicPointCost();
            if (cost > 0) {
                label = new Label("mp:" + cost, Fonts.small);
                panel.add(label);
                label.getHasTooltipImpl().setTooltipText("This power costs<br>" + cost + " magic points to use.", 0);
            }
            if ((cost = power.getClericalPointCost()) > 0) {
                label = new Label("cp:" + cost, Fonts.small);
                panel.add(label);
                label.getHasTooltipImpl().setTooltipText("This power costs<br>" + cost + " clerical points to use.", 0);
            }
            panel.add(Box.createHorizontalGlue());
            this.powersPanel.add(Box.createRigidArea(new Dimension(0, 2)));
        }
        if (powers.isEmpty()) {
            this.powersPanel.add(new Label("No powers currently possessed.", Fonts.medium));
        }
        this.pack();
        int maxDialogHeight = 500;
        if (this.getHeight() > 500) {
            this.setSize(this.getWidth(), 500);
            ((JComponent)this.powersPanel.getParent()).revalidate();
        }
    }

    public void onPowersChanged() {
        this.doCreatePowersWidgets();
    }

    public void doAddListener(Listener listener) {
        this.reporter.doAddListener(listener);
    }

    public static class PowerSelected
    extends Event {
        public PlayerPower power;
        public static final EventType powerSelected = new EventType();

        public PowerSelected(PlayerPower power) {
            this.power = power;
        }

        public EventType getType() {
            return powerSelected;
        }
    }
}

