/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import silmar.entities.beings.player.Player;
import silmar.entities.beings.player.PlayerAttribute;
import silmar.gui.Fonts;
import silmar.gui.dialogs.MessageDialog;
import silmar.gui.widgets.Button;
import silmar.gui.widgets.Label;
import silmar.util.ComponentUtil;
import silmar.util.HtmlUtil;
import silmar.util.TextUtil;

public final class PlayerAttributesDisplay
extends JPanel {
    private Player player;
    private AttributePanel[] attributePanels = new AttributePanel[PlayerAttribute.attributes.size()];
    private JLabel extraPointsLabel;
    private int extraPoints = 0;

    public PlayerAttributesDisplay(Player player) {
        this(player, false);
    }

    public PlayerAttributesDisplay(Player player, boolean showModifyButtons) {
        this.player = player;
        this.setBackground(Color.black);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BoxLayout(this, 1));
        int numAttributes = PlayerAttribute.attributes.size();
        for (int i = 0; i < numAttributes; ++i) {
            AttributePanel panel = this.attributePanels[i] = new AttributePanel(i, showModifyButtons);
            this.add(panel);
            this.add(Box.createRigidArea(new Dimension(0, 1)));
        }
        if (showModifyButtons) {
            this.extraPointsLabel = new Label("", Fonts.small);
            Label label = this.extraPointsLabel;
            this.add(label);
        }
        this.onAttributesChanged();
    }

    public void onAttributeChanged(PlayerAttribute attribute) {
        this.onAttributeChanged(attribute.getIndex());
    }

    public void onAttributeChanged(int index) {
        this.attributePanels[index].onValueChanged();
        if (this.extraPointsLabel != null) {
            this.extraPointsLabel.setText("extra points: " + this.extraPoints);
        }
    }

    public void onAttributesChanged() {
        int numAttributes = PlayerAttribute.attributes.size();
        for (int i = 0; i < numAttributes; ++i) {
            this.onAttributeChanged(i);
        }
    }

    private void doAppendAttributeInfo(PlayerAttribute attribute, StringBuffer text) {
        if (attribute.equals(PlayerAttribute.strength)) {
            HtmlUtil.doBreakIndent(text);
            text.append("melee attack to-hit modifier: ");
            text.append(TextUtil.doFormatModifier(this.player.getToHitModifierForStrength()));
            HtmlUtil.doBreakIndent(text);
            text.append("melee attack damage modifier: ");
            text.append(TextUtil.doFormatModifier(this.player.getDamageModifierForStrength()));
            HtmlUtil.doBreakIndent(text);
            text.append("max encumbrance modifier: ");
            text.append(TextUtil.doFormatModifier(this.player.getMaxEncumbranceModifierForStrength()));
            HtmlUtil.doBreakIndent(text);
            text.append("base movement rate modifier: ");
            text.append(TextUtil.doFormatModifier(this.player.getMaxMovementPointsModifierForStrength()));
        } else if (attribute.equals(PlayerAttribute.intelligence)) {
            HtmlUtil.doBreakIndent(text);
            text.append("magic-user spell-casting success modifier: ");
            text.append(TextUtil.doFormatModifier(this.player.getCastingModifierForIntelligence()));
            HtmlUtil.doBreakIndent(text);
            text.append("magic-points per-casting-level modifier: ");
            text.append(TextUtil.doFormatModifier(this.player.getMagicPointsModifierForIntelligence()));
        } else if (attribute.equals(PlayerAttribute.judgement)) {
            HtmlUtil.doBreakIndent(text);
            text.append("clerical spell-casting success modifier: ");
            text.append(TextUtil.doFormatModifier(this.player.getCastingModifierForJudgement()));
            HtmlUtil.doBreakIndent(text);
            text.append("clerical-points per-casting-level modifier: ");
            text.append(TextUtil.doFormatModifier(this.player.getClericalPointsModifierForJudgement()));
        } else if (attribute.equals(PlayerAttribute.agility)) {
            HtmlUtil.doBreakIndent(text);
            text.append("ranged attack to-hit modifier: ");
            text.append(TextUtil.doFormatModifier(this.player.getRangedAttackToHitModifierForAgility()));
            HtmlUtil.doBreakIndent(text);
            text.append("base movement rate modifier: ");
            text.append(TextUtil.doFormatModifier(this.player.getMaxMovementPointsModifierForAgility()));
            HtmlUtil.doBreakIndent(text);
            text.append("to-hit penalty (regular/offhand) with two weapons: ");
            text.append(this.player.getToHitWithTwoWeaponsModifierForAgility(false));
            text.append("/");
            text.append(this.player.getToHitWithTwoWeaponsModifierForAgility(true));
            HtmlUtil.doBreakIndent(text);
            text.append("defense modifier: ");
            text.append(TextUtil.doFormatModifier(this.player.getDefenseModifierForAgility()));
            HtmlUtil.doBreakIndent(text);
            text.append("avoidance check modifier: ");
            text.append(TextUtil.doFormatModifier(this.player.getAvoidanceModifierForAgility()));
        } else if (attribute.equals(PlayerAttribute.endurance)) {
            HtmlUtil.doBreakIndent(text);
            text.append("hit points per level modifier: ");
            text.append(TextUtil.doFormatModifier(this.player.getHitPointsModifierForEndurance()));
            HtmlUtil.doBreakIndent(text);
            text.append("max encumbrance modifier: ");
            text.append(TextUtil.doFormatModifier(this.player.getMaxEncumbranceModifierForEndurance()));
            HtmlUtil.doBreakIndent(text);
            text.append("magic-points per-casting-level modifier: ");
            text.append(TextUtil.doFormatModifier(this.player.getMagicPointsModifierForEndurance()));
            HtmlUtil.doBreakIndent(text);
            text.append("clerical-points per-casting-level modifier: ");
            text.append(TextUtil.doFormatModifier(this.player.getClericalPointsModifierForEndurance()));
        }
    }

    static /* synthetic */ int access$208(PlayerAttributesDisplay x0) {
        return x0.extraPoints++;
    }

    static /* synthetic */ int access$200(PlayerAttributesDisplay x0) {
        return x0.extraPoints;
    }

    static /* synthetic */ int access$210(PlayerAttributesDisplay x0) {
        return x0.extraPoints--;
    }

    private class AttributePanel
    extends JPanel {
        private int attributeIndex;
        private Label nameLabel;
        private Label valueLabel;

        public AttributePanel(int attributeIndex, boolean showModifyButtons) {
            this.attributeIndex = attributeIndex;
            this.setBackground(Color.black);
            this.setBorder(new EmptyBorder(0, 1, 0, 1));
            this.setLayout(new BoxLayout(this, 0));
            PlayerAttribute attribute = PlayerAttribute.getAttribute(attributeIndex);
            Label label = this.nameLabel = new Label(attribute.getName(), Fonts.small);
            label.setHorizontalAlignment(2);
            this.add(label);
            this.add(Box.createHorizontalGlue());
            this.add(Box.createRigidArea(new Dimension(20, 0)));
            label = this.valueLabel = new Label("--", Fonts.small);
            label.setHorizontalAlignment(4);
            this.add(label);
            if (showModifyButtons) {
                this.add(Box.createRigidArea(new Dimension(5, 0)));
                Button button = new Button(" - ");
                this.add(button);
                button.addActionListener(new ActionListener(this, attribute, attributeIndex){
                    private final /* synthetic */ PlayerAttribute val$attribute;
                    private final /* synthetic */ int val$attributeIndex;
                    private final /* synthetic */ AttributePanel this$1;
                    {
                        this.this$1 = this$1;
                        this.val$attribute = val$attribute;
                        this.val$attributeIndex = val$attributeIndex;
                    }

                    public void actionPerformed(ActionEvent e) {
                        if (PlayerAttributesDisplay.access$100(AttributePanel.access$000(this.this$1)).getBaseAttributes().get(this.val$attribute) <= 1) {
                            return;
                        }
                        PlayerAttributesDisplay.access$100(AttributePanel.access$000(this.this$1)).getBaseAttributes().doAdd(this.val$attributeIndex, -1);
                        PlayerAttributesDisplay.access$208(AttributePanel.access$000(this.this$1));
                        AttributePanel.access$000(this.this$1).onAttributeChanged(this.val$attributeIndex);
                    }
                });
                button = new Button(" + ");
                this.add(button);
                button.addActionListener(new ActionListener(this, attribute, PlayerAttributesDisplay.this, attributeIndex){
                    private final /* synthetic */ PlayerAttribute val$attribute;
                    private final /* synthetic */ PlayerAttributesDisplay val$this$0;
                    private final /* synthetic */ int val$attributeIndex;
                    private final /* synthetic */ AttributePanel this$1;
                    {
                        this.this$1 = this$1;
                        this.val$attribute = val$attribute;
                        this.val$this$0 = val$this$0;
                        this.val$attributeIndex = val$attributeIndex;
                    }

                    public void actionPerformed(ActionEvent e) {
                        if (PlayerAttributesDisplay.access$100(AttributePanel.access$000(this.this$1)).getBaseAttributes().get(this.val$attribute) >= 15) {
                            MessageDialog.doShow(ComponentUtil.getParentFrame(AttributePanel.access$000(this.this$1)), "Starting scores above 15 are not allowed.");
                            return;
                        }
                        if (PlayerAttributesDisplay.access$200(AttributePanel.access$000(this.this$1)) <= 0) {
                            MessageDialog.doShow(ComponentUtil.getParentFrame(AttributePanel.access$000(this.this$1)), "You must first subtract from another attribute.");
                            return;
                        }
                        PlayerAttributesDisplay.access$100(AttributePanel.access$000(this.this$1)).getBaseAttributes().doAdd(this.val$attributeIndex, 1);
                        PlayerAttributesDisplay.access$210(AttributePanel.access$000(this.this$1));
                        AttributePanel.access$000(this.this$1).onAttributeChanged(this.val$attributeIndex);
                    }
                });
            }
            this.onValueChanged();
        }

        public void onValueChanged() {
            this.valueLabel.setText("" + PlayerAttributesDisplay.this.player.getAttributes().get(this.attributeIndex));
            String info = this.getAttributeInfo();
            this.nameLabel.getHasTooltipImpl().setTooltipText(info, 0);
            this.valueLabel.getHasTooltipImpl().setTooltipText(info, 0);
        }

        private String getAttributeInfo() {
            StringBuffer text = new StringBuffer();
            text.append("<i>");
            PlayerAttribute attribute = PlayerAttribute.getAttribute(this.attributeIndex);
            text.append(attribute.getName());
            text.append(":</i> ");
            text.append("<b>");
            text.append(PlayerAttributesDisplay.this.player.getAttributes().get(this.attributeIndex));
            text.append("</b>");
            PlayerAttributesDisplay.this.doAppendAttributeInfo(attribute, text);
            return text.toString();
        }

        static /* synthetic */ PlayerAttributesDisplay access$000(AttributePanel x0) {
            return x0.PlayerAttributesDisplay.this;
        }
    }
}

