/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import java.awt.Dimension;
import silmar.entities.beings.MovementType;
import silmar.entities.beings.player.Player;
import silmar.entities.beings.player.PlayerPower;
import silmar.map.Map;
import silmar.map.MapPixelLocation;

public abstract class LocationSelection {
    public abstract void onSelection(MapPixelLocation var1, Player var2);

    public boolean isNearbyOnly() {
        return false;
    }

    public static class HurlFireball
    extends LocationSelection {
        public void onSelection(MapPixelLocation location, Player player) {
            player.doUsePower(PlayerPower.hurlFireball, location);
        }
    }

    public static class FreezeBeing
    extends LocationSelection {
        public void onSelection(MapPixelLocation location, Player player) {
            player.doUsePower(PlayerPower.freezeBeing, location);
        }
    }

    public static class ThrowBoulder
    extends LocationSelection {
        public void onSelection(MapPixelLocation location, Player player) {
            player.doUsePower(PlayerPower.throwBoulder, location);
        }
    }

    public static class PlaceVengefulSymbol
    extends LocationSelection {
        public void onSelection(MapPixelLocation location, Player player) {
            player.doUsePower(PlayerPower.placeVengefulSymbol, location);
        }

        public boolean isNearbyOnly() {
            return true;
        }
    }

    public static class ConjureDeathFog
    extends LocationSelection {
        public void onSelection(MapPixelLocation location, Player player) {
            player.doUsePower(PlayerPower.conjureDeathFog, location);
        }
    }

    public static class EmitLightning
    extends LocationSelection {
        public void onSelection(MapPixelLocation location, Player player) {
            player.doUsePower(PlayerPower.emitLightning, location);
        }
    }

    public static class Leap
    extends LocationSelection {
        public void onSelection(MapPixelLocation location, Player player) {
            Map map = player.getMap();
            Dimension playerSize = player.getSize();
            if (!map.isRectanglePassible((MapPixelLocation)location, (Dimension)playerSize, (MovementType)MovementType.walking, (boolean)true, null, null, (boolean)false).passible) {
                player.onMessage("You cannot leap there.");
                return;
            }
            player.doUsePower(PlayerPower.leap, location);
        }
    }

    public static class FireEyeBeams
    extends LocationSelection {
        public void onSelection(MapPixelLocation location, Player player) {
            player.doUsePower(PlayerPower.fireEyeBeams, location);
        }
    }

    public static class RangedAttack
    extends LocationSelection {
        public void onSelection(MapPixelLocation location, Player player) {
            player.doAttack(location);
        }
    }

    public static class MeleeAttack
    extends LocationSelection {
        public void onSelection(MapPixelLocation location, Player player) {
            player.doAttack(location);
        }

        public boolean isNearbyOnly() {
            return true;
        }
    }
}

