/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import silmar.client.gui.ItemDisplay;
import silmar.entities.items.Item;
import silmar.events.Event;
import silmar.events.Listener;
import silmar.events.Reporter;
import silmar.tiles.TileSize;

public class ItemsDisplay
extends JPanel
implements Listener {
    private List itemDisplays = new ArrayList();
    private Dimension defaultItemSize = TileSize.tileSize;
    private Reporter reporter = new Reporter();

    public ItemsDisplay() {
        this.setBackground(Color.black);
        this.setLayout(null);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ItemsDisplay.this.doDetmPreferredHeight();
                ItemsDisplay.this.doLayoutItemDisplays();
            }
        });
    }

    public void setItems(List items) {
        this.removeAll();
        this.itemDisplays.clear();
        int numItems = items.size();
        for (int i = 0; i < numItems; ++i) {
            Item item = (Item)items.get(i);
            ItemDisplay display = new ItemDisplay();
            display.setItem(item);
            this.itemDisplays.add(display);
            this.add(display);
            display.doAddListener(this);
        }
        this.doDetmPreferredHeight();
        this.doLayoutItemDisplays();
        this.repaint();
    }

    public void doAddListener(Listener listener) {
        this.reporter.doAddListener(listener);
    }

    private void doDetmPreferredHeight() {
        int width = this.getWidth();
        int numItemsAcross = Math.max(1, width / this.defaultItemSize.width);
        int numRows = this.itemDisplays != null ? (int)Math.ceil((float)this.itemDisplays.size() / (float)numItemsAcross) : 1;
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, numRows * this.defaultItemSize.height));
    }

    private void doLayoutItemDisplays() {
        int width = this.getWidth();
        int numItemsAcross = Math.max(1, width / this.defaultItemSize.width);
        int leftx = (width - numItemsAcross * this.defaultItemSize.width) / 2;
        int numItemDisplays = this.itemDisplays.size();
        for (int i = 0; i < numItemDisplays; ++i) {
            ItemDisplay display = (ItemDisplay)this.itemDisplays.get(i);
            display.setBounds(leftx + this.defaultItemSize.width * (i % numItemsAcross), this.defaultItemSize.height * (i / numItemsAcross), this.defaultItemSize.width, this.defaultItemSize.height);
        }
        this.revalidate();
    }

    public void onEvent(Event event) {
        this.reporter.doReport(event);
    }

    public int getPreferredViewableHeight() {
        return 2 * this.defaultItemSize.height;
    }

    public void doUpdateItems() {
        int numItemDisplays = this.itemDisplays.size();
        for (int i = 0; i < numItemDisplays; ++i) {
            ItemDisplay itemDisplay = (ItemDisplay)this.itemDisplays.get(i);
            itemDisplay.repaint();
        }
    }
}

