/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import silmar.client.gui.ItemDisplay;
import silmar.entities.beings.player.Player;
import silmar.entities.items.EquipLocation;

public final class HandsItemsDisplay
extends JPanel {
    private Player player;
    private ItemDisplay leftDisplay;
    private ItemDisplay rightDisplay;

    public HandsItemsDisplay(Player player) {
        this.player = player;
        this.setBackground(Color.black);
        this.setLayout(new BoxLayout(this, 0));
        this.leftDisplay = new ItemDisplay();
        this.leftDisplay.setBorder(new LineBorder(Color.white, 1));
        this.add(this.leftDisplay);
        this.add(Box.createRigidArea(new Dimension(1, 0)));
        this.rightDisplay = new ItemDisplay();
        this.rightDisplay.setBorder(new LineBorder(Color.white, 1));
        this.add(this.rightDisplay);
    }

    public void onItemsChanged() {
        this.leftDisplay.setItem(this.player.getEquippedItems().get(EquipLocation.leftHand));
        this.rightDisplay.setItem(this.player.getEquippedItems().get(EquipLocation.rightHand));
        this.repaint();
    }

    public void doUpdateItems() {
        this.leftDisplay.repaint();
        this.rightDisplay.repaint();
    }
}

