/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import silmar.client.gui.HandsConfigsDisplay;
import silmar.entities.beings.player.Player;
import silmar.events.Event;
import silmar.events.Listener;
import silmar.gui.Fonts;
import silmar.gui.widgets.Label;
import silmar.util.WindowUtil;

public final class HandsConfigDialog
extends JDialog {
    private HandsConfigsDisplay handsConfigsDisplay;
    private boolean inSetMode;
    private Label headingLabel;

    public HandsConfigDialog(Frame parent, final Player player) {
        super(parent);
        this.setSize(100, 275);
        WindowUtil.doCenterWindow(this);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.setBackground(Color.black);
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.setLayout(new BoxLayout(panel, 1));
        pane.add((Component)panel, "Center");
        Label label = this.headingLabel = new Label("<html><p style='color:white;text-align:center'> <br> ", Fonts.medium);
        panel.add(label);
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        HandsConfigsDisplay display = this.handsConfigsDisplay = new HandsConfigsDisplay(player);
        panel.add(display);
        display.doAddListener(new Listener(){

            public void onEvent(Event event) {
                if (event.isOfType(HandsConfigsDisplay.ConfigSelected.configSelected)) {
                    int index = ((HandsConfigsDisplay.ConfigSelected)event).configIndex;
                    if (!HandsConfigDialog.this.inSetMode) {
                        player.doUseHandsConfig(index);
                    } else {
                        player.setHandsConfig(index);
                    }
                    HandsConfigDialog.this.setVisible(false);
                }
            }
        });
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        label = new Label("mouseover for info,", Fonts.small);
        panel.add(label);
        label = new Label("click to select", Fonts.small);
        panel.add(label);
    }

    public HandsConfigsDisplay getHandsConfigsDisplay() {
        return this.handsConfigsDisplay;
    }

    public void doShow(boolean inSetMode) {
        this.inSetMode = inSetMode;
        this.headingLabel.setText("<html><p style='color:white;text-align:center'>" + (inSetMode ? "Set " : "Use ") + "Hands<br>Configuration");
        this.setVisible(true);
    }
}

