/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import silmar.entities.beings.player.Player;
import silmar.entities.beings.player.PlayerClass;
import silmar.entities.beings.player.PlayerLevel;
import silmar.gui.Fonts;
import silmar.gui.widgets.Button;
import silmar.gui.widgets.Label;
import silmar.gui.widgets.TextArea;
import silmar.util.WindowUtil;

public final class GainLevelDialog
extends JDialog {
    public GainLevelDialog(JFrame owner, final Player player) {
        super(owner);
        JPanel panel;
        Container pane = this.getContentPane();
        pane.setBackground(owner.getContentPane().getBackground());
        this.setTitle("Gain Level");
        this.setModal(true);
        this.setSize(300, 320);
        this.setResizable(false);
        pane.setLayout(new BorderLayout());
        WindowUtil.doCenterWindow(this);
        this.setDefaultCloseOperation(0);
        JPanel mainPanel = panel = new JPanel();
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(mainPanel, 1));
        pane.add((Component)panel, "Center");
        TextArea area = new TextArea("You have earned enough experience to advance a level!  You must choose which level you wish to gain from the following choices:");
        area.setFont(Fonts.medium);
        area.setRows(4);
        area.setBorder(new EmptyBorder(5, 5, 5, 5));
        mainPanel.add(area);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel choicesPanel = panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        mainPanel.add(panel);
        mainPanel.add(Box.createVerticalGlue());
        JPanel headingsPanel = panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 0));
        choicesPanel.add(panel);
        panel.add(Box.createRigidArea(new Dimension(50, 0)));
        Label label = new Label("Class", Fonts.medium);
        Font font = new Font("sans-serif", 1, 15);
        label.setFont(font);
        label.setAlignmentX(0.0f);
        headingsPanel.add(label);
        panel.add(Box.createHorizontalGlue());
        label = new Label("Next Level", Fonts.medium);
        label.setFont(font);
        label.setAlignmentX(1.0f);
        headingsPanel.add(label);
        panel.add(Box.createRigidArea(new Dimension(50, 0)));
        Font buttonFont = new Font("sans-serif", 1, 13);
        int numClasses = PlayerClass.classes.size();
        for (int i = 0; i < numClasses; ++i) {
            PlayerClass playerClass = (PlayerClass)PlayerClass.classes.get(i);
            choicesPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            panel = new JPanel();
            panel.setOpaque(false);
            panel.setLayout(new BoxLayout(panel, 0));
            choicesPanel.add(panel);
            panel.add(Box.createRigidArea(new Dimension(50, 0)));
            label = new Label(playerClass.getName(), Fonts.medium);
            label.setAlignmentX(0.0f);
            panel.add(label);
            panel.add(Box.createHorizontalGlue());
            final PlayerLevel next = player.getNextEarnableLevel(playerClass);
            if (next == null) {
                label = new Label("None Left!", Fonts.medium);
                label.setAlignmentX(1.0f);
                panel.add(label);
            } else {
                Button button = new Button(" " + next.getName() + " ");
                button.setFont(buttonFont);
                button.setAlignmentX(1.0f);
                panel.add(button);
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        player.onPlayerLevelChosen(next);
                        GainLevelDialog.this.setVisible(false);
                    }
                });
            }
            panel.add(Box.createRigidArea(new Dimension(50, 0)));
        }
    }
}

