/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import silmar.client.gui.ItemDisplay;
import silmar.entities.beings.player.Player;
import silmar.entities.items.EquipLocation;
import silmar.entities.items.Item;
import silmar.events.Event;
import silmar.events.Listener;
import silmar.events.Reporter;
import silmar.gui.Fonts;
import silmar.gui.widgets.Label;
import silmar.tiles.TileSize;

public class EquippedItemsDisplay
extends JPanel
implements Listener {
    private Player player;
    private ItemDisplay[] displays = new ItemDisplay[EquipLocation.locations.size()];
    private JLabel[] labels = new JLabel[this.displays.length];
    private Reporter reporter = new Reporter();
    private Dimension itemSize = TileSize.tileSize;

    public EquippedItemsDisplay(Player player) {
        this.player = player;
        this.setLayout(null);
        this.setBackground(Color.black);
        this.setOpaque(true);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                EquippedItemsDisplay.this.doLayoutDisplays();
            }
        });
        for (int i = 0; i < this.displays.length; ++i) {
            ItemDisplay display;
            this.displays[i] = display = new ItemDisplay();
            display.setBorder(new LineBorder(Color.white, 1));
            this.add(display);
            display.doAddListener(this);
            Label label = new Label(EquipLocation.getLocation(i).getName(), Fonts.small);
            this.labels[i] = label;
            this.add(label);
        }
        this.onEquippedItemsChanged();
    }

    private void doLayoutDisplays() {
        int headY = 0;
        int neckY = 0;
        int ringY = 0;
        int handY = 0;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int fontAscent = fontMetrics.getAscent();
        int width = this.getWidth();
        int height = this.getHeight();
        int minYBetweenDisplays = this.itemSize.height + fontAscent + 2;
        for (int i = 0; i < this.displays.length; ++i) {
            ItemDisplay display = this.displays[i];
            int x1 = width / 10 + 4;
            int x2 = width / 2;
            int x3 = 9 * width / 10 - 4;
            int x = 0;
            int y = 0;
            if (i == EquipLocation.head.getIndex()) {
                x = x2;
                y = headY = Math.max(height / 12, fontAscent + 2 + this.itemSize.height / 2);
            } else if (i == EquipLocation.neck.getIndex()) {
                x = x2;
                y = neckY = headY + minYBetweenDisplays;
            } else if (i == EquipLocation.body.getIndex()) {
                x = x2;
                y = Math.max(height / 2, neckY + minYBetweenDisplays);
            } else if (i == EquipLocation.feet.getIndex()) {
                x = x2;
                y = Math.min(11 * height / 12, height - 2 - this.itemSize.height / 2);
            } else if (i == EquipLocation.back.getIndex()) {
                x = 3 * width / 10 + 2;
                y = height / 3;
            } else if (i == EquipLocation.leftRing.getIndex()) {
                x = x1;
                y = ringY = 5 * height / 12;
            } else if (i == EquipLocation.leftHand.getIndex()) {
                x = x1;
                y = handY = ringY + minYBetweenDisplays;
            } else if (i == EquipLocation.rightRing.getIndex()) {
                x = x3;
                y = ringY;
            } else if (i == EquipLocation.rightHand.getIndex()) {
                x = x3;
                y = handY;
            }
            display.setBounds(x - this.itemSize.width / 2, y - this.itemSize.height / 2, this.itemSize.width, this.itemSize.height);
            JLabel label = this.labels[i];
            int textWidth = fontMetrics.stringWidth(label.getText());
            label.setBounds(x - textWidth / 2, y - this.itemSize.height / 2 - fontAscent - 2, textWidth, fontMetrics.getHeight());
        }
    }

    public void doAddListener(Listener listener) {
        this.reporter.doAddListener(listener);
    }

    public void onEquippedItemsChanged() {
        Player.EquippedItems equippedItems = this.player.getEquippedItems();
        for (int i = 0; i < this.displays.length; ++i) {
            Item item = equippedItems.get(i);
            this.displays[i].setItem(item);
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, Math.max(super.getPreferredSize().height, 6 * this.itemSize.height));
    }

    public void onEvent(Event event) {
        this.reporter.doReport(event);
    }

    public void doUpdateItems() {
        for (int i = 0; i < this.displays.length; ++i) {
            this.displays[i].repaint();
        }
    }
}

