/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import silmar.client.gui.EquippedItemsDisplay;
import silmar.client.gui.ItemsDisplay;
import silmar.entities.beings.player.Player;
import silmar.gui.Fonts;
import silmar.gui.widgets.TextArea;
import silmar.util.WindowUtil;

public class EquippedItemsAndInventoryDialog
extends JDialog {
    protected Player player;
    private EquippedItemsDisplay equippedItemsDisplay;
    private ItemsDisplay inventoryDisplay;

    public EquippedItemsAndInventoryDialog(Frame parent, String title, Player player, String greeting) {
        super(parent, title);
        this.player = player;
        this.setSize(300, 410);
        WindowUtil.doCenterWindow(this);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.setBackground(Color.black);
        JPanel mainPanel = new JPanel();
        mainPanel.setOpaque(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        pane.add((Component)mainPanel, "Center");
        if (greeting != null) {
            TextArea area = new TextArea(greeting);
            area.setFont(Fonts.medium);
            area.setRows(4);
            area.setBorder(new EmptyBorder(5, 5, 5, 5));
            mainPanel.add(area);
        }
        this.doAddDisplaysBeforeEquippedItemsDisplay(mainPanel);
        JPanel equippedPanel = new JPanel();
        equippedPanel.setOpaque(false);
        equippedPanel.setAlignmentX(0.5f);
        equippedPanel.setBorder(new MatteBorder(0, 0, 5, 0, Color.lightGray));
        equippedPanel.setLayout(new BoxLayout(equippedPanel, 1));
        mainPanel.add(equippedPanel);
        EquippedItemsDisplay panel = this.equippedItemsDisplay = new EquippedItemsDisplay(player);
        equippedPanel.add(panel);
        this.doAddEquippedItemsHelpText(equippedPanel);
        equippedPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel inventoryPanel = new JPanel();
        inventoryPanel.setOpaque(false);
        inventoryPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        inventoryPanel.setLayout(new BoxLayout(inventoryPanel, 1));
        mainPanel.add(inventoryPanel);
        this.inventoryDisplay = new ItemsDisplay();
        JScrollPane scrollPane = new JScrollPane(this.inventoryDisplay);
        scrollPane.setBorder(new LineBorder(Color.white, 1));
        scrollPane.setOpaque(false);
        scrollPane.setHorizontalScrollBarPolicy(31);
        inventoryPanel.add(scrollPane);
        this.inventoryDisplay.setItems(player.getInventory().getItems());
        scrollPane.setPreferredSize(new Dimension(this.getPreferredSize().width, this.inventoryDisplay.getPreferredViewableHeight()));
        this.doAddInventoryHelpText(inventoryPanel);
    }

    protected void doAddDisplaysBeforeEquippedItemsDisplay(JPanel panel) {
    }

    protected void doAddEquippedItemsHelpText(JPanel panel) {
    }

    protected void doAddInventoryHelpText(JPanel panel) {
    }

    public EquippedItemsDisplay getEquippedItemsDisplay() {
        return this.equippedItemsDisplay;
    }

    public ItemsDisplay getInventoryDisplay() {
        return this.inventoryDisplay;
    }
}

