/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import silmar.client.gui.EquippedItemsAndInventoryDialog;
import silmar.client.gui.ItemDisplay;
import silmar.client.gui.ItemDisplayListener;
import silmar.client.gui.ItemsDisplay;
import silmar.entities.beings.player.Player;
import silmar.entities.items.ItemValueContext;
import silmar.entities.talkers.ItemSeller;
import silmar.util.WindowUtil;

public final class BuyDialog
extends EquippedItemsAndInventoryDialog {
    private ItemsDisplay saleItemsDisplay;
    private ItemSeller seller;
    private ItemDisplayListener saleItemsDisplayListener;

    public BuyDialog(JFrame owner, Player player, ItemSeller seller) {
        super((Frame)owner, "Buy items", player, seller.getGreeting());
        this.seller = seller;
        this.saleItemsDisplayListener.setSeller(seller);
        this.setModal(true);
        this.setSize(400, 500);
        WindowUtil.doCenterWindow(this);
        this.saleItemsDisplay.setItems(Arrays.asList(seller.getItemsForSale()));
    }

    protected void doAddDisplaysBeforeEquippedItemsDisplay(JPanel panel) {
        ItemsDisplay display = this.saleItemsDisplay = new ItemsDisplay();
        JScrollPane scrollPane = new JScrollPane(display);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder(new EtchedBorder(Color.white, Color.lightGray));
        panel.add(scrollPane);
        ItemDisplayListener listener = this.saleItemsDisplayListener = new ItemDisplayListener(ItemValueContext.buy){

            protected void onItemClickedAndValidated(ItemDisplay.ItemClicked event) {
                BuyDialog.this.player.doBuyItem(event.item, BuyDialog.this.seller.getAdjustedItemPrice(event.item, event.item.getValue(ItemValueContext.buy)));
            }
        };
        display.doAddListener(listener);
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
    }
}

