/*
 * Decompiled with CFR 0.152.
 */
package silmar.client;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import silmar.entities.LightSource;
import silmar.entities.MapEntity;
import silmar.entities.beings.Being;
import silmar.entities.damage.DamageStatus;
import silmar.gui.Fonts;
import silmar.map.Map;
import silmar.map.MapPixelLocation;
import silmar.map.MapTileLocation;
import silmar.map.events.MapEvents;
import silmar.tiles.Tile;
import silmar.tiles.TileSize;
import silmar.tiles.TileSizeUtil;
import silmar.util.FloatPoint;
import silmar.util.GuiUtil;
import silmar.util.ImageUtil;
import silmar.util.PointUtil;
import silmar.util.ThreadUtil;

public final class MapView
extends JPanel
implements TileSize {
    private MessageDrawer messageDrawer;
    private LOSDeterminer losDeterminer = new LOSDeterminer();
    private LitDeterminer litDeterminer = new LitDeterminer();
    private Viewpoint viewpoint = new Viewpoint();
    private ViewpointShift viewpointShift = new ViewpointShift();
    private ShiftedViewpoint shiftedViewpoint = new ShiftedViewpoint();
    private Cursor cursor;
    private Cursors cursors = new Cursors();
    private MapEntity viewpointEntity;
    private List drawOnTopEntities = new ArrayList();
    private boolean viewOn = false;
    private boolean groupOfChangesOccurring = false;
    private Map map;
    private VolatileImage offscreen;
    private boolean useLOSBlocking = true;
    private boolean paintWaitedFor = false;
    private MapTileLocation doDrawView_viewTileLocation = new MapTileLocation();
    private Dimension doDrawView_viewTileSize = new Dimension();
    private MapTileLocation doDrawView_startTileLocation = new MapTileLocation();
    private MapTileLocation doDrawView_endTileLocation = new MapTileLocation();
    private MapPixelLocation doDrawView_startLocation = new MapPixelLocation();
    private MapTileLocation doDrawView_tileLocation = new MapTileLocation();
    private List doDetmIfLightSourcesChanged_lightSourceLocations = new ArrayList();
    private MapTileLocation doDetmIfLightSourcesChanged_tileLocation = new MapTileLocation();

    public MapView() {
        this.setBackground(Color.black);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent event) {
                MapView.this.onResized();
            }
        });
        new Shifter();
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public void addNotify() {
        super.addNotify();
        this.messageDrawer = new MessageDrawer();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.offscreen != null && this.viewOn) {
            do {
                GraphicsConfiguration gc;
                int valCode;
                if ((valCode = this.offscreen.validate(gc = this.getGraphicsConfiguration())) == 2) {
                    this.doCreateOffscreenImage();
                }
                this.doDrawView();
                g.drawImage(this.offscreen, 0, 0, null);
                this.messageDrawer.doDrawMessages(g);
            } while (this.offscreen.contentsLost());
        } else {
            super.paint(g);
        }
        this.paintWaitedFor = false;
    }

    private void doWaitForPaint() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.repaint();
            System.out.println("doWaitForPaint called on event thread");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (!SwingUtilities.getWindowAncestor(this).isVisible()) {
            return;
        }
        this.paintWaitedFor = true;
        this.repaint();
        boolean sleepInterval = true;
        for (int timeSlept = 0; this.paintWaitedFor && timeSlept < 1000; ++timeSlept) {
            ThreadUtil.doSleep(1L);
        }
    }

    private void onResized() {
        this.doCreateOffscreenImage();
        this.losDeterminer.onResized();
        this.litDeterminer.onResized();
        this.repaint();
    }

    private void doCreateOffscreenImage() {
        this.offscreen = this.getGraphicsConfiguration().createCompatibleVolatileImage(Math.max(this.getWidth(), 1), Math.max(this.getHeight(), 1));
    }

    public MapPixelLocation getMapLocationAtPoint(Point point) {
        return new MapPixelLocation(this.shiftedViewpoint.get().x + (point.x - this.getWidth() / 2), this.shiftedViewpoint.get().y + (point.y - this.getHeight() / 2));
    }

    public void doHomeViewpoint() {
        this.viewpointShift.set(0, 0);
        this.repaint();
    }

    public void doDisplayMessage(String message) {
        this.doDisplayMessage(message, null);
    }

    public void doDisplayMessage(String messageText, MapPixelLocation location) {
        this.doDisplayMessage(messageText, location, 0);
    }

    public void doDisplayMessage(String messageText, MapPixelLocation location, int duration) {
        Message message = new Message();
        message.text = messageText;
        message.duration = duration != 0 ? duration : 1000 + Math.max(0, messageText.length() - 20) * 100;
        message.location = location != null ? location : this.viewpointEntity.getLocation();
        this.messageDrawer.doDrawMessage(message);
        this.repaint();
    }

    public void setViewOn(boolean viewOn) {
        this.viewOn = viewOn;
        this.repaint();
    }

    private Dimension getViewTileSize() {
        return this.getViewTileSize(new Dimension());
    }

    private Dimension getViewTileSize(Dimension use) {
        Dimension size = this.getSize();
        use.setSize((int)Math.ceil((float)size.width / (float)TileSize.tileSize.width) + 2, (int)Math.ceil((float)size.height / (float)TileSize.tileSize.height) + 2);
        return use;
    }

    private void doDrawView() {
        int y;
        int j;
        Graphics g = this.offscreen.getGraphics();
        MapTileLocation viewTileLocation = this.doDrawView_viewTileLocation;
        viewTileLocation.setLocation(this.shiftedViewpoint.get().x / TileSize.tileSize.width, this.shiftedViewpoint.get().y / TileSize.tileSize.height);
        Dimension size = this.getSize();
        Dimension viewTileSize = this.getViewTileSize(this.doDrawView_viewTileSize);
        MapTileLocation startTileLocation = this.doDrawView_startTileLocation;
        startTileLocation.setLocation(viewTileLocation.x - viewTileSize.width / 2, viewTileLocation.y - viewTileSize.height / 2);
        MapTileLocation endTileLocation = this.doDrawView_endTileLocation;
        endTileLocation.setLocation(viewTileLocation.x + viewTileSize.width / 2, viewTileLocation.y + viewTileSize.height / 2);
        MapPixelLocation startLocation = this.doDrawView_startLocation;
        startLocation.setLocation(size.width / 2 - (this.shiftedViewpoint.get().x - startTileLocation.x * TileSize.tileSize.width), size.height / 2 - (this.shiftedViewpoint.get().y - startTileLocation.y * TileSize.tileSize.height));
        this.losDeterminer.getUpperLeftTileLocation().set(startTileLocation);
        this.litDeterminer.getUpperLeftTileLocation().set(startTileLocation);
        this.doDetmIfLightSourcesChanged();
        MapTileLocation tileLocation = this.doDrawView_tileLocation;
        int i = startTileLocation.x;
        int x = startLocation.x;
        while (i <= endTileLocation.x) {
            j = startTileLocation.y;
            y = startLocation.y;
            while (j <= endTileLocation.y) {
                tileLocation.move(i, j);
                if (this.losDeterminer.getLOSStatus(tileLocation) != LOSStatus.blocked && this.litDeterminer.getLitStatus(tileLocation) != LitStatus.unlit) {
                    Tile tile = this.map.getTile(tileLocation);
                    Image tileImage = this.map.getMotif().getTileImages()[tile.getIndex()];
                    g.drawImage(tileImage, x, y, null);
                }
                ++j;
                y += TileSize.tileSize.height;
            }
            ++i;
            x += TileSize.tileSize.width;
        }
        this.drawOnTopEntities.clear();
        this.doDrawEntities(this.map.getTerrains(), g, this.drawOnTopEntities);
        this.doDrawEntities(this.map.getItems(), g);
        this.doDrawEntities(this.map.getBeings(), g);
        this.doDrawEntities(this.drawOnTopEntities, g);
        this.doDrawEntities(this.map.getVisualEffects(), g);
        this.messageDrawer.doDrawMessages(g);
        i = startTileLocation.x;
        x = startLocation.x;
        while (i <= endTileLocation.x) {
            j = startTileLocation.y;
            y = startLocation.y;
            while (j <= endTileLocation.y) {
                tileLocation.move(i, j);
                LOSStatus losStatus = this.losDeterminer.getLOSStatus(tileLocation);
                Image image = losStatus.image;
                if (image != null) {
                    g.drawImage(image, x, y, null);
                }
                if (losStatus != LOSStatus.blocked) {
                    LitStatus litStatus = this.litDeterminer.getLitStatus(tileLocation);
                    image = litStatus.image;
                    if (image != null) {
                        g.drawImage(image, x, y, null);
                    }
                }
                ++j;
                y += TileSize.tileSize.height;
            }
            ++i;
            x += TileSize.tileSize.width;
        }
    }

    private void doDrawEntities(List entities, Graphics g) {
        this.doDrawEntities(entities, g, null);
    }

    private void doDrawEntities(List entities, Graphics g, List onTopEntities) {
        for (int i = 0; i < entities.size(); ++i) {
            MapEntity entity = (MapEntity)entities.get(i);
            if (!entity.isVisible()) continue;
            if (onTopEntities != null && entity.getShouldDrawOnTop()) {
                onTopEntities.add(entity);
                continue;
            }
            this.doDrawEntity(entity, g);
        }
    }

    private void doDrawEntity(MapEntity entity, Graphics g) {
        Being being;
        DamageStatus status;
        MapPixelLocation location = entity.getLocation();
        if (!this.getRectangleIntersectsViewArea(entity.getBounds())) {
            return;
        }
        Image image = entity.getImage();
        Dimension size = this.getSize();
        int halfImageWidth = image.getWidth(null) / 2;
        int halfImageHeight = image.getHeight(null) / 2;
        int entityX = size.width / 2 - (this.shiftedViewpoint.get().x - location.x);
        int entityY = size.height / 2 - (this.shiftedViewpoint.get().y - location.y);
        g.drawImage(image, entityX - halfImageWidth, entityY - halfImageHeight, null);
        if (entity.isBeing() && !(status = (being = (Being)entity).getDamageStatus()).equals(DamageStatus.undamaged) && being.isVisible()) {
            image = status.getMarkerImage();
            halfImageWidth = image.getWidth(null) / 2;
            halfImageHeight = image.getHeight(null) / 2;
            g.drawImage(image, entityX - halfImageWidth, entityY - halfImageHeight, null);
        }
    }

    private boolean getRectangleIntersectsViewArea(Rectangle rectangle) {
        Point viewpoint = this.shiftedViewpoint.get();
        int halfViewWidth = this.getWidth() / 2;
        int halfViewHeight = this.getHeight() / 2;
        return rectangle.x + rectangle.width >= viewpoint.x - halfViewWidth && rectangle.y + rectangle.height >= viewpoint.y - halfViewHeight && rectangle.x < viewpoint.x + halfViewWidth && rectangle.y < viewpoint.y + halfViewHeight;
    }

    public void onEntityPresenceChange(MapEvents.EntityPresenceChange event) {
        MapEntity entity = event.entity;
        if (entity == this.viewpointEntity) {
            this.viewpoint.set(entity.getLocation());
            return;
        }
        if (this.groupOfChangesOccurring) {
            return;
        }
        if (this.getRectangleIntersectsViewArea(entity.getBounds())) {
            if (this.map.getCanSeeAnyPartOfRectangle(this.viewpoint.get(), entity.getLocation(), entity.getSize())) {
                this.doWaitForPaint();
            } else {
                this.repaint(10L);
            }
        }
    }

    public void setViewpointEntity(MapEntity viewpointEntity) {
        this.viewpointEntity = viewpointEntity;
        this.viewpoint.set(viewpointEntity.getLocation());
    }

    public void onTileChange() {
        this.losDeterminer.doDetmStatuses();
        this.litDeterminer.doDetmStatuses();
        this.repaint(50L);
    }

    public boolean isViewpointShifted() {
        Point shift = this.viewpointShift.get();
        return shift.x != 0 || shift.y != 0;
    }

    public void doUseCursor(Cursor cursor) {
        this.cursor = cursor;
        this.setCursor(cursor);
    }

    public void doUseNormalCursor() {
        this.cursor = null;
        this.setCursor(Cursor.getDefaultCursor());
    }

    public Point getViewLocationOfMapLocation(Point mapLocation) {
        Point viewLocation = new Point();
        this.getViewLocationOfMapLocation(mapLocation, viewLocation);
        return viewLocation;
    }

    public Point getViewLocationOfMapLocation(Point mapLocation, Point use) {
        use.move(this.getWidth() / 2 - (this.viewpoint.get().x + this.viewpointShift.get().x - mapLocation.x), this.getHeight() / 2 - (this.viewpoint.get().y + this.viewpointShift.get().y - mapLocation.y));
        return use;
    }

    public void setUseLOSBlocking(boolean useLOSBlocking) {
        if (this.useLOSBlocking == useLOSBlocking) {
            return;
        }
        this.useLOSBlocking = useLOSBlocking;
        this.repaint();
    }

    public Map getMap() {
        return this.map;
    }

    public void setGroupOfChangesOccurring(boolean groupOfChangesOccurring) {
        if (!groupOfChangesOccurring && this.groupOfChangesOccurring) {
            this.doWaitForPaint();
        }
        this.groupOfChangesOccurring = groupOfChangesOccurring;
    }

    private void doDetmIfLightSourcesChanged() {
        LightSource source;
        int i;
        int numSources;
        boolean changed = false;
        List sources = this.map.getLightSources();
        List sourceLocations = this.doDetmIfLightSourcesChanged_lightSourceLocations;
        if (sourceLocations.size() != sources.size()) {
            changed = true;
        }
        if (!changed) {
            numSources = sources.size();
            for (i = 0; i < numSources; ++i) {
                source = (LightSource)sources.get(i);
                MapTileLocation tileLocation = this.doDetmIfLightSourcesChanged_tileLocation;
                TileSizeUtil.getTileLocation(source.getLocation(), tileLocation);
                MapTileLocation oldLocation = (MapTileLocation)sourceLocations.get(i);
                if (!(oldLocation == null && source.isEmittingLight() || oldLocation != null && !source.isEmittingLight()) && tileLocation.equals(sourceLocations.get(i))) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this.litDeterminer.doDetmStatuses();
            sourceLocations.clear();
            numSources = sources.size();
            for (i = 0; i < numSources; ++i) {
                source = (LightSource)sources.get(i);
                sourceLocations.add(source.isEmittingLight() ? TileSizeUtil.getTileLocation(source.getLocation()) : null);
            }
        }
    }

    private static class LitStatus {
        public Image image;
        public static final LitStatus unlit = new LitStatus("darkness");
        public static final LitStatus unlitUpperLeft = new LitStatus("unlitUpperLeft");
        public static final LitStatus unlitUpperRight = new LitStatus("unlitUpperRight");
        public static final LitStatus unlitLowerLeft = new LitStatus("unlitLowerLeft");
        public static final LitStatus unlitLowerRight = new LitStatus("unlitLowerRight");
        public static final LitStatus halfLit = new LitStatus("halfLit");
        public static final LitStatus halfLitUpperLeft = new LitStatus("halfLitUpperLeft");
        public static final LitStatus halfLitUpperRight = new LitStatus("halfLitUpperRight");
        public static final LitStatus halfLitLowerLeft = new LitStatus("halfLitLowerLeft");
        public static final LitStatus halfLitLowerRight = new LitStatus("halfLitLowerRight");
        public static final LitStatus fullyLit = new LitStatus(null);

        public LitStatus(String imageName) {
            if (imageName != null) {
                this.image = ImageUtil.doLoadImage(imageName);
            }
        }

        public static LitStatus doMap(Map.IsLitResult result) {
            if (result.fullyLit) {
                return fullyLit;
            }
            if (result.halfLit) {
                return halfLit;
            }
            return unlit;
        }
    }

    private final class LitDeterminer {
        private LitStatus[][] litStatuses;
        private UpperLeftTileLocation upperLeftTileLocation = new UpperLeftTileLocation();
        private final MapPixelLocation doDetmStatuses_pixelLocation = new MapPixelLocation();
        private final Map.IsLitResult doDetmStatuses_isLitResult = new Map.IsLitResult();

        private LitDeterminer() {
        }

        public UpperLeftTileLocation getUpperLeftTileLocation() {
            return this.upperLeftTileLocation;
        }

        public void doDetmStatuses() {
            if (MapView.this.map == null) {
                return;
            }
            MapPixelLocation pixelAt = this.doDetmStatuses_pixelLocation;
            Map.IsLitResult isLitResult = this.doDetmStatuses_isLitResult;
            for (int i = 0; i < this.litStatuses.length; ++i) {
                for (int j = 0; j < this.litStatuses[i].length; ++j) {
                    TileSizeUtil.getPixelLocation(this.upperLeftTileLocation.get(), pixelAt);
                    pixelAt.x += i * TileSize.tileSize.width;
                    pixelAt.y += j * TileSize.tileSize.height;
                    LightSource inLosLightSource = MapView.this.viewpointEntity.isLightSource() && ((LightSource)((Object)MapView.this.viewpointEntity)).isEmittingLight() ? (LightSource)((Object)MapView.this.viewpointEntity) : null;
                    this.litStatuses[i][j] = LitStatus.doMap(MapView.this.map.isLit(pixelAt, MapView.this.viewpoint.get(), inLosLightSource, MapView.this.viewpointEntity, isLitResult));
                }
            }
            this.doSmoothCorners();
        }

        public void onResized() {
            Dimension viewTileSize = MapView.this.getViewTileSize();
            this.litStatuses = new LitStatus[viewTileSize.width][viewTileSize.height];
            this.doDetmStatuses();
        }

        public LitStatus getLitStatus(MapTileLocation location) {
            MapTileLocation upperLeft = this.upperLeftTileLocation.get();
            int xIndex = location.x - upperLeft.x;
            int yIndex = location.y - upperLeft.y;
            if (xIndex < 0 || yIndex < 0 || xIndex >= this.litStatuses.length || yIndex >= this.litStatuses[0].length) {
                return LitStatus.unlit;
            }
            return this.litStatuses[xIndex][yIndex];
        }

        private void doSmoothCorners() {
            LitStatus[][] statuses = this.litStatuses;
            LitStatus halfLit = LitStatus.halfLit;
            LitStatus fullyLit = LitStatus.fullyLit;
            LitStatus unlit = LitStatus.unlit;
            for (int i = 0; i < statuses.length; ++i) {
                for (int j = 0; j < statuses[i].length; ++j) {
                    LitStatus status;
                    if (statuses[i][j] == halfLit) {
                        boolean upHalfLit = j == 0 || statuses[i][j - 1] == halfLit;
                        boolean downHalfLit = j == statuses[i].length - 1 || statuses[i][j + 1] == halfLit;
                        boolean leftHalfLit = i == 0 || statuses[i - 1][j] == halfLit;
                        boolean rightHalfLit = i == statuses.length - 1 || statuses[i + 1][j] == halfLit;
                        boolean upFullyLit = j != 0 && statuses[i][j - 1] == fullyLit;
                        boolean downFullyLit = j != statuses[i].length - 1 && statuses[i][j + 1] == fullyLit;
                        boolean leftFullyLit = i != 0 && statuses[i - 1][j] == fullyLit;
                        boolean rightFullyLit = i != statuses.length - 1 && statuses[i + 1][j] == fullyLit;
                        int numHalfLit = 0;
                        if (upHalfLit) {
                            ++numHalfLit;
                        }
                        if (downHalfLit) {
                            ++numHalfLit;
                        }
                        if (leftHalfLit) {
                            ++numHalfLit;
                        }
                        if (rightHalfLit) {
                            ++numHalfLit;
                        }
                        if (numHalfLit != 2) continue;
                        status = null;
                        if (upHalfLit && leftHalfLit && downFullyLit && rightFullyLit) {
                            status = LitStatus.halfLitUpperLeft;
                        } else if (upHalfLit && rightHalfLit && downFullyLit && leftFullyLit) {
                            status = LitStatus.halfLitUpperRight;
                        } else if (downHalfLit && leftHalfLit && upFullyLit && rightFullyLit) {
                            status = LitStatus.halfLitLowerLeft;
                        } else if (downHalfLit && rightHalfLit && upFullyLit && leftFullyLit) {
                            status = LitStatus.halfLitLowerRight;
                        }
                        if (status == null) continue;
                        statuses[i][j] = status;
                        continue;
                    }
                    if (statuses[i][j] != unlit) continue;
                    boolean upUnlit = j == 0 || statuses[i][j - 1] == unlit;
                    boolean downUnlit = j == statuses[i].length - 1 || statuses[i][j + 1] == unlit;
                    boolean leftUnlit = i == 0 || statuses[i - 1][j] == unlit;
                    boolean rightUnlit = i == statuses.length - 1 || statuses[i + 1][j] == unlit;
                    boolean upHalfLit = j != 0 && statuses[i][j - 1] == halfLit;
                    boolean downHalfLit = j != statuses[i].length - 1 && statuses[i][j + 1] == halfLit;
                    boolean leftHalfLit = i != 0 && statuses[i - 1][j] == halfLit;
                    boolean rightHalfLit = i != statuses.length - 1 && statuses[i + 1][j] == halfLit;
                    int numUnlit = 0;
                    if (upUnlit) {
                        ++numUnlit;
                    }
                    if (downUnlit) {
                        ++numUnlit;
                    }
                    if (leftUnlit) {
                        ++numUnlit;
                    }
                    if (rightUnlit) {
                        ++numUnlit;
                    }
                    if (numUnlit != 2) continue;
                    status = null;
                    if (upUnlit && leftUnlit && downHalfLit && rightHalfLit) {
                        status = LitStatus.unlitUpperLeft;
                    } else if (upUnlit && rightUnlit && downHalfLit && leftHalfLit) {
                        status = LitStatus.unlitUpperRight;
                    } else if (downUnlit && leftUnlit && upHalfLit && rightHalfLit) {
                        status = LitStatus.unlitLowerLeft;
                    } else if (downUnlit && rightUnlit && upHalfLit && leftHalfLit) {
                        status = LitStatus.unlitLowerRight;
                    }
                    if (status == null) continue;
                    statuses[i][j] = status;
                }
            }
        }

        private final class UpperLeftTileLocation {
            private MapTileLocation upperLeftTileLocation = new MapTileLocation();

            private UpperLeftTileLocation() {
            }

            public MapTileLocation get() {
                return this.upperLeftTileLocation;
            }

            public void set(MapTileLocation location) {
                if (location.equals(this.upperLeftTileLocation)) {
                    return;
                }
                this.upperLeftTileLocation.setLocation(location);
                LitDeterminer.this.doDetmStatuses();
            }
        }
    }

    protected class Shifter
    extends Thread {
        private boolean shifting = false;
        private Point2D.Float shiftDelta = new Point2D.Float();
        private static final int shiftViewBorderWidth = 32;

        public Shifter() {
            this.start();
            MapView.this.addMouseListener(new MouseListener());
            MapView.this.addMouseMotionListener(new MouseMotionListener());
        }

        public void run() {
            while (true) {
                if (!this.shifting || MapView.this.map == null) {
                    ThreadUtil.doSleep(400L);
                    continue;
                }
                int pixelsPerShift = 8;
                MapView.this.viewpointShift.doAdd((int)(this.shiftDelta.x * 8.0f), (int)(this.shiftDelta.y * 8.0f));
                long startTime = System.currentTimeMillis();
                MapView.this.doWaitForPaint();
                long timeTaken = System.currentTimeMillis() - startTime;
                int minimumShiftStepTime = 20;
                if (timeTaken >= 20L) continue;
                ThreadUtil.doSleep(20L - timeTaken);
            }
        }

        public void doStartShifting(Point2D.Float direction) {
            this.shiftDelta.setLocation(direction);
            this.shifting = true;
            this.interrupt();
        }

        public void doEndShifting() {
            this.shifting = false;
        }

        private boolean isPointInShiftArea(Point point) {
            return point.x < 32 || point.x >= MapView.this.getWidth() - 32 || point.y < 32 || point.y >= MapView.this.getHeight() - 32;
        }

        protected class MouseMotionListener
        extends MouseMotionAdapter {
            protected MouseMotionListener() {
            }

            public void mouseMoved(MouseEvent e) {
                Point point = e.getPoint();
                if (!Shifter.this.isPointInShiftArea(point)) {
                    MapView.this.setCursor(MapView.this.cursor != null ? MapView.this.cursor : Cursor.getDefaultCursor());
                } else {
                    int width = MapView.this.getWidth();
                    int height = MapView.this.getHeight();
                    Cursor cursor = point.x < width / 3 ? (point.y < height / 3 ? ((MapView)((Shifter)Shifter.this).MapView.this).cursors.shiftNorthwestCursor : (point.y > 2 * height / 3 ? ((MapView)((Shifter)Shifter.this).MapView.this).cursors.shiftSouthwestCursor : ((MapView)((Shifter)Shifter.this).MapView.this).cursors.shiftWestCursor)) : (point.x > 2 * width / 3 ? (point.y < height / 3 ? ((MapView)((Shifter)Shifter.this).MapView.this).cursors.shiftNortheastCursor : (point.y > 2 * height / 3 ? ((MapView)((Shifter)Shifter.this).MapView.this).cursors.shiftSoutheastCursor : ((MapView)((Shifter)Shifter.this).MapView.this).cursors.shiftEastCursor)) : (point.y < height / 2 ? ((MapView)((Shifter)Shifter.this).MapView.this).cursors.shiftNorthCursor : ((MapView)((Shifter)Shifter.this).MapView.this).cursors.shiftSouthCursor));
                    MapView.this.setCursor(cursor);
                    e.consume();
                }
            }
        }

        protected class MouseListener
        extends MouseAdapter {
            protected boolean consumeRelease = false;

            protected MouseListener() {
            }

            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                Point point = e.getPoint();
                if (!Shifter.this.isPointInShiftArea(point)) {
                    return;
                }
                Dimension size = MapView.this.getSize();
                Point viewCenter = new Point(size.width / 2, size.height / 2);
                FloatPoint direction = PointUtil.getUnitVector(viewCenter, point);
                Shifter.this.doStartShifting(direction);
                e.consume();
                this.consumeRelease = true;
            }

            public void mouseReleased(MouseEvent e) {
                Shifter.this.doEndShifting();
                if (this.consumeRelease) {
                    e.consume();
                    this.consumeRelease = false;
                }
            }
        }
    }

    private class ShiftedViewpoint {
        private Point shiftedViewpoint = new Point();

        private ShiftedViewpoint() {
        }

        public Point get() {
            return this.shiftedViewpoint;
        }

        public void doUpdate() {
            MapPixelLocation viewpoint = MapView.this.viewpoint.get();
            Point shift = MapView.this.viewpointShift.get();
            this.shiftedViewpoint.move(viewpoint.x + shift.x, viewpoint.y + shift.y);
        }
    }

    private class ViewpointShift {
        private Point shift = new Point();

        private ViewpointShift() {
        }

        public Point get() {
            return this.shift;
        }

        public void set(int x, int y) {
            this.shift.move(x, y);
            MapView.this.shiftedViewpoint.doUpdate();
        }

        public void doAdd(int dx, int dy) {
            this.set(this.shift.x + dx, this.shift.y + dy);
        }
    }

    private class Viewpoint {
        private MapPixelLocation viewpoint = new MapPixelLocation();
        private MapTileLocation scratchViewpointTile = new MapTileLocation();

        private Viewpoint() {
        }

        public MapPixelLocation get() {
            return this.viewpoint;
        }

        public void set(MapPixelLocation viewpoint) {
            TileSizeUtil.getTileLocation(viewpoint, this.scratchViewpointTile);
            boolean tileChanged = this.scratchViewpointTile.equals(TileSizeUtil.getTileLocation(this.viewpoint));
            this.viewpoint.setLocation(viewpoint);
            MapView.this.shiftedViewpoint.doUpdate();
            if (tileChanged) {
                MapView.this.losDeterminer.doDetmStatuses();
            }
            MapView.this.doWaitForPaint();
        }
    }

    private class Cursors {
        public Cursor shiftNorthCursor;
        public Cursor shiftSouthCursor;
        public Cursor shiftWestCursor;
        public Cursor shiftEastCursor;
        public Cursor shiftNorthwestCursor;
        public Cursor shiftNortheastCursor;
        public Cursor shiftSouthwestCursor;
        public Cursor shiftSoutheastCursor;

        public Cursors() {
            Toolkit kit = Toolkit.getDefaultToolkit();
            this.shiftNorthCursor = kit.createCustomCursor(ImageUtil.doLoadImage("shiftNorthCursor"), new Point(15, 1), "");
            this.shiftSouthCursor = kit.createCustomCursor(ImageUtil.doLoadImage("shiftSouthCursor"), new Point(15, 30), "");
            this.shiftWestCursor = kit.createCustomCursor(ImageUtil.doLoadImage("shiftWestCursor"), new Point(1, 15), "");
            this.shiftEastCursor = kit.createCustomCursor(ImageUtil.doLoadImage("shiftEastCursor"), new Point(30, 15), "");
            this.shiftNorthwestCursor = kit.createCustomCursor(ImageUtil.doLoadImage("shiftNorthwestCursor"), new Point(1, 1), "");
            this.shiftNortheastCursor = kit.createCustomCursor(ImageUtil.doLoadImage("shiftNortheastCursor"), new Point(30, 1), "");
            this.shiftSouthwestCursor = kit.createCustomCursor(ImageUtil.doLoadImage("shiftSouthwestCursor"), new Point(1, 30), "");
            this.shiftSoutheastCursor = kit.createCustomCursor(ImageUtil.doLoadImage("shiftSoutheastCursor"), new Point(30, 30), "");
        }
    }

    private static class LOSStatus {
        public Image image;
        public static final LOSStatus ok = new LOSStatus(null);
        public static final LOSStatus blocked = new LOSStatus("darkness");
        public static final LOSStatus blockedUpperLeft = new LOSStatus("darknessUpperLeft");
        public static final LOSStatus blockedUpperRight = new LOSStatus("darknessUpperRight");
        public static final LOSStatus blockedLowerLeft = new LOSStatus("darknessLowerLeft");
        public static final LOSStatus blockedLowerRight = new LOSStatus("darknessLowerRight");

        private LOSStatus(String imageName) {
            if (imageName != null) {
                this.image = ImageUtil.doLoadImage(imageName);
            }
        }
    }

    private final class LOSDeterminer {
        private LOSStatus[][] losStatuses;
        private final UpperLeftTileLocation upperLeftTileLocation = new UpperLeftTileLocation();
        private final MapPixelLocation doDetmStatuses_pixelTo = new MapPixelLocation();
        private final MapPixelLocation doDetmStatuses_nearestCorner = new MapPixelLocation();

        private LOSDeterminer() {
        }

        public UpperLeftTileLocation getUpperLeftTileLocation() {
            return this.upperLeftTileLocation;
        }

        public void onResized() {
            Dimension viewTileSize = MapView.this.getViewTileSize();
            this.losStatuses = new LOSStatus[viewTileSize.width][viewTileSize.height];
            this.doDetmStatuses();
        }

        private void doDetmStatuses() {
            if (MapView.this.map == null) {
                return;
            }
            MapPixelLocation pixelTo = this.doDetmStatuses_pixelTo;
            MapPixelLocation nearestCorner = this.doDetmStatuses_nearestCorner;
            for (int i = 0; i < this.losStatuses.length; ++i) {
                for (int j = 0; j < this.losStatuses[i].length; ++j) {
                    TileSizeUtil.getPixelLocation(this.upperLeftTileLocation.get(), pixelTo);
                    pixelTo.x += i * TileSize.tileSize.width;
                    pixelTo.y += j * TileSize.tileSize.height;
                    TileSizeUtil.getNearestTileCorner(pixelTo, MapView.this.viewpoint.get(), nearestCorner);
                    boolean result = MapView.this.map.getCanSee(MapView.this.viewpoint.get(), nearestCorner, TileSize.tileSize.width, true, false, null, null);
                    if (!result && MapView.this.map.getCanSeeFailedOnLastStep() && !(result = MapView.this.map.getCanSee(MapView.this.viewpoint.get(), nearestCorner, TileSize.tileSize.width - 1, true, false, null, null)) && MapView.this.map.getCanSeeFailedOnLastStep()) {
                        result = MapView.this.map.getCanSee(MapView.this.viewpoint.get(), nearestCorner, TileSize.tileSize.width - 3, true, false, null, null);
                    }
                    this.losStatuses[i][j] = result ? LOSStatus.ok : LOSStatus.blocked;
                }
            }
            this.doSmoothCorners();
        }

        public LOSStatus getLOSStatus(MapTileLocation at) {
            if (!MapView.this.useLOSBlocking) {
                return LOSStatus.ok;
            }
            MapTileLocation upperLeft = this.upperLeftTileLocation.get();
            int xIndex = at.x - upperLeft.x;
            int yIndex = at.y - upperLeft.y;
            if (xIndex < 0 || yIndex < 0 || xIndex >= this.losStatuses.length || yIndex >= this.losStatuses[0].length) {
                return LOSStatus.blocked;
            }
            return this.losStatuses[xIndex][yIndex];
        }

        private void doSmoothCorners() {
            int viewpointX = ((MapView)MapView.this).viewpoint.get().x / TileSize.tileSize.width - this.upperLeftTileLocation.get().x;
            int viewpointY = ((MapView)MapView.this).viewpoint.get().y / TileSize.tileSize.height - this.upperLeftTileLocation.get().y;
            LOSStatus[][] statuses = this.losStatuses;
            LOSStatus blocked = LOSStatus.blocked;
            LOSStatus clear = LOSStatus.ok;
            for (int i = 0; i < statuses.length; ++i) {
                for (int j = 0; j < statuses[i].length; ++j) {
                    LOSStatus status;
                    if (statuses[i][j] != blocked) continue;
                    boolean upBlocked = j == 0 || statuses[i][j - 1] == blocked;
                    boolean downBlocked = j == statuses[i].length - 1 || statuses[i][j + 1] == blocked;
                    boolean leftBlocked = i == 0 || statuses[i - 1][j] == blocked;
                    boolean rightBlocked = i == statuses.length - 1 || statuses[i + 1][j] == blocked;
                    boolean upClear = j != 0 && statuses[i][j - 1] == clear;
                    boolean downClear = j != statuses[i].length - 1 && statuses[i][j + 1] == clear;
                    boolean leftClear = i != 0 && statuses[i - 1][j] == clear;
                    boolean rightClear = i != statuses.length - 1 && statuses[i + 1][j] == clear;
                    int numBlocked = 0;
                    if (upBlocked) {
                        ++numBlocked;
                    }
                    if (downBlocked) {
                        ++numBlocked;
                    }
                    if (leftBlocked) {
                        ++numBlocked;
                    }
                    if (rightBlocked) {
                        ++numBlocked;
                    }
                    if (numBlocked == 2) {
                        status = null;
                        if (upBlocked && leftBlocked && downClear && rightClear && (i > viewpointX || j > viewpointY)) {
                            status = LOSStatus.blockedUpperLeft;
                        } else if (upBlocked && rightBlocked && downClear && leftClear && (i < viewpointX || j > viewpointY)) {
                            status = LOSStatus.blockedUpperRight;
                        } else if (downBlocked && leftBlocked && upClear && rightClear && (i > viewpointX || j < viewpointY)) {
                            status = LOSStatus.blockedLowerLeft;
                        } else if (downBlocked && rightBlocked && upClear && leftClear && (i < viewpointX || j < viewpointY)) {
                            status = LOSStatus.blockedLowerRight;
                        }
                        if (status == null) continue;
                        statuses[i][j] = status;
                        continue;
                    }
                    if (numBlocked != 1) continue;
                    status = null;
                    if (upBlocked && leftClear && downClear && rightClear) {
                        if (j <= viewpointY) {
                            status = i <= viewpointX ? LOSStatus.blockedUpperRight : LOSStatus.blockedUpperLeft;
                        }
                    } else if (downBlocked && leftClear && upClear && rightClear) {
                        if (j >= viewpointY) {
                            status = i <= viewpointX ? LOSStatus.blockedLowerRight : LOSStatus.blockedLowerLeft;
                        }
                    } else if (leftBlocked && upClear && downClear && rightClear) {
                        if (i <= viewpointX) {
                            status = j <= viewpointY ? LOSStatus.blockedLowerLeft : LOSStatus.blockedUpperLeft;
                        }
                    } else if (rightBlocked && upClear && downClear && leftClear && i >= viewpointX) {
                        LOSStatus lOSStatus = status = j <= viewpointY ? LOSStatus.blockedLowerRight : LOSStatus.blockedUpperRight;
                    }
                    if (status == null) continue;
                    statuses[i][j] = status;
                }
            }
        }

        private final class UpperLeftTileLocation {
            private MapTileLocation upperLeftTileLocation = new MapTileLocation();

            private UpperLeftTileLocation() {
            }

            public MapTileLocation get() {
                return this.upperLeftTileLocation;
            }

            public void set(MapTileLocation location) {
                if (location.equals(this.upperLeftTileLocation)) {
                    return;
                }
                this.upperLeftTileLocation.setLocation(location);
                LOSDeterminer.this.doDetmStatuses();
            }
        }
    }

    private class MessageDrawer {
        private int messageFontAscent;
        private HashMap messageYs = new HashMap();
        private FontMetrics messageFontMetrics;
        private List messages = new ArrayList();

        public MessageDrawer() {
            this.messageFontMetrics = MapView.this.getFontMetrics(Fonts.viewMessage);
            this.messageFontAscent = this.messageFontMetrics.getAscent();
        }

        private void doDrawMessages(Graphics g) {
            g.setFont(Fonts.viewMessage);
            this.messageYs.clear();
            long currentTime = System.currentTimeMillis();
            int numMessages = this.messages.size();
            for (int i = 0; i < numMessages; ++i) {
                Integer yInt;
                Message message = (Message)this.messages.get(i);
                if (message.startTime == 0L) {
                    message.startTime = System.currentTimeMillis();
                    message.width = GuiUtil.getStringWidth(message.text, this.messageFontMetrics);
                    new Thread(this, message){
                        private final /* synthetic */ Message val$message;
                        private final /* synthetic */ MessageDrawer this$1;
                        {
                            this.this$1 = this$1;
                            this.val$message = val$message;
                        }

                        public void run() {
                            ThreadUtil.doSleep(this.val$message.duration + 20);
                            MessageDrawer.access$800(this.this$1).repaint();
                        }
                    }.start();
                }
                if (currentTime - message.startTime >= (long)message.duration) {
                    this.messages.remove(i--);
                    --numMessages;
                    continue;
                }
                if (!MapView.this.map.getCanSee(MapView.this.viewpoint.get(), message.location, TileSize.tileSize.width, true, false, null, null)) continue;
                int x = message.location.x - message.width / 2;
                int y = message.location.y + this.messageFontAscent / 2 - 2;
                while (this.messageYs.get(yInt = new Integer(y / 8 * 8)) != null) {
                    y += TileSize.tileSize.height / 2;
                }
                this.messageYs.put(yInt, message);
                int gx = x - (((MapView)MapView.this).shiftedViewpoint.get().x - MapView.this.getWidth() / 2);
                int gy = y - (((MapView)MapView.this).shiftedViewpoint.get().y - MapView.this.getHeight() / 2);
                g.setColor(Color.black);
                g.drawString(message.text, gx + 1, gy + 2);
                g.setColor(Color.white);
                g.drawString(message.text, gx, gy);
            }
        }

        public void doDrawMessage(Message message) {
            this.messages.add(message);
        }

        static /* synthetic */ MapView access$800(MessageDrawer x0) {
            return x0.MapView.this;
        }
    }

    private static class Message {
        public MapPixelLocation location;
        public String text;
        public int duration;
        public long startTime;
        public int width;

        private Message() {
        }
    }
}

