/*
 * Decompiled with CFR 0.152.
 */
package silmar.client;

import java.awt.Color;
import java.awt.Frame;
import java.util.List;
import silmar.Sound;
import silmar.client.CommandsThread;
import silmar.client.MapView;
import silmar.client.gui.BuyDialog;
import silmar.client.gui.DonateDialog;
import silmar.client.gui.GainLevelDialog;
import silmar.client.gui.HandsConfigDialog;
import silmar.client.gui.HelpDialog;
import silmar.client.gui.IdentifyDialog;
import silmar.client.gui.LocationSelection;
import silmar.client.gui.ModifyAttributesFrame;
import silmar.client.gui.PlayFrame;
import silmar.client.gui.PlayerAttributesDialog;
import silmar.client.gui.PowersDialog;
import silmar.client.gui.RepairDialog;
import silmar.client.gui.SellDialog;
import silmar.client.gui.ServicesDialog;
import silmar.client.gui.StoryFrame;
import silmar.client.gui.UseOrDropItemsDialog;
import silmar.entities.beings.player.Player;
import silmar.entities.beings.player.PlayerPower;
import silmar.entities.beings.player.events.PlayerEventType;
import silmar.entities.beings.player.events.PlayerEvents;
import silmar.entities.beings.talkerBeings.TalkerBeing;
import silmar.entities.beings.talkerBeings.TalkerBeingType;
import silmar.entities.beings.talkerBeings.TalkerBeings;
import silmar.entities.items.weapons.Weapon;
import silmar.entities.talkers.ItemFixer;
import silmar.entities.talkers.ItemSeller;
import silmar.entities.talkers.ServiceSeller;
import silmar.entities.terrains.Terrain;
import silmar.entities.terrains.TerrainType;
import silmar.entities.terrains.Terrains;
import silmar.events.Event;
import silmar.events.Listener;
import silmar.game.Game;
import silmar.gui.dialogs.InputIntDialog;
import silmar.gui.dialogs.InputStringDialog;
import silmar.gui.dialogs.MessageDialog;
import silmar.gui.dialogs.OkCancelDialog;
import silmar.gui.frames.InputStringFrame;
import silmar.gui.tooltips.TooltipManager;
import silmar.map.Map;
import silmar.map.MapLevel;
import silmar.map.MapPixelLocation;
import silmar.map.events.MapEventType;
import silmar.map.events.MapEvents;
import silmar.server.Server;
import silmar.util.ThreadUtil;

public final class Client {
    private boolean playerCanAct;
    private UseOrDropItemsDialog useOrDropItemsDialog;
    private PlayerAttributesDialog playerAttributesDialog;
    private PowersDialog powersDialog;
    private ServicesDialog servicesDialog;
    private DonateDialog donateDialog;
    private IdentifyDialog identifyDialog;
    private RepairDialog repairDialog;
    private BuyDialog buyDialog;
    private SellDialog sellDialog;
    private HandsConfigDialog handsConfigDialog;
    private Color backgroundColor = new Color(0, 0, 0);
    private Server server;
    private HelpDialog helpDialog;
    private PlayFrame playFrame;
    private Player player;
    private CommandsThread commandsThread;
    private MapListener mapListener = new MapListener();

    public Client(Server server) {
        this.server = server;
    }

    public void doShowPowers() {
        this.powersDialog.setVisible(true);
    }

    public void doDisplayHelp() {
        this.helpDialog.show();
    }

    private void doHaveUserChoosePlayerName(Player player) {
        String name = null;
        while (name == null || name.equals("")) {
            name = InputStringFrame.doShow("Enter your character's name:");
        }
        player.setName(name);
    }

    public void onPlayerCreated(Player player) {
        this.doHaveUserChoosePlayerName(player);
        this.setPlayer(player);
        ModifyAttributesFrame frame = new ModifyAttributesFrame(player);
        frame.setVisible(true);
        while (frame.isVisible()) {
            ThreadUtil.doSleep(100L);
        }
        this.doShowStory();
    }

    public void doShowStory() {
        StoryFrame frame = new StoryFrame(false);
        frame.setVisible(true);
        while (frame.isVisible()) {
            ThreadUtil.doSleep(100L);
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void doSayCommand() {
        String text = InputStringDialog.doShow(this.playFrame, "Say to those within sight:");
        if (text != null && !text.equals("")) {
            this.player.doSay(text);
        }
    }

    public Server getServer() {
        return this.server;
    }

    public void onPlayerAtMap() {
        MapView mapView = this.playFrame.getMapView();
        Map map = this.player.getMap();
        mapView.setMap(map);
        mapView.setViewpointEntity(this.player);
        map.doAddListener(this.mapListener);
        this.playFrame.doClearStatusLine();
        mapView.setViewOn(true);
        this.setPlayerCanAct(true);
        Sound.atMap.doPlay();
    }

    public void onNearbyTalkerBeingClicked(TalkerBeing being) {
        if (being instanceof ItemSeller) {
            ItemSeller seller = (ItemSeller)((Object)being);
            this.buyDialog = new BuyDialog(this.playFrame, this.player, seller);
            this.buyDialog.setVisible(true);
        } else if (being instanceof ServiceSeller) {
            ServiceSeller seller = (ServiceSeller)((Object)being);
            this.servicesDialog = new ServicesDialog(this.playFrame, this.player, seller, seller.getGreeting());
            this.servicesDialog.setVisible(true);
        } else if (being.getType().equals(TalkerBeingType.goldPorter)) {
            this.donateDialog = new DonateDialog(this.playFrame, this.player, being.getGreeting());
            this.donateDialog.setVisible(true);
        } else if (being instanceof TalkerBeings.ItemIdentifier) {
            this.identifyDialog = new IdentifyDialog(this.playFrame, this.player, (TalkerBeings.ItemIdentifier)being);
            this.identifyDialog.setVisible(true);
        } else if (being instanceof TalkerBeings.Buyer) {
            this.sellDialog = new SellDialog(this.playFrame, this.player, (TalkerBeings.Buyer)being, being.getGreeting());
            this.sellDialog.setVisible(true);
        } else if (being instanceof ItemFixer) {
            this.repairDialog = new RepairDialog(this.playFrame, this.player, (ItemFixer)((Object)being));
            this.repairDialog.setVisible(true);
        } else {
            MessageDialog.doShow(this.playFrame, being.getGreeting());
            this.player.doProceedWithTalkerBeyondGreeting(being);
        }
        being.onTalkedTo();
    }

    public boolean onNearbyTerrainClicked(Terrain terrain) {
        if (terrain.getType().equals(TerrainType.chest)) {
            Terrains.Chest chest = (Terrains.Chest)terrain;
            chest.doOpen(this.player);
            return true;
        }
        if (terrain.getType().equals(TerrainType.fountain)) {
            if (!OkCancelDialog.doShow(this.playFrame, "Drink from this fountain?")) {
                this.player.doDrinkFromFountain((Terrains.Fountain)terrain);
                return true;
            }
        } else if (terrain.getType().equals(TerrainType.mine)) {
            if (!OkCancelDialog.doShow(this.playFrame, "Enter this dark, old mining shaft?")) {
                this.player.doEnterMine((Terrains.Mine)terrain);
                return true;
            }
        } else {
            if (terrain.getType().equals(TerrainType.statue)) {
                if (((Terrains.Statue)terrain).isUsed()) {
                    this.player.onMessage("This statue is non-descript.", new Player.LocationalMessageType(terrain.getLocation()));
                    return false;
                }
                if (OkCancelDialog.doShow(this.playFrame, "An inscription on this statue reads, \"Insert gold into my mouth, and I will reward you with an item!\" Do so?")) {
                    return true;
                }
                int playerGold = this.player.getGold();
                if (playerGold < 1) {
                    MessageDialog.doShow(this.playFrame, "You have no gold!");
                    return true;
                }
                InputIntDialog.Result result = InputIntDialog.doShow(this.playFrame, "How much gold do you wish to insert?", 0, playerGold, playerGold);
                if (!result.cancelled && result.valueEntered > 0) {
                    this.player.doInsertGoldIntoStatue(result.valueEntered, (Terrains.Statue)terrain);
                }
                return true;
            }
            if (terrain instanceof ItemSeller) {
                ItemSeller seller = (ItemSeller)((Object)terrain);
                this.buyDialog = new BuyDialog(this.playFrame, this.player, seller);
                this.buyDialog.setVisible(true);
            } else if (terrain instanceof ItemFixer) {
                this.repairDialog = new RepairDialog(this.playFrame, this.player, (ItemFixer)((Object)terrain));
                this.repairDialog.setVisible(true);
            } else {
                return this.player.doInteractWithTerrain(terrain);
            }
        }
        return false;
    }

    public void setPlayer(Player player) {
        this.player = player;
        this.playFrame = new PlayFrame(this);
        this.helpDialog = new HelpDialog(this.playFrame);
        player.doAddListener(new PlayerListener());
        this.powersDialog = new PowersDialog((Frame)this.playFrame, player);
        this.powersDialog.doAddListener(new Listener(){

            public void onEvent(Event event) {
                boolean powerUsed;
                if (event.isOfType(PowersDialog.PowerSelected.powerSelected) && !(powerUsed = Client.this.onPowerSelected(((PowersDialog.PowerSelected)event).power))) {
                    new Thread(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            ThreadUtil.doSleep(500L);
                            Client.access$400(1.access$300(this.this$1)).setVisible(true);
                        }
                    }.start();
                }
            }

            static /* synthetic */ Client access$300(1 x0) {
                return x0.Client.this;
            }
        });
        this.playerAttributesDialog = new PlayerAttributesDialog((Frame)this.playFrame, player);
        this.useOrDropItemsDialog = new UseOrDropItemsDialog((Frame)this.playFrame, player);
        this.playFrame.getPlayerVitalStatsDisplay().onAttributeValueChanged();
        this.playFrame.getHandsItemsDisplay().onItemsChanged();
        this.handsConfigDialog = new HandsConfigDialog((Frame)this.playFrame, player);
        this.commandsThread = new CommandsThread(this);
        this.commandsThread.start();
    }

    private void onPlayerEquippedItemsChange() {
        this.useOrDropItemsDialog.getEquippedItemsDisplay().onEquippedItemsChanged();
        this.playFrame.getHandsItemsDisplay().onItemsChanged();
        if (this.sellDialog != null) {
            this.sellDialog.getEquippedItemsDisplay().onEquippedItemsChanged();
        }
        if (this.donateDialog != null) {
            this.donateDialog.getEquippedItemsDisplay().onEquippedItemsChanged();
        }
        if (this.repairDialog != null) {
            this.repairDialog.getEquippedItemsDisplay().onEquippedItemsChanged();
        }
        if (this.identifyDialog != null) {
            this.identifyDialog.getEquippedItemsDisplay().onEquippedItemsChanged();
        }
    }

    private void doUpdateEquippedItemDisplays() {
        this.useOrDropItemsDialog.getEquippedItemsDisplay().doUpdateItems();
        if (this.sellDialog != null) {
            this.sellDialog.getEquippedItemsDisplay().doUpdateItems();
        }
        if (this.donateDialog != null) {
            this.donateDialog.getEquippedItemsDisplay().doUpdateItems();
        }
        if (this.repairDialog != null) {
            this.repairDialog.getEquippedItemsDisplay().doUpdateItems();
        }
        if (this.identifyDialog != null) {
            this.identifyDialog.getEquippedItemsDisplay().doUpdateItems();
        }
    }

    private void onPlayerInventoryChange() {
        List items = this.player.getInventory().getItems();
        this.useOrDropItemsDialog.getInventoryDisplay().setItems(items);
        if (this.sellDialog != null) {
            this.sellDialog.getInventoryDisplay().setItems(items);
        }
        if (this.donateDialog != null) {
            this.donateDialog.getInventoryDisplay().setItems(items);
        }
        if (this.repairDialog != null) {
            this.repairDialog.getInventoryDisplay().setItems(items);
        }
        if (this.buyDialog != null) {
            this.buyDialog.getInventoryDisplay().setItems(items);
        }
        if (this.identifyDialog != null) {
            this.identifyDialog.getInventoryDisplay().setItems(items);
        }
    }

    private void doUpdateInventoryDisplays() {
        this.useOrDropItemsDialog.getInventoryDisplay().doUpdateItems();
        if (this.sellDialog != null) {
            this.sellDialog.getInventoryDisplay().doUpdateItems();
        }
        if (this.donateDialog != null) {
            this.donateDialog.getInventoryDisplay().doUpdateItems();
        }
        if (this.repairDialog != null) {
            this.repairDialog.getInventoryDisplay().doUpdateItems();
        }
        if (this.buyDialog != null) {
            this.buyDialog.getInventoryDisplay().doUpdateItems();
        }
        if (this.identifyDialog != null) {
            this.identifyDialog.getInventoryDisplay().doUpdateItems();
        }
    }

    private boolean onPowerSelected(final PlayerPower power) {
        if (!this.player.getCanEmployPowerNow(power)) {
            return false;
        }
        LocationSelection selection = power.getLocationSelection();
        if (selection != null) {
            this.playFrame.setLocationSelection(selection);
            return true;
        }
        MapPixelLocation location = null;
        if (power.equals(PlayerPower.teleportSelf)) {
            MapLevel level = this.player.getMap().getLevel();
            if (level.equals(MapLevel.dungeonCEnd) || level.equals(MapLevel.moonEnd)) {
                this.player.onMessage("Your attempt to teleport is blocked!");
                return true;
            }
            Game game = Game.getCurrentGame();
            int maxLevel = game.getFurthestLevelReachedByPlayer(this.player);
            int defaultLevel = level.getIndex() == 0 ? maxLevel : 0;
            InputIntDialog.Result result = InputIntDialog.doShow(this.playFrame, "To which level do you wish to teleport?", 0, maxLevel, defaultLevel);
            if (result.cancelled) {
                return true;
            }
            location = new MapPixelLocation(result.valueEntered, 0);
        }
        final MapPixelLocation finalLocation = location;
        CommandsThread.getInstance().doAddCommand(new CommandsThread.Command(){

            public void doExecute() {
                Client.this.player.doUsePower(power, finalLocation);
            }
        });
        return true;
    }

    private void onPlayerDead() {
        MessageDialog.doShow(this.playFrame, "You are dead!");
        this.playFrame.setVisible(false);
    }

    private void onPlayerCanMakeAttack() {
        boolean offhand = this.player.isCurrentAttackOffhand();
        Weapon weapon = !offhand ? this.player.getWeapon() : this.player.getOffhandWeapon();
        this.playFrame.doDisplayStatusMessage("Attacking with " + weapon.getName() + (offhand ? " (offhand)" : ""));
        this.playFrame.setLocationSelection(weapon.getWeaponType().isRanged() ? new LocationSelection.RangedAttack() : new LocationSelection.MeleeAttack());
    }

    private void onPlayerReceivedMessage(PlayerEvents.MessageReceived event) {
        if (event.type.equals(Player.MessageType.normal)) {
            this.playFrame.getMapView().doDisplayMessage(event.message, null, event.duration);
        } else if (event.type instanceof Player.LocationalMessageType) {
            this.playFrame.getMapView().doDisplayMessage(event.message, ((Player.LocationalMessageType)event.type).location, event.duration);
        } else if (event.type.equals(Player.MessageType.important) || event.type.equals(Player.MessageType.error)) {
            MessageDialog.doShow(this.playFrame, event.message);
        } else if (event.type.equals(Player.MessageType.status)) {
            this.playFrame.doDisplayStatusMessage(event.message, 5000);
        } else if (event.type.equals(Player.MessageType.gameFinished)) {
            this.playFrame.setVisible(false);
            StoryFrame frame = new StoryFrame(true);
            frame.setVisible(true);
            while (frame.isVisible()) {
                ThreadUtil.doSleep(100L);
            }
        }
    }

    public void onPlayerEmployedSuperVision(PlayerEvents.SuperVisionEmployed event) {
        MapView view = this.playFrame.getMapView();
        view.setUseLOSBlocking(false);
        ThreadUtil.doSleep(7000L);
        view.setUseLOSBlocking(true);
    }

    private void onMapLoading() {
        this.playFrame.getMapView().setViewOn(false);
        this.playFrame.setVisible(true);
        if (this.playFrame.getMapView().getMap() != null) {
            Sound.loadingLevel.doPlay();
        }
        this.playFrame.doDisplayStatusMessage("Loading level...");
        this.setPlayerCanAct(false);
    }

    private void onPlayerHeldItemChanged() {
        this.doUpdateInventoryDisplays();
        this.doUpdateEquippedItemDisplays();
        this.handsConfigDialog.getHandsConfigsDisplay().doUpdateItems();
        this.playFrame.getHandsItemsDisplay().doUpdateItems();
        this.playFrame.getPlayerVitalStatsDisplay().onAttributeValueChanged();
        TooltipManager.getSharedInstance().doRefreshTooltip();
    }

    public void doShowAttributes() {
        this.playerAttributesDialog.setVisible(true);
    }

    public void doShowItems() {
        this.useOrDropItemsDialog.setVisible(true);
    }

    public boolean getPlayerCanAct() {
        return this.playerCanAct;
    }

    private void setPlayerCanAct(boolean canAct) {
        this.playerCanAct = canAct;
        this.playFrame.setUIEnabled(canAct);
    }

    public void doSelectHandsConfig() {
        this.handsConfigDialog.setLocation(this.playFrame.getX() + this.playFrame.getWidth() - this.handsConfigDialog.getWidth(), this.playFrame.getY() + this.playFrame.getHeight() - this.handsConfigDialog.getHeight());
        this.handsConfigDialog.doShow(false);
    }

    public void doSelectHandsConfigToSet() {
        this.handsConfigDialog.setLocation(this.playFrame.getX() + this.playFrame.getWidth() - this.handsConfigDialog.getWidth(), this.playFrame.getY() + this.playFrame.getHeight() - this.handsConfigDialog.getHeight());
        this.handsConfigDialog.doShow(true);
    }

    private class PlayerListener
    implements Listener {
        private PlayerListener() {
        }

        public void onEvent(Event event) {
            if (event.isOfType(PlayerEventType.mustWaitToAct)) {
                Client.this.setPlayerCanAct(false);
            } else if (event.isOfType(PlayerEventType.canActAgain)) {
                Client.this.setPlayerCanAct(true);
            } else if (event.isOfType(PlayerEventType.soundHeard)) {
                PlayerEvents.SoundHeard heard = (PlayerEvents.SoundHeard)event;
                heard.sound.doPlay(heard.distance, heard.location.x - ((Client)Client.this).player.getLocation().x);
            } else if (event.isOfType(PlayerEventType.messageReceived)) {
                Client.this.onPlayerReceivedMessage((PlayerEvents.MessageReceived)event);
            } else if (event.isOfType(PlayerEventType.maxHitPointsChanged) || event.isOfType(PlayerEventType.hitPointsChanged) || event.isOfType(PlayerEventType.maxMagicPointsChanged) || event.isOfType(PlayerEventType.magicPointsChanged) || event.isOfType(PlayerEventType.maxClericalPointsChanged) || event.isOfType(PlayerEventType.clericalPointsChanged) || event.isOfType(PlayerEventType.confused) || event.isOfType(PlayerEventType.paralyzed) || event.isOfType(PlayerEventType.notConfused) || event.isOfType(PlayerEventType.notParalyzed) || event.isOfType(PlayerEventType.poisonedChanged) || event.isOfType(PlayerEventType.diseasedChanged) || event.isOfType(PlayerEventType.maxEncumbranceChanged) || event.isOfType(PlayerEventType.encumbranceChanged) || event.isOfType(PlayerEventType.levelChanged) || event.isOfType(PlayerEventType.defenseChanged) || event.isOfType(PlayerEventType.quickenedChanged)) {
                Client.this.playFrame.getPlayerVitalStatsDisplay().onAttributeValueChanged();
                if (event.isOfType(PlayerEventType.levelChanged)) {
                    Client.this.powersDialog.onPowersChanged();
                }
            } else if (event.isOfType(PlayerEventType.attributeChanged)) {
                Client.this.playerAttributesDialog.getAttributesDisplay().onAttributeChanged(((PlayerEvents.AttributeChanged)event).attribute);
            } else if (event.isOfType(PlayerEventType.itemEquipped)) {
                PlayerEvents.ItemEquipped equipped = (PlayerEvents.ItemEquipped)event;
                Sound sound = equipped.item != null ? Sound.itemEquipped : Sound.itemUnequipped;
                sound.doPlay();
                Client.this.onPlayerEquippedItemsChange();
            } else if (event.isOfType(PlayerEventType.itemAddedToInventory) || event.isOfType(PlayerEventType.itemRemovedFromInventory)) {
                Client.this.onPlayerInventoryChange();
            } else if (event.isOfType(PlayerEventType.dead)) {
                Client.this.onPlayerDead();
            } else if (event.isOfType(PlayerEventType.canMakeAttack)) {
                Client.this.onPlayerCanMakeAttack();
            } else if (event.isOfType(PlayerEventType.superVisionEmployed)) {
                Client.this.onPlayerEmployedSuperVision((PlayerEvents.SuperVisionEmployed)event);
            } else if (event.isOfType(PlayerEventType.usedImmediateEffectItem)) {
                Client.this.useOrDropItemsDialog.setVisible(false);
            } else if (event.isOfType(PlayerEventType.buyerLeft)) {
                Client.this.sellDialog.setVisible(false);
            } else if (event.isOfType(PlayerEventType.mapLoading)) {
                Client.this.onMapLoading();
            } else if (event.isOfType(PlayerEventType.heldItemChanged)) {
                Client.this.onPlayerHeldItemChanged();
            } else if (event.isOfType(PlayerEventType.handsConfigSet) || event.isOfType(PlayerEventType.handsConfigChanged)) {
                Client.this.handsConfigDialog.getHandsConfigsDisplay().onConfigChanged();
                if (event.isOfType(PlayerEventType.handsConfigSet)) {
                    Sound.handsConfigSet.doPlay();
                }
            } else if (event.isOfType(PlayerEventType.becameBones)) {
                Client.this.playFrame.getMapView().setViewpointEntity(((PlayerEvents.BecameBones)event).bones);
            } else if (event.isOfType(PlayerEventType.atMap)) {
                Client.this.onPlayerAtMap();
            } else if (event.isOfType(PlayerEventType.mustChooseLevelGained)) {
                new GainLevelDialog(Client.this.playFrame, Client.this.player).setVisible(true);
            }
        }
    }

    private class MapListener
    implements Listener {
        private MapListener() {
        }

        public void onEvent(Event event) {
            if (event.isOfType(MapEventType.entityPresenceChange)) {
                Client.this.playFrame.getMapView().onEntityPresenceChange((MapEvents.EntityPresenceChange)event);
            } else if (event.isOfType(MapEventType.tileChanged)) {
                Client.this.playFrame.getMapView().onTileChange();
            } else if (event.isOfType(MapEventType.entityChangedAppearance)) {
                Client.this.playFrame.getMapView().repaint();
            } else if (event.isOfType(MapEventType.groupOfChangesToOccur)) {
                Client.this.playFrame.getMapView().setGroupOfChangesOccurring(true);
            } else if (event.isOfType(MapEventType.groupOfChangesOccurred)) {
                Client.this.playFrame.getMapView().setGroupOfChangesOccurring(false);
            }
        }
    }
}

