/*
 * Decompiled with CFR 0.152.
 */
package silmar.client;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import silmar.Images;
import silmar.client.AnimationCell;
import silmar.client.MapView;
import silmar.entities.damage.DamageForm;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.tiles.TileSize;

public class Animations
implements TileSize {

    public static class DragonBreath {
        public static void doShow(MapView view, List locations, DamageForm breathType) {
            view.onTemporaryLightSourceAdded((MapPixelLocation)locations.get(0));
            Image image = breathType.equals(DamageForm.acid) ? Images.getImage("acidDragonBreath") : Images.getImage("redDragonBreath");
            ArrayList<AnimationCell> cells = new ArrayList<AnimationCell>();
            MapPixelLocation lastLocation = null;
            MapPixelDistance newArcIndicatorDistance = new MapPixelDistance(2 * TileSize.tileSize.width);
            int i = 0;
            while (i < locations.size()) {
                MapPixelLocation location = (MapPixelLocation)locations.get(i);
                if (lastLocation != null && !MapPixelLocationUtil.isDistanceAtMost(lastLocation, location, newArcIndicatorDistance)) {
                    view.doDisplayAnimationCells(cells, 30);
                }
                cells.add(new AnimationCell(new MapPixelLocation(location), image));
                lastLocation = location;
                ++i;
            }
            view.doDisplayAnimationCells(cells, 400);
            view.onTemporaryLightSourceRemoved();
        }
    }
}

