/*
 * Decompiled with CFR 0.152.
 */
package silmar;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import silmar.map.MapPixelDistance;
import silmar.map.MapTileDistance;
import silmar.tiles.TileSize;

public final class Sound
implements TileSize {
    private String fileName;
    private boolean activatesMonsters;
    private MapPixelDistance range;
    private List clips = new ArrayList();
    private static final MapTileDistance defaultTileRange = new MapTileDistance(15);
    public static Sound damage = new Sound("damage");
    public static Sound meleeAttack = new Sound("meleeAttack", false);
    public static Sound meleeAttackAlert = new Sound(null);
    public static Sound oldProjectile = new Sound("oldProjectile", false);
    public static Sound oldProjectileAlert = new Sound(null);
    public static Sound bullet = new Sound("bullet", new MapTileDistance(25), false);
    public static Sound bulletAlert = new Sound(null);
    public static Sound laserCell = new Sound("laserCell", false);
    public static Sound laserCellAlert = new Sound(null);
    public static Sound web = new Sound("web", false);
    public static Sound webAlert = new Sound(null);
    public static Sound fireballWhoosh = new Sound("fireballWhoosh", new MapTileDistance(20), false);
    public static Sound fireballWhooshAlert = new Sound(null);
    public static Sound electricity = new Sound("electricity", false);
    public static Sound electricityAlert = new Sound(null);
    public static Sound deathRay = new Sound("deathRay", false);
    public static Sound deathRayAlert = new Sound(null);
    public static Sound vortexBeam = new Sound("vortexBeam", new MapTileDistance(20), false);
    public static Sound vortexBeamAlert = new Sound(null);
    public static Sound grunt = new Sound("grunt");
    public static Sound gruntAlert = new Sound(null);
    public static Sound curePoison = new Sound("curePoison");
    public static Sound cureDisease = new Sound("cureDisease");
    public static Sound miss = new Sound("miss");
    public static Sound disintegration = new Sound("disintegration");
    public static Sound fireballBlast = new Sound("fireballBlast", new MapTileDistance(30));
    public static Sound heal = new Sound("heal");
    public static Sound laser = new Sound("laser");
    public static Sound lightning = new Sound("lightning", new MapTileDistance(20));
    public static Sound livingDeadRepel = new Sound("livingDeadRepelled");
    public static Sound markLocation = new Sound("markLocations");
    public static Sound flash = new Sound("flash");
    public static Sound powerCircle = new Sound("powerCircle");
    public static Sound radiation = new Sound("powerCircle", false);
    public static Sound radWave = new Sound("radWave", new MapTileDistance(25));
    public static Sound teleportIn = new Sound("teleportIn");
    public static Sound teleportOut = new Sound("teleportOut");
    public static Sound vacuumHole = new Sound("vacuumHole", new MapTileDistance(25), false);
    public static Sound dragonBreathed = new Sound("dragonBreathed", new MapTileDistance(25));
    public static Sound wallsClosing = new Sound("wallsClosing", new MapTileDistance(20), false);
    public static Sound wallsOpening = new Sound("wallsOpening", false);
    public static Sound wallsShut = new Sound("wallsShut", false);
    public static Sound waterAppears = new Sound("waterAppears", false);
    public static Sound waterDisappears = new Sound("waterDisappears", false);
    public static Sound doorAppears = new Sound("doorAppears");
    public static Sound deathFog = new Sound("deathFog");
    public static Sound vengefulSymbol = new Sound("vengefulSymbol");
    public static Sound landMinePlaced = new Sound("landMinePlaced");
    public static Sound trollBackToLife = new Sound("trollBackToLife");
    public static Sound machineBreaks = new Sound("machineBreaks");
    public static Sound monsterGenerated = new Sound("monsterGenerated", false);
    public static Sound exitAppears = new Sound("exitAppears");
    public static Sound playerDead = new Sound("playerDead");
    public static Sound atMap = new Sound("mapLoaded", false);
    public static Sound loadingLevel = new Sound("loadingLevel", false);
    public static Sound attributeLost = new Sound("attributeLost");
    public static Sound attributeGained = new Sound("attributeGained");
    public static Sound levelLost = new Sound("levelLost");
    public static Sound itemAdded = new Sound("itemAdded", false);
    public static Sound itemRemoved = new Sound("itemRemoved", false);
    public static Sound itemDamaged = new Sound("itemDamaged");
    public static Sound itemRepaired = new Sound("itemRepaired");
    public static Sound itemEquipped = new Sound("itemEquipped");
    public static Sound itemUnequipped = new Sound("itemUnequipped");
    public static Sound itemIdentified = new Sound("itemIdentified");
    public static Sound handsConfigSet = new Sound("handsConfigSet");
    public static Sound movement = new Sound("movement", new MapTileDistance(10));
    public static Sound trapSprung = new Sound("trapSprung", new MapTileDistance(20));
    public static Sound trapDetected = new Sound("trapDetected", false);
    public static Sound torchLit;
    public static Sound fire;
    public static Sound torchGoesOut;
    public static Sound itemLost;
    public static Sound superVision;
    public static Sound gremlin;
    public static Sound ghost;
    public static Sound killerCorpse;
    public static Sound guardianSword;
    public static Sound mirroredArmor;
    public static Sound slime;
    public static Sound blob;
    public static Sound sentryborg;
    public static Sound cetharg;
    public static Sound mercenary;
    public static Sound deathbot;
    public static Sound mutivider;
    public static Sound scumShamble;
    public static Sound atoman;
    public static Sound orc;
    public static Sound ogre;
    public static Sound cyclops;
    public static Sound redDragon;
    public static Sound acidDragon;
    public static Sound warpDemon;
    public static Sound earthElemental;
    public static Sound giantWorm;
    public static Sound bat;
    public static Sound slimeChucker;
    public static Sound cannibal;
    public static Sound gulp;
    public static Sound floatingSpheroid;
    public static Sound robotGenerator;
    public static Sound livingDeadWizard;
    public static Sound livingDeadWizard2;
    public static Sound confused;
    public static Sound title;
    public static Sound alarm;
    public static Sound gameFinished;
    public static Sound bionicStrength;
    public static Sound senseCreatures;
    public static Sound medicalRobot;
    public static Sound doorOpens;
    public static Sound doorCloses;
    public static Sound poof;
    public static Sound playerSaid;
    public static Sound ferrousGolem;
    public static Sound chestOpens;
    public static Sound itemBought;
    public static Sound itemSold;
    public static Sound itemDonated;
    public static Sound inWeb;
    public static Sound leap;
    public static Sound potionDrunk;
    public static Sound phylacteryOfResurrection;
    public static Sound retributiveShieldProjection;
    public static Sound monsterActivation;
    public static final int noXDelta = Integer.MAX_VALUE;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;

    private Sound(String fileName) {
        this(fileName, defaultTileRange);
    }

    private Sound(String fileName, MapTileDistance range) {
        this(fileName, range, true);
    }

    private Sound(String fileName, boolean activatesMonsters) {
        this(fileName, defaultTileRange, activatesMonsters);
    }

    private Sound(String fileName, MapTileDistance range, boolean activatesMonsters) {
        this.fileName = fileName;
        this.range = new MapPixelDistance(range.distance * TileSize.tileSize.width);
        this.activatesMonsters = activatesMonsters;
    }

    public void doPlay() {
        this.doPlay(null, Integer.MAX_VALUE);
    }

    public void doPlay(MapPixelDistance distance, int xDelta) {
        if (this.fileName == null) {
            return;
        }
        Line clip = null;
        int numClips = this.clips.size();
        for (int i = 0; i < numClips; ++i) {
            ClipWrapper test = (ClipWrapper)this.clips.get(i);
            if (test.playing) continue;
            clip = test.clip;
            test.playing = true;
            break;
        }
        if (clip == null) {
            AudioInputStream stream;
            URL url = ClassLoader.getSystemClassLoader().getResource("sounds/" + this.fileName + ".wav");
            try {
                stream = AudioSystem.getAudioInputStream(url);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            DataLine.Info info = null;
            AudioFormat format = stream.getFormat();
            info = new DataLine.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = Sound.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip, format);
            try {
                clip = (Clip)AudioSystem.getLine(info);
                clip.open(stream);
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            final ClipWrapper wrapper = new ClipWrapper((Clip)clip);
            clip.addLineListener(new LineListener(){

                public void update(LineEvent event) {
                    if (event.getType().equals(LineEvent.Type.STOP)) {
                        wrapper.clip.stop();
                        wrapper.clip.setFramePosition(0);
                        wrapper.playing = false;
                    }
                }
            });
            this.clips.add(wrapper);
        }
        float gain = 0.0f;
        if (distance != null) {
            FloatControl gainControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
            gain = Math.max(1.5f - 1.5f * (float)distance.distance / (float)this.range.distance, 0.1f);
            gain = Math.min(gain, 1.0f);
            double dB = Math.log(gain) / Math.log(10.0) * 20.0;
            gainControl.setValue((float)dB);
        }
        if (xDelta != Integer.MAX_VALUE) {
            FloatControl panControl = (FloatControl)clip.getControl(FloatControl.Type.PAN);
            panControl.setValue((float)xDelta / (float)distance.distance * (1.0f - gain) / 2.0f);
        }
        clip.start();
    }

    public boolean getActivatesMonsters() {
        return this.activatesMonsters;
    }

    public MapPixelDistance getRange() {
        return this.range;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        fire = torchLit = new Sound("torchLit");
        torchGoesOut = new Sound("torchGoesOut", false);
        itemLost = new Sound("itemLost", false);
        superVision = new Sound("superVision", false);
        gremlin = new Sound("gremlin", false);
        ghost = new Sound("ghost", false);
        killerCorpse = new Sound("killerCorpse", false);
        guardianSword = new Sound("guardianSword", false);
        mirroredArmor = new Sound("mirroredArmor", false);
        slime = new Sound("slime", false);
        blob = new Sound("blob", false);
        sentryborg = new Sound("sentryborg", false);
        cetharg = new Sound("cetharg", false);
        mercenary = new Sound("mercenary", false);
        deathbot = new Sound("deathbot", false);
        mutivider = new Sound("mutivider", false);
        scumShamble = new Sound("scumShamble", false);
        atoman = new Sound("atoman", false);
        orc = new Sound("orc", false);
        ogre = new Sound("ogre", false);
        cyclops = new Sound("cyclops", false);
        redDragon = new Sound("redDragon", false);
        acidDragon = new Sound("acidDragon", false);
        warpDemon = new Sound("warpDemon", false);
        earthElemental = new Sound("earthElemental", new MapTileDistance(20), false);
        giantWorm = new Sound("giantWorm", new MapTileDistance(20), false);
        bat = new Sound("bat", false);
        slimeChucker = new Sound("slimeChucker", false);
        cannibal = new Sound("cannibal", false);
        gulp = new Sound("gulp", false);
        floatingSpheroid = new Sound("floatingSpheroid", false);
        robotGenerator = new Sound("robotGenerator", false);
        livingDeadWizard = new Sound("livingDeadWizard", false);
        livingDeadWizard2 = new Sound("livingDeadWizard2", false);
        confused = new Sound("confused", false);
        title = new Sound("title", false);
        alarm = new Sound("alarm", new MapTileDistance(20));
        gameFinished = new Sound("gameFinished");
        bionicStrength = new Sound("bionicStrength", false);
        senseCreatures = new Sound("senseCreatures", false);
        medicalRobot = new Sound("medicalRobot", false);
        doorOpens = new Sound("doorOpens");
        doorCloses = new Sound("doorCloses");
        poof = new Sound("poof");
        playerSaid = new Sound("playerSaid");
        ferrousGolem = new Sound("ferrousGolem", false);
        chestOpens = new Sound("chestOpens");
        itemBought = itemRemoved;
        itemSold = new Sound("itemSold");
        itemDonated = new Sound("itemDonated");
        inWeb = new Sound("inWeb");
        leap = new Sound("leap");
        potionDrunk = new Sound("potionDrunk");
        phylacteryOfResurrection = new Sound("phylacteryOfResurrection");
        retributiveShieldProjection = new Sound("retributiveShieldProjection");
        monsterActivation = new Sound("monsterActivation");
        Sound.bulletAlert.range = Sound.bullet.range;
        Sound.fireballWhooshAlert.range = Sound.fireballWhoosh.range;
        Sound.vortexBeamAlert.range = Sound.vortexBeam.range;
    }

    private class ClipWrapper {
        public boolean playing = false;
        public Clip clip;

        public ClipWrapper(Clip clip) {
            this.clip = clip;
        }
    }
}

