/*
 * Decompiled with CFR 0.152.
 */
package patpack.stack;

import java.awt.Graphics;
import patpack.card.Card;
import patpack.stack.CardDrag;
import patpack.stack.CardStack;

public class CardSpread
extends CardStack {
    public static final int MULTIDRAG_NONE = 0;
    public static final int MULTIDRAG_SEQ = 1;
    public static final int MULTIDRAG_ANY = 2;
    public static final int MULTIDRAG_SUIT = 3;
    private int multiDrag = 0;
    private int offsetX = 0;
    private int offsetY = 16;

    public void setDragCheck(int colorCheck, int valueCheck, int emptyCheck) {
        this.dragColorCheck = colorCheck;
        this.dragValueCheck = valueCheck;
        this.dropEmptyCheck = emptyCheck;
    }

    public void setMultiDrag(int multiDrag) {
        this.multiDrag = multiDrag;
    }

    public void setSpread(int offX, int offY) {
        this.offsetX = offX;
        this.offsetY = offY;
    }

    public int select(int sx, int sy) {
        int dx = sx - this.x;
        int dy = sy - this.y;
        int size = this.stack.size();
        if (size <= 0) {
            if (dx >= 0 && dx < 71 && dy >= 0 && dy < 96) {
                return -2;
            }
            return -1;
        }
        dx -= (size - 1) * this.offsetX;
        dy -= (size - 1) * this.offsetY;
        int i = size - 1;
        while (i >= 0) {
            if (dx >= 0 && dx < 71 && dy >= 0 && dy < 96) {
                return i;
            }
            dx += this.offsetX;
            dy += this.offsetY;
            --i;
        }
        return -1;
    }

    public CardStack take(int cardPos) {
        if (cardPos < 0) {
            return null;
        }
        int size = this.stack.size();
        if (this.numFaceDown >= size) {
            return null;
        }
        if (!this.takeOkay(cardPos)) {
            return null;
        }
        CardSpread newStack = new CardSpread();
        int newX = this.x + cardPos * this.offsetX;
        int newY = this.y + cardPos * this.offsetY;
        newStack.init(this.game, newX, newY, ' ');
        newStack.setSpread(this.offsetX, this.offsetY);
        int i = cardPos;
        while (i < size) {
            newStack.add(this.getCard(cardPos));
            this.stack.remove(cardPos);
            ++i;
        }
        return newStack;
    }

    public boolean turn(int cardPos) {
        if (cardPos < 0) {
            return false;
        }
        int size = this.stack.size();
        if (this.numFaceDown < size) {
            return false;
        }
        if (cardPos != size - 1) {
            return false;
        }
        this.numFaceDown = cardPos;
        return true;
    }

    public boolean drop(int cardPos, CardDrag drag, boolean cheat) {
        if (!this.dropOkay(cardPos, drag) && !cheat) {
            return false;
        }
        this.add(cardPos + 1, drag.getDrag());
        return true;
    }

    protected boolean takeOkay(int cardPos) {
        if (this.autoDrop()) {
            return false;
        }
        int size = this.stack.size();
        if (cardPos < 0 || cardPos >= size) {
            return false;
        }
        if (cardPos < this.numFaceDown) {
            return false;
        }
        if (cardPos != size - 1 && this.multiDrag == 0) {
            return false;
        }
        if (this.multiDrag != 2) {
            Card c1 = this.getCard(cardPos);
            int i = cardPos + 1;
            while (i < size) {
                Card c2 = this.getCard(i);
                if (!CardDrag.dragMatch(this, c1, c2)) {
                    return false;
                }
                if (this.multiDrag == 3 && c1.getSuit() != c2.getSuit()) {
                    return false;
                }
                c1 = c2;
                ++i;
            }
        }
        return true;
    }

    protected boolean dropOkay(int cardPos, CardDrag drag) {
        CardStack s = drag.getSrc();
        if (s.getX() == this.x && s.getY() == this.y) {
            return false;
        }
        if (this.dropOnlyFromDeck && !s.isDeck()) {
            return false;
        }
        s = drag.getDrag();
        int size = this.stack.size();
        if (this.maxSize >= 0 && s.getSize() + size > this.maxSize) {
            return false;
        }
        if ((size <= 0 || cardPos != size - 1) && cardPos != -2) {
            return false;
        }
        if (s.getSize() != 1 && this.multiDrag == 0) {
            return false;
        }
        Card c = s.getCard(0);
        if (size > 0) {
            return CardDrag.dragMatch(this, this.getCard(cardPos), c);
        }
        return CardDrag.dropEmptyMatch(this, c);
    }

    public void draw(Graphics g) {
        int size = this.stack.size();
        if (size <= 0) {
            this.cardBase.draw(g, this.x, this.y);
            return;
        }
        int x = this.x;
        int y = this.y;
        int i = 0;
        while (i < size) {
            this.getCard(i).draw(g, x, y, i < this.numFaceDown);
            x += this.offsetX;
            y += this.offsetY;
            ++i;
        }
        if (this.mark != null) {
            this.mark.draw(g, x - this.offsetX, y - this.offsetY);
        }
    }
}

