/*
 * Decompiled with CFR 0.152.
 */
package patpack.scores;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import patpack.dice.Dice;
import patpack.scores.SingleScore;

public class YahtzeeScores
extends AbstractTableModel {
    static final int NUM_COLS = 2;
    static final int NUM_ROWS = 19;
    static final String[] COL_NAMES = new String[]{"Combinations", "Score"};
    static final String[] ROW_NAMES = new String[]{"Ones", "Twos", "Threes", "Fours", "Fives", "Sixes", "Sub-Total", "Bonus", "", "3 of Kind", "4 of Kind", "Full House", "Short Run", "Long Run", "Yahtzee", "Chance", "Sub-Total", "", "Grand Total"};
    SingleScore[] scores = new SingleScore[19];

    public YahtzeeScores() {
        this.resetScores();
    }

    public void resetScores() {
        int i = 0;
        while (i < 19) {
            this.scores[i] = new SingleScore();
            if (i >= 0 && i < 6) {
                this.scores[i].setTemp(true);
            }
            if (i >= 9 && i < 16) {
                this.scores[i].setTemp(true);
            }
            ++i;
        }
        this.updateTotals();
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return 19;
    }

    public String getColumnName(int col) {
        return COL_NAMES[col];
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return ROW_NAMES[row];
        }
        return this.scores[row];
    }

    public Class getColumnClass(int col) {
        return this.getValueAt(0, col).getClass();
    }

    public boolean allDone() {
        int i = 0;
        while (i < 19) {
            if (this.scores[i].isTemp()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getTotal() {
        return this.scores[18].getValue();
    }

    public boolean selectScore(int row) {
        if (row >= 19) {
            return false;
        }
        SingleScore sc = this.scores[row];
        if (!sc.isSet() || !sc.isTemp()) {
            return false;
        }
        sc.setTemp(false);
        this.updateTotals();
        int i = 0;
        while (i < 19) {
            if (this.scores[i].isTemp()) {
                if (i == 14 && this.scores[i].getValue() > 100) {
                    this.scores[i].setTemp(false);
                    this.scores[i].setValue(this.scores[14].getValue() - 100);
                } else {
                    this.scores[i].clearValue();
                }
            }
            ++i;
        }
        this.fireTableDataChanged();
        return true;
    }

    private void updateTotals() {
        int total = 0;
        int i = 0;
        while (i < 6) {
            if (!this.scores[i].isTemp()) {
                total += this.scores[i].getValue();
            }
            ++i;
        }
        this.scores[6].setValue(total);
        this.scores[7].setValue(total >= 63 ? 35 : 0);
        total = 0;
        int i2 = 9;
        while (i2 < 16) {
            if (!this.scores[i2].isTemp()) {
                total += this.scores[i2].getValue();
            }
            ++i2;
        }
        this.scores[16].setValue(total);
        total = this.scores[6].getValue() + this.scores[7].getValue() + this.scores[16].getValue();
        this.scores[18].setValue(total);
    }

    public void calc(ArrayList diceArray) {
        int[] num = new int[6];
        int i = 0;
        while (i < 6) {
            num[i] = 0;
            ++i;
        }
        int numPairs = 0;
        int numSeq = 0;
        int total = 0;
        int i2 = 1;
        while (i2 <= 5) {
            Dice dice = (Dice)diceArray.get(i2);
            int val = dice.getValue();
            int n = val - 1;
            num[n] = num[n] + val;
            total += val;
            int numAbove = 0;
            int numBelow = 0;
            int j = 1;
            while (j <= 5) {
                if (j != i2) {
                    Dice dice2 = (Dice)diceArray.get(j);
                    int val2 = dice2.getValue();
                    if (val2 == val) {
                        ++numPairs;
                    }
                    if (val2 == val + 1) {
                        ++numAbove;
                    }
                    if (val2 == val - 1) {
                        ++numBelow;
                    }
                }
                ++j;
            }
            numSeq += numAbove * numBelow;
            ++i2;
        }
        if ((numPairs /= 2) >= 2) {
            numSeq = 0;
        }
        if (numPairs == 1 && numSeq >= 3) {
            numSeq = 2;
        }
        int i3 = 0;
        while (i3 < 6) {
            if (this.scores[i3].isTemp()) {
                this.scores[i3].setValue(num[i3]);
            }
            ++i3;
        }
        if (this.scores[9].isTemp()) {
            this.scores[9].setValue(numPairs >= 3 ? total : 0);
        }
        if (this.scores[10].isTemp()) {
            this.scores[10].setValue(numPairs >= 6 ? total : 0);
        }
        if (this.scores[11].isTemp()) {
            this.scores[11].setValue(numPairs == 4 || numPairs == 10 ? 25 : 0);
        }
        if (this.scores[12].isTemp()) {
            this.scores[12].setValue(numSeq >= 2 ? 30 : 0);
        }
        if (this.scores[13].isTemp()) {
            this.scores[13].setValue(numSeq >= 3 ? 40 : 0);
        }
        if (this.scores[14].isTemp()) {
            this.scores[14].setValue(numPairs >= 10 ? 50 : 0);
        }
        if (this.scores[15].isTemp()) {
            this.scores[15].setValue(total);
        }
        if (numPairs >= 10 && !this.scores[14].isTemp() && this.scores[14].getValue() > 0) {
            this.scores[14].setValue(this.scores[14].getValue() + 100);
            this.scores[14].setTemp(true);
        }
        this.fireTableDataChanged();
    }
}

