/*
 * Decompiled with CFR 0.152.
 */
package patpack.scores;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import patpack.card.Card;
import patpack.scores.SingleScore;
import patpack.stack.CardStack;

public class CribScores
extends AbstractTableModel {
    static final int NUM_COLS = 2;
    static final int NUM_ROWS = 9;
    static final String[] COL_NAMES = new String[]{"Row / Column", "Score"};
    String[] names = new String[9];
    SingleScore[] scores = new SingleScore[9];

    public CribScores() {
        int i = 0;
        while (i < 4) {
            this.names[i] = "Row " + (i + 1);
            ++i;
        }
        int i2 = 4;
        while (i2 < 8) {
            this.names[i2] = "Column " + (i2 - 3);
            ++i2;
        }
        this.names[8] = "TOTAL";
        this.resetScores();
    }

    public void resetScores() {
        int i = 0;
        while (i < 9) {
            this.scores[i] = new SingleScore();
            ++i;
        }
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return 9;
    }

    public String getColumnName(int col) {
        return COL_NAMES[col];
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.names[row];
        }
        return this.scores[row];
    }

    public Class getColumnClass(int col) {
        return this.getValueAt(0, col).getClass();
    }

    public int calc(ArrayList cardStacks) {
        int tot = 0;
        int i = 0;
        while (i < 4) {
            int sc = this.calcEntry(cardStacks, i * 4 + 1, 1);
            this.scores[i].setValue(sc);
            tot += sc;
            ++i;
        }
        int i2 = 0;
        while (i2 < 4) {
            int sc = this.calcEntry(cardStacks, i2 + 1, 4);
            this.scores[i2 + 4].setValue(sc);
            tot += sc;
            ++i2;
        }
        this.scores[8].setValue(tot);
        this.fireTableDataChanged();
        return tot;
    }

    private int calcEntry(ArrayList cardStacks, int first, int inc) {
        int numSuit = 4;
        int numPairs = 0;
        int numSeq = 0;
        int score = 0;
        Card[] cards = new Card[5];
        int i = 0;
        while (i < 5) {
            int pos = i < 4 ? first + inc * i : 0;
            CardStack s = (CardStack)cardStacks.get(pos);
            cards[i] = s.getCard(0);
            if (i < 4 && numSuit > 0 && cards[i].getSuit() != cards[0].getSuit()) {
                numSuit = 0;
            }
            ++i;
        }
        char deckSuit = cards[4].getSuit();
        if (numSuit >= 4 && deckSuit == cards[0].getSuit()) {
            numSuit = 5;
        }
        score += numSuit;
        int i2 = 0;
        while (i2 < 5) {
            int val = cards[i2].getValue();
            if (i2 < 4 && val == 11 && cards[i2].getSuit() == deckSuit) {
                ++score;
            }
            int numAbove = 0;
            int numBelow = 0;
            int j = 0;
            while (j < 5) {
                if (j != i2) {
                    int val2 = cards[j].getValue();
                    if (val2 == val) {
                        ++numPairs;
                    }
                    if (val2 == val + 1) {
                        ++numAbove;
                    }
                    if (val2 == val - 1) {
                        ++numBelow;
                    }
                }
                ++j;
            }
            numSeq += numAbove * numBelow;
            ++i2;
        }
        score += 2 * (numPairs /= 2);
        if (numSeq > 0) {
            score = numPairs == 0 ? (score += numSeq + 2) : (numPairs == 1 && numSeq >= 3 ? (score += 8) : (score += 3 * numSeq));
        }
        return score += 2 * this.calc15s(cards);
    }

    private int calc15s(Card[] cards) {
        int num15s = 0;
        int[] vals = new int[5];
        int i = 0;
        while (i < 5) {
            vals[i] = cards[i].getValue();
            if (vals[i] > 10) {
                vals[i] = 10;
            }
            ++i;
        }
        int i1 = 0;
        while (i1 < 5) {
            int v1 = vals[i1];
            int i2 = i1 + 1;
            while (i2 < 5) {
                int v2 = v1 + vals[i2];
                if (v2 == 15) {
                    ++num15s;
                }
                if (v2 < 15) {
                    int i3 = i2 + 1;
                    while (i3 < 5) {
                        int v3 = v2 + vals[i3];
                        if (v3 == 15) {
                            ++num15s;
                        }
                        if (v3 < 15) {
                            int i4 = i3 + 1;
                            while (i4 < 5) {
                                int v4 = v3 + vals[i4];
                                if (v4 == 15) {
                                    ++num15s;
                                }
                                if (i4 == 3 && v4 + vals[4] == 15) {
                                    ++num15s;
                                }
                                ++i4;
                            }
                        }
                        ++i3;
                    }
                }
                ++i2;
            }
            ++i1;
        }
        return num15s;
    }
}

