/*
 * Decompiled with CFR 0.152.
 */
package patpack.game;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import patpack.dice.Dice;
import patpack.game.DiceGame;

public class Ladybird
extends DiceGame
implements ActionListener {
    private static final int END_SCORE = 35;
    private static final Color[] LadyColors = new Color[]{Color.green, Color.blue, Color.magenta, Color.red, Color.orange, Color.yellow};
    private static final String[] LadyNames = new String[]{"GREEN", "BLUE", "PURPLE", "RED", "ORANGE", "YELLOW"};
    private int[] LadyScores;
    private int[] LadyFlames;
    private ImageIcon[] LadyIcons;
    private ImageIcon[] HouseIcons;
    private ImageIcon[] FlameIcons;
    private Timer flameTimer = null;

    public void start() {
        super.start();
        this.LadyScores = new int[6];
        this.LadyFlames = new int[6];
        this.LadyIcons = new ImageIcon[6];
        this.HouseIcons = new ImageIcon[6];
        int i = 0;
        while (i < 6) {
            this.LadyScores[i] = 0;
            this.LadyFlames[i] = this.getRandom(6);
            this.LadyIcons[i] = this.loadIcon("dice/l/" + (i + 1) + ".gif");
            this.HouseIcons[i] = this.loadIcon("dice/l/h/" + (i + 1) + ".gif");
            ++i;
        }
        this.FlameIcons = new ImageIcon[6];
        int i2 = 0;
        while (i2 < 6) {
            this.FlameIcons[i2] = this.loadIcon("dice/l/f/" + (i2 + 1) + ".gif");
            ++i2;
        }
        Dice roll = new Dice(this, 600, 400, false);
        roll.setStyle('r');
        roll.setValue(1);
        this.diceArray.add(roll);
        int i3 = 0;
        while (i3 < 2) {
            Dice dice = new Dice(this, 0, 0, false);
            if (i3 == 0) {
                dice.setStyle('l');
            }
            this.diceArray.add(dice);
            ++i3;
        }
        this.flameTimer = new Timer(200, this);
        this.flameTimer.start();
    }

    public boolean diceMark(int numDice) {
        if (numDice == 0) {
            this.diceRoll();
        }
        return true;
    }

    public void diceRoll() {
        int lady = 0;
        int val = 0;
        int cx = 40 + this.getRandom(200);
        int cy = 320 + this.getRandom(100);
        int i = 1;
        while (i <= 2) {
            Dice dice = (Dice)this.diceArray.get(i);
            int x = cx + 120 * (i - 1) + this.getRandom(50);
            int y = cy + this.getRandom(80);
            dice.move(x, y);
            dice.setValue(this.getRandom(6) + 1);
            if (i == 1) {
                lady = dice.getValue() - 1;
            }
            if (i == 2) {
                val = dice.getValue();
            }
            ++i;
        }
        int n = lady;
        this.LadyScores[n] = this.LadyScores[n] + val;
        if (this.LadyScores[lady] > 35) {
            this.LadyScores[lady] = 35;
        }
        this.updateStatus();
    }

    public void updateStatus() {
        if (this.isFinished() || this.isFailed()) {
            return;
        }
        int winner = -1;
        int i = 0;
        while (i < 6) {
            if (this.LadyScores[i] >= 35) {
                winner = i;
            }
            ++i;
        }
        if (winner >= 0) {
            this.setFailed("The " + LadyNames[winner] + " ladybird won the race");
        }
    }

    public void actionPerformed(ActionEvent evt) {
        int i = 0;
        while (i < 6) {
            this.LadyFlames[i] = (this.LadyFlames[i] + 1) % 6;
            ++i;
        }
        this.getTable().repaint();
    }

    public void draw(Graphics g) {
        super.draw(g);
        int i = 0;
        while (i < 6) {
            int x = 32;
            int y = 32 + 48 * i;
            g.setPaintMode();
            g.setColor(LadyColors[i]);
            int j = 0;
            while (j < this.LadyScores[i]) {
                g.fillOval(x + j * 20 - 4, y - 4, 8, 8);
                ++j;
            }
            g.setColor(Color.darkGray);
            int j2 = this.LadyScores[i] + 1;
            while (j2 < 35) {
                g.fillOval(x + j2 * 20 - 4, y - 4, 8, 8);
                ++j2;
            }
            this.HouseIcons[i].paintIcon(this.getTable(), g, x + 700 - 12, y - 16);
            if (this.LadyScores[i] < 35) {
                int flame = this.LadyFlames[i];
                this.FlameIcons[flame].paintIcon(this.getTable(), g, x + 700 - 12, y - 16);
                this.LadyIcons[i].paintIcon(this.getTable(), g, x + 20 * this.LadyScores[i] - 32, y - 32);
            }
            ++i;
        }
    }
}

