/*
 * Decompiled with CFR 0.152.
 */
package patpack.game;

import java.util.HashMap;
import patpack.game.Game;

public class GameFactory {
    private static HashMap labelMap = new HashMap();
    private static HashMap typeMap = new HashMap();

    public static void add(String name, String label) {
        if (label == null) {
            label = name;
        }
        labelMap.put(label, name);
    }

    public static void setType(String name, String type) {
        typeMap.put(name, type);
    }

    public static String getType(String name) {
        String type = (String)typeMap.get(name);
        if (type == null) {
            type = "patpack";
        }
        return type;
    }

    public static HashMap getLabelMap() {
        return labelMap;
    }

    public static Game newGame(String name) {
        try {
            String cname = "patpack.game." + name;
            if (cname != null) {
                return (Game)Class.forName(cname).newInstance();
            }
        }
        catch (Exception e) {
            System.out.println("Error " + e.toString());
        }
        return new Game();
    }

    static {
        GameFactory.add("Accordion", null);
        GameFactory.add("Baroness", null);
        GameFactory.add("BlackHole", "Black Hole");
        GameFactory.add("Calculation", null);
        GameFactory.add("Canfield", null);
        GameFactory.add("Carpet", null);
        GameFactory.add("Castle", null);
        GameFactory.add("Chameleon", null);
        GameFactory.add("Clock", null);
        GameFactory.add("Cribbage", null);
        GameFactory.add("DaisyChains", "Daisy Chains");
        GameFactory.add("Dimensions", null);
        GameFactory.add("Discard", null);
        GameFactory.add("Elevens", null);
        GameFactory.add("Emperor", null);
        GameFactory.add("Families", null);
        GameFactory.add("Fives", null);
        GameFactory.add("FlipEm", "Flip'Em");
        GameFactory.add("FlowerBed", "Flower Bed");
        GameFactory.add("FourSeasons", "Four Seasons");
        GameFactory.add("Golf", null);
        GameFactory.add("Gravity", null);
        GameFactory.add("Hanoy", null);
        GameFactory.add("Helena", "St. Helena");
        GameFactory.add("HigherLower", "Higher / Lower");
        GameFactory.add("Hurricane", null);
        GameFactory.add("Interregnum", null);
        GameFactory.add("KingsCorners", "Kings Corners");
        GameFactory.add("Klondike", null);
        GameFactory.add("Ladybird", "Ladybird Run");
        GameFactory.add("LineUp", "Line Up");
        GameFactory.add("LSpider", "Little Spider");
        GameFactory.add("Lucky13", "Lucky Thirteen");
        GameFactory.add("Maire", null);
        GameFactory.add("MeanDeal", "Mean Deal");
        GameFactory.add("Milligan", "Miss Milligan");
        GameFactory.add("MonteCarlo", "Monte Carlo");
        GameFactory.add("NeuralNet", "Neural Net");
        GameFactory.add("OddsEvens", "Odds & Evens");
        GameFactory.add("Osmosis", null);
        GameFactory.add("Pairs", null);
        GameFactory.add("Perpetual", null);
        GameFactory.add("Pigs", null);
        GameFactory.add("PileSort", "Pile Sort");
        GameFactory.add("Pohtzee", null);
        GameFactory.add("Poker", null);
        GameFactory.add("Pyramid", null);
        GameFactory.add("QuickSand", "Quick Sand");
        GameFactory.add("RollOut", "Roll Out");
        GameFactory.add("Scorpion", null);
        GameFactory.add("SirTommy", "Sir Tommy");
        GameFactory.add("Spiders", null);
        GameFactory.add("SquareLines", "Square Lines");
        GameFactory.add("SteelWheels", "Steel Wheels");
        GameFactory.add("Strategy", null);
        GameFactory.add("Sultan", null);
        GameFactory.add("Towers", null);
        GameFactory.add("Wanderers", null);
        GameFactory.add("Windmill", null);
        GameFactory.add("Yahtzee", null);
        GameFactory.setType("Ladybird", "dice");
        GameFactory.setType("NeuralNet", "dice");
        GameFactory.setType("Pigs", "dice");
        GameFactory.setType("RollOut", "dice");
        GameFactory.setType("SquareLines", "dice");
        GameFactory.setType("Yahtzee", "dice");
    }
}

