/*
 * Decompiled with CFR 0.152.
 */
package patpack.game;

import java.awt.Graphics;
import java.util.Date;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import patpack.applet.PatPack;
import patpack.applet.Table;

public class Game {
    protected boolean cheat = false;
    protected PatPack patpack = null;
    protected Table table = null;
    protected long randSeed = new Date().getTime();
    protected Random random = null;
    private boolean finished = false;
    private boolean failed = false;

    public void destroy() {
        this.patpack.getScores().init(null);
        this.patpack = null;
        this.table = null;
    }

    public void setTable(PatPack patpack, Table table) {
        this.patpack = patpack;
        this.table = table;
        this.table.removeAll();
        this.initScores();
    }

    protected void initScores() {
        this.patpack.getScores().init(null);
    }

    public JPanel getTable() {
        return this.table;
    }

    public void start() {
        this.finished = false;
        this.failed = false;
        this.random = new Random(this.randSeed);
        this.enableUndo(false);
        this.table.repaint();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished() {
        this.enableUndo(false);
        this.patpack.showDialog("You successfully completed this game", 1);
        this.finished = true;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(String msg) {
        this.enableUndo(false);
        this.patpack.showDialog(msg, 2);
        this.failed = true;
    }

    public Random getRandom() {
        return this.random;
    }

    public int getRandom(int num) {
        long rand = this.random.nextInt();
        if (rand < 0L) {
            rand = -rand;
        }
        return (int)(rand % (long)num);
    }

    public ImageIcon loadIcon(String path) {
        return this.patpack.loadIcon(path);
    }

    public void enableUndo(boolean enable) {
        this.patpack.enableUndo(enable);
    }

    public boolean mousePress(int x, int y) {
        return false;
    }

    public boolean mouseRelease(int x, int y) {
        return false;
    }

    public boolean mouseClick(int x, int y) {
        return false;
    }

    public boolean mouseDblClick(int x, int y) {
        return false;
    }

    public boolean mouseDrag(int x, int y) {
        return false;
    }

    public void undo() {
    }

    public void selectScore(int row) {
    }

    public void draw(Graphics g) {
    }
}

