/*
 * Decompiled with CFR 0.152.
 */
package patpack.game;

import patpack.game.CardGame;
import patpack.scores.CribScores;
import patpack.stack.CardDeck;
import patpack.stack.CardPile;
import patpack.stack.CardStack;

public class Cribbage
extends CardGame {
    private CribScores scores = null;

    protected void initScores() {
        this.scores = new CribScores();
        this.patpack.getScores().init(this.scores);
    }

    public void start() {
        super.start();
        CardDeck deck = new CardDeck();
        deck.init(this, 40, 190, 'd');
        deck.initDeck(1, 3, 0);
        this.cardStacks.add(deck);
        int j = 0;
        while (j < 4) {
            int i = 0;
            while (i < 4) {
                CardPile pile = new CardPile();
                int x = 240 + 75 * i;
                int y = 40 + 100 * j;
                pile.init(this, x, y, 'g');
                pile.setDragCheck(0, 0, 3);
                pile.setAutoDrop(true);
                this.cardStacks.add(pile);
                ++i;
            }
            ++j;
        }
        this.scores.resetScores();
    }

    public void updateStatus() {
        if (this.isFinished() || this.isFailed()) {
            return;
        }
        boolean done = true;
        int i = this.cardStacks.size() - 1;
        while (i >= 0) {
            CardStack s = (CardStack)this.cardStacks.get(i);
            if (s.getSize() == 0) {
                done = false;
            }
            if (i == 0 && s.numFaceDown() == s.getSize()) {
                done = false;
            }
            --i;
        }
        if (done) {
            int score = this.scores.calc(this.cardStacks);
            if (score >= 61) {
                this.setFinished();
            } else {
                this.setFailed("You failed to get 61 or more points");
            }
        }
        super.updateStatus();
    }
}

