/*
 * Decompiled with CFR 0.152.
 */
package patpack.applet;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Date;
import javax.swing.JPanel;
import patpack.applet.PatPack;
import patpack.game.Game;

public class Table
extends JPanel
implements MouseListener,
MouseMotionListener {
    private PatPack patpack = null;
    private long ClickTime = 0L;
    private int ClickCount = 0;
    private int ClickX = 0;
    private int ClickY = 0;
    private static final int CLICK_DELTA = 2;
    private static final long CLICK_TIME = 1000L;

    public Table(PatPack patpack) {
        this.patpack = patpack;
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setColor(String tableColor) {
        Color color = Color.decode(tableColor);
        this.setBackground(color);
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        red = red >= 128 ? 0 : 255;
        green = green >= 128 ? 0 : 255;
        blue = blue >= 128 ? 0 : 255;
        this.setForeground(new Color(red, green, blue));
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        int ex = e.getX();
        int ey = e.getY();
        if (this.patpack.getGame().mousePress(ex, ey)) {
            this.repaint();
        }
        long now = new Date().getTime();
        if (this.ClickCount == 1 && now <= this.ClickTime + 1000L && ex >= this.ClickX - 2 && ex <= this.ClickX + 2 && ey >= this.ClickY - 2 && ey <= this.ClickY + 2) {
            ++this.ClickCount;
        } else {
            this.ClickTime = now;
            this.ClickCount = 1;
            this.ClickX = ex;
            this.ClickY = ey;
        }
    }

    public void mouseReleased(MouseEvent e) {
        long now;
        int ex = e.getX();
        int ey = e.getY();
        if (this.patpack.getGame().mouseRelease(ex, ey)) {
            this.repaint();
        }
        if ((now = new Date().getTime()) > this.ClickTime + 1000L || ex < this.ClickX - 2 || ex > this.ClickX + 2 || ey < this.ClickY - 2 || ey > this.ClickY + 2) {
            this.ClickCount = 0;
        } else if (this.ClickCount <= 1) {
            if (this.patpack.getGame().mouseClick(this.ClickX, this.ClickY)) {
                this.ClickCount = 0;
                this.repaint();
            }
        } else {
            if (this.patpack.getGame().mouseDblClick(this.ClickX, this.ClickY)) {
                this.repaint();
            }
            this.ClickCount = 0;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.patpack.getGame().mouseDrag(e.getX(), e.getY())) {
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Game game = this.patpack.getGame();
        if (game != null) {
            game.draw(g);
        }
    }
}

