/*
 * Decompiled with CFR 0.152.
 */
package patpack.applet;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import patpack.applet.PatPack;

public class MenuBar
extends JMenuBar
implements ActionListener {
    private PatPack patpack = null;
    private JMenu gameMenu = null;
    private JMenu editMenu = null;
    private JMenu cardMenu = null;
    private JMenu tableMenu = null;
    private JMenu helpMenu = null;
    private JMenuItem undoItem = null;
    private JMenuItem helpItem = null;

    public MenuBar(PatPack patpack) {
        this.patpack = patpack;
        this.gameMenu = this.newGameMenu();
        this.add(this.gameMenu);
        this.editMenu = this.newEditMenu();
        this.add(this.editMenu);
        this.cardMenu = this.newCardsMenu();
        this.add(this.cardMenu);
        this.tableMenu = this.newTableMenu();
        this.add(this.tableMenu);
        this.helpMenu = this.newHelpMenu();
        this.add(this.helpMenu);
    }

    private JMenu newGameMenu() {
        JMenu menu = new JMenu("Game");
        menu.setMnemonic(71);
        JMenuItem item = new JMenuItem("New Game", 78);
        item.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        item.setActionCommand("newgame");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Restart Game", 82);
        item.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        item.setActionCommand("restart");
        item.addActionListener(this);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Exit Game", 69);
        item.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        item.setActionCommand("another");
        item.addActionListener(this);
        menu.add(item);
        return menu;
    }

    private JMenu newEditMenu() {
        JMenu menu = new JMenu("Edit");
        menu.setMnemonic(69);
        JMenuItem item = new JMenuItem("Undo", 85);
        item.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        item.setActionCommand("undo");
        item.addActionListener(this);
        this.undoItem = item;
        menu.add(item);
        return menu;
    }

    private JMenu newCardsMenu() {
        BackOption[] backOptions = new BackOption[]{new BackOption("Purple", 80), new BackOption("Olive", 79), new BackOption("Gray", 71), new BackOption("Blue Chain", 66), new BackOption("Mountains", 77), new BackOption("Roses", 83), new BackOption("Fish", 70), new BackOption("Robot", 82)};
        JMenu menu = new JMenu("Cards");
        menu.setMnemonic(67);
        ButtonGroup bg = new ButtonGroup();
        int i = 0;
        while (i < backOptions.length) {
            JRadioButtonMenuItem rad = new JRadioButtonMenuItem(backOptions[i].name, i == 0);
            rad.setMnemonic(backOptions[i].mnem);
            rad.setActionCommand("back" + (i + 1));
            rad.addActionListener(this);
            menu.add(rad);
            bg.add(rad);
            ++i;
        }
        return menu;
    }

    private JMenu newTableMenu() {
        ClrOption[] clrOptions = new ClrOption[]{new ClrOption("Red", 82, "800000"), new ClrOption("Green", 71, "008000"), new ClrOption("Blue", 66, "000080"), new ClrOption("Gold", 76, "FFC000"), new ClrOption("Silver", 83, "C0C0C0")};
        JMenu menu = new JMenu("Table");
        menu.setMnemonic(84);
        ButtonGroup bg = new ButtonGroup();
        int i = 0;
        while (i < clrOptions.length) {
            JRadioButtonMenuItem rad = new JRadioButtonMenuItem(clrOptions[i].name, i == 1);
            rad.setMnemonic(clrOptions[i].mnem);
            rad.setActionCommand("color" + clrOptions[i].clr);
            rad.addActionListener(this);
            menu.add(rad);
            bg.add(rad);
            ++i;
        }
        return menu;
    }

    private JMenu newHelpMenu() {
        JMenu menu = new JMenu("Help");
        menu.setMnemonic(72);
        JMenuItem item = new JMenuItem("Overview", 79);
        item.setActionCommand("overview");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Help", 72);
        item.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        item.setActionCommand("help");
        item.addActionListener(this);
        this.helpItem = item;
        menu.add(item);
        item = new JMenuItem("More ...", 77);
        item.setActionCommand("more");
        item.addActionListener(this);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("About PatPack", 65);
        item.setActionCommand("about");
        item.addActionListener(this);
        menu.add(item);
        return menu;
    }

    public void actionPerformed(ActionEvent e) {
        this.patpack.menuAction(e.getActionCommand());
    }

    public void enableGame(boolean enable) {
        this.gameMenu.setEnabled(enable);
        this.editMenu.setEnabled(enable);
        this.cardMenu.setEnabled(enable);
        this.tableMenu.setEnabled(enable);
    }

    public void enableHelp(boolean enable) {
        this.helpItem.setEnabled(enable);
    }

    public void enableUndo(boolean enable) {
        this.undoItem.setEnabled(enable);
    }

    class ClrOption {
        public String name;
        public int mnem;
        public String clr;

        public ClrOption(String n, int m, String c) {
            this.name = n;
            this.mnem = m;
            this.clr = c;
        }
    }

    class BackOption {
        public String name;
        public int mnem;

        public BackOption(String n, int m) {
            this.name = n;
            this.mnem = m;
        }
    }
}

