/*
 * Decompiled with CFR 0.152.
 */
package WizSolitaire.Games;

import WizSolitaire.Card;
import WizSolitaire.CardGame;
import WizSolitaire.CardWrapper;
import WizSolitaire.Deck;
import WizSolitaire.GameTable;
import WizSolitaire.TableCell;
import WizSolitaire.UndoStep;

public class Pyramid
extends CardGame {
    private int a;
    private CardWrapper b = null;

    public Pyramid(Deck deck, GameTable gameTable, int n2, int n3) {
        super("Pyramid", deck, gameTable, n2, n3);
    }

    protected void SetupCells() {
        TableCell tableCell;
        for (int i2 = 0; i2 < 28; ++i2) {
            tableCell = new TableCell();
            tableCell.Reset(2);
            this.Table.AddCell(tableCell);
        }
        this.Table.AddCell(new TableCell());
        this.Table.AddCell(new TableCell());
        tableCell = new TableCell();
        tableCell.Reset(0);
        this.Table.AddCell(tableCell);
    }

    protected void Layout() {
        int n2;
        int n3 = 0;
        this.Table.Resize(12 + (6 + this.CardWidth) * 7, 10 + (4 + this.CardHeight / 3) * 6 + this.CardHeight);
        ++n3;
        this.Table.GetCell(0).SetPos(6 + 3 * (6 + this.CardWidth), 5);
        for (n2 = 2; n2 < 4; ++n2) {
            this.Table.GetCell(n3++).SetPos(6 + this.CardWidth / 2 + n2 * (6 + this.CardWidth), 5 + (4 + this.CardHeight / 3));
        }
        for (n2 = 2; n2 < 5; ++n2) {
            this.Table.GetCell(n3++).SetPos(6 + n2 * (6 + this.CardWidth), 5 + (4 + this.CardHeight / 3 << 1));
        }
        for (n2 = 1; n2 < 5; ++n2) {
            this.Table.GetCell(n3++).SetPos(6 + this.CardWidth / 2 + n2 * (6 + this.CardWidth), 5 + (4 + this.CardHeight / 3) * 3);
        }
        for (n2 = 1; n2 < 6; ++n2) {
            this.Table.GetCell(n3++).SetPos(6 + n2 * (6 + this.CardWidth), 5 + (4 + this.CardHeight / 3 << 2));
        }
        for (n2 = 0; n2 < 6; ++n2) {
            this.Table.GetCell(n3++).SetPos(6 + this.CardWidth / 2 + n2 * (6 + this.CardWidth), 5 + (4 + this.CardHeight / 3) * 5);
        }
        for (n2 = 0; n2 < 7; ++n2) {
            this.Table.GetCell(n3++).SetPos(6 + n2 * (6 + this.CardWidth), 5 + (4 + this.CardHeight / 3) * 6);
        }
        this.Table.GetCell(28).SetPos(6, 5);
        this.Table.GetCell(29).SetPos(6 + 6 * (6 + this.CardWidth), 5);
        this.Table.GetCell(30).SetPos(0, 0);
    }

    protected void PlaceCards() {
        CardWrapper cardWrapper;
        TableCell tableCell;
        Card card;
        int n2;
        for (n2 = 0; n2 < 28; ++n2) {
            card = this.MyDeck.Pick();
            tableCell = this.Table.GetCell(n2);
            cardWrapper = this.Table.WrapCard(card);
            tableCell.AddCard(cardWrapper);
            cardWrapper.SetFrontUp(true);
        }
        tableCell = this.Table.GetCell(28);
        for (n2 = 24; n2 > 0; --n2) {
            card = this.MyDeck.Pick();
            cardWrapper = this.Table.WrapCard(card);
            tableCell.AddCard(cardWrapper);
            cardWrapper.SetFrontUp(false);
        }
        tableCell.GetWrapper(-1).SetFrontUp(true);
        this.a = 0;
        this.b = null;
        this.Table.StatusMsg("Cards removed: 0");
    }

    public void CardDblClick(CardWrapper cardWrapper, int n2, int n3) {
        TableCell tableCell;
        CardWrapper cardWrapper2;
        if (n2 == 28 && (cardWrapper2 = (tableCell = this.Table.GetCell(n2)).GetWrapper(-1)) != null) {
            UndoStep undoStep = this.NewMove();
            cardWrapper2.ClearFlags(4);
            undoStep.AddMove(cardWrapper2, tableCell);
            this.Table.GetCell(29).AddCard(cardWrapper2);
            this.b = null;
            cardWrapper2 = tableCell.GetWrapper(-1);
            if (cardWrapper2 != null) {
                undoStep.AddCard(cardWrapper2);
                cardWrapper2.SetFrontUp(true);
            }
            this.AddUndo(undoStep);
        }
    }

    public void CardClick(CardWrapper cardWrapper, int n2, int n3) {
        UndoStep undoStep = this.NewMove();
        if (cardWrapper != null) {
            if (cardWrapper.HasFlags(4)) {
                cardWrapper.ClearFlags(4);
                this.b = null;
            } else if (this.b != null) {
                this.h(n2, cardWrapper, undoStep);
            } else if (this.g(n2)) {
                if (cardWrapper.GetCard().GetValue() == 13) {
                    undoStep.AddMove(cardWrapper);
                    this.Table.GetCell(30).AddCard(cardWrapper);
                    cardWrapper = this.Table.GetCell(28).GetWrapper(-1);
                    if (cardWrapper != null) {
                        undoStep.AddCard(cardWrapper);
                        cardWrapper.SetFrontUp(true);
                    }
                    ++this.a;
                } else {
                    cardWrapper.AddFlags(4);
                    this.b = cardWrapper;
                }
            } else {
                this.Beep();
            }
            this.Table.StatusMsg("Cards removed: " + this.a);
            this.Table.repaint();
            if (this.a >= 52) {
                this.GameOver(true);
            }
        } else if (n2 == 28) {
            this.i(undoStep);
        }
        this.AddUndo(undoStep);
    }

    private boolean g(int n2) {
        boolean bl = true;
        if (n2 < 21) {
            int[] nArray = new int[]{0, 1, 3, 6, 10, 15, 21};
            int n3 = 0;
            while (nArray[n3] <= n2) {
                ++n3;
            }
            int n4 = n2 - nArray[n3 - 1];
            bl = this.Table.GetCell(n3 = nArray[n3] + n4).GetWrapper(-1) == null && this.Table.GetCell(n3 + 1).GetWrapper(-1) == null;
        }
        return bl;
    }

    private void h(int n2, CardWrapper cardWrapper, UndoStep undoStep) {
        if (this.g(n2) && this.b.GetCard().GetValue() + cardWrapper.GetCard().GetValue() == 13) {
            TableCell tableCell = this.Table.GetCell(30);
            this.b.ClearFlags(4);
            undoStep.AddMove(this.b);
            undoStep.AddMove(cardWrapper);
            tableCell.AddCard(this.b);
            tableCell.AddCard(cardWrapper);
            this.a += 2;
            this.b = null;
            CardWrapper cardWrapper2 = this.Table.GetCell(28).GetWrapper(-1);
            if (cardWrapper2 != null) {
                undoStep.AddCard(cardWrapper2);
                cardWrapper2.SetFrontUp(true);
            }
            return;
        }
        this.Beep();
    }

    private void i(UndoStep undoStep) {
        TableCell tableCell = this.Table.GetCell(28);
        if (tableCell.GetWrapper(-1) == null) {
            CardWrapper cardWrapper;
            TableCell tableCell2 = this.Table.GetCell(29);
            while ((cardWrapper = tableCell2.GetWrapper(-1)) != null) {
                undoStep.AddMove(cardWrapper, tableCell2);
                cardWrapper.SetFrontUp(false);
                tableCell.AddCard(cardWrapper);
            }
            cardWrapper = tableCell.GetWrapper(-1);
            if (cardWrapper != null) {
                undoStep.AddCard(cardWrapper);
                cardWrapper.SetFrontUp(true);
            }
        }
    }

    public void Undo() {
        super.Undo();
        if (this.b != null) {
            this.b.ClearFlags(4);
        }
        this.b = null;
        this.a = this.Table.GetCell(30).GetCardsCount();
        this.Table.StatusMsg("Cards removed: " + this.a);
    }
}

