/*
 * @(#)AddWindowClosingListenerExample.java	
 *
 * Product Of	: MakeLogic
 * URL			: http://www.makelogic.com
 * Author		: R.Venkatesh
 * Date			: 20 June, 2003
 * email		: venkat@makelogicmldb.com
 * 
 * Please feel free to use this Sample Code in your applications.
 */

/*
 * This sample Application Demonstrates how to use the FileMenu's
 * getDefaultClosingListener method while adding WindowListener
 * to Sample Application to handle the Window closing.
 * 
 * getDefaultClosingListener method will return windowListener
 * which takes care of File Saving,etc., * when the Application
 *  Window Closes.
 */

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;

import com.makeLogic.utils.FileMenu;

class AddWindowClosingListener extends JFrame 
{
	JMenuBar menuBar;
	JDesktopPane desktop;

	AddWindowClosingListener(String title)
	{
		//..calls the super class constructor
		super(title);
		//..MenuBar
		menuBar = new JMenuBar();
		//..Container
		desktop=new JDesktopPane();
		
		//..Gets the ContentPane of the JFrame and adds the container to the center
		getContentPane().add("Center",desktop);

		//..Creates a FileMenu Object
		//..The following two lines of code is sufficient to create complete FileMenu Object
		//..and adds it to the MenuBar
		FileMenu fileMenu=new FileMenu(desktop);

		//..add the fileMenu object to the JMenuBar
		menuBar.add(fileMenu);

		//..adds the MenuBar to the frame
		setJMenuBar(menuBar);

		//..window closing Listener
		//..getDefaultClosingListener will return the WindowListener 
		//..handles the windwoClosing Event and takes care of 
		//..File Saving,etc., at the time of window closing
		addWindowListener(fileMenu.getDefaultClosingListener());
				
	}
	
}
public class AddWindowClosingListenerExample
{

	public static void main(String args[])
	{
		AddWindowClosingListener addWindowClosingListener=new AddWindowClosingListener("Add Window Closing Example");
		addWindowClosingListener.show();
		addWindowClosingListener.setSize(500,500);
		addWindowClosingListener.validate();
	}

}


