/*
 * @(#)OpenMenuItem.java	1.1 11/17/2003
 *
 * Copyright 2003 MakeLogic, Inc. All rights reserved.
 * MakeLogic PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)OpenMenuItem.java	1.1
 *
 * Author : R.Venkatesh
 * Copyright 2003 MakeLogic. All Rights Reserved.
 *
 * This software is the proprietary information of MakeLogic.
 * Use is subject to license terms.
 * 
 *
 */

package com.makeLogic.utils;

import java.awt.Container;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.io.File;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import java.lang.StringBuffer;

import java.util.Hashtable;
import java.util.Vector;

import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;

import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

import com.makeLogic.utils.FileMenu;

/**
 * Open MenuItem is one of the MenuItems of FileMenu.<br>
 * Open a FileChooser to select the File and Click on OK<br>
 * to display its contents into a JInternalFrame.
 * 
 */



public class OpenMenuItem extends JMenuItem implements ActionListener
{
	//..Declaration
	Container container;
	Hashtable internalFramesOpenFileNames;
	Vector recentFileEntries;

	//.. constructor 
	OpenMenuItem(Container container)
	{	
		//..calls super class constructor with Open as MenuItem name
		super("Open");

		//..sets the default Accelerator as CTRl+O to OpenMenuItem
		setAccelerator(KeyStroke.getKeyStroke('O',java.awt.Event.CTRL_MASK,false));
		
		//..adds Listener class to the OpenMenuItem
		addActionListener(this);

		
		this.container=container;
	} 
   
	//.. sets user defined KeyStroke 
	public void setKeyStrokeForOpenMenuItem(KeyStroke openMenuItemKeyStroke)
	{
		//..sets the user defined KeyStroke to the OpenMenuItem
		setAccelerator(openMenuItemKeyStroke);
	}

    //.. Handles Events

	public void actionPerformed(ActionEvent evt)
	{
		//.. File Objec to Set the DefaultPath
		File dir=new File("e:\\windowing-venkat\\");
		
		//..Creates a FilChooser with some default filePath
		JFileChooser fileChooser = new JFileChooser(dir);

		//..Fire the property change event
		firePropertyChange("FileChooserOpened",fileChooser,null);

		//..opens a filChooser Dialog to Opon the required file
		int response =fileChooser.showOpenDialog(container);
		
		//.. if Open Button is Clicked
			if(response==JFileChooser.APPROVE_OPTION )
			{
			
				try
				{
					//..gets the selected File
					File selectedFile=fileChooser.getSelectedFile();

					//..opens the selected file to read its contents
					DataInputStream inputStream=new DataInputStream(new FileInputStream(selectedFile.getAbsolutePath()));

					//..Creates a StringBuffer of fileSize
					StringBuffer stringBuffer=new StringBuffer((int)selectedFile.length());

			
					//inputStream.flush();

					String tempText="";

					//.. reads the file contents and appends to the StringBuffer

					while(( tempText=inputStream.readLine() )!=null)
					{
						//tempText=inputStream.readLine();
						stringBuffer.append(tempText+"\n");
					}
					
							
					//.. Creates a new MLInternalFrame 
					MLInternalFrame internalFrame=new MLInternalFrame(container,selectedFile,stringBuffer);

					//..gets the JVewport from the JScrollPane and JScrollPane from the JInternalFrame
					JViewport jvp=(JViewport)((JScrollPane)internalFrame.getContentPane().getComponent(0)).getComponent(0);

					//..gets the JEditorPane from the JViewport
					JEditorPane jep=(JEditorPane)jvp.getComponent(0);

					//..sets the CatetPosition at the begining of the File
					jep.setCaretPosition(0);

					
					//..gets the InternalFramesHashtable
					internalFramesOpenFileNames=FileMenu.getInternalFramesOpenFileNamesHashTable();

					//..gets the OpenFiles Vector
					recentFileEntries=FileMenu.getRecentFileEntriesVector();

                    //..puts the FilePath into the Hashtable with the InternalFrame as key
					internalFramesOpenFileNames.put(internalFrame,selectedFile.getAbsolutePath());

					//..put the FilePath into the RecentOpenFilesVecor
					recentFileEntries.add(selectedFile.getAbsolutePath());

					//..adds the closingInternalFrameListener to it
					internalFrame.addInternalFrameListener(new InternalFrameClosingHandler(container,internalFramesOpenFileNames,internalFrame));


				}
				catch(FileNotFoundException fnfe)
				{
					//e.printStackTrace();
					JOptionPane.showMessageDialog(null,fnfe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);

				}
				catch(IOException ioe)
				{
					//e.printStackTrace();
					JOptionPane.showMessageDialog(null,ioe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);

				}
				
				
			}
		
	}
	
}



