/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http;

import com.sun.xml.rpc.server.http.JAXRPCRuntimeInfo;
import com.sun.xml.rpc.server.http.JAXRPCServletException;
import com.sun.xml.rpc.server.http.RuntimeEndpointInfo;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderException;
import com.sun.xml.rpc.streaming.XMLReaderFactory;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public class JAXRPCRuntimeInfoParser {
    protected ClassLoader classLoader;
    public static final String NS_RUNTIME = "http://java.sun.com/xml/ns/jax-rpc/ri/runtime";
    public static final QName QNAME_ENDPOINTS = new QName("http://java.sun.com/xml/ns/jax-rpc/ri/runtime", "endpoints");
    public static final QName QNAME_ENDPOINT = new QName("http://java.sun.com/xml/ns/jax-rpc/ri/runtime", "endpoint");
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_INTERFACE = "interface";
    public static final String ATTR_IMPLEMENTATION = "implementation";
    public static final String ATTR_TIE = "tie";
    public static final String ATTR_MODEL = "model";
    public static final String ATTR_WSDL = "wsdl";
    public static final String ATTR_SERVICE = "service";
    public static final String ATTR_PORT = "port";
    public static final String ATTR_URL_PATTERN = "urlpattern";
    public static final String ATTRVALUE_VERSION_1_0 = "1.0";

    public JAXRPCRuntimeInfoParser(ClassLoader cl) {
        this.classLoader = cl;
    }

    public JAXRPCRuntimeInfo parse(InputStream is) {
        try {
            XMLReader reader = XMLReaderFactory.newInstance().createXMLReader(is);
            reader.next();
            return this.parseEndpoints(reader);
        }
        catch (XMLReaderException e) {
            throw new JAXRPCServletException("runtime.parser.xmlReader", e);
        }
    }

    protected JAXRPCRuntimeInfo parseEndpoints(XMLReader reader) {
        if (!reader.getName().equals(QNAME_ENDPOINTS)) {
            JAXRPCRuntimeInfoParser.failWithFullName("runtime.parser.invalidElement", reader);
        }
        JAXRPCRuntimeInfo info = new JAXRPCRuntimeInfo();
        ArrayList<RuntimeEndpointInfo> endpoints = new ArrayList<RuntimeEndpointInfo>();
        String version = this.getMandatoryNonEmptyAttribute(reader, ATTR_VERSION);
        if (!version.equals(ATTRVALUE_VERSION_1_0)) {
            JAXRPCRuntimeInfoParser.failWithLocalName("runtime.parser.invalidVersionNumber", reader, version);
        }
        while (reader.nextElementContent() != 2) {
            if (reader.getName().equals(QNAME_ENDPOINT)) {
                RuntimeEndpointInfo rei = new RuntimeEndpointInfo();
                rei.setName(this.getMandatoryNonEmptyAttribute(reader, ATTR_NAME));
                String interfaceName = this.getMandatoryNonEmptyAttribute(reader, ATTR_INTERFACE);
                rei.setRemoteInterface(this.loadClass(interfaceName));
                String implementationName = this.getMandatoryNonEmptyAttribute(reader, ATTR_IMPLEMENTATION);
                rei.setImplementationClass(this.loadClass(implementationName));
                String tieName = this.getMandatoryNonEmptyAttribute(reader, ATTR_TIE);
                rei.setTieClass(this.loadClass(tieName));
                rei.setModelFileName(this.getAttribute(reader, ATTR_MODEL));
                rei.setWSDLFileName(this.getAttribute(reader, ATTR_WSDL));
                rei.setServiceName(this.getQNameAttribute(reader, ATTR_SERVICE));
                rei.setPortName(this.getQNameAttribute(reader, ATTR_PORT));
                rei.setUrlPattern(this.getMandatoryNonEmptyAttribute(reader, ATTR_URL_PATTERN));
                JAXRPCRuntimeInfoParser.ensureNoContent(reader);
                rei.setDeployed(true);
                endpoints.add(rei);
                continue;
            }
            JAXRPCRuntimeInfoParser.failWithLocalName("runtime.parser.invalidElement", reader);
        }
        reader.close();
        info.setEndpoints(endpoints);
        return info;
    }

    protected String getAttribute(XMLReader reader, String name) {
        Attributes attributes = reader.getAttributes();
        String value = attributes.getValue(name);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    protected QName getQNameAttribute(XMLReader reader, String name) {
        String value = this.getAttribute(reader, name);
        if (value == null || value.equals("")) {
            return null;
        }
        return QName.valueOf(value);
    }

    protected String getNonEmptyAttribute(XMLReader reader, String name) {
        String value = this.getAttribute(reader, name);
        if (value != null && value.equals("")) {
            JAXRPCRuntimeInfoParser.failWithLocalName("runtime.parser.invalidAttributeValue", reader, name);
        }
        return value;
    }

    protected String getMandatoryAttribute(XMLReader reader, String name) {
        String value = this.getAttribute(reader, name);
        if (value == null) {
            JAXRPCRuntimeInfoParser.failWithLocalName("runtime.parser.missing.attribute", reader, name);
        }
        return value;
    }

    protected String getMandatoryNonEmptyAttribute(XMLReader reader, String name) {
        String value = this.getAttribute(reader, name);
        if (value == null) {
            JAXRPCRuntimeInfoParser.failWithLocalName("runtime.parser.missing.attribute", reader, name);
        } else if (value.equals("")) {
            JAXRPCRuntimeInfoParser.failWithLocalName("runtime.parser.invalidAttributeValue", reader, name);
        }
        return value;
    }

    protected static void ensureNoContent(XMLReader reader) {
        if (reader.nextElementContent() != 2) {
            JAXRPCRuntimeInfoParser.fail("runtime.parser.unexpectedContent", reader);
        }
    }

    protected static void fail(String key, XMLReader reader) {
        throw new JAXRPCServletException(key, Integer.toString(reader.getLineNumber()));
    }

    protected static void failWithFullName(String key, XMLReader reader) {
        throw new JAXRPCServletException(key, new Object[]{Integer.toString(reader.getLineNumber()), reader.getName().toString()});
    }

    protected static void failWithLocalName(String key, XMLReader reader) {
        throw new JAXRPCServletException(key, new Object[]{Integer.toString(reader.getLineNumber()), reader.getLocalName()});
    }

    protected static void failWithLocalName(String key, XMLReader reader, String arg) {
        throw new JAXRPCServletException(key, new Object[]{Integer.toString(reader.getLineNumber()), reader.getLocalName(), arg});
    }

    protected Class loadClass(String name) {
        try {
            return Class.forName(name, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new JAXRPCServletException("runtime.parser.classNotFound", name);
        }
    }
}

