/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.util;

import com.sun.xml.rpc.processor.ProcessorNotificationListener;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.ProcessorEnvironmentBase;
import com.sun.xml.rpc.util.localization.Localizable;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class ClientProcessorEnvironment
extends ProcessorEnvironmentBase
implements ProcessorEnvironment {
    private OutputStream out;
    private PrintStream outprintstream;
    private ProcessorNotificationListener listener;
    private String classPath;
    private Vector generatedFiles = new Vector();
    private int nwarnings;
    private int nerrors;
    private int flags;
    private Names names;

    public ClientProcessorEnvironment(OutputStream out, String classPath, ProcessorNotificationListener listener) {
        this.out = out;
        this.classPath = classPath;
        this.listener = listener;
        this.flags = 0;
        this.names = new Names();
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public boolean verbose() {
        return (this.flags & 1) != 0;
    }

    public void addGeneratedFile(File file) {
        this.generatedFiles.add(file);
    }

    public Iterator getGeneratedFiles() {
        return ((AbstractList)this.generatedFiles).iterator();
    }

    public void deleteGeneratedFiles() {
        Vector vector = this.generatedFiles;
        synchronized (vector) {
            Enumeration enumeration = this.generatedFiles.elements();
            while (enumeration.hasMoreElements()) {
                File file = (File)enumeration.nextElement();
                if (file.getName().endsWith(".wsdl")) continue;
                file.delete();
            }
            this.generatedFiles.removeAllElements();
        }
    }

    public void shutdown() {
        this.listener = null;
        this.generatedFiles = null;
    }

    public void error(Localizable msg) {
        if (this.listener != null) {
            this.listener.onError(msg);
        }
        ++this.nerrors;
    }

    public void warn(Localizable msg) {
        if (this.warnings()) {
            ++this.nwarnings;
            if (this.listener != null) {
                this.listener.onWarning(msg);
            }
        }
    }

    public void info(Localizable msg) {
        if (this.listener != null) {
            this.listener.onInfo(msg);
        }
    }

    public void printStackTrace(Throwable t) {
        if (this.outprintstream == null) {
            this.outprintstream = new PrintStream(this.out);
        }
        t.printStackTrace(this.outprintstream);
    }

    public Names getNames() {
        return this.names;
    }

    public int getErrorCount() {
        return this.nerrors;
    }

    public int getWarningCount() {
        return this.nwarnings;
    }

    private boolean warnings() {
        return (this.flags & 2) != 0;
    }
}

