/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiModeler;
import com.sun.xml.rpc.processor.modeler.rmi.RmiType;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.StringUtils;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class ExceptionModeler
implements RmiConstants {
    private RmiModeler modeler;
    private Class defRuntimeException;
    private ProcessorEnvironment env;
    private static final String THROWABLE_CLASSNAME = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionModeler.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName();
    private static final String OBJECT_CLASSNAME = (class$java$lang$Object == null ? (class$java$lang$Object = ExceptionModeler.class$("java.lang.Object")) : class$java$lang$Object).getName();
    private static final int MESSAGE_FLAG = 2;
    private static final int LOCALIZED_MESSAGE_FLAG = 4;
    private static Method GET_MESSAGE_METHOD;
    private Map faultMap;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$lang$String;

    public ExceptionModeler(RmiModeler modeler) {
        this.modeler = modeler;
        this.env = modeler.getProcessorEnvironment();
        this.faultMap = new HashMap();
        this.defRuntimeException = class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = ExceptionModeler.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException;
    }

    public Fault modelException(String typeUri, String wsdlUri, Class exceptionClass) {
        return this.createFault(typeUri, wsdlUri, exceptionClass);
    }

    public Fault createFault(String typeUri, String wsdlUri, Class classDef) {
        String exceptionName = classDef.getName();
        Fault fault = (Fault)this.faultMap.get(exceptionName);
        if (fault != null) {
            return fault;
        }
        HashMap<String, Method> members = new HashMap<String, Method>();
        this.collectMembers(classDef, members);
        int getMessageFlags = 0;
        if (members.containsKey("getMessage")) {
            Iterator iterator = members.entrySet().iterator();
            while (iterator.hasNext()) {
                Method member = (Method)iterator.next().getValue();
                if (!member.getReturnType().equals(class$java$lang$String == null ? ExceptionModeler.class$("java.lang.String") : class$java$lang$String) || member.getName().equals("getMessage")) continue;
                members.remove("getMessage");
                break;
            }
        }
        if (members.size() == 0) {
            members.put("getMessage", GET_MESSAGE_METHOD);
        }
        if (members.containsKey("getMessage")) {
            getMessageFlags = 2;
        }
        boolean hasDuplicates = false;
        Set duplicateMembers = ExceptionModeler.getDuplicateMembers(members);
        if (duplicateMembers.size() > 0) {
            hasDuplicates = true;
        }
        if (members.size() > 0 && !hasDuplicates) {
            Constructor<?>[] constrs = classDef.getConstructors();
            int i = 0;
            while (i < constrs.length && fault == null) {
                SOAPStructureMember[] soapMembers = this.constructorMatches(typeUri, wsdlUri, classDef, constrs[i], members, getMessageFlags);
                if (soapMembers != null) {
                    fault = this.createFault(typeUri, wsdlUri, classDef, soapMembers);
                }
                ++i;
            }
        }
        if (fault == null) {
            ArrayList<String> newMembers = new ArrayList<String>();
            if (!members.containsKey("getMessage")) {
                newMembers.add("getMessage");
            }
            if (!members.containsKey("getLocalizedMessage")) {
                newMembers.add("getLocalizedMessage");
            }
            fault = this.createFault(typeUri, wsdlUri, classDef, this.addMessage(typeUri, wsdlUri, classDef, members, newMembers));
        }
        this.faultMap.put(classDef.getName().toString(), fault);
        return fault;
    }

    private static Set getDuplicateMembers(Map members) {
        HashSet<RmiType> types = new HashSet<RmiType>();
        HashSet<Method> duplicateMembers = new HashSet<Method>();
        Iterator iter = members.entrySet().iterator();
        while (iter.hasNext()) {
            Method member = (Method)iter.next().getValue();
            RmiType type = RmiType.getRmiType(member.getReturnType());
            String memberName = member.getName();
            if (types.contains(type)) {
                duplicateMembers.add(member);
                continue;
            }
            types.add(type);
        }
        return duplicateMembers;
    }

    private SOAPStructureMember[] constructorMatches(String typeUri, String wsdlUri, Class classDef, Constructor cstr, Map members, int getMessageFlags) {
        Object[] memberArray;
        boolean memberCountMatch;
        Class<?>[] args = cstr.getParameterTypes();
        boolean bl = memberCountMatch = args.length == (memberArray = members.values().toArray()).length;
        if (!(memberCountMatch || getMessageFlags != 0 && args.length == memberArray.length - 1)) {
            return null;
        }
        SOAPStructureMember[] soapMembers = new SOAPStructureMember[args.length];
        int i = 0;
        while (i < args.length) {
            int j = 0;
            while (j < memberArray.length && soapMembers[i] == null) {
                block9: {
                    block8: {
                        if (memberCountMatch) break block8;
                        String memberName = ((Method)memberArray[j]).getName();
                        if (getMessageFlags == 2 && memberName.equals("getMessage")) break block9;
                    }
                    if (args[i].equals(((Method)memberArray[j]).getReturnType())) {
                        soapMembers[i] = this.createSOAPMember(typeUri, wsdlUri, classDef, (Method)memberArray[j], i);
                    }
                }
                ++j;
            }
            if (soapMembers[i] == null) {
                return null;
            }
            ++i;
        }
        return soapMembers;
    }

    public SOAPStructureMember createSOAPMember(String typeUri, String wsdlUri, Class classDef, Method member, int cstrPos) {
        String packageName = classDef.getPackage().getName();
        RmiType memberType = RmiType.getRmiType(member.getReturnType());
        String readMethod = member.getName();
        String namespaceURI = this.modeler.getNamespaceURI(packageName);
        if (namespaceURI == null) {
            namespaceURI = wsdlUri;
        }
        String propertyName = StringUtils.decapitalize(readMethod.substring(3));
        QName propertyQName = new QName("", propertyName);
        SOAPType propertyType = this.modeler.modelTypeSOAP(typeUri, memberType);
        SOAPStructureMember soapMember = new SOAPStructureMember(propertyQName, propertyType, null);
        JavaStructureMember javaMember = new JavaStructureMember(propertyName, propertyType.getJavaType(), soapMember);
        soapMember.setJavaStructureMember(javaMember);
        javaMember.setConstructorPos(cstrPos);
        javaMember.setReadMethod(readMethod);
        soapMember.setJavaStructureMember(javaMember);
        return soapMember;
    }

    public SOAPStructureMember[] addMessage(String typeUri, String wsdlUri, Class classDef, Map members, List newMembers) {
        String packageName = classDef.getPackage().getName();
        String namespaceURI = this.modeler.getNamespaceURI(packageName);
        if (namespaceURI == null) {
            namespaceURI = wsdlUri;
        }
        SOAPStructureMember[] soapMembers = new SOAPStructureMember[members.size() + newMembers.size()];
        Iterator iter = members.entrySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Method argMember = (Method)iter.next().getValue();
            soapMembers[i] = this.createSOAPMember(typeUri, wsdlUri, classDef, argMember, -1);
            ++i;
        }
        iter = newMembers.iterator();
        int i2 = members.size();
        while (iter.hasNext()) {
            String propertyName = StringUtils.decapitalize(((String)((Object)iter.next())).substring(3));
            QName propertyQName = new QName("", propertyName);
            SOAPSimpleType propertyType = this.modeler.getSOAPTypes().XSD_STRING_SOAPTYPE;
            SOAPStructureMember soapMember = new SOAPStructureMember(propertyQName, propertyType, null);
            JavaStructureMember javaMember = new JavaStructureMember(propertyName, propertyType.getJavaType(), soapMember);
            soapMember.setJavaStructureMember(javaMember);
            javaMember.setReadMethod("get" + StringUtils.capitalize(propertyName));
            soapMember.setJavaStructureMember(javaMember);
            soapMembers[i2] = soapMember;
            ++i2;
        }
        return soapMembers;
    }

    public Fault createFault(String typeUri, String wsdlUri, Class classDef, SOAPStructureMember[] soapMembers) {
        String packageName = classDef.getPackage().getName();
        String namespaceURI = this.modeler.getNamespaceURI(packageName);
        if (namespaceURI == null) {
            namespaceURI = typeUri;
        }
        this.env.getNames();
        Fault fault = new Fault(Names.stripQualifier(classDef.getName()));
        SOAPOrderedStructureType soapStruct = new SOAPOrderedStructureType(new QName(namespaceURI, fault.getName()));
        namespaceURI = this.modeler.getNamespaceURI(packageName);
        if (namespaceURI == null) {
            namespaceURI = wsdlUri;
        }
        QName faultQName = new QName(namespaceURI, fault.getName());
        JavaException javaException = new JavaException(classDef.getName(), true, soapStruct);
        int i = 0;
        while (i < soapMembers.length) {
            soapStruct.add(soapMembers[i]);
            javaException.add(soapMembers[i].getJavaStructureMember());
            ++i;
        }
        Block faultBlock = soapMembers.length == 1 ? new Block(faultQName, soapMembers[0].getType()) : new Block(faultQName, soapStruct);
        fault.setBlock(faultBlock);
        soapStruct.setJavaType(javaException);
        fault.setJavaException(javaException);
        return fault;
    }

    public void collectMembers(Class classDef, Map members) {
        try {
            if (this.defRuntimeException.isAssignableFrom(classDef)) {
                throw new ModelerException("rmimodeler.must.not.extend.runtimeexception", classDef.getName());
            }
            Method[] methods = classDef.getMethods();
            int i = 0;
            while (i < methods.length) {
                String memberName;
                Class<?> decClass = methods[i].getDeclaringClass();
                if (!(Modifier.isStatic(methods[i].getModifiers()) || decClass.equals(class$java$lang$Throwable == null ? ExceptionModeler.class$("java.lang.Throwable") : class$java$lang$Throwable) || decClass.equals(class$java$lang$Object == null ? ExceptionModeler.class$("java.lang.Object") : class$java$lang$Object) || !(memberName = methods[i].getName()).startsWith("get") || methods[i].getParameterTypes().length != 0 || members.containsKey(memberName) || memberName.equals("getLocalizedMessage"))) {
                    members.put(memberName, methods[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ModelerException(new LocalizableExceptionAdapter(e));
        }
    }

    private Fault getMappedFault(String className) {
        return (Fault)this.faultMap.get(className);
    }

    private static void log(ProcessorEnvironment env, String msg) {
        if (env.verbose()) {
            System.out.println("[ExceptionIntrospector: " + msg + "]");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            GET_MESSAGE_METHOD = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionModeler.class$("java.lang.Throwable")) : class$java$lang$Throwable).getDeclaredMethod("getMessage", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

