/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model;

import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.ModelObject;
import com.sun.xml.rpc.processor.model.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Message
extends ModelObject {
    private Map _bodyBlocks = new HashMap();
    private Map _headerBlocks = new HashMap();
    private List _parameters = new ArrayList();
    private Map _parametersByName = new HashMap();

    public void addBodyBlock(Block b) {
        if (this._bodyBlocks.containsKey(b.getName())) {
            throw new ModelException("model.uniqueness");
        }
        this._bodyBlocks.put(b.getName(), b);
        b.setLocation(1);
    }

    public Iterator getBodyBlocks() {
        return this._bodyBlocks.values().iterator();
    }

    public int getBodyBlockCount() {
        return this._bodyBlocks.size();
    }

    public Map getBodyBlocksMap() {
        return this._bodyBlocks;
    }

    public void setBodyBlocksMap(Map m) {
        this._bodyBlocks = m;
    }

    public boolean isBodyEmpty() {
        return this.getBodyBlocks().hasNext();
    }

    public boolean isBodyEncoded() {
        boolean isEncoded = true;
        Iterator iter = this.getBodyBlocks();
        while (iter.hasNext()) {
            Block bodyBlock = (Block)iter.next();
            if (bodyBlock.getType().isSOAPType()) continue;
            isEncoded = false;
        }
        return isEncoded;
    }

    public void addHeaderBlock(Block b) {
        if (this._headerBlocks.containsKey(b.getName())) {
            throw new ModelException("model.uniqueness");
        }
        this._headerBlocks.put(b.getName(), b);
        b.setLocation(2);
    }

    public Iterator getHeaderBlocks() {
        return this._headerBlocks.values().iterator();
    }

    public int getHeaderBlockCount() {
        return this._headerBlocks.size();
    }

    public Map getHeaderBlocksMap() {
        return this._headerBlocks;
    }

    public void setHeaderBlocksMap(Map m) {
        this._headerBlocks = m;
    }

    public void addParameter(Parameter p) {
        if (this._parametersByName.containsKey(p.getName())) {
            throw new ModelException("model.uniqueness");
        }
        this._parameters.add(p);
        this._parametersByName.put(p.getName(), p);
    }

    public Parameter getParameterByName(String name) {
        if (this._parametersByName.size() != this._parameters.size()) {
            this.initializeParametersByName();
        }
        return (Parameter)this._parametersByName.get(name);
    }

    public Iterator getParameters() {
        return this._parameters.iterator();
    }

    public List getParametersList() {
        return this._parameters;
    }

    public void setParametersList(List l) {
        this._parameters = l;
        this.initializeParametersByName();
    }

    private void initializeParametersByName() {
        this._parametersByName = new HashMap();
        if (this._parameters != null) {
            Iterator iter = this._parameters.iterator();
            while (iter.hasNext()) {
                Parameter param = (Parameter)iter.next();
                if (param.getName() != null && this._parametersByName.containsKey(param.getName())) {
                    throw new ModelException("model.uniqueness");
                }
                this._parametersByName.put(param.getName(), param);
            }
        }
    }
}

