/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.encoding.InternalEncodingConstants;
import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterBase;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.modeler.ModelerConstants;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.wsdl.document.schema.BuiltInTypes;
import com.sun.xml.rpc.wsdl.document.soap.SOAPConstants;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class SimpleTypeSerializerWriter
extends SerializerWriterBase
implements GeneratorConstants {
    private String encoder = null;
    private String serializerMemberName;
    private static Map encoderMap = null;
    private static Set attachmentTypes = null;

    public SimpleTypeSerializerWriter(SOAPType type, Names names) {
        super(type, names);
        this.encoder = SimpleTypeSerializerWriter.getTypeEncoder(type);
        if (this.encoder == null) {
            throw new GeneratorException("generator.simpleTypeSerializerWriter.no.encoder.for.type", new Object[]{type.getName().toString(), type.getJavaType().getRealName()});
        }
        String partialSerializerName = this.encoder.substring(0, this.encoder.lastIndexOf("Encoder"));
        if (partialSerializerName.startsWith("XSD")) {
            partialSerializerName = partialSerializerName.substring(3);
        }
        String serializerName = partialSerializerName + "_Serializer";
        this.serializerMemberName = names.getClassMemberName(partialSerializerName, type, "_Serializer");
    }

    public void createSerializer(IndentingWriter p, StringBuffer typeName, String serName, boolean encodeTypes, boolean multiRefEncoding, String typeMapping) throws IOException {
        SOAPType type = (SOAPType)this.type;
        String nillable = type.isNillable() ? "NULLABLE" : "NOT_NULLABLE";
        String referenceable = type.isReferenceable() ? "REFERENCEABLE" : "NOT_REFERENCEABLE";
        String multiRef = multiRefEncoding && type.isReferenceable() ? "SERIALIZE_AS_REF" : "DONT_SERIALIZE_AS_REF";
        String encodeType = encodeTypes ? "ENCODE_TYPE" : "DONT_ENCODE_TYPE";
        this.declareType(p, typeName, type.getName(), false, false);
        QName typeQName = type.getName();
        if (attachmentTypes.contains(typeQName)) {
            boolean serAsAttachment = !typeQName.equals(SOAPConstants.QNAME_TYPE_STRING) && !typeQName.equals(BuiltInTypes.STRING);
            p.plnI(this.serializerName() + " " + serName + " = new " + GeneratorConstants.ATTACHMENT_SERIALIZER_NAME + "(" + typeName + ",");
            p.pln(encodeType + ", " + nillable + ", SOAPConstants.NS_SOAP_ENCODING, " + serAsAttachment + ", " + this.encoder + ".getInstance());");
            multiRef = "DONT_SERIALIZE_AS_REF";
        } else if (typeQName.equals(BuiltInTypes.BASE64_BINARY) || typeQName.equals(SOAPConstants.QNAME_TYPE_BASE64_BINARY) || typeQName.equals(SOAPConstants.QNAME_TYPE_BASE64)) {
            p.plnI(this.serializerName() + " " + serName + " = new " + GeneratorConstants.SIMPLE_MULTI_TYPE_SERIALIZER_NAME + "(" + typeName + ",");
            p.pln(encodeType + ", " + nillable + ", SOAPConstants.NS_SOAP_ENCODING, " + this.encoder + ".getInstance(),");
            p.plnI("new QName[] {");
            GeneratorUtil.writeNewQName(p, BuiltInTypes.BASE64_BINARY);
            p.pln(",");
            GeneratorUtil.writeNewQName(p, SOAPConstants.QNAME_TYPE_BASE64_BINARY);
            p.pln(",");
            GeneratorUtil.writeNewQName(p, SOAPConstants.QNAME_TYPE_BASE64);
            p.pOln("});");
        } else {
            p.plnI(this.serializerName() + " " + serName + " = new " + GeneratorConstants.SIMPLE_TYPE_SERIALIZER_NAME + "(" + typeName + ",");
            p.pln(encodeType + ", " + nillable + ", SOAPConstants.NS_SOAP_ENCODING, " + this.encoder + ".getInstance());");
        }
        p.pO();
        if (type.isReferenceable()) {
            p.plnI(serName + " = new " + GeneratorConstants.REFERENCEABLE_SERIALIZER_NAME + "(" + multiRef + ", " + serName + ");");
            p.pO();
        }
    }

    public void declareSerializer(IndentingWriter p, boolean isStatic, boolean isFinal) throws IOException {
        String modifier = this.getPrivateModifier(isStatic, isFinal);
        p.pln(modifier + this.serializerName() + " " + this.serializerMemberName + ";");
    }

    public String serializerMemberName() {
        return this.serializerMemberName;
    }

    public String deserializerMemberName() {
        return this.serializerMemberName;
    }

    protected String getPrivateModifier(boolean isStatic, boolean isFinal) {
        return "private " + super.getModifier(isStatic, isFinal);
    }

    public static String getTypeEncoder(AbstractType type) {
        QName name = type.getName();
        String encoder = (String)encoderMap.get(name);
        if (encoder == null) {
            String javaName = type.getJavaType().getRealName();
            if (name.equals(BuiltInTypes.DATE_TIME) || name.equals(SOAPConstants.QNAME_TYPE_DATE_TIME)) {
                if (javaName.equals(ModelerConstants.DATE_CLASSNAME)) {
                    encoder = GeneratorConstants.XSD_DATE_TIME_DATE_ENCODER_NAME;
                } else if (javaName.equals(ModelerConstants.CALENDAR_CLASSNAME)) {
                    encoder = GeneratorConstants.XSD_DATE_TIME_CALENDAR_ENCODER_NAME;
                }
            } else if (name.equals(BuiltInTypes.BASE64_BINARY) || name.equals(SOAPConstants.QNAME_TYPE_BASE64_BINARY) || name.equals(SOAPConstants.QNAME_TYPE_BASE64)) {
                if (javaName.equals(ModelerConstants.BYTE_ARRAY_CLASSNAME)) {
                    encoder = GeneratorConstants.XSD_BASE64_BINARY_ENCODER_NAME;
                }
            } else if ((name.equals(BuiltInTypes.HEX_BINARY) || name.equals(SOAPConstants.QNAME_TYPE_HEX_BINARY)) && javaName.equals(ModelerConstants.BYTE_ARRAY_CLASSNAME)) {
                encoder = GeneratorConstants.XSD_HEX_BINARY_ENCODER_NAME;
            }
        }
        return encoder;
    }

    protected String getEncoder() {
        return SimpleTypeSerializerWriter.getTypeEncoder(this.type);
    }

    static {
        attachmentTypes = new HashSet();
        attachmentTypes.add(InternalEncodingConstants.QNAME_TYPE_IMAGE);
        attachmentTypes.add(InternalEncodingConstants.QNAME_TYPE_MIME_MULTIPART);
        attachmentTypes.add(InternalEncodingConstants.QNAME_TYPE_SOURCE);
        attachmentTypes.add(InternalEncodingConstants.QNAME_TYPE_DATA_HANDLER);
        attachmentTypes.add(BuiltInTypes.STRING);
        attachmentTypes.add(SOAPConstants.QNAME_TYPE_STRING);
        encoderMap = new HashMap();
        encoderMap.put(InternalEncodingConstants.QNAME_TYPE_IMAGE, GeneratorConstants.IMAGE_ENCODER_NAME);
        encoderMap.put(InternalEncodingConstants.QNAME_TYPE_MIME_MULTIPART, GeneratorConstants.MIME_MULTIPART_ENCODER_NAME);
        encoderMap.put(InternalEncodingConstants.QNAME_TYPE_SOURCE, GeneratorConstants.SOURCE_ENCODER_NAME);
        encoderMap.put(InternalEncodingConstants.QNAME_TYPE_DATA_HANDLER, GeneratorConstants.DATA_HANDLER_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.BOOLEAN, GeneratorConstants.XSD_BOOLEAN_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.BYTE, GeneratorConstants.XSD_BYTE_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.BASE64_BINARY, null);
        encoderMap.put(BuiltInTypes.HEX_BINARY, null);
        encoderMap.put(BuiltInTypes.DOUBLE, GeneratorConstants.XSD_DOUBLE_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.FLOAT, GeneratorConstants.XSD_FLOAT_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.INT, GeneratorConstants.XSD_INT_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.INTEGER, GeneratorConstants.XSD_INTEGER_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.LONG, GeneratorConstants.XSD_LONG_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.SHORT, GeneratorConstants.XSD_SHORT_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.DECIMAL, GeneratorConstants.XSD_DECIMAL_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.DATE_TIME, null);
        encoderMap.put(BuiltInTypes.STRING, GeneratorConstants.XSD_STRING_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.QNAME, GeneratorConstants.XSD_QNAME_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_BOOLEAN, GeneratorConstants.XSD_BOOLEAN_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_BYTE, GeneratorConstants.XSD_BYTE_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_BASE64_BINARY, null);
        encoderMap.put(SOAPConstants.QNAME_TYPE_DOUBLE, GeneratorConstants.XSD_DOUBLE_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_FLOAT, GeneratorConstants.XSD_FLOAT_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_INT, GeneratorConstants.XSD_INT_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_LONG, GeneratorConstants.XSD_LONG_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_SHORT, GeneratorConstants.XSD_SHORT_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_DECIMAL, GeneratorConstants.XSD_DECIMAL_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_DATE_TIME, null);
        encoderMap.put(SOAPConstants.QNAME_TYPE_STRING, GeneratorConstants.XSD_STRING_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_QNAME, GeneratorConstants.XSD_QNAME_ENCODER_NAME);
    }
}

