/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.util.DirectoryUtil;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class ServletConfigGenerator
extends GeneratorBase {
    private File configFile = null;
    private Service currentService;
    private IndentingWriter out = null;
    private int portCount = 0;
    private TreeSet operations = null;

    public ServletConfigGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new ServletConfigGenerator(model, config, properties);
    }

    private ServletConfigGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    protected void preVisitService(Service service) throws Exception {
        try {
            this.currentService = service;
            String className = service.getName().getLocalPart();
            this.configFile = ServletConfigGenerator.configFileForClass(className, this.nonclassDestDir, this.env);
            this.out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(this.configFile)));
            this.portCount = 0;
            this.out.pln("# This file is generated by xrpcc.");
            this.out.pln();
        }
        catch (IOException e) {
            GeneratorBase.fail("cant.write", this.configFile.toString());
        }
    }

    protected void postVisitService(Service service) throws Exception {
        try {
            try {
                this.out.pln("portcount=" + this.portCount);
                this.closeFile();
            }
            catch (IOException e) {
                GeneratorBase.fail("cant.write", this.configFile.toString());
                Object var4_3 = null;
                this.currentService = null;
            }
            Object var4_2 = null;
            this.currentService = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.currentService = null;
            throw throwable;
        }
    }

    public void visit(Port port) throws Exception {
        int myPortNum = this.portCount;
        this.portCount = myPortNum + 1;
        this.operations = new TreeSet(new StringLenComparator());
        Iterator operations = port.getOperations();
        while (operations.hasNext()) {
            ((Operation)operations.next()).accept(this);
        }
        try {
            String portID = "port" + myPortNum;
            String servant = null;
            servant = port.getJavaInterface().getImpl();
            if (servant == null) {
                servant = "Please specify the servant class for port:" + port.getName().getLocalPart();
            }
            this.out.pln(portID + ".tie=" + this.env.getNames().tieFor(port.getJavaInterface()));
            this.out.pln(portID + ".servant=" + servant);
            this.out.pln(portID + ".name=" + port.getName().getLocalPart());
            this.out.pln(portID + ".wsdl.targetNamespace=" + this.model.getTargetNamespaceURI());
            this.out.pln(portID + ".wsdl.serviceName=" + this.currentService.getName().getLocalPart());
            QName portName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
            this.out.pln(portID + ".wsdl.portName=" + portName.getLocalPart());
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", this.configFile.toString());
        }
    }

    protected void visitOperation(Operation operation) throws Exception {
        this.operations.add(operation);
    }

    private void closeFile() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    private String getBaseName(String s) {
        if (s.endsWith("Port")) {
            return s.substring(0, s.length() - 4);
        }
        return s;
    }

    private String getPortName(String s) {
        return this.getBaseName(s) + "Port";
    }

    protected static File configFileForClass(String className, File destDir, ProcessorEnvironment env) throws GeneratorException {
        File packageDir = DirectoryUtil.getOutputDirectoryFor(className, destDir, env);
        env.getNames();
        String outputName = Names.stripQualifier(className);
        String outputFileName = outputName + "_Config.properties";
        return new File(packageDir, outputFileName);
    }

    private static class StringLenComparator
    implements Comparator {
        private StringLenComparator() {
        }

        public int compare(Object o1, Object o2) {
            int len2;
            int len1 = ((Operation)o1).getName().getLocalPart().length();
            return len1 <= (len2 = ((Operation)o2).getName().getLocalPart().length()) ? -1 : 1;
        }
    }
}

