/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationEntry;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class EnumerationGenerator
extends GeneratorBase {
    private Set types;

    public EnumerationGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new EnumerationGenerator(model, config, properties);
    }

    private EnumerationGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.types = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        this.types = null;
    }

    public void visit(SOAPCustomType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    public void visit(SOAPSimpleType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    public void visit(SOAPAnyType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    public void visit(SOAPEnumerationType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        this.generateEnumeration(type);
    }

    protected void visitSOAPArrayType(SOAPArrayType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        super.visitSOAPArrayType(type);
    }

    protected void visitSOAPStructureType(SOAPStructureType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        super.visitSOAPStructureType(type);
    }

    private boolean isRegistered(SOAPType type) {
        return this.types.contains(type);
    }

    private void registerType(SOAPType type) {
        this.types.add(type);
    }

    private void generateEnumeration(SOAPEnumerationType type) {
        this.log("generating Enumeration for: " + type.getJavaType().getRealName());
        try {
            String className = type.getJavaType().getRealName();
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            this.env.addGeneratedFile(classFile);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            GeneratorBase.writePackage(out, className);
            out.pln();
            this.writeClassDecl(out, className);
            this.writeMembers(out, type);
            out.pln();
            this.writeClassConstructor(out, className, type);
            out.pln();
            this.writeGetValue(out, type);
            out.pln();
            this.writeFromValue(out, type);
            out.pln();
            this.writeFromString(out, type);
            out.pln();
            this.writeToString(out, type);
            out.pln();
            this.writeEquals(out, type);
            out.pln();
            this.writeHashCode(out, type);
            out.pOln("}");
            out.close();
            this.log("wrote file: " + classFile.getPath());
        }
        catch (Exception e) {
            GeneratorBase.fail(e);
        }
    }

    private void writeClassDecl(IndentingWriter p, String className) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.stripQualifier(className)).append(" implements java.io.Serializable {").toString());
    }

    private void writeMembers(IndentingWriter p, SOAPEnumerationType type) throws IOException {
        JavaEnumerationEntry entry;
        JavaEnumerationType javaEnum = (JavaEnumerationType)type.getJavaType();
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        this.env.getNames();
        String className = Names.stripQualifier(type.getJavaType().getRealName());
        p.pln("private " + baseTypeStr + " value;");
        Iterator enums = javaEnum.getEntries();
        if (!SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
            enums = javaEnum.getEntries();
            while (enums.hasNext()) {
                entry = (JavaEnumerationEntry)enums.next();
                p.pln("public static final String _" + entry.getName() + "String = \"" + entry.getLiteralValue() + "\";");
            }
            p.pln();
        }
        enums = javaEnum.getEntries();
        while (enums.hasNext()) {
            entry = (JavaEnumerationEntry)enums.next();
            if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
                if (baseTypeStr.equals("long")) {
                    p.pln("public static final " + baseTypeStr + " _" + entry.getName() + " = " + entry.getLiteralValue() + "L;");
                    continue;
                }
                p.pln("public static final " + baseTypeStr + " _" + entry.getName() + " = (" + baseTypeStr + ")" + entry.getLiteralValue() + ";");
                continue;
            }
            p.pln("public static final " + baseTypeStr + " _" + entry.getName() + " = new " + baseTypeStr + "(_" + entry.getName() + "String);");
        }
        p.pln();
        enums = javaEnum.getEntries();
        while (enums.hasNext()) {
            entry = (JavaEnumerationEntry)enums.next();
            p.pln("public static final " + className + " " + entry.getName() + " = new " + className + "(_" + entry.getName() + ");");
        }
    }

    private void writeClassConstructor(IndentingWriter p, String className, SOAPType type) throws IOException {
        JavaEnumerationType javaEnum = (JavaEnumerationType)type.getJavaType();
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        StringBuffer stringBuffer = new StringBuffer().append("protected ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.stripQualifier(className)).append("(").append(baseTypeStr).append(" value) {").toString());
        p.pln("this.value = value;");
        p.pOln("}");
    }

    private void writeGetValue(IndentingWriter p, SOAPEnumerationType type) throws IOException {
        JavaEnumerationType javaEnum = (JavaEnumerationType)type.getJavaType();
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        p.plnI("public " + baseTypeStr + " getValue() {");
        p.pln("return value;");
        p.pOln("}");
    }

    private void writeFromValue(IndentingWriter p, SOAPEnumerationType type) throws IOException {
        JavaEnumerationType javaEnum = (JavaEnumerationType)type.getJavaType();
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        this.env.getNames();
        String className = Names.stripQualifier(type.getJavaType().getRealName());
        p.plnI("public static " + className + " fromValue(" + baseTypeStr + " value)");
        p.pln("throws java.lang.IllegalStateException {");
        Iterator enums = javaEnum.getEntries();
        int i = 0;
        while (enums.hasNext()) {
            JavaEnumerationEntry entry = (JavaEnumerationEntry)enums.next();
            if (i > 0) {
                p.p(" else ");
            }
            if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
                p.plnI("if (" + entry.getName() + ".value == value) {");
            } else {
                p.plnI("if (" + entry.getName() + ".value.equals(value)) {");
            }
            p.pln("return " + entry.getName() + ";");
            p.pO("}");
            ++i;
        }
        p.pln();
        p.pln("throw new IllegalArgumentException();");
        p.pOln("}");
    }

    private void writeFromString(IndentingWriter p, SOAPEnumerationType type) throws IOException {
        JavaEnumerationType javaEnum = (JavaEnumerationType)type.getJavaType();
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        this.env.getNames();
        String className = Names.stripQualifier(type.getJavaType().getRealName());
        p.plnI("public static " + className + " fromString(String value)");
        p.pln("throws java.lang.IllegalStateException {");
        Iterator enums = javaEnum.getEntries();
        int i = 0;
        while (enums.hasNext()) {
            JavaEnumerationEntry entry = (JavaEnumerationEntry)enums.next();
            if (i > 0) {
                p.p(" else ");
            }
            if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
                p.plnI("if (value.equals(\"" + entry.getLiteralValue() + "\")) {");
            } else {
                p.plnI("if (value.equals(_" + entry.getName() + "String)) {");
            }
            p.pln("return " + entry.getName() + ";");
            p.pO("}");
            ++i;
        }
        p.pln();
        p.pln("throw new IllegalArgumentException();");
        p.pOln("}");
    }

    private void writeToString(IndentingWriter p, SOAPEnumerationType type) throws IOException {
        JavaEnumerationType javaEnum = (JavaEnumerationType)type.getJavaType();
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        this.env.getNames();
        String className = Names.stripQualifier(type.getJavaType().getRealName());
        p.plnI("public String toString() {");
        String exp = "value";
        if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
            exp = SimpleToBoxedUtil.getBoxedExpressionOfType(exp, baseTypeStr);
        }
        p.pln("return " + exp + ".toString();");
        p.pOln("}");
    }

    private void writeEquals(IndentingWriter p, SOAPEnumerationType type) throws IOException {
        JavaEnumerationType javaEnum = (JavaEnumerationType)type.getJavaType();
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        this.env.getNames();
        String className = Names.stripQualifier(type.getJavaType().getRealName());
        p.plnI("public boolean equals(Object obj) {");
        p.plnI("if (!(obj instanceof " + className + ")) {");
        p.pln("return false;");
        p.pOln("}");
        if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
            p.pln("return ((" + className + ")obj).value == value;");
        } else {
            p.pln("return ((" + className + ")obj).value.equals(value);");
        }
        p.pOln("}");
    }

    private void writeHashCode(IndentingWriter p, SOAPEnumerationType type) throws IOException {
        JavaEnumerationType javaEnum = (JavaEnumerationType)type.getJavaType();
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        p.plnI("public int hashCode() {");
        if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
            String boxedExp = SimpleToBoxedUtil.getBoxedExpressionOfType("value", baseTypeStr);
            p.pln("return " + boxedExp + ".toString().hashCode();");
        } else {
            p.pln("return value.hashCode();");
        }
        p.pOln("}");
    }
}

