/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.literal;

import com.sun.xml.rpc.encoding.CombinedSerializer;
import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.SerializerConstants;
import com.sun.xml.rpc.encoding.xsd.XSDConstants;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;

public abstract class LiteralObjectSerializerBase
implements SerializerConstants,
CombinedSerializer {
    protected QName type;
    protected boolean isNullable;
    protected String encodingStyle;

    protected LiteralObjectSerializerBase(QName type, boolean isNullable, String encodingStyle) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.isNullable = isNullable;
        this.encodingStyle = encodingStyle;
    }

    public QName getXmlType() {
        return this.type;
    }

    public boolean getEncodeType() {
        return false;
    }

    public CombinedSerializer getInnermostSerializer() {
        return this;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public void serialize(Object value, QName name, SerializerCallback callback, XMLWriter writer, SOAPSerializationContext context) {
        try {
            this.internalSerialize(value, name, writer, context);
        }
        catch (JAXRPCExceptionBase e) {
            throw new SerializationException(e);
        }
        catch (Exception e) {
            throw new SerializationException(new LocalizableExceptionAdapter(e));
        }
    }

    public Object deserialize(QName name, XMLReader reader, SOAPDeserializationContext context) {
        try {
            return this.internalDeserialize(name, reader, context);
        }
        catch (JAXRPCExceptionBase e) {
            throw new DeserializationException(e);
        }
        catch (Exception e) {
            throw new DeserializationException(new LocalizableExceptionAdapter(e));
        }
    }

    public Object deserialize(DataHandler dataHandler, SOAPDeserializationContext context) throws DeserializationException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected void internalSerialize(Object obj, QName name, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        context.beginSerializing(obj);
        writer.startElement(name != null ? name : this.type);
        boolean pushedEncodingStyle = context.pushEncodingStyle(this.encodingStyle, writer);
        if (obj == null) {
            if (!this.isNullable) {
                throw new SerializationException("literal.unexpectedNull");
            }
            writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, "1");
        } else {
            this.writeAdditionalNamespaceDeclarations(obj, writer);
            this.doSerializeAttributes(obj, writer, context);
            this.doSerialize(obj, writer, context);
        }
        writer.endElement();
        if (pushedEncodingStyle) {
            context.popEncodingStyle();
        }
        context.doneSerializing(obj);
    }

    protected Object internalDeserialize(QName name, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        boolean pushedEncodingStyle = context.processEncodingStyle(reader);
        try {
            QName actualType;
            QName actualName;
            context.verifyEncodingStyle(this.encodingStyle);
            if (name != null && !(actualName = reader.getName()).equals(name)) {
                throw new DeserializationException("xsd.unexpectedElementName", new Object[]{name.toString(), actualName.toString()});
            }
            Attributes attrs = reader.getAttributes();
            String typeVal = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (typeVal != null && !(actualType = XMLReaderUtil.decodeQName(reader, typeVal)).equals(this.type)) {
                throw new DeserializationException("xsd.unexpectedElementType", new Object[]{this.type.toString(), actualType.toString()});
            }
            String nullVal = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
            boolean isNull = nullVal != null && SerializerBase.decodeBoolean(nullVal);
            Object obj = null;
            if (isNull) {
                if (!this.isNullable) {
                    throw new DeserializationException("xsd.unexpectedNull");
                }
                reader.next();
            } else {
                obj = this.doDeserialize(reader, context);
            }
            XMLReaderUtil.verifyReaderState(reader, 2);
            Object object = obj;
            Object var12_11 = null;
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
            return object;
        }
        catch (Throwable throwable) {
            block8: {
                Object var12_12 = null;
                if (!pushedEncodingStyle) break block8;
                context.popEncodingStyle();
            }
            throw throwable;
        }
    }

    protected void writeAdditionalNamespaceDeclarations(Object obj, XMLWriter writer) throws Exception {
    }

    protected abstract void doSerialize(Object var1, XMLWriter var2, SOAPSerializationContext var3) throws Exception;

    protected abstract void doSerializeAttributes(Object var1, XMLWriter var2, SOAPSerializationContext var3) throws Exception;

    protected abstract Object doDeserialize(XMLReader var1, SOAPDeserializationContext var2) throws Exception;

    public String getMechanismType() {
        return "http://java.sun.com/jax-rpc-ri/1.0/streaming/";
    }
}

