/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.ArraySerializerBase;
import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.ObjectArraySerializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.encoding.xsd.XSDConstants;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterUtil;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.lang.reflect.Array;
import javax.xml.namespace.QName;

public class PolymorphicArraySerializer
extends SerializerBase
implements Initializable {
    protected QName elemName;
    protected InternalTypeMappingRegistry registry;

    public PolymorphicArraySerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName elemName) {
        super(type, encodeType, isNullable, encodingStyle);
        this.elemName = elemName;
    }

    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        this.registry = registry;
    }

    public void serialize(Object obj, QName name, SerializerCallback callback, XMLWriter writer, SOAPSerializationContext context) throws SerializationException {
        boolean pushedEncodingStyle = false;
        try {
            block14: {
                try {
                    String attrVal;
                    if (obj == null) {
                        if (!this.isNullable) {
                            throw new SerializationException("soap.unexpectedNull");
                        }
                        this.serializeNull(name, writer, context);
                        break block14;
                    }
                    if (!obj.getClass().isArray()) {
                        throw new SerializationException("type.is.not.array", new Object[]{obj.getClass().getName()});
                    }
                    writer.startElement(name != null ? name : this.type);
                    if (callback != null) {
                        callback.onStartTag(obj, name, writer, context);
                    }
                    pushedEncodingStyle = context.pushEncodingStyle(this.encodingStyle, writer);
                    if (this.encodeType) {
                        attrVal = XMLWriterUtil.encodeQName(writer, SOAPConstants.QNAME_ENCODING_ARRAY);
                        writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, attrVal);
                    }
                    int[] dims = ArraySerializerBase.getArrayDimensions(obj, this.getArrayRank(obj));
                    String encodedDims = ArraySerializerBase.encodeArrayDimensions(dims);
                    QName xmlType = this.registry.getXmlType(this.encodingStyle, obj.getClass());
                    if (xmlType == null) {
                        throw new SerializationException("typemapping.serializerNotRegistered", new Object[]{obj.getClass().getName()});
                    }
                    attrVal = XMLWriterUtil.encodeQName(writer, xmlType) + encodedDims;
                    writer.writeAttributeUnquoted(SOAPConstants.QNAME_ENCODING_ARRAYTYPE, attrVal);
                    this.serializeArrayInstance(obj, dims, writer, context);
                    writer.endElement();
                }
                catch (SerializationException e) {
                    throw e;
                }
                catch (JAXRPCExceptionBase e) {
                    throw new SerializationException(e);
                }
                catch (Exception e) {
                    throw new SerializationException(new LocalizableExceptionAdapter(e));
                }
            }
            Object var12_14 = null;
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
            throw throwable;
        }
    }

    protected void serializeArrayInstance(Object obj, int[] dims, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        this.serializeArrayElements((Object[])obj, 0, dims, writer, context);
    }

    protected void serializeArrayElements(Object[] arr, int level, int[] dims, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        if (arr == null || arr.length != dims[level]) {
            throw new SerializationException("soap.irregularMultiDimensionalArray");
        }
        boolean serializeLeaves = false;
        JAXRPCSerializer elemSer = null;
        if (level == dims.length - 1) {
            serializeLeaves = true;
            elemSer = (JAXRPCSerializer)this.registry.getSerializer(this.encodingStyle, arr.getClass().getComponentType());
        }
        int i = 0;
        while (i < dims[level]) {
            Object elem = arr[i];
            if (serializeLeaves) {
                elemSer.serialize(elem, this.elemName, null, writer, context);
            } else {
                this.serializeArrayElements((Object[])elem, level + 1, dims, writer, context);
            }
            ++i;
        }
    }

    protected void serializeNull(QName name, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        boolean pushedEncodingStyle = false;
        writer.startElement(name != null ? name : this.type);
        pushedEncodingStyle = context.pushEncodingStyle(this.encodingStyle, writer);
        if (this.encodeType) {
            String attrVal = XMLWriterUtil.encodeQName(writer, this.type);
            writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, attrVal);
        }
        writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, "1");
        writer.endElement();
        if (pushedEncodingStyle) {
            context.popEncodingStyle();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object deserialize(QName name, XMLReader reader, SOAPDeserializationContext context) {
        Object actualType2;
        boolean pushedEncodingStyle;
        block13: {
            pushedEncodingStyle = false;
            try {
                Object object;
                block12: {
                    try {
                        boolean isNull;
                        pushedEncodingStyle = context.processEncodingStyle(reader);
                        context.verifyEncodingStyle(this.encodingStyle);
                        if (name != null) {
                            this.verifyName(reader, name);
                        }
                        if (!(isNull = SerializerBase.getNullStatus(reader))) {
                            QName actualType2 = SerializerBase.getType(reader);
                            if (actualType2 != null && !actualType2.equals(this.type) && !actualType2.equals(SOAPConstants.QNAME_ENCODING_ARRAY)) {
                                throw new DeserializationException("soap.unexpectedElementType", new Object[]{this.type.toString(), actualType2.toString()});
                            }
                            String arrayType = null;
                            Attributes attrs = reader.getAttributes();
                            arrayType = attrs.getValue("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
                            if (arrayType == null) {
                                throw new DeserializationException("soap.malformedArrayType", "<arrayType attribute missing>");
                            }
                            int[] dims = ArraySerializerBase.getArrayDimensions(arrayType, reader);
                            QName elemXmlType = ArraySerializerBase.getArrayElementType(arrayType, reader);
                            Class elemJavaType = this.registry.getJavaType(this.encodingStyle, elemXmlType);
                            if (elemJavaType == null) {
                                throw new SerializationException("typemapping.deserializerNotRegistered", new Object[]{elemXmlType});
                            }
                            JAXRPCDeserializer elemDeser = (JAXRPCDeserializer)this.registry.getDeserializer(this.encodingStyle, elemXmlType);
                            Object rslt = this.deserializeArrayInstance(reader, context, dims, elemJavaType, elemDeser);
                            XMLReaderUtil.verifyReaderState(reader, 2);
                            object = rslt;
                            Object var16_19 = null;
                            if (!pushedEncodingStyle) return object;
                            break block12;
                        }
                        if (!this.isNullable) {
                            throw new DeserializationException("soap.unexpectedNull");
                        }
                        this.skipEmptyContent(reader);
                        actualType2 = null;
                        break block13;
                    }
                    catch (DeserializationException e) {
                        throw e;
                    }
                    catch (JAXRPCExceptionBase e) {
                        throw new DeserializationException(e);
                    }
                    catch (Exception e) {
                        throw new DeserializationException(new LocalizableExceptionAdapter(e));
                    }
                }
                context.popEncodingStyle();
                return object;
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                if (!pushedEncodingStyle) throw throwable;
                context.popEncodingStyle();
                throw throwable;
            }
        }
        Object var16_20 = null;
        if (!pushedEncodingStyle) return actualType2;
        context.popEncodingStyle();
        return actualType2;
    }

    protected Object deserializeArrayInstance(XMLReader reader, SOAPDeserializationContext context, int[] dims, Class elemClass, JAXRPCDeserializer elemDeser) throws Exception {
        String id = this.getID(reader);
        SOAPDeserializationState state = id != null ? context.getStateFor(id) : null;
        boolean isComplete = true;
        boolean emptyDims = ArraySerializerBase.isEmptyDimensions(dims);
        int[] dimOffsets = ArraySerializerBase.getDimensionOffsets(dims);
        int[] offset = ArraySerializerBase.getArrayOffset(reader, dims);
        if (offset == null) {
            offset = new int[emptyDims ? 1 : dims.length];
        }
        Object[] value = null;
        int maxPosition = 0;
        int length = 0;
        if (reader.nextElementContent() != 2) {
            Object[] newValue;
            boolean isSparseArray;
            int[] position = ArraySerializerBase.getArrayElementPosition(reader, dims);
            boolean bl = isSparseArray = position != null;
            if (!isSparseArray) {
                position = offset;
            }
            if (emptyDims) {
                maxPosition = position[0];
                length = Math.max(maxPosition * 2, 1024);
                value = (Object[])Array.newInstance(elemClass, length);
            } else {
                value = (Object[])Array.newInstance(elemClass, dims);
            }
            while (true) {
                if (!emptyDims && !ArraySerializerBase.isPositionWithinBounds(position, dims)) {
                    if (isSparseArray) {
                        throw new DeserializationException("soap.outOfBoundsArrayElementPosition", ArraySerializerBase.encodeArrayDimensions(position));
                    }
                    throw new DeserializationException("soap.tooManyArrayElements");
                }
                if (emptyDims && position[0] >= length) {
                    int newLength = length * 2;
                    while (position[0] >= newLength) {
                        newLength *= 2;
                    }
                    newValue = (Object[])Array.newInstance(elemClass, newLength);
                    System.arraycopy(value, 0, newValue, 0, length);
                    value = newValue;
                    length = newLength;
                }
                Object elem = null;
                elem = elemDeser.deserialize(this.elemName, reader, context);
                if (elem instanceof SOAPDeserializationState) {
                    SOAPDeserializationState elemState = (SOAPDeserializationState)elem;
                    isComplete = false;
                    if (state == null) {
                        state = new SOAPDeserializationState();
                    }
                    state.setInstance(value);
                    if (state.getBuilder() == null) {
                        state.setBuilder(new ObjectArrayInstanceBuilder(dimOffsets));
                    }
                    elemState.registerListener(state, ArraySerializerBase.indexFromPosition(position, dimOffsets));
                } else {
                    ObjectArraySerializer.setElement(value, position, elem);
                }
                if (reader.nextElementContent() == 2) break;
                if (isSparseArray) {
                    position = ArraySerializerBase.getArrayElementPosition(reader, dims);
                    if (position == null) {
                        throw new DeserializationException("soap.missingArrayElementPosition");
                    }
                } else if (emptyDims) {
                    position[0] = position[0] + 1;
                } else {
                    ArraySerializerBase.incrementPosition(position, dims);
                }
                if (!emptyDims) continue;
                maxPosition = Math.max(position[0], maxPosition);
            }
            if (emptyDims && length != maxPosition + 1) {
                int newLength = maxPosition + 1;
                newValue = (Object[])Array.newInstance(elemClass, newLength);
                System.arraycopy(value, 0, newValue, 0, newLength);
                value = newValue;
                length = newLength;
            }
        } else {
            value = emptyDims ? (Object[])Array.newInstance(elemClass, 0) : (Object[])Array.newInstance(elemClass, dims);
        }
        if (state != null) {
            state.setDeserializer(this);
            state.setInstance(value);
            state.doneReading();
        }
        if (isComplete) {
            return value;
        }
        return state;
    }

    protected int getArrayRank(Object obj) {
        int rank = 0;
        Class<?> type = obj.getClass();
        while (type.isArray()) {
            ++rank;
            type = type.getComponentType();
        }
        return rank;
    }

    private class ObjectArrayInstanceBuilder
    implements SOAPInstanceBuilder {
        Object[] instance = null;
        int[] dimOffsets = null;

        ObjectArrayInstanceBuilder(int[] dimOffsets) {
            this.dimOffsets = dimOffsets;
        }

        public int memberGateType(int memberIndex) {
            return 6;
        }

        public void construct() {
            throw new IllegalStateException();
        }

        public void setMember(int index, Object memberValue) {
            int[] position = ArraySerializerBase.positionFromIndex(index, this.dimOffsets);
            ObjectArraySerializer.setElement(this.instance, position, memberValue);
        }

        public void initialize() {
        }

        public void setInstance(Object instance) {
            this.instance = (Object[])instance;
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

