/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import com.sun.xml.rpc.client.HandlerChainImpl;
import com.sun.xml.rpc.client.dii.CallEx;
import com.sun.xml.rpc.client.dii.CallInvoker;
import com.sun.xml.rpc.client.dii.CallInvokerImpl;
import com.sun.xml.rpc.client.dii.CallRequest;
import com.sun.xml.rpc.client.dii.DynamicInvocationException;
import com.sun.xml.rpc.encoding.DynamicInternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.ReferenceableSerializerImpl;
import com.sun.xml.rpc.encoding.SOAPFaultInfoSerializer;
import com.sun.xml.rpc.encoding.literal.LiteralFragmentSerializer;
import com.sun.xml.rpc.encoding.soap.SOAPRequestSerializer;
import com.sun.xml.rpc.encoding.soap.SOAPResponseSerializer;
import com.sun.xml.rpc.encoding.soap.SOAPResponseStructure;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerRegistry;
import javax.xml.soap.SOAPMessage;

public class BasicCall
implements CallEx {
    protected static final QName EMPTY_QNAME = new QName("");
    protected static final QName RESULT_QNAME = null;
    protected static final int RETURN_VALUE_INDEX = 0;
    protected static final JAXRPCDeserializer faultDeserializer = new ReferenceableSerializerImpl(false, new SOAPFaultInfoSerializer(false, false));
    protected static final Set recognizedProperties;
    protected JAXRPCSerializer requestSerializer = null;
    protected JAXRPCDeserializer responseDeserializer = null;
    protected List inParameterNames = new ArrayList();
    protected List outParameterNames = new ArrayList();
    protected List inParameterXmlTypes = new ArrayList();
    protected List outParameterXmlTypes = new ArrayList();
    protected List inParameterClasses = new ArrayList();
    protected List outParameterClasses = new ArrayList();
    protected SOAPResponseStructure response = null;
    protected QName returnXmlType = null;
    protected Class returnClass = null;
    protected QName operationName = EMPTY_QNAME;
    protected QName portName = EMPTY_QNAME;
    protected QName portTypeName = EMPTY_QNAME;
    protected String targetEndpointAddress = null;
    protected Map properties = new HashMap();
    protected InternalTypeMappingRegistry typeRegistry;
    protected CallInvoker invoker = new CallInvokerImpl();
    protected HandlerRegistry handlerRegistry;

    public BasicCall(InternalTypeMappingRegistry registry, HandlerRegistry handlerRegistry) {
        if (registry == null) {
            throw new DynamicInvocationException("dii.typeregistry.missing.in.call");
        }
        this.typeRegistry = new DynamicInternalTypeMappingRegistry(registry);
        this.handlerRegistry = handlerRegistry;
        this.setProperty("javax.xml.rpc.soap.http.soapaction.use", new Boolean(false));
    }

    public boolean isParameterAndReturnSpecRequired(QName operation) {
        return true;
    }

    public HandlerChain getHandlerChain() {
        if (this.handlerRegistry.getHandlerChain(this.portName) == null) {
            return null;
        }
        return new HandlerChainImpl(this.handlerRegistry.getHandlerChain(this.portName));
    }

    public void addParameter(String paramName, QName paramXmlType, ParameterMode parameterMode) {
        this.checkIsParameterAndReturnTypeSpecAllowed();
        this.doAddParameter(paramName, paramXmlType, parameterMode);
    }

    protected void doAddParameter(String paramName, QName paramXmlType, ParameterMode parameterMode) {
        this.doAddParameter(paramName, paramXmlType, null, parameterMode);
    }

    public void addParameter(String paramName, QName paramXmlType, Class paramClass, ParameterMode parameterMode) {
        this.checkIsParameterAndReturnTypeSpecAllowed();
        this.doAddParameter(paramName, paramXmlType, paramClass, parameterMode);
    }

    protected void doAddParameter(String paramName, QName paramXmlType, Class paramClass, ParameterMode parameterMode) {
        this.resetSerializers();
        if (parameterMode == ParameterMode.OUT) {
            this.outParameterNames.add(new QName(paramName));
            this.outParameterXmlTypes.add(paramXmlType);
            this.outParameterClasses.add(paramClass);
        } else if (parameterMode == ParameterMode.IN) {
            this.inParameterNames.add(new QName(paramName));
            this.inParameterXmlTypes.add(paramXmlType);
            this.inParameterClasses.add(paramClass);
        } else if (parameterMode == ParameterMode.INOUT) {
            this.inParameterNames.add(new QName(paramName));
            this.inParameterXmlTypes.add(paramXmlType);
            this.inParameterClasses.add(paramClass);
            this.outParameterNames.add(new QName(paramName));
            this.outParameterXmlTypes.add(paramXmlType);
            this.outParameterClasses.add(paramClass);
        }
    }

    public QName getParameterTypeByName(String parameterName) {
        String currentName;
        ListIterator eachName = this.inParameterNames.listIterator();
        while (eachName.hasNext()) {
            currentName = ((QName)eachName.next()).getLocalPart();
            if (!currentName.equals(parameterName)) continue;
            return (QName)this.inParameterXmlTypes.get(eachName.previousIndex());
        }
        eachName = this.outParameterNames.listIterator();
        while (eachName.hasNext()) {
            currentName = ((QName)eachName.next()).getLocalPart();
            if (!currentName.equals(parameterName)) continue;
            return (QName)this.outParameterXmlTypes.get(eachName.previousIndex());
        }
        return null;
    }

    public void setReturnType(QName type) {
        this.checkIsParameterAndReturnTypeSpecAllowed();
        this.doSetReturnType(type);
    }

    protected void doSetReturnType(QName type) {
        this.setReturnType(type, null);
    }

    public void setReturnType(QName type, Class javaType) {
        this.checkIsParameterAndReturnTypeSpecAllowed();
        this.doSetReturnType(type, javaType);
    }

    protected void doSetReturnType(QName type, Class javaType) {
        this.resetSerializers();
        this.returnXmlType = type;
        this.returnClass = javaType;
    }

    public QName getReturnType() {
        return this.returnXmlType;
    }

    public void removeAllParameters() {
        this.checkIsParameterAndReturnTypeSpecAllowed();
        this.doRemoveAllParameters();
    }

    protected void doRemoveAllParameters() {
        this.resetSerializers();
        this.inParameterNames.clear();
        this.inParameterXmlTypes.clear();
        this.inParameterClasses.clear();
        this.outParameterNames.clear();
        this.outParameterXmlTypes.clear();
        this.outParameterClasses.clear();
    }

    protected void resetSerializers() {
        this.requestSerializer = null;
        this.responseDeserializer = null;
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(QName portType) {
        this.portTypeName = portType;
    }

    public QName getPortName() {
        return this.portName;
    }

    public void setPortName(QName port) {
        this.portName = port;
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName operationName) {
        this.operationName = operationName;
    }

    public void setTargetEndpointAddress(String address) {
        this.targetEndpointAddress = address;
        this.invoker = new CallInvokerImpl();
    }

    public String getTargetEndpointAddress() {
        return this.targetEndpointAddress;
    }

    public void setProperty(String name, Object value) {
        if (!recognizedProperties.contains(name)) {
            throw new DynamicInvocationException("dii.call.property.set.unrecognized", new Object[]{name});
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        if (!recognizedProperties.contains(name)) {
            throw new DynamicInvocationException("dii.call.property.get.unrecognized", new Object[]{name});
        }
        return this.properties.get(name);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public Iterator getPropertyNames() {
        return recognizedProperties.iterator();
    }

    public Object invoke(Object[] parameters) throws RemoteException {
        block7: {
            if (parameters == null) {
                parameters = new Object[]{};
            }
            try {
                String operationStyle = (String)this.getProperty("javax.xml.rpc.soap.operation.style");
                if ("document".equals(operationStyle)) {
                    this.response = this.getInvoker().doInvoke(new CallRequest(this, (SOAPMessage)parameters[0]), this.getRequestSerializer(), this.getResponseDeserializer(), this.getFaultDeserializer());
                    break block7;
                }
                if ("rpc".equals(operationStyle)) {
                    this.response = this.getInvoker().doInvoke(new CallRequest(this, parameters), this.getRequestSerializer(), this.getResponseDeserializer(), this.getFaultDeserializer());
                    break block7;
                }
                throw this.unsupportedOperationStyleException(operationStyle);
            }
            catch (RemoteException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RemoteException("", new DynamicInvocationException(new LocalizableExceptionAdapter(e)));
            }
        }
        return this.response.returnValue;
    }

    public Object invoke(QName operationName, Object[] inputParams) throws RemoteException {
        this.setOperationName(operationName);
        Object returnValue = this.invoke(inputParams);
        return returnValue;
    }

    public void invokeOneWay(Object[] parameters) {
        block6: {
            if (parameters == null) {
                parameters = new Object[]{};
            }
            try {
                String operationStyle = (String)this.getProperty("javax.xml.rpc.soap.operation.style");
                if ("document".equals(operationStyle)) {
                    this.getInvoker().doInvokeOneWay(new CallRequest(this, (SOAPMessage)parameters[0]), this.getRequestSerializer());
                    break block6;
                }
                if ("rpc".equals(operationStyle)) {
                    this.getInvoker().doInvokeOneWay(new CallRequest(this, parameters), this.getRequestSerializer());
                    break block6;
                }
                throw this.unsupportedOperationStyleException(operationStyle);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new DynamicInvocationException(new LocalizableExceptionAdapter(e));
            }
        }
    }

    protected DynamicInvocationException unsupportedOperationStyleException(String operationStyle) {
        return new DynamicInvocationException("dii.operation.style.unsupported", new Object[]{operationStyle});
    }

    public Map getOutputParams() {
        if (this.response == null) {
            throw new DynamicInvocationException("dii.outparameters.not.available");
        }
        return Collections.unmodifiableMap(this.response.outParameters);
    }

    public List getOutputValues() {
        return Collections.unmodifiableList((List)this.response.outParameters.values());
    }

    Object getRequiredProperty(String requiredProperty) {
        Object property = this.getProperty(requiredProperty);
        if (property == null) {
            throw this.propertyNotFoundException(requiredProperty);
        }
        return property;
    }

    protected void checkIsParameterAndReturnTypeSpecAllowed() {
        if (!this.isParameterAndReturnSpecRequired(this.operationName)) {
            throw new DynamicInvocationException("dii.parameterandreturntypespec.not.allowed");
        }
    }

    protected CallInvoker getInvoker() {
        return this.invoker;
    }

    protected JAXRPCSerializer getRequestSerializer() throws Exception {
        if (this.requestSerializer == null) {
            String encodingStyle = this.getEncodingStyle();
            if ("http://schemas.xmlsoap.org/soap/encoding/".equals(encodingStyle)) {
                this.createRpcRequestSerializer();
            } else if ("".equals(encodingStyle)) {
                this.createLiteralRequestSerializer();
            } else {
                throw new DynamicInvocationException("dii.encoding.style.unsupported", new Object[]{encodingStyle});
            }
        }
        return this.requestSerializer;
    }

    protected void createRpcRequestSerializer() throws Exception {
        int parameterCount = this.inParameterNames.size();
        this.requestSerializer = new SOAPRequestSerializer(EMPTY_QNAME, this.inParameterNames.toArray(new QName[parameterCount]), this.inParameterXmlTypes.toArray(new QName[parameterCount]), this.inParameterClasses.toArray(new Class[parameterCount]));
        ((Initializable)((Object)this.requestSerializer)).initialize(this.typeRegistry);
    }

    protected void createLiteralRequestSerializer() throws Exception {
        this.requestSerializer = new LiteralFragmentSerializer((QName)this.inParameterXmlTypes.get(0), true, "");
    }

    protected JAXRPCDeserializer getResponseDeserializer() throws Exception {
        if (this.responseDeserializer == null) {
            String encodingStyle = this.getEncodingStyle();
            if ("http://schemas.xmlsoap.org/soap/encoding/".equals(encodingStyle)) {
                this.createRpcResponseSerializer();
            } else if ("".equals(encodingStyle)) {
                this.createLiteralResponseSerializer();
            } else {
                throw new DynamicInvocationException("dii.encoding.style.unsupported", new Object[]{encodingStyle});
            }
        }
        return this.responseDeserializer;
    }

    protected void createRpcResponseSerializer() throws Exception {
        int parameterCount = this.outParameterNames.size();
        this.responseDeserializer = new ReferenceableSerializerImpl(false, new SOAPResponseSerializer(EMPTY_QNAME, this.outParameterNames.toArray(new QName[parameterCount]), this.outParameterXmlTypes.toArray(new QName[parameterCount]), this.outParameterClasses.toArray(new Class[parameterCount]), this.returnXmlType, this.returnClass));
        ((Initializable)((Object)this.responseDeserializer)).initialize(this.typeRegistry);
    }

    protected void createLiteralResponseSerializer() throws Exception {
        this.requestSerializer = new ReferenceableSerializerImpl(false, new LiteralFragmentSerializer(this.returnXmlType, true, ""));
    }

    protected JAXRPCDeserializer getFaultDeserializer() {
        return faultDeserializer;
    }

    protected String getEncodingStyle() {
        return (String)this.getRequiredProperty("javax.xml.rpc.encodingstyle.namespace.uri");
    }

    protected DynamicInvocationException serializerNotFoundException(int index, QName name, Class clazz, QName xmlType) {
        Integer indexObject = new Integer(index);
        if (clazz == null) {
            if (xmlType == null) {
                return new DynamicInvocationException("dii.parameter.type.underspecified", new Object[]{indexObject, name});
            }
            return new DynamicInvocationException("dii.parameter.type.ambiguous.no.class", new Object[]{indexObject, name, xmlType});
        }
        if (xmlType == null) {
            return new DynamicInvocationException("dii.parameter.type.ambiguous.no.typename", new Object[]{indexObject, name, clazz});
        }
        return new DynamicInvocationException("dii.parameter.type.unknown", new Object[]{indexObject, name, clazz, xmlType});
    }

    protected DynamicInvocationException propertyNotFoundException(String property) {
        return new DynamicInvocationException("dii.required.property.not.set", new Object[]{property});
    }

    static {
        HashSet<String> temp = new HashSet<String>();
        temp.add("javax.xml.rpc.security.auth.username");
        temp.add("javax.xml.rpc.security.auth.password");
        temp.add("javax.xml.rpc.endpoint");
        temp.add("javax.xml.rpc.soap.operation.style");
        temp.add("javax.xml.rpc.soap.http.soapaction.use");
        temp.add("javax.xml.rpc.soap.http.soapaction.uri");
        temp.add("javax.xml.rpc.session.maintain");
        temp.add("javax.xml.rpc.encodingstyle.namespace.uri");
        recognizedProperties = Collections.unmodifiableSet(temp);
    }
}

