/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.tags;

import com.sun.xml.messaging.saaj.tags.JaxmContext;
import java.io.ByteArrayOutputStream;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class DisplayMessage {
    int dL = 0;
    String id;
    SOAPMessage msg;

    public void setMsgId(String s) {
        this.id = s;
    }

    public void setName(String s) {
        this.id = s;
    }

    public void setDebug(int d) {
        this.dL = d;
    }

    public void setMessage(SOAPMessage msg) {
        this.msg = msg;
    }

    public void execute() throws Exception {
        String s = this.getMessageAsString();
        if (s != null) {
            System.out.println(s);
        }
    }

    public String getMessageAsString() throws Exception {
        if (this.dL > 0) {
            this.debug("dump message " + this.id);
        }
        if (this.id == null && this.msg == null) {
            return null;
        }
        try {
            if (this.msg == null) {
                JaxmContext gctx = JaxmContext.getJaxmContext();
                Object o = gctx.getAttribute(this.id);
                if (!(o instanceof SOAPMessage)) {
                    if (this.dL > 0) {
                        this.debug("Not a message " + o);
                    }
                    return null;
                }
                this.msg = (SOAPMessage)o;
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.msg.writeTo(os);
            String s = os.toString();
            if (this.dL > 0) {
                this.debug("Got string " + s);
            }
            return s;
        }
        catch (Exception ex) {
            this.dumpException(ex);
            throw ex;
        }
    }

    private void dumpException(Throwable e) {
        e.printStackTrace();
        while (e instanceof SOAPException) {
            if ((e = ((SOAPException)e).getCause()) == null) continue;
            e.printStackTrace();
        }
    }

    private void debug(String s) {
        System.out.println("JaxmDump: " + s);
    }
}

