/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.client.p2p;

import com.sun.xml.messaging.saaj.client.p2p.http.handler.HttpURLConnection;
import com.sun.xml.messaging.saaj.util.Base64;
import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.messaging.saaj.util.JaxmURI;
import com.sun.xml.messaging.saaj.util.ParseUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpSOAPConnection
extends SOAPConnection {
    private static Log logger = LogFactory.getFactory().getInstance("HttpSOAPConnection");
    public static String defaultProxyHost = null;
    public static int defaultProxyPort = -1;
    MessageFactory messageFactory = null;
    boolean closed = false;
    private String proxyHost = defaultProxyHost;
    private int proxyPort = defaultProxyPort;
    private static String SSL_PKG = "com.sun.net.ssl.internal.www.protocol";
    private static String SSL_PROVIDER = "com.sun.net.ssl.internal.ssl.Provider";
    private static final int dL = 0;
    private static final boolean _overrideDefaultHttpHandler;

    public HttpSOAPConnection() throws SOAPException {
        try {
            this.messageFactory = MessageFactory.newInstance();
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to create message factory", (Throwable)ex);
            throw new SOAPException("Unable to create message factory", ex);
        }
    }

    public void close() throws SOAPException {
        if (this.closed) {
            throw new SOAPException("Connection already closed");
        }
        this.messageFactory = null;
        this.closed = true;
    }

    public SOAPMessage call(SOAPMessage message, Object endPoint) throws SOAPException {
        if (this.closed) {
            throw new SOAPException("Connection is closed");
        }
        Class<?> uepClz = null;
        try {
            uepClz = Class.forName("javax.xml.messaging.URLEndpoint");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (uepClz != null && uepClz.isInstance(endPoint)) {
            String url = null;
            try {
                Method m = uepClz.getMethod("getURL", null);
                url = (String)m.invoke(endPoint, null);
            }
            catch (Exception ex) {
                throw new SOAPException("Internal error: " + ex.getMessage());
            }
            try {
                endPoint = new URL(url);
            }
            catch (MalformedURLException mex) {
                throw new SOAPException("Bad URL: " + mex.getMessage());
            }
        }
        if (endPoint instanceof String) {
            try {
                endPoint = new URL((String)endPoint);
            }
            catch (MalformedURLException mex) {
                throw new SOAPException("Bad URL: " + mex.getMessage());
            }
        }
        if (endPoint instanceof URL) {
            try {
                PriviledgedPost pp = new PriviledgedPost(this, message, (URL)endPoint);
                SOAPMessage response = (SOAPMessage)AccessController.doPrivileged(pp);
                return response;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SOAPException(ex);
            }
        }
        throw new SOAPException("Bad endPoint type " + endPoint);
    }

    public void setProxy(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
        System.setProperty("http.proxyHost", this.proxyHost);
        System.setProperty("http.proxyPort", new Integer(this.proxyPort).toString());
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    SOAPMessage post(SOAPMessage message, URL endPoint) throws SOAPException {
        int responseCode;
        java.net.HttpURLConnection httpConnection;
        boolean isFailure;
        block25: {
            isFailure = false;
            URL url = null;
            httpConnection = null;
            responseCode = 0;
            try {
                if (endPoint.getProtocol().equals("https")) {
                    this.initHttps();
                }
                JaxmURI uri = new JaxmURI(endPoint.toString());
                String userInfo = uri.getUserinfo();
                url = new URL(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath());
                if (!url.getProtocol().equalsIgnoreCase("http") && !url.getProtocol().equalsIgnoreCase("https")) {
                    throw new IllegalArgumentException("Protocol " + url.getProtocol() + " not supported in URL " + url);
                }
                httpConnection = this.createConnection(url);
                httpConnection.setRequestMethod("POST");
                httpConnection.setDoOutput(true);
                httpConnection.setDoInput(true);
                httpConnection.setUseCaches(false);
                java.net.HttpURLConnection.setFollowRedirects(true);
                if (message.saveRequired()) {
                    message.saveChanges();
                }
                MimeHeaders headers = message.getMimeHeaders();
                Iterator it = headers.getAllHeaders();
                boolean hasAuth = false;
                while (it.hasNext()) {
                    MimeHeader header = (MimeHeader)it.next();
                    String[] values = headers.getHeader(header.getName());
                    if (values.length == 1) {
                        httpConnection.setRequestProperty(header.getName(), header.getValue());
                    } else {
                        StringBuffer concat = new StringBuffer();
                        int i = 0;
                        while (i < values.length) {
                            if (i != 0) {
                                concat.append(',');
                            }
                            concat.append(values[i]);
                            ++i;
                        }
                        httpConnection.setRequestProperty(header.getName(), concat.toString());
                    }
                    if (!"Authorization".equals(header.getName())) continue;
                    hasAuth = true;
                }
                if (!hasAuth && userInfo != null) {
                    this.initAuthUserInfo(httpConnection, userInfo);
                }
                OutputStream out = httpConnection.getOutputStream();
                message.writeTo(out);
                out.flush();
                out.close();
                httpConnection.connect();
                try {
                    responseCode = httpConnection.getResponseCode();
                    if (responseCode == 500) {
                        isFailure = true;
                    } else if (responseCode / 100 != 2) {
                        throw new SOAPException("Bad response: (" + responseCode + httpConnection.getResponseMessage());
                    }
                }
                catch (IOException e) {
                    responseCode = httpConnection.getResponseCode();
                    if (responseCode == 500) {
                        isFailure = true;
                        break block25;
                    }
                    throw e;
                }
            }
            catch (SOAPException ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SOAPException("Message send failed", ex);
            }
        }
        SOAPMessage response = null;
        if (responseCode == 200 || isFailure) {
            try {
                MimeHeaders headers = new MimeHeaders();
                int i = 1;
                while (true) {
                    String key = ((URLConnection)httpConnection).getHeaderFieldKey(i);
                    String value = ((URLConnection)httpConnection).getHeaderField(i);
                    if (key == null && value == null) break;
                    if (key != null) {
                        StringTokenizer values = new StringTokenizer(value, ",");
                        while (values.hasMoreTokens()) {
                            headers.addHeader(key, values.nextToken().trim());
                        }
                    }
                    ++i;
                }
                InputStream httpIn = isFailure ? httpConnection.getErrorStream() : httpConnection.getInputStream();
                byte[] bytes = this.readFully(httpIn);
                int length = httpConnection.getContentLength() == -1 ? bytes.length : httpConnection.getContentLength();
                ByteInputStream in = new ByteInputStream(bytes, length);
                response = this.messageFactory.createMessage(headers, in);
                httpIn.close();
                httpConnection.disconnect();
            }
            catch (SOAPException ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SOAPException("Unable to read response: " + ex.getMessage());
            }
        }
        return response;
    }

    private byte[] readFully(InputStream istream) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int num = 0;
        while ((num = istream.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        byte[] ret = bout.toByteArray();
        return ret;
    }

    private void initHttps() {
        String pkgs = System.getProperty("java.protocol.handler.pkgs");
        System.out.println("Providers " + pkgs);
        if (pkgs == null || pkgs.indexOf(SSL_PKG) < 0) {
            pkgs = pkgs == null ? SSL_PKG : SSL_PKG + "|" + pkgs;
            System.setProperty("java.protocol.handler.pkgs", pkgs);
            System.out.println("Setting providers  " + pkgs);
            try {
                Class<?> c = Class.forName(SSL_PROVIDER);
                Class<?> c1 = Class.forName(SSL_PKG + ".https.Handler");
                Provider p = (Provider)c.newInstance();
                Security.addProvider(p);
                System.out.println("Added SSL_PROVIDER " + SSL_PROVIDER);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void initAuthUserInfo(java.net.HttpURLConnection conn, String userInfo) {
        if (userInfo != null) {
            String password;
            String user;
            int delimiter = userInfo.indexOf(58);
            if (delimiter == -1) {
                user = ParseUtil.decode(userInfo);
                password = null;
            } else {
                user = ParseUtil.decode(userInfo.substring(0, delimiter++));
                password = ParseUtil.decode(userInfo.substring(delimiter));
            }
            String plain = user + ":";
            byte[] nameBytes = plain.getBytes();
            byte[] passwdBytes = password.getBytes();
            byte[] concat = new byte[nameBytes.length + passwdBytes.length];
            System.arraycopy(nameBytes, 0, concat, 0, nameBytes.length);
            System.arraycopy(passwdBytes, 0, concat, nameBytes.length, passwdBytes.length);
            String auth = "Basic " + new String(Base64.encode(concat));
            conn.setRequestProperty("Authorization", auth);
        }
    }

    private void d(String s) {
        System.err.println("HttpSOAPConnection: " + s);
    }

    private java.net.HttpURLConnection createConnection(URL endpoint) throws IOException {
        if (_overrideDefaultHttpHandler) {
            return new HttpURLConnection(endpoint, null, 80);
        }
        return (java.net.HttpURLConnection)endpoint.openConnection();
    }

    static {
        String version = System.getProperty("java.specification.version");
        String vmVersion = System.getProperty("java.vm.version");
        boolean override = false;
        if (version.equals("1.3") && vmVersion.startsWith("1.3") && !vmVersion.startsWith("1.3.1_")) {
            override = true;
        }
        _overrideDefaultHttpHandler = override;
    }

    static class PriviledgedPost
    implements PrivilegedExceptionAction {
        HttpSOAPConnection c;
        SOAPMessage message;
        URL endPoint;

        PriviledgedPost(HttpSOAPConnection c, SOAPMessage message, URL endPoint) {
            this.c = c;
            this.message = message;
            this.endPoint = endPoint;
        }

        public Object run() throws Exception {
            return this.c.post(this.message, this.endPoint);
        }
    }
}

